/* net3d.h
 *
 * Include files, common definitions and global variables
 */
#ifndef net3d_h
#define net3d_h

/* current version number. All clients must be using the same version
 * to stay synchronised. */
#define NET3D_VERSION "0.08"
#define VERSION_ERROR "net3d version mismatch"

/* bug fix under linux */
#ifdef linux
#define float double
#endif

/* commonly used types */
#ifndef VMS
typedef signed char byte;
#else
typedef char byte;
#define NO_SELECT_H
typedef char * caddr_t;
#define CADDR_T
#endif /* VMS */

typedef unsigned char ubyte;
typedef enum{false=0, true=1} bool;

struct cache {
	double val;			/* input value */
	double res;			/* corresponding output */
	long lastused;			/* time of last call */
	bool inuse;			/* is this cache line in use? */
	};
/* a cache line, usually used in an array to form a cache */

/* Include files */
#define NeedFunctionPrototypes 1	/* why is this needed ?!? */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <signal.h>
#include <limits.h>
#include <float.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>

#ifndef VMS
#include <sys/wait.h>
#endif /* VMS */

#if !defined(NO_SELECT_H) && !defined(__FreeBSD__)
#include <sys/select.h>
#endif
#include "config.h"
#include "3d.h"
#include "brain.h"
#include "protos.h"
#include "netprotos.h"

/* defines used in creating 3-d view */
#define WINDOW_W 400
#define WINDOW_H 400
#define SCALE 160
#define VIEW_RANGE 2000.0
#define EYE_DISTANCE 3.0
#define RADAR_RANGE 2000
#define STARSCALE 500

/* defines limiting max size of object, vehicles & faces */
#define MAX_POINTS_PER_FACE 20
#define MAX_POINTS_PER_OBJECT 100
#define MAX_FACES_PER_OBJECT 100
#define MAX_PARTS_PER_VEHICLE 110
#define MAX_OSCLI_PER_OBJECT 30

/* defines used in networking */
#define MAX_PLAYERS 20

/* assorted definitions */
#ifndef PI		/* already defined under Linux */
#define PI 3.1415927
#endif
#define DEATH_MSG "Your vehicle has been destroyed"
#define WINNER_MSG "All other players have been destroyed. You win!"
#define FIREBALLS 30
#define PLAYERTYPE t_fish
#define KEYFILE ".net3drc"

/* definitions for growning trees */
#define GROWTHRATE 1.01

/* definitions for movement */
#define DELTA_ANGLE dtor(0.2)
#define DELTA_ALT   0.5

#define DELTA_ANGLE_VEL dtor(5.0)
#define DELTA_VELOCITY 2.0
#define DELTA_CLIMB 5.0
#define DELTA_TURRET_ANG dtor(5.0)
#define MAX_VELOCITY 150.0
#define MAX_ANGLE_VEL PI/4.0
#define MAX_ALTITUDE 2000.0
#define MAX_TURRET_ANG dtor(45.0)
#define FRICTION 100.0			/* rate at which rotating things slow */

/* definitions for brains */
#define MAX_STATES_PER_VEHICLE 50
#define MAX_LINKS_PER_STATE 20

/* rate at which things fall in the game */
#define GRAVITY 40

/* simple defined functions */
#define dtor(x)		((x)/(180.0/PI))
#define rtod(x)		((x)*(180.0/PI))
#define max(x,y)	((x) > (y) ? (x) : (y))
#define min(x,y)	((x) < (y) ? (x) : (y))
#define chksum(p)	((p).x + (p).y + (p).z)

/* external global variables and functions */
extern Display *display;
extern GC view_gc;
extern Window view_win;
extern Pixmap view_pm;
extern Colormap view_cm;
extern bool wireframe;
extern double gtm;
extern int vidcount;
extern int stillalive;
extern bool singlep;
extern int window_w, window_h;
extern double vmax[];
extern char *extras[];
extern char fakepipe[];
extern bool buildicons;
extern int linenum;
extern struct vehicle *evhead;
extern struct object *eohead;
extern char *pnames[];
extern vehicle_type playertype;
extern int ctrlc;
extern int sock;

/* global variables containing information about map cacheing 
 * efficiency. */
extern int mappointsdone;
extern int mapcachehits;

/* variables containing into about sin caching */
extern int sincalls;
extern int sincachehits;

extern double (sinhalf)(double);
extern double (sinsq)(double);

/* the matrix multiply function, defined inline if using gcc */
#if defined(__GNUC__) && USEINLINES == 1
static inline void mmult(struct point *p, float m[3][3], struct point *r)
{
r->x=p->x*m[0][0] + p->y*m[0][1] + p->z*m[0][2];
r->y=p->x*m[1][0] + p->y*m[1][1] + p->z*m[1][2];
r->z=p->x*m[2][0] + p->y*m[2][1] + p->z*m[2][2];
}

static inline float cmult(struct point *p, float l[3])
{
return p->x*l[0] + p->y*l[1] + p->z*l[2];
}
#endif

#endif
