#include "net.h"


extern int linenum;		/* also defined in net3d.h, but I don't
				 * want to include that whole file.
				 */

/* opens a destination socket and returns it's file descriptor.
 * accept can then be used to wait for incoming connections.
 */
int OpenDest(void)
{
int newsock;
struct sockaddr_in addr={0};

/* create an internet socket, on the port defined by NET_PORT */
newsock=socket(AF_INET,SOCK_STREAM,0);
addr.sin_family=AF_INET;
addr.sin_port=NET_PORT;
addr.sin_addr.s_addr=INADDR_ANY;
if (bind(newsock,(struct sockaddr *)&addr,sizeof(addr)) < 0) {
	printf("bind failed! %s\n",strerror(errno));
	printf("The server is probably already running on this machine\n");
	exit(1);
	}

/* allow max 8 connections in queue */
listen(newsock,8);
setsockopt(newsock,SOL_SOCKET,SO_REUSEADDR,NULL,0);
return(newsock);
}

/* connect to the specified address, and return the file descriptor
 * of that connection.
 */
int OpenSend(char *server)
{
int sock;
struct sockaddr_in addr={0};
struct hostent *dest;
struct in_addr *ip;

/* create the sending socket */
sock=socket(AF_INET,SOCK_STREAM,0);

/* convert the address to an IP number, and connect to that machine */
addr.sin_family=AF_INET;
addr.sin_port=NET_PORT;
dest=gethostbyname(server);
if (!dest) {
	printf("Error finding machine or file \"%s\"\n",server);
	exit(1);
	}
ip=(struct in_addr *)dest->h_addr;
addr.sin_addr.s_addr=ip->s_addr;
if (connect(sock,(struct sockaddr *)&addr,sizeof(addr)) < 0) {
	printf("Error connecting to machine \"%s\" : %s\n",server,
	 strerror(errno));
	exit(2);
	}
return(sock);
}

/* writes a formatted stream of characters to a specified socket,
 * in the style of fprintf
 */
void nprintf(int sock, char *fmt, ...)
{
char buf[1200];
va_list ap;

va_start(ap,fmt);
vsprintf(buf,fmt,ap);
if (write(sock,buf,strlen(buf)) != strlen(buf)) {
	printf("Error on writing to socket %d : %s\n",sock,strerror(errno));
	exit(5);
	}
va_end(ap);
}

/* read one line from the specified socket into an internal static
 * buffer, and return a pointer to it
 */
char *ngets(int sock)
{
static char buf[5000];
char c;
int i=0;

do {
	if (read(sock,&c,1) != 1) {
		printf("network read error : %s\n",strerror(errno));
		exit(5);
		}
	if (i < 5000)
		buf[i++]=c;
	else
		printf("ngets buffer overflow!!\n");
	} while(c != '\n');
buf[i-1]='\0';
return(buf);
}

/* read one word from the specified socket into an internal static
 * buffer, and returns a pointer to it. Also increments the linenum
 * counter for each \n hit.
 */
char *ngetw(int sock)
{
static char buf[5000];
int i=0;
int rv;

/* skip initial whitespaces */
do {
#ifndef VMS
	if ((rv = read(sock,&buf[0],1)) != 1) {
		printf("network read error : %s\n",strerror(errno));
		exit(5);
		}
#else
	if ((rv = read(sock,&buf[0],1)) != 1)
		return "";
#endif /* VMS */
	if (buf[0] == '\n')
		linenum++;
	} while((buf[0]=='\n' || buf[0]==' ' || buf[0]=='\t') && rv);

/* read a word up to a whitespace */
while(buf[i] != '\n' && buf[i] != ' ' && buf[i] != '\t' && rv) {
	i++;
#ifndef VMS
	if ((rv=read(sock,buf+i,1)) != 1) {
		printf("network read error : %s\n",strerror(errno));
		exit(5);
		}
#else
	if ((rv=read(sock,buf+i,1)) != 1)
		return "";
#endif /* VMS */
	if (buf[i] == '\n')
		linenum++;
	}
buf[i]='\0';
return(buf);
}

