﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Pagila;

namespace LinqRental
{
    class Program
    {
        static void Main(string[] args)
        {
            using (PagilaContext context = new PagilaContext())
            {
                customer rentingCustomer = ReadCustomer(context);
                inventory movieInventory = null;
                if (rentingCustomer != null)
                {
                    Console.WriteLine("Found customer {0} {1}",
                        rentingCustomer.first_name, rentingCustomer.last_name);
                    Console.WriteLine("at address:");
                    rentingCustomer.addressReference.Load();
                    Console.WriteLine(rentingCustomer.address.address1);
                    if (!string.IsNullOrEmpty(rentingCustomer.address.address2))
                        Console.WriteLine(rentingCustomer.address.address2);
                    rentingCustomer.address.cityReference.Load();
                    Console.WriteLine("{0}, {1}  {2}",
                        rentingCustomer.address.city.city1,
                        rentingCustomer.address.district,
                        rentingCustomer.address.postal_code);
                    Console.WriteLine();
                    string movieName = ReadMovie(context);
                    movieInventory = GetAvailableMovie(context, movieName, 1);
                    if (movieInventory != null)
                    {
                        RentMovie(context, movieInventory, rentingCustomer, 1);
                        movieInventory.filmReference.Load();
                        DisplayMovieDetails(movieInventory.film);
                    }
                    else
                    {
                        inventory transferedMovie;
                        if (TryTransferMovie(context, movieName, out transferedMovie))
                        {
                            RentMovie(context, transferedMovie, rentingCustomer, 1);
                        }
                        DisplayMovieDetails(transferedMovie.film);
                    }
                }
                Console.WriteLine("Press Any Key to Continue...");
                Console.ReadKey();
                // do all writes in one transaction
                context.SaveChanges();
            }
        }

        private static void DisplayMovieDetails(film movie)
        {
            Console.WriteLine("Found movie {0}", movie.title);
            Console.WriteLine(movie.description);
            Console.WriteLine();
        }

        private static customer ReadCustomer(PagilaContext context)
        {
            Console.WriteLine("Enter last name:");
            string lastName = Console.ReadLine();
            Console.WriteLine("Enter first name:");
            string firstName = Console.ReadLine();

            var cust = from c in context.customer
                       where c.last_name == lastName &&
                       c.first_name == firstName
                       select c;
            return cust.FirstOrDefault();
        }

        private static string ReadMovie(PagilaContext context)
        {
            Console.WriteLine("Enter name of movie to rent:");
            return Console.ReadLine();
        }

        private static inventory GetAvailableMovie(PagilaContext context, string movieName, int storeNumber)
        {
            var inventoryId = from i in context.inventory
                              where i.film.title == movieName &&
                              i.store.store_id == storeNumber &&
                              (i.rental.Count() == 0 ||
                              i.rental.Count(r => r.return_date == null) != 0)
                              select i;
            return inventoryId.FirstOrDefault();
        }

        private static void RentMovie(PagilaContext context, inventory movieInventory, customer rentingCustomer, int staffId)
        {
            rental movieRental = new rental();
            movieRental.rental_date = DateTime.Now;
            movieRental.inventory = movieInventory;
            movieRental.customer = rentingCustomer;
            movieRental.staff = (from s in context.staff
                                 where s.staff_id == staffId
                                 select s).FirstOrDefault();
            context.AddTorental(movieRental);
        }

        private static bool TryTransferMovie(PagilaContext context, string movieName, out inventory transferedMovie)
        {
            transferedMovie = GetAvailableMovie(context, movieName, 2);
            if (transferedMovie == null)
            {
                return false;
            }

            // mark out of store 2
            RentMovie(context,
                transferedMovie,
                (from c in context.customer
                 where c.first_name == "STORE" && c.last_name == "TRANSFER"
                 select c).FirstOrDefault(),
                 2);
            // first try to reuse a previous transfer inventory
            rental previousTransfer = (from r in context.rental
                               from c in context.customer
                               where r.inventory.film.title == movieName &&
                               r.customer.customer_id == c.customer_id &&
                               c.first_name == "TRANSFER" &&
                               c.last_name == "BACK" && 
                               c.store.store_id == 1 &&
                               r.return_date == null
                               select r).FirstOrDefault();
            if (previousTransfer != null)
            {
                previousTransfer.return_date = DateTime.Now;
                transferedMovie = previousTransfer.inventory;
            }
            else
            {
                // couldn't find old transfer, create new inventory
                transferedMovie = new inventory();
                transferedMovie.film = (from m in context.film
                                        where m.title == movieName
                                        select m).FirstOrDefault();
                transferedMovie.store = (from s in context.store
                                         where s.store_id == 1
                                         select s).FirstOrDefault();
                context.AddToinventory(transferedMovie);
            }
            return true;
        }
    }
}
