/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */


//
//
//----------------------------------------------------------------------------
// @class CImpIRowsetScroll | Contained IRowsetScroll class
//
class CImpIRowsetScroll : public IRowsetScroll		//@base public | IRowsetScroll
{
	private: //@access private
		DEBUGCODE(ULONG m_cRef);										
		CRowset		*m_pObj;											
		LPUNKNOWN	m_pUnkOuter;

	public: //@access public
		CImpIRowsetScroll( CRowset *pObj, IUnknown *pUnkOuter )					
		{																	
			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpIRowsetScroll()														
		{																	
		}

		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}


	//	IRowsetScroll members inherited from IRowsetLocate
	//@cmember Compares two bookmarks.
	STDMETHODIMP	Compare (
						HCHAPTER		hReserved, 
						ULONG			cbBookmark1, 
						const BYTE*		pBookmark1,
						ULONG			cbBookmark2,
						const BYTE*		pBookmark2,
						DBCOMPARE*		pComparison);

	//@cmember Fetches rows starting with the row specified by an offset from a bookmark.
	STDMETHODIMP	GetRowsAt (
						HWATCHREGION	hReserved1,
						HCHAPTER		hReserved2,
						ULONG			cbBookmark,
						const BYTE*		pBookmark,
						LONG			lRowsOffset,
						LONG			cRows,
						ULONG*			pcRowsObtained,
						HROW**			prghRows);

	//@cmember Fetches the rows that match the specified bookmarks.
	STDMETHODIMP	GetRowsByBookmark (
						HCHAPTER		hChapter,
						ULONG			cRows,
						const ULONG		rgcbBookmarks[],
						const BYTE*		rgpBookmarks[],
						HROW			rghRows[],
						DBROWSTATUS		rgRowStatus[]);

	//@cmember Returns hash values for the specified bookmarks.
	STDMETHODIMP	Hash (
						HCHAPTER		hChapter,
						ULONG			cBookmarks,
						const ULONG		rgcbBookmarks[],
						const BYTE*		rgpBookmarks[],
						DWORD			rgHashedValues[],
						DBROWSTATUS		rgBookmarkStatus[]);

		//	"Native" IRowsetScroll members
		//@cmember GetApproximatePosition Method 
		// Gets the approximate position of a row corresponding to a specified bookmark
		STDMETHODIMP GetApproximatePosition (
						HCHAPTER        hChapter,
						ULONG           cbBookmark,
						const BYTE *    pBookmark,
						ULONG *         pulPosition,
						ULONG *         pcRows);

		//@cmember GetRowsAtRatio Method 
		// Fetches rows starting from a fractional position in the rowset
		STDMETHODIMP GetRowsAtRatio (
						HWATCHREGION    hReserved1,
						HCHAPTER        hChapter,
						ULONG           ulNumerator,
						ULONG           ulDenominator,
						LONG            cRows,
						ULONG *         pcRowsObtained,
						HROW **         prghRows);
};

