/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

// Includes ------------------------------------------------------------------

#include "hfiles.h"
#include "headers.h"

// CImpIRowsetIdentity::IsSameRow
//
// @mfunc	Compares two bookmarks.
//
// @desc	HRESULT
//		@flag	S_OK			| The method succeeded. 
//		@flag	E_FAIL			| A provider-specific error occurred. 
//		@flag	E_INVALIDARG	| cbBookmark1 or cbBookmark2 was zero. 
//		@flag	DB_E_BADBOOKMARK| pBookmark1 or pBookmark2 was zero
//
HRESULT	CImpIRowsetIdentity::IsSameRow
(
	HROW    hThisRow,
    HROW    hThatRow
)
{
	INTERFACE_METHOD_START( "IRowsetIdentity::IsSameRow" );

	// if row handle bad ?
	if (hThisRow > ACTIVE_ROWS_LIMIT || hThatRow >ACTIVE_ROWS_LIMIT)
		return DB_E_BADROWHANDLE;

    // IsSlotSet returns S_OK    if row is marked.
    //                   S_FALSE if row is not marked.
    // The "mark" means that there is data present in the row.
    // Rows are [1...n], slot marks are [0...n-1].
	if (m_pObj->m_prowbitsIBuffer->IsSlotSet( m_pObj->GetSlotNumber(hThisRow) ) != S_OK ||
		m_pObj->m_prowbitsIBuffer->IsSlotSet( m_pObj->GetSlotNumber(hThatRow) ) != S_OK)
	{
        return DB_E_BADROWHANDLE;
	}

	// if row hThisRow is deleted ?
	if (m_pObj->IfRowMarkedAsDeleted(hThisRow)) 
		return DB_E_DELETEDROW;

	// if row hThatRow is deleted ?
	if (m_pObj->IfRowMarkedAsDeleted(hThatRow)) 
		return DB_E_DELETEDROW;

	// are hThisRow and hThatRow rows the same ?
	if (hThisRow == hThatRow)
		return S_OK;
	else
		return S_FALSE;

	INTERFACE_METHOD_END();
}
