/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

#ifndef _EXTBUFF_H_
#define _EXTBUFF_H_

// Forward Declaration
class FAR CExtBuffer;
typedef CExtBuffer FAR *LPEXTBUFFER;


//--------------------------------------------------------------------
// @class Allocates and manages fixed sized block memory routines
// 
// @hungarian ext or pext
//
class FAR CExtBuffer
{			
	START_CLASS(); 

private: //@access private
	//@cmember Current count of items
	ULONG    m_cbItem;		
	//@cmember Item size, in bytes
	ULONG    m_cItem;		
	//@cmember Reserved byte count
	ULONG    m_cbReserved;	
	//@cmember Allocated byte count
	ULONG    m_cbAlloc;
	//@cmember increment value
	ULONG    m_dbAlloc;
	//@cmember Ptr to beginning of buffer
	BYTE     *m_rgItem;		
	

private:
	// Not implemented; private so dcl prevents generation.
	CExtBuffer( const CExtBuffer & p);
	CExtBuffer& operator=(const CExtBuffer & p);

public:	//@access public
	//@cmember Construcutor
	CExtBuffer ( void );
	//@cmember Destructor
	~CExtBuffer ( void );
	//@cmember Calculated data pointer from index value
	void * operator[] (ULONG nIndex);	
	//@cmember Initialize the fixed size buffer
	STDMETHODIMP 	FInit (ULONG cItemMax, ULONG cbItem, ULONG cbPage);
	//@cmember Add new items to the buffer
	STDMETHODIMP 	InsertIntoExtBuffer (VOID* pvItem, ULONG &hItem);
	//cmember Retrieve items from buffer
	STDMETHODIMP    GetItemOfExtBuffer (ULONG hItem,	VOID* pvItem);
	//@cmember Get usage extent indexes
	STDMETHODIMP    GetFirstLastItemH (ULONG &hItemFirst, ULONG &hItemLast);

	FINISH_CLASS(); 
};

#endif
