/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

// Includes ------------------------------------------------------------------
#include "hfiles.h"
#include "headers.h"
#include "mysqlmeta.h"

static int OleDbPrompt2Odbc (int prompt)
{
	switch( prompt )
	{
	case DBPROMPT_PROMPT: return SQL_DRIVER_PROMPT;
	case DBPROMPT_COMPLETE: return SQL_DRIVER_COMPLETE;
	case DBPROMPT_COMPLETEREQUIRED: return SQL_DRIVER_COMPLETE_REQUIRED;
	case DBPROMPT_NOPROMPT:	default: return SQL_DRIVER_NOPROMPT;
	}
}

void MakeMySqlConnStr( const char* in, const char* loc, const char* usr, const char* pwd, char* out )
{
		if( !out || !in )
			return;
	
		*out = 0;

		if( !strstr( in, "DSN=" ) )
		{
			strcat( out, "DSN=(Default);" );
			out += strlen(out);
		}
		
		if( loc && *loc )
		{
			strcat( out, "SERVER=" );
			strcat( out, loc );
			strcat( out, ";" );
			out += strlen(out);
		}

		if( usr && *usr )
		{
			strcat( out, "UID=" );
			strcat( out, usr );
			strcat( out, ";" );
			out += strlen(out);
		}

		if( pwd && *pwd )
		{
			strcat( out, "PWD=" );
			strcat( out, pwd );
			strcat( out, ";" );
			out += strlen(out);
		}

		if( !strpbrk( in, "=;" ) )
		{
			strcat( out, "DB=" );
			strcat( out, in );
			strcat( out, ";" );
			out += strlen(out);
		}
		else
		{
			strcat( out, in );
			out += strlen(out);
		}
}


// CImpIDBInitialize::Initialize ---------------------------------------------
//
// @mfunc Initializes the DataSource object.. For this provider it requires
// that a valid path is given to where the file will be located.
//
// @rdesc HRESULT
//      @flag S_OK          | Path exists
//      @flag E_FAIL        | Invalid path
//      @flag E_INVALIDARG  | Invalid Parameters passed in
//		@flag DB_E_ALREADYINITIALIZED | Datasource Object already initialized
//
STDMETHODIMP CImpIDBInitialize::Initialize
    (
	)
{
	INTERFACE_METHOD_START( "IDBInitialize::Initialize" );

	HRESULT		hr;
 
	DBPROPIDSET	rgPropertyIDSets[1];
	ULONG		cPropertySets;
	DBPROPSET*	prgPropertySets;
	DBPROPID	rgPropId[6];

	char szDbName[ MAXDDFPATH+1 ]; *szDbName = '\0';
	char szDDFPath[ MAXDDFPATH+1 ]; *szDDFPath = '\0';
	char szDataPath[ MAXDDFPATH+1 ]; *szDataPath = '\0';
	char szUserId[ MAXUSERNAME+1 ]; *szUserId = '\0';
	char szPasswd[ MAXPASSWORD+1 ]; *szPasswd = '\0';
	int  nPrompt = DBPROMPT_NOPROMPT;
	HWND hWnd = NULL;

    assert( m_pObj );

    if (m_pObj->m_fDSOInitialized)
        return DB_E_ALREADYINITIALIZED;

	rgPropId[0]								= DBPROP_INIT_DATASOURCE;
	rgPropId[1]								= DBPROP_INIT_PROMPT;
	rgPropId[2]								= DBPROP_INIT_HWND;
	rgPropId[3]								= DBPROP_INIT_LOCATION;
	rgPropId[4]								= DBPROP_AUTH_USERID;
	rgPropId[5]								= DBPROP_AUTH_PASSWORD;
 
	rgPropertyIDSets[0].guidPropertySet		= DBPROPSET_DBINIT;
	rgPropertyIDSets[0].rgPropertyIDs		= rgPropId;
	rgPropertyIDSets[0].cPropertyIDs		= sizeof(rgPropId)/sizeof(rgPropId[0]);

    // Get the value of the DBPROP_INIT_DATASOURCE property
    hr = m_pObj->m_pUtilProp->GetProperties( 
									PROPSET_INIT,
									sizeof(rgPropertyIDSets)/sizeof(rgPropertyIDSets[0]), 
									rgPropertyIDSets,
									&cPropertySets,
									&prgPropertySets );

	// On failure treat it as if we were opening with prompt..
    if( SUCCEEDED(hr) )
	{
		// Get Data Source name
		if( !W2Asz( V_BSTR(&prgPropertySets[0].rgProperties[0].vValue), szDbName ) )
			*szDbName = '\0';

		// Get the Prompt value
		nPrompt = V_I2(&prgPropertySets[0].rgProperties[1].vValue);

		// Get handle of parent window
		hWnd = (HWND)V_I4(&prgPropertySets[0].rgProperties[2].vValue);

		// Get data path (if provided in INIT_LOCATION) -- for DDFs only
		// It is server name for DBNames, too!
		if( !W2Asz( V_BSTR(&prgPropertySets[0].rgProperties[3].vValue), szDataPath ) )
			*szDataPath = '\0';

		if( !W2Asz( V_BSTR(&prgPropertySets[0].rgProperties[4].vValue), szUserId ) )
			*szUserId = '\0';
	
		if( !W2Asz( V_BSTR(&prgPropertySets[0].rgProperties[5].vValue), szPasswd ) )
			*szPasswd = '\0';
	}

	// Set desctop window if it the property was not set
	if( hWnd == NULL ) 
		hWnd = GetDesktopWindow();

	// Free the memory
	if (prgPropertySets)
	{
		for(ULONG ulIndex=0; ulIndex<prgPropertySets[0].cProperties; ulIndex++)
			VariantClear(&prgPropertySets[0].rgProperties[ulIndex].vValue);		
		
		g_pIMalloc->Free(prgPropertySets[0].rgProperties);	
		g_pIMalloc->Free(prgPropertySets);
	}

	switch( m_pObj->m_pUtilProp->InternalSqlSupport() )
	{
	case ISS_MYSQL:
		{
		char szFullInfo[ 1024 ]; 
		MakeMySqlConnStr( szDbName, szDataPath, szUserId, szPasswd, szFullInfo );

		SQLHENV henv = NULL;
		SQLHDBC hdbc = NULL;
		SQLSMALLINT cbFullInfo;
		SQLRETURN connect = SQL_ERROR;
		BOOL bSucceeded = FALSE;
		char szDDFPath[ MAXDDFPATH+1 ]; *szDDFPath = '\0';

		if( SQL_SUCCEEDED( SQLAllocEnv( &henv ) ) &&
			SQL_SUCCEEDED( SQLAllocConnect( henv, &hdbc ) ) &&
			SQL_SUCCEEDED( connect = SQLDriverConnect( hdbc, hWnd, (BYTE*)szFullInfo, strlen( szFullInfo ), (BYTE*)szFullInfo, MAXSTR(szFullInfo), &cbFullInfo, OleDbPrompt2Odbc(nPrompt) ) ) )
		{
			char * db = strstr( szFullInfo, ";DB=" );

			if( db )
			{
				db += 4; // strlen( ";DB=" )
				strcpy( szDDFPath, db );
			}

			if( *szDDFPath )
			{
				char * end = strchr( szDDFPath, ';' );
				if( end ) *end = 0;
			}
			
			// Save it in provider object now
			strcpy0( m_pObj->m_szDDFPath, szDDFPath, MAXSTR( m_pObj->m_szDDFPath ) );
			strcpy0( m_pObj->m_szDataPath, szDDFPath, MAXSTR( m_pObj->m_szDataPath ) );
			// Save type of data source
			m_pObj->m_typeOfDataSource = DATASOURCE_MYSQL;
			// Set selected datasource name. Note that property is read-only 
			m_pObj->m_pUtilProp->SetDataSourceName( *szDbName ? szDbName : szDDFPath, szFullInfo );
			// Set selected ODBC driver type (for P.SQL 2000 )
			m_pObj->m_iDriverID = 0;
			
			// we succeded if we are here :)
			m_pObj->m_fDSOInitialized = TRUE;

			bSucceeded = TRUE;
		}

		if( hdbc != NULL )
		{
			SQLDisconnect( hdbc );
			SQLFreeConnect( hdbc );
		}

		if( henv != NULL )
			SQLFreeEnv( henv );

		return bSucceeded ? S_OK : ( (connect==SQL_NO_DATA_FOUND) ? DB_E_CANCELED : E_FAIL );
		}

	case ISS_WRONG:
		return E_UNEXPECTED;

	default:
		break;
	}

	return S_OK;
	
	INTERFACE_METHOD_END();
}


// CImpIDBInitialize::Uninitialize ---------------------------------------------
//
// @mfunc Returns the Data Source Object to an uninitialized state
//
// @rdesc HRESULT
//      @flag S_OK            | The method succeeded
//      @flag DB_E_OBJECTOPEN | A DBSession object was already created
//
STDMETHODIMP CImpIDBInitialize::Uninitialize
    (
    void
    )
{
	INTERFACE_METHOD_START( "IDBInitialize::Uninitialize" );

    assert( m_pObj );

    if (!m_pObj->m_fDSOInitialized)
		return S_OK;

	if (m_pObj->IfActiveSessionsExist())
		return DB_E_OBJECTOPEN;

	m_pObj->ClearSwstMeta();

	m_pObj->m_fDSOInitialized = FALSE;
	
	return S_OK;
	
	INTERFACE_METHOD_END();
}
