/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

#ifndef _BITARRAY_H_
#define _BITARRAY_H_

// Forward Declaration
class FAR CBitArray;
typedef CBitArray FAR *LPBITARRAY;

// Invalid slot number
#define INVALID_SLOT_NUMBER		~(ULONG)0


//--------------------------------------------------------------------
// @class Allocates and manages a bit array through various methods 
// defined in the class
// 
// @hungarian bits or pbits
//
class FAR CBitArray
{
	START_CLASS(); 
	
	private:					//@access private
		//@cmember Count of Slots
		ULONG    m_cslotCurrent;
		//@cmember Maximum number of pages 
		ULONG    m_cPageMax;
		//@cmember Current number of pages
		ULONG    m_cPageCurrent;
		//@cmember Number of bytes per page
		ULONG    m_cbPage;
		//@cmember Mask buffer
		BYTE     m_rgbBitMask[8];
		//@cmember Bit Array
		BYTE     *m_rgbBit;
		

	public:						//@access public
		//@cmember Class constructor
		CBitArray( void );
		//@cmember Class destructor
		~CBitArray( void );
		//@cmember Initialization method
		STDMETHODIMP FInit(ULONG cslotMax, ULONG cbPage);
		//@cmember Set a range of slots
		STDMETHODIMP SetSlots(ULONG islotFirst, ULONG islotLast);
		//@cmember Reset a range of slots
		STDMETHODIMP ResetSlots(ULONG islotFirst, ULONG islotLast);
		//@cmember Reset all slots
		VOID		 ResetAllSlots(void);
		//@cmember Check if any bits are set
		STDMETHODIMP ArrayEmpty(void);
		//@cmember Check the status of a particular bit
		STDMETHODIMP IsSlotSet(ULONG islot);
		//@cmember Find the first set bit in a range of bits
		STDMETHODIMP FindSet(ULONG islotStart, ULONG islotLimit, ULONG* pislot);

	FINISH_CLASS(); 
};

#endif

