/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

// Includes ------------------------------------------------------------------

#include "hfiles.h"
#include "headers.h"

extern LPWSTR str2wstr(LPCTSTR str);


// Code ----------------------------------------------------------------------

///////////////////////////////////////
// Helper methods
///////////////////////////////////////

// Free descriptions array
void CImpIRowsetIndex::FreeCurrentIndexInfos()
{
	if( m_pColId != NULL )
		for( int i = 0; i < GetCurrentIndexParts(); i++ )
			if( m_pColId->eKind == DBKIND_NAME )
				delete m_pColId->uName.pwszName;

	delete m_pColId;
	delete m_pIndexColDesc;
}


// Allocate descriptions array
BOOL CImpIRowsetIndex::AllocateCurrentIndexInfos()
{
	// Ensure that no memory is lost
	FreeCurrentIndexInfos();

	// Allocate memory
	ULONG ulParts = GetCurrentIndexParts();
	m_pIndexColDesc = new DBINDEXCOLUMNDESC[ ulParts ];
	m_pColId		= new DBID[ ulParts ];
	
	// Check for success
	if( m_pIndexColDesc == NULL ||	m_pColId == NULL )
		return FALSE;

	// set up new array
	for( int i = 0; i < ulParts; i++ )
		m_pIndexColDesc[ i ].pColumnID = m_pColId + i;

	return TRUE;
}


// Get info #
DBINDEXCOLUMNDESC* CImpIRowsetIndex::GetCurrentIndexInfos( int iInfoNumber )
{
	return m_pIndexColDesc + iInfoNumber;
}


// Get index #
MT_WORD CImpIRowsetIndex::GetCurrentIndexNumber()
{
	return 0; 
}

// Get number of index parts
MT_WORD CImpIRowsetIndex::GetCurrentIndexParts()
{

	return 0;
}

// Get pointer to index segment #
SWSTINDEXtag* CImpIRowsetIndex::GetCurrentIndexPtr( int iIndexSegment )
{
	return NULL;
}


///////////////////////////////////////////////////
// IRowsetIndex specific methods
///////////////////////////////////////////////////


// Get index information (key columns in most->less significant order; properties of index group)
STDMETHODIMP CImpIRowsetIndex::GetIndexInfo
    (
    ULONG*		        pcKeyColumns,		//@parm OUT | # of key columns
    DBINDEXCOLUMNDESC **   prgIndexColumnDesc,	//@parm OUT  | Array of key columns in most->less significant order
    ULONG*              pcPropertySets,		//@parm OUT | count of property sets returned
    DBPROPSET**			prgPropertySets		//@parm OUT | property information returned
    )
{
	INTERFACE_METHOD_START("IRowsetIndex::GetIndexInfo");

	assert( m_pObj );
    assert( m_pObj->m_pUtilProp );

	
	// Done!
	return S_OK;

	INTERFACE_METHOD_END();
}


STDMETHODIMP CImpIRowsetIndex::Seek
	( 
    HACCESSOR hAccessor,	// IN | The handle of the accessor to use
    ULONG cKeyValues,		// IN | The number of bindings in hAccessor for which *pData contains valid data
    void *pData,			// IN | A pointer to a buffer containing the key values to which to seek, at offsets that correspond to the bindings in the accessor
    DBSEEK dwSeekOptions	// IN | A bitmask describing the options for the Seek method
	)
{ 
	INTERFACE_METHOD_START( "IRowsetIndex::Seek" );


	// Done!
	return  DB_E_NOTFOUND;
	
	INTERFACE_METHOD_END();
}
        

STDMETHODIMP CImpIRowsetIndex::SetRange
	( 
    HACCESSOR hAccessor,	// IN | The handle of the accessor to use for both *pStartData and *pEndData
    ULONG cStartKeyColumns,	// IN | The number of bindings in hAccessor for which *pStartData contains valid data
    void *pStartData,		// IN | A pointer to a buffer containing the starting key values of the range
    ULONG cEndKeyColumns,	// IN | The number of bindings in hAccessor for which *pEndData contains valid data
    void *pEndData,			// IN | A pointer to a buffer containing the ending key values of the range
    DBRANGE dwRangeOptions	// IN | A bitmask describing the options of the range
	)
{ 
	INTERFACE_METHOD_START( "IRowsetIndex::SetRange" );

	// Done!
	return S_OK;
	
	INTERFACE_METHOD_END();
}

