/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

// Includes ------------------------------------------------------------------
#include "hfiles.h"
#include "headers.h"

#include "cache_val.h"

#define GOOD_ERROR_VALUE	E_NOTIMPL

EnumNamedDatabases::EnumNamedDatabases()
{
	CLEAR_CONSTRUCT( EnumNamedDatabases );
	m_lConnectionNumber = -1;
}

HRESULT EnumNamedDatabases::Init( DSNINFO* pDSNINFO ) 
{
	HRESULT hr = S_OK;
	

	return S_OK;
}

HRESULT EnumNamedDatabases::Done() 
{
	return S_OK;
}

HRESULT EnumNamedDatabases::Reset() 
{
	m_iDatabase = 0;
	return S_OK;
}

HRESULT EnumNamedDatabases::PathByName( DSNINFO* pDSNINFO )
{
	// Name should be set
	if( pDSNINFO == NULL )
		return E_INVALIDARG;


	return S_OK; // Success
}


HRESULT EnumNamedDatabases::Next( DSNINFO* pDSNINFO )
{		
	return S_OK; // Success!
}

HRESULT EnumNamedDatabases::Skip() 
{
	++m_iDatabase;
	return S_OK;
}

HRESULT EnumNamedDatabases::Count(int* pCount ) 
{
	if( pCount == NULL )
		return E_INVALIDARG;
	

	return S_OK;
}	

////////////////
// EnumMashineDSNs
////////////////
HRESULT EnumMashineDSNs::Init( DSNINFO* pDSNINFO ) 
{
		return E_FAIL;
}

HRESULT EnumUserDSNs::Init( DSNINFO* pDSNINFO ) 
{
	
	return EnumMashineDSNs::Init( pDSNINFO );
}

HRESULT EnumMashineDSNs::Done() 
{
	if( m_hRemoteKey != NULL )
		RegCloseKey( m_hRemoteKey );
	
	if( m_hKey == NULL ) 
		return S_FALSE; // not initialized
	
	// Close key
	return RegCloseKey( m_hKey ) == ERROR_SUCCESS ? S_OK : E_FAIL;
}

HRESULT EnumMashineDSNs::Reset() 
{
	m_nSubKey = -1;
	return S_OK;
}

HRESULT EnumMashineDSNs::Next( DSNINFO* pDSNINFO )
{		
	// To work correctly with NULL argument
	DSNINFO dummy;
	if( pDSNINFO == NULL )
		pDSNINFO = &dummy;

	HRESULT hr = E_FAIL;

	// Enum subkeys
	while( RegEnumKey( m_hKey, ++m_nSubKey, pDSNINFO->m_szDataSource, MAXDATASOURCENAME ) == ERROR_SUCCESS )
	{
		// Get path by obtained DSN name, which is subkey title. Get descr., too
		hr = PathByName( pDSNINFO );
		if( SUCCEEDED( hr ) )
			return hr; // Success
	}

	return hr; // Pass all available
}


// It is only function ofo this class that supports now getting 
// of DbName/DDFPath informationunder for remote databases under P.SQL 2000
HRESULT EnumMashineDSNs::PathByName( DSNINFO* pDSNINFO )
{

	return S_OK;
}

HRESULT EnumMashineDSNs::Skip() 
{
	if( SUCCEEDED( Next(NULL) )	)
		m_nSubKey--;
	return S_OK;
}

HRESULT EnumMashineDSNs::Count(int* count ) 
{
	if( count == NULL ) 
		return E_INVALIDARG;
	// Reset count
	*count = 0;

		return S_OK;
}	




HRESULT EnumOfEnumsDataSources::Next( DSNINFO* pDSNINFO ) 
{ 
	DSNINFO	dsnInfo;
	if( pDSNINFO == NULL ) pDSNINFO = &dsnInfo;
	ZeroMemory( pDSNINFO, sizeof( DSNINFO ) );

	switch( m_nCurrent )
	{
		case DATASOURCE_NONE:
			 strcpy0( pDSNINFO->m_szDataSource, "MySQL Data Source Name", MAXSTR(pDSNINFO->m_szDataSource) );
			 m_nCurrent = DATASOURCE_MYSQL;
			 break;
		default:
			 return E_FAIL;
	}
	
	pDSNINFO->m_type = m_nCurrent;
	
	return S_OK;
}


HRESULT EnumOfEnumsDataSources::Count(int* count) 
{
	if( count == NULL ) return E_INVALIDARG;
	*count = 1;
	return S_OK;
}


HRESULT EnumOfEnumsDataSources::GetNewObject( DATASOURCE_TYPE type, EnumDatabase** ppObj )
{
	if( ppObj == NULL )
		return E_INVALIDARG;

	switch( type )
	{
	case DATASOURCE_MYSQL:
		*ppObj = new EnumMySQLs;
		break;
	default:
		return E_FAIL;
	}
	return ( *ppObj != NULL ) ? S_OK : E_OUTOFMEMORY;
}




//////////////// Enumeration od MySQL data sources \\\\\\\\\\\\\\\\\\\\\\\\\/
HRESULT EnumMySQLs::Init( DSNINFO* pDSNINFO )
{
	if( pDSNINFO == NULL )
		return E_INVALIDARG;

	const char* stmt = "show databases";
	const char* connStr = 
		(pDSNINFO->m_pszMySqlStr && *pDSNINFO->m_pszMySqlStr ) 
		? pDSNINFO->m_pszMySqlStr 
		: "DSN=(Default);SYSDB=.;DB=mysql";

	if( SQL_SUCCEEDED( SQLAllocEnv(&m_henv) ) && 
		SQL_SUCCEEDED( SQLAllocConnect(m_henv, &m_hdbc) ) &&
		SQL_SUCCEEDED( SQLDriverConnect(m_hdbc, NULL, (BYTE*)connStr, strlen(connStr), NULL, 0, NULL, SQL_DRIVER_NOPROMPT) ) &&
		SQL_SUCCEEDED( SQLAllocStmt(m_hdbc, &m_hstmt) ) &&
		SQL_SUCCEEDED( SQLExecDirect( m_hstmt, (BYTE*)stmt, strlen(stmt) ) ) )
			return S_OK;

	return E_FAIL;
}


HRESULT EnumMySQLs::Done()
{
	if( m_hstmt ) 
		SQLFreeStmt( m_hstmt, SQL_DROP );
	if( m_hdbc )
	{
		SQLDisconnect( m_hdbc );
		SQLFreeConnect( m_hdbc );
	}
	if( m_henv )
		SQLFreeEnv( m_henv );

	return S_OK;
}

HRESULT EnumMySQLs::Reset()
{
	const char* stmt = "show databases";

	SQLFreeStmt( m_hstmt, SQL_CLOSE );
	if( SQL_SUCCEEDED( SQLExecDirect( m_hstmt, (BYTE*)stmt, strlen(stmt) ) ) )
			return S_OK;

	return E_FAIL;
}

HRESULT EnumMySQLs::Next( DSNINFO* pDSNINFO )
{		
	// To work correctly with NULL argument
	DSNINFO dummy;
	if( pDSNINFO == NULL )
		pDSNINFO = &dummy;

	SQLINTEGER info;
	if( SQL_SUCCEEDED( SQLFetch( m_hstmt ) ) &&
		SQL_SUCCEEDED( SQLGetData( m_hstmt, 1, SQL_C_CHAR, pDSNINFO->m_szDataSource, MAXDATASOURCENAME, &info ) ) &&
		SUCCEEDED( PathByName( pDSNINFO ) ) )
			return S_OK;

	return E_FAIL;
}			


HRESULT EnumMySQLs::Skip()
{		
	SQLFetch( m_hstmt );
	return S_OK;
}			


HRESULT EnumMySQLs::PathByName( DSNINFO* pDSNINFO )
{
	if( pDSNINFO == NULL )
		return E_INVALIDARG;

	GetType( &pDSNINFO->m_type );  // Save data source type information
	*pDSNINFO->m_szDDFPath = *pDSNINFO->m_szDataPath = '\0';
	strcpy0( pDSNINFO->m_szDescription, "MySQL Data Source Name", MAXSTR(pDSNINFO->m_szDescription) );
	
	return S_OK;
}

HRESULT EnumMySQLs::Count(int* count ) 
{ 
	if( !count ) 
		return E_INVALIDARG; 
	
	SQLINTEGER iCount;
	if( SUCCEEDED( Reset() ) &&
		SQL_SUCCEEDED( SQLRowCount( m_hstmt, &iCount ) ) )
	{
		*count = iCount;
		return S_OK;
	}
	
	return E_FAIL; 
}



