<?PHP
if (!defined('PHPUnit_MAIN_METHOD')) {
    define('PHPUnit_MAIN_METHOD', 'AllTests::main');    
}

require_once('PHPUnit/Framework/TestSuite.php');
require_once('PHPUnit/TextUI/TestRunner.php');

require_once('Function/AllTests.php');
require_once('Converter/AllTests.php');

/**
* PHPUnit AlltTests
*
* Check the README file in the directory for instructions!
*
* @category   UnitTests
* @package    MySQLConverterTool
* @author     Andrey Hristov <andrey@php.net>, Ulf Wendel <ulf.wendel@phpdoc.de>
* @copyright  1997-2006 The PHP Group
* @license    http://www.php.net/license/3_0.txt  PHP License 3.0
* @version    CVS: $Id:$, Release: @package_version@
* @link       http://www.mysql.com
* @since      Class available since Release 1.0
*/
class AllTests {
    
    public static function main() {
        PHPUnit_TextUI_TestRunner::run(self::suite());
    }

    public static function suite() {
        
        $suite = new PHPUnit_Framework_TestSuite('MySQLConverterTool');
        $suite->addTest(MySQLConverterTool_UnitTests_Function_AllTests::suite());
        $suite->addTest(MySQLConverterTool_UnitTests_Converter_AllTests::suite());
        
        return $suite;
    }
}

if (PHPUnit_MAIN_METHOD == 'AllTests::main') {
    AllTests::main();
}
?>