/*
 * Decompiled with CFR 0.152.
 */
package com.ice.sqlclient;

import com.ice.sqlclient.ErrMsgAdapter;
import com.ice.sqlclient.MySQLAdapter;
import com.ice.sqlclient.SQLClientHandler;
import com.ice.util.AWTUtilities;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSplitPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.table.TableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;

public class QueryTablePanel
extends JPanel
implements ActionListener {
    private JTextArea queryText;
    private JButton queryButton;
    private JPanel queryPanel;
    private JPanel resultPanel;
    private JSplitPane splitPane;
    private JTable resultTable;
    private MySQLAdapter sqlAdapter;
    private JScrollPane scroller;

    public QueryTablePanel() {
        this.setDoubleBuffered(true);
        this.establishContents();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("QUERY")) {
            String string2 = this.queryText.getText();
            SQLClientHandler sQLClientHandler = SQLClientHandler.getCurrentHandler();
            if (sQLClientHandler == null) {
                ErrMsgAdapter errMsgAdapter = new ErrMsgAdapter("INTERNAL ERROR: current handler is null.");
                this.setTableModel((TableModel)errMsgAdapter);
                return;
            }
            if (!sQLClientHandler.isOpen()) {
                ErrMsgAdapter errMsgAdapter = new ErrMsgAdapter("INTERNAL ERROR: connection is not open.");
                this.setTableModel((TableModel)errMsgAdapter);
                return;
            }
            try {
                this.sqlAdapter = (MySQLAdapter)sQLClientHandler.performTableSQLQuery(String.valueOf(string2) + "\n");
                this.setTableModel((TableModel)this.sqlAdapter);
                return;
            }
            catch (SQLException sQLException) {
                String string3 = "SQLException: performing query\n" + sQLException.getMessage();
                ErrMsgAdapter errMsgAdapter = new ErrMsgAdapter(string3);
                this.setTableModel((TableModel)errMsgAdapter);
                return;
            }
        }
        ErrMsgAdapter errMsgAdapter = new ErrMsgAdapter("INTERNAL ERROR: unknown command: " + string);
        this.setTableModel((TableModel)errMsgAdapter);
    }

    private void setTableModel(TableModel tableModel) {
        if (tableModel instanceof ErrMsgAdapter) {
            this.resultTable.setAutoResizeMode(2);
        } else {
            this.resultTable.setAutoResizeMode(0);
        }
        this.resultTable.setModel(tableModel);
        this.resultTable.tableChanged(new TableModelEvent(tableModel, -1));
    }

    private void establishContents() {
        int n = 0;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.queryPanel = new JPanel();
        this.queryPanel.setLayout(new GridBagLayout());
        this.queryPanel.setPreferredSize(new Dimension(450, 125));
        JLabel jLabel = new JLabel("Query:");
        AWTUtilities.constrain((Container)this.queryPanel, (Component)jLabel, 0, 17, 0, n, 2, 1, 0.0, 0.0);
        this.queryText = new JTextArea();
        this.scroller = new JScrollPane();
        this.scroller.getViewport().add((Component)this.queryText);
        AWTUtilities.constrain((Container)this.queryPanel, (Component)this.scroller, 1, 10, 0, ++n, 2, 1, 1.0, 1.0);
        this.queryButton = new JButton("Perform Query");
        this.queryButton.setActionCommand("QUERY");
        this.queryButton.addActionListener((ActionListener)this);
        AWTUtilities.constrain((Container)this.queryPanel, (Component)this.queryButton, 2, 10, 0, ++n, 2, 1, 1.0, 0.0);
        this.resultPanel = new JPanel();
        this.resultPanel.setLayout(new GridBagLayout());
        n = 0;
        jLabel = new JLabel("Result:");
        AWTUtilities.constrain((Container)this.resultPanel, (Component)jLabel, 0, 17, 0, n, 1, 1, 0.0, 0.0);
        ++n;
        this.sqlAdapter = new MySQLAdapter(null);
        this.resultTable = new JTable((TableModel)this.sqlAdapter);
        this.resultTable.setAutoResizeMode(0);
        this.scroller = JTable.createScrollPaneForTable((JTable)this.resultTable);
        this.scroller.setMinimumSize(new Dimension(250, 50));
        this.scroller.setVerticalScrollBarPolicy(22);
        this.scroller.setHorizontalScrollBarPolicy(32);
        AWTUtilities.constrain((Container)this.resultPanel, (Component)this.scroller, 1, 10, 0, n, 1, 1, 1.0, 1.0);
        ++n;
        this.splitPane = new JSplitPane(0, (Component)this.queryPanel, (Component)this.resultPanel);
        this.splitPane.setContinuousLayout(true);
        ((Container)((Object)this)).add((Component)this.splitPane, "Center");
    }
}

