unit MyMySQL;
//
// Updates note:
//
// 05-10-99 - ASI - added Several SQL Queries , and several SQL
//
// 18-09-99 - ASI - first created update notes!
//                  added clearform support
//                        use to clear forms from object inspector OnClick
//                  added ClientNumExit support
//                        use to setup number enter and update of form
//
//  TMyForm - Class :
//    reserved names on the form:
//      AddButton     / TButton / Button to add form to database
//      ExitButton    / TButton / Button to exit form
//      ClearButton   / TButton / Button to clear form
//      RefreshButton / TButton / Search Form only / Tests how many matched query
//                                                   of form from database.
//      SCButton      / TButton / Search Form only / Add To Shopping Cart the query
//      RepButton     / TButton / Search Form only / Creates report of query
//      MaxID         / TLabel  / Maximum ID of the current form.
//      ClientNum     / TEdit   / Number of client in the current form.
//      FirstName     / TEdit   / First name of client
//      LastName      / TEdit   / Last name of client
//
//    Regular procedures on MyForm:
//      AddForm     - Add the current form to the SQL Table.
//      UpdateForm  - Updates visibility of fonts
//      ClearForm   - Clears the form
//
//     LOG File Structre:  LOGCODE     INFO1     INFO2    CLIENTID    SUM
//                           01        LOGIN
//                           02        LOGOUT
//                           03        CLIENTADD
//                           04
//                           05        REALESTATE
//                           06        MANPOWERADD
//                           07        VEHICLEADD
//                           08        BUSINESSADD
//
{
   MYSQL Types:
          | DataTable  | DataVariable | DataGrid   | DataColumn | DataLabel  | DataEdit
          | ----------------------------------------------------------------------------
Format:   |  integer   |  As request  |   integer  | As Request | As Request | AsRequest
Field:    | As request |  As request  | As Request | As Request | As Request | AsRequest
SQLTable: |  itself    |              |            |            |            |
          |            |              |            |            |            |

Known Functions:
  synchronizetables - synchronize tables into sql
  synchronizefields - synchronize tables into fields
  insert into sql   - insert new column into sql
  update into sql   - update record into sql, using primary data
  replace into sql  - changes the new column into sql
  load from sql     - load record into sql, using primary key data
  }

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Db, Forms,
  StdCtrls, LUCombo, Mask, Spin , PBSpinEdit , IniFiles, Graphics, DataGrid, _libmysq;

const
  SQLAnd = ' AND ';
  SQLOr  = ' OR ';
  SQLMode_Count     = 1;
  SQLMode_SelectAll = 2;
  Vat = 17.00;
  SQLChar = '''';
  SQLFinishChar = '';


 {Load / Save Query Options}

{
     Database - A Structore which hold data, in formated sturctores of Tables.
                The Database can be held any place, and its the shared memory
                of all users.
     Table - Array on Database splitted into fields and can hold data;
     Field - A Column on the Database, which has unique types of what can be hold.
     SQLType - The type of the field format, 'field CHAR(15)'

     Form - Like table but it can only hold one record! stored on local memory,
            and it is user's local memory.
     Array - Like table , can hold several records! stored in local memory,
            and it is user's local memory.
     Column - a column on the form or array, which can hold several functions.
     Format - The type of the column
}

 const
   msSyncTables   = $0001;   // create new tables, if needed from Form & Array types.
   msSyncFields   = $0002;   // create new fields, if needed from Columns
   msSyncForms    = $0004;   // create new forms, if needed from tables ,
   msSyncColumns  = $0008;   // create new columns, if needed from fields.
   { msSyncForms & msSyncColumns will be capable on next version, if all the
     program itself will be kept on the database.}
   msSyncFormats  = $0010;   // synchronize all the SQL types and Formats of the columns
   msSyncInto     = $0020;   // Synchronize into inherrited arrays or tables
//   lgFormtoSQLSync  = $0001; //  Synchronize Form with Table (adding Components to SQLColumns)
//   lgSQLtoFormSync  = $0002; //  Synchronize Table with Form (adding SQL Columns to Form)
//   lgSQLtoGridSync  = $0004; //  Synchronize Grid with Table (adding GridColumns to SQLColumns)
//   lgGridtoSQLSync  = $0008; //  Synchronize Table with Grid (adding SQLColumns to GridColumns)
//   lgNoUpdte        = $0010; //  Do not update tables and grids
//   lgNoTableCreate  = $0020; //  Do not create table if table does not exist
//   lgGridTypeSync   = $0040; //  Do not synchronize the types of grid relative to sql
//   lgSQLTypeSync    = $0080; //  Do not synchronize the types of SQL relative to grid


var
  PCID   : string;

 {- Components handling}
function GetOutString (SubStr : string ; S : string) : String;
 {- Returns the string not between the SubStr}
function GetInString (SubStr : string ; S : string) : String;
 {- Returns the string between the SubStr}
procedure SetFieldMode (Sender : TObject; Mode : Boolean);
 {- Set the field of Sender to enable or disable}
procedure SetFieldModeWithLabel (Sender : TObject; Mode : Boolean);
 {- Set the field of Sender to enable or disable and also components starting with 'L'}
function  strnum2str (s : string) : string;
 {- Takes string checks it and reformat it and return string}
function CheckedToYN (Sender : TCheckBox) : char;
 {- function to check CHECKBOX and return 'Y' or 'N'}
procedure YNToChecked (Sender : TCheckBox ; S : String);
 {- procedure to change the Sender.Checked relative to S = ['Y','N','n']}
function GetWord (SubStr,S : string ; Count : word) : String;
 {- Get the word number inside the string}
function LongChr (X : integer) : string;
 {- Get integer, and return it as string format in byte type}
function LongOrd (S : string) : integer;
 {- Get string and translate it to integer}
function CRLFTrim (S : String) : String;
 {- Remove CRLF from Text file, changes it to space}

function CalcPullWindowSpeed (MaxSize,MinSize,CurPos,Relative : integer) : integer;
 {- Get Window size and calculate the next step in fast pulldown}

 {Handles the Variables Types}
function DBStrFormat (GridType : TColumnFormat ; length : word) : string;
 {- Translate TColumnFormat to SQL type}
function GetTable (Component : TObject) : string;
 {- Returns the name of the table of object}

procedure SetMaxLength (Component : TObject ; MaxLength : integer);

{Main unit}
procedure SaveGrid (MySQLRec : MySQL ; Grid : TDataGrid ; Options : Integer);
 {- Update Grid cells according to Linked Data and row counter}
procedure LoadGrid (MySQLRec : MySQL ; Grid : TDataGrid ; Options : Integer);
 {- Load Grid cells according to primary key and row counter}
//procedure LoadForm (MySQLRec : MySQL ; Component : TObject ; Options : Integer);
 {- Loads form from SQL Database, Search method is Component, wild card allowed}
procedure SaveForm (MySQLRec : MySQL; Form : TForm ; Options : Integer);
 {- Insert form into SQL table from all form components}
procedure InsertForm (Form : TForm ; Options : Integer ; Component : TComponent);
 {- Updates form into SQL table from all form components, where update form is the}

{Sql procedures}
function FixSQLString (S : string) : string;
function SQLBetween (FieldName ,SQLRel,  SQLFrom , SQLTo : string) : string;
function SQLEqual (FieldName, SQLRel,SQLEqual : string) : string;
function SQLStrEqual (FieldName, SQLRel,SQLEqual : string) : string;
function SQLYNEqual (FieldName, SQLRel : string ; SQLEqual : TCheckBoxState) : string;
function SQLAddRel (String1 , SQLRel, String2 : String) : string;
function SQLAlike (FieldName,SQLRel, SQLAlike : string) : string;

procedure SQLSelectAll (SQL : TStrings ; TableName : String);
procedure SQLCount (SQL : TStrings ; TableName , ResultsField : String);

procedure SQLInsertStart (SQL : TStrings ; TableName : String);
 {- Start and initialize INSERT Query of SQL}
procedure SQLReplaceStart (SQL : TStrings ; TableName : String);
 {- Start and initialize REPLACE Query of SQL}
procedure SQLUpdateStart (SQL : TStrings ; TableName : String);
 {- Start and initialize UPDATE Query of SQL}

procedure SQLcfInsert (SQL : TStrings ; Format : TColumnFormat ; RecordName,RecordData : string ; Size : word);
 {- Insert into record the format of the Column format}
procedure SQLStrInsert (SQL : TStrings ; RecordName,RecordData : String);
 {- Insert into Record name the String Record Data}
procedure SQLInsert (SQL : TStrings ; RecordName,RecordData : String);
 {- Insert into Record name the Integer Record Data}
procedure SQLIntInsert (SQL : TStrings ; RecordName : string ; RecordData : Integer);
 {- Insert into Record name the integer Record data}
procedure SQLStrUpdate (SQL : TStrings ; RecordName,RecordData : String);
procedure SQLIntUpdate (SQL : TStrings ; RecordName : string ; RecordData : Integer);
procedure SQLUpdate (SQL : TStrings ; RecordName : string ; RecordData : String);
procedure SQLYNInsert (SQL : TStrings ; RecordName : string ; RecordData : TCheckBoxState);
 {- Insert into Record name the Y/N Record data}
//procedure SQLQueryInsert (SQL : TStrings ; RecordName : string ; RecordData : String);
 {- Insert into SQL Record the Update query}
procedure SQLInsertFinish (SQL : TStrings);
 {- Finish of SQL Insert Query}
//procedure SQLReplaceFinish (SQL : TStrings);
 {- Finish of SQL Replace Query}
procedure SQLUpdateFinish (SQL : TStrings ; Key : String ; KeyData : String);
 {- Finish of SQL Update Query, with update rules of key = keydata}
//procedure SQLUpdateFinish (SQL : TStrings);
 {- Finish of SQL Update Query}

{Real SQL Functions}
function ConnectToServer (var MySQLRec : MySQL ; Host,User,Passwd : string): integer;
 {- Connect to MySQL Server}
function ConnectToDB (var MySQLRec : MySQL ; DBName : string) : integer;
 {- Connect to MySQL Database}
procedure DisconnectFromServer (var MySQLRec : MySQL);
 {- Disconnected from MySQL DataBase}
function SendSQLQuery (var MySQLRec : MySQL ; SQL : TStrings) : integer;
 {- Use connection to send SQL Query}
function FetchRow (var MySQLRec : MySQL ; SQLData : TStrings) : integer;
 {- Fetch row from MySQL server}
function RemovePhoneTrails (Str : String) : String;
 {- Removes chars not allowed in phone number}

implementation

function CRLFTrim (S : String) : String;
 {- Remove CRLF from Text file, changes it to space}

var
 I : integer;

 begin
  I:=Pos(#10#13,S);
  while I>0 do
   begin
     S:=Copy (S,1,I-1)+' '+Copy(S,I+2,Length(S)-I-2);
     I:=Pos(#10#13,S);
   end;
  I:=Pos(#13#10,S);
  while I>0 do
   begin
     S:=Copy (S,1,I-1)+' '+Copy(S,I+2,Length(S)-I-2);
     I:=Pos(#13#10,S);
   end;
  result:=S;
 end;


function GetWord (SubStr,S : string ; Count : word) : String;
 {- Get the word number inside the string}

var
 I : integer;
 I1 : integer;

begin
 S:=S+SubStr; I1:=1;
 for I:=1 to count-1 do
   I1:=I1+Pos(SubStr,Copy (S,I1,Length(S)-I1+1));
 result:=Copy (S,I1,Pos(SubStr,Copy (S,I1,Length(S)-I1+1))-1);
end;

function LongChr (X : integer) : string;

begin
 Result:=Chr(X and $FF)+Chr(X and $FF00 DIV $100)+Chr(X and $FF0000 DIV $10000)+Chr(X and $FF000000 DIV $1000000);
end;

function LongOrd (S : string) : integer;
 {- Get string and translate it to integer}

begin
  S:=S+#00+#00+#00+#00;
  result:=ord(S[1])+(ord(S[2])*$100)+(ord(S[3])*$10000)+(ord(S[4])*$1000000);
end;

function CalcPullWindowSpeed (MaxSize,MinSize,CurPos,Relative : integer) : integer;

begin
 result:=round((MaxSize-CurPos)/Relative+1);
end;

procedure UpdateTableFromForm (Form : TForm ; Options : integer);
 {- Updates table from form components to grid}
begin

end;

procedure SaveForm (MySQLRec : MySQL; Form : TForm ; Options : Integer);
 {- Insert form into SQL table from all form components}

var
 I : integer;
// S,S1 : string;
 Table : string;
 SQL : TStringList;
 Components : TComponent;

begin
// if (Options and (0))>0 then
{  SynchronizeForm (MySQLRec,Form,Options);}
 SQL:=TStringList.Create;
 SQL.Clear;
 SQLInsertStart (SQL,'TABLE');
 for I:=1 to Form.ComponentCount do
  begin
   Components:=Form.Components[I] as TComponent;
   if (Components is TDataVariable) then
    begin
     if (Components as TDataVariable).Field<>'' then
      SQLcfInsert (SQL,(Components as TDataVariable).Format,(Components as TDataVariable).Field,(Components as TDataVariable).VariableData,(Components as TDataVariable).MaxLength);
    end
   else
    if (Components is TDataTable) then
     begin
      Table:=(Components as TDataTable).DBTableName;
     end
    else
     if (Components  is TDataGrid) then
      SaveGrid (MySQLRec,Components as TDataGrid,Options);
  end;
 if Table='' then exit;
 SQL[0]:='insert into '+Table;
 SQLInsertFinish (SQL);
end;

procedure SQLcfInsert (SQL : TStrings ; Format : TColumnFormat ; RecordName,RecordData : string ; Size : word);

 begin
  if RecordName<>'' then
   begin
    RecordData:=FixSQLString(RecordData);
    SQL.Strings[1]:=SQL.Strings[1]+RecordName+',';
//  TColumnFormat = (cfString, cfNumber, cfDate, cfBoolean, cfReal);
    if (Format=cfNumber) or (Format=cfReal) then
     SQL.Strings[2]:=SQL.Strings[2]+RecordData+',' else
    if (Format=cfString) or (Format=cfDate) then
     SQL.Strings[2]:=SQL.Strings[2]+SQLChar+RecordData+SQLChar+',' else
    if (Format=cfBoolean) then
     begin
      RecordData:=Uppercase (RecordData);
      if (RecordData='Y') or (RecordData = 'TRUE') or (RecordData='T') or
         (RecordData='ENABLE') or (RecordData='ON') or (RecordData='YES') or
         (RecordData='') or (RecordData='') or (RecordData='EN') then
         RecordData:='Y' else
      if (RecordData='N') or (RecordData = 'FALSE') or (RecordData='F') or
         (RecordData='DISABLE') or (RecordData='OFF') or (RecordData='NO') or
         (RecordData='') or (RecordData='') or (RecordData='DIS') then
         RecordData:='N';
// BooleanExpression = set of string ('Y','TRUE','T','','ENABLE','ON','YES');
       SQL.Strings[2]:=SQL.Strings[2]+SQLChar+RecordData+SQLChar+',';
     end;
   end;
 end;

function IsTable (Component : TObject) : boolean;

 begin
  if (Component is TForm) or (Component is TDataGrid) or (Component is TDataTable) then
   result:=true else result:=false;
 end;

function isArray (Component : TObject) : boolean;

 begin
  if (Component is TDataTable) or (Component is TColumn) then result:=true
  else result:=false;
 end;


procedure InsertForm (Form : TForm ; Options : Integer ; Component : TComponent);
 {- Updates form into SQL table from all form components, where update form is the}
begin

end;

function GetOutString (SubStr : string ; S : string) : String;
 {- Returns the string not between the SubStr}
var
 I,I1 : integer;

begin
 I:=Pos(SubStr,S); result:='';  // 'abcdefabcde'
 I1:=Pos(SubStr,Copy(S,I+Length(SubStr),Length(S)-I-Length(SubStr)+1));
 result:=Copy (S,1,I-1)+Copy (S,I+I1+Length(SubStr),Length(S)-I-I1-Length(SubStr)+1);
end;

function GetInString (SubStr : string ; S : string) : String;
 {- Returns the string between the SubStr}

var
 I,I1 : integer;

begin
 I:=Pos(SubStr,S); result:='';     // 'fabcdefghijabcd' result: 'cdefghij'
 I1:=Pos(SubStr,Copy(S,I+Length(SubStr),Length(S)-I-Length(Substr)+1));
 if I1=0 then I1:=Length(S)-I-Length(SubStr);
 if I>0 then result:=Copy (S,I+Length(Substr),I1-1);
end;

function RemovePhoneTrails (Str : String) : String;

var
 I : Integer;

 begin
  if Str='' then Exit;
  if (Str[1]='+') or (Str[1]='0') then Delete (Str,1,1);
  I:=Pos('-',Str);
  While I>0 do
   begin
    Delete (Str,I,1);
    I:=Pos('-',Str);
   end;
  Result:=Str;
 end;

function ConnectToServer (var MySQLRec : MySQL ; Host,User,Passwd : string): integer;

begin

     mysql_connect(@mysqlrec, PChar(host), PChar(user), PChar(passwd));
     ConnectToServer:=mysqlrec._net.last_errno;
end;

function ConnectToDB (var MySQLRec : MySQL ; DBName : string) : integer;

begin
  Result:= mysql_select_db(@MySqlRec, PChar(DBName));
end;

function SendSQLQuery (var MySQLRec : MySQL ; SQL : TStrings) : integer;

begin
  result:=mysql_query(@mysqlrec, SQL.GetText);       //Send Query to server
end;

procedure DisconnectFromServer (var MySQLRec : MySQL);

 begin
  mysql_close (@mysqlrec);
 end;

function FetchRow (var MySQLRec : MySQL ; SQLData : TStrings) : integer;

var
  presults : pmysql_res; //results structure *pointer
  prow     : pmysql_row; //row structure *pointer
  row      : mysql_row;  //Couldnt figure out pointer arithmetic so....you'll see
  i        : integer;

begin
 result:=0;
 presults:= mysql_store_result(@mysqlrec);
 if presults<>nil then
  begin
   prow:=mysql_fetch_row (presults);
   if prow<>nil then
    begin
     row:= prow^;            // Only way I could figure out to use an index into a MYSQL_ROW struct
     for i:=0 to presults.field_count-1 do SQLData.Add (StrPas(row[I]));
    end
   else
    result:=-1;
  end
 else
  result:=-2;
end;

procedure SetLinkedData (Component : TObject ; LinkedData : string);

var
 I : integer;

begin
  if Component is TDataGrid then
   (Component as TDataGrid).DBLinkedData:=LinkedData else
  if Component is TForm then
   begin
     for I:=1 to (Component as TForm).ComponentCount do
      if (Component as TForm).Components[I] is TDataTable then
       ((Component as TForm).Components[I] as TDataTable).DBLinkedData:=LinkedData;
   end
  else
   if Component is TDataVariable then
    SetLinkedData ((Component as TDataVariable).Owner,LinkedData) else
   if Component is TColumn then
    SetLinkedData ((Component as TColumn).Grid,LinkedData) else
end;

procedure SetField (Component : TObject ; Field : string);
 {- Set Field name of component}

begin
 if Component is TDataVariable then
  (Component as TDataVariable).Field:=Field else
 if Component is TColumn then
  (Component as TColumn).Field:=Field;
end;

function DBStrFormat (GridType : TColumnFormat ; length : word) : string;
 {- Translate TColumnFormat to SQL type}

begin
// TColumnFormat = (cfString, cfNumber, cfDate, cfBoolean, cfReal);
 case GridType of
  cfString  : if length=0 then result:='varchar (255)' else result:='char ('+inttostr(length)+')';
  cfNumber  : case length of
                 0        : result := 'integer';
                 1        : result := 'tinyint';
                 2        : result := 'smallint';
                 3        : result := 'mediumint';
                 4        : result := 'integer';
                 5..$ffff : result := 'bigint';
               end;
  cfDate    : result := 'date';
  cfboolean : result := 'enum ('+SQLChar+'Y'+SQLChar+','+SQLChar+'N'+SQLChar+')';
  cfReal    : case length of
                 0..4      : result := 'float';
                 5..$ffff  : result := 'real';
              end;
 end;
end;

procedure SQLUpdate (SQL : TStrings ; RecordName : string ; RecordData : String);

 begin
   RecordData:=FixSQLString(RecordData);
   SQL.Strings[1]:=SQL.Strings[1]+RecordName+' = '+RecordData+',';
 end;

procedure SetMaxLength (Component : TObject ; MaxLength : integer);

begin
 if Component is TDataVariable then
  (Component as TDataVariable).MaxLength:=MaxLength else
 if Component is TColumn then
  (Component as TColumn).MaxLength:=MaxLength;
end;

procedure SetFormat (Component : TObject ; Format : TColumnFormat);

begin
 if Component is TDataVariable then
  (Component as TDataVariable).Format:=Format else
 if Component is TColumn then
  (Component as TColumn).Format:=Format;
end;

procedure SetFieldData (Component : TObject ; S : string);

 begin
  if Component is TDataVariable then
   (Component as TDataVariable).VariableData:=S;
 end;

function GetFormat (Component : TObject) : TColumnFormat;

begin
 if Component is TDataVariable then
  result:=(Component as TDataVariable).Format else
 if Component is TColumn then
  result:=(Component as TColumn).Format else
 if (Component is TDataGrid) or (Component is TForm) or (Component is TDataTable) then
  result:=cfString else result:=cfString;
end;

function GetFieldData (Component : Tobject) : string;
 {- Get component and returns the Data in the component}

 begin
  if Component is TDataVariable then
   result:=(Component as TDataVariable).VariableData else
//  if Component is TColumn then
//   result:=(Component as TColumn).VariableData;
 end;

function GetLength (Component : TObject) : integer;

 begin
  result:=-1;
  if Component is TDataVariable then
   result:=(Component as TDataVariable).MaxLength else
  if Component is TColumn then
   result:=(Component as TColumn).MaxLength;
  if (Component is TDataGrid) or (Component is TForm) or (Component is TDataTable) then
   result:=16;
 end;

function GetField (Component : TObject) : string;
 {- Get component and returns the DBField}

 begin
  if Component is TDataVariable then
   result:=(Component as TDataVariable).Field else
  if Component is TColumn then
   result:=(Component as TColumn).Field;
  if (Component is TDataGrid) or (Component is TForm) or (Component is TDataTable) then
   result:=GetTable (component);
 end;

function GetSQLField (Component : TObject) : string;
 {Get the component field name FIELD1 CHAR(25);}

 begin
   if Component is TDataVariable then
    result:=(Component as TDataVariable).Field+' '+DBStrFormat((Component as TDataVariable).Format,(Component as TDataVariable).MaxLength);
   if Component is TColumn then
    result:=(Component as TColumn).Field+' '+DBStrFormat ((Component as TColumn).Format,(Component as TColumn).MaxLength);
 end;

function SQLTypeToFormat (SQLType : byte ; var length : word) : TColumnFormat;

 begin
   result := cfNumber;
   case SQLType of
   1..3     : result := cfNumber;
   4..5     : result := cfReal;
   253      : result := cfString;
   254      : begin
               result := cfString;
               Length := 0;
              end;
   10       : result := cfDate;
   247      : result := cfBoolean;

   { field_type_time=11;
   field_type_datetime=12;
   field_type_set=248;
   field_type_tiny_blob=249;
   field_type_medium_blob=250;
   field_type_long_blob=251;
   field_type_blob=252;
   not implemented yet!
   }
   end; {case}
 end;


procedure UpdateSQLType (SQLType : byte ; length : word ; Component : TObject);

begin
 SetFormat (Component,SQLTypetoFormat(SQLType,length));
 SetMaxLength (Component,length);
end;

function CreateTable (MySQLRec : MySQL; TableName : string) : integer;

var
  S : string;

begin
  S:='create table '+TableName;
  result:=mysql_query(@mysqlrec, pchar(S));       //Send Query to server
end;

procedure SynchronizeGrid (MySQLRec : MySQL ; Grid : TDataGrid ; Options : Integer);
 {- Synchronize Grid and Grid in table}

//var
// presults : pmysql_res;
// fields : TStringList;
// pfield : pmysql_field;
// field : mysql_field;
// I,I1 : integer;
// S : string;
// bool : boolean;

begin
{ if (Grid.DBTableName <> '') and (Options and (lgSQLtoGridSync+lgGridtoSQLSync)>0) then
  begin
   fields:=TStringList.Create;
   fields.Clear;
   presults:=nil;
   try
    presults:=mysql_list_fields(@MySQLRec,PChar(Grid.DBTableName),#00);
    if (presults=nil) and (options and lgNoTableCreate<>lgNoTableCreate) then //Table does not exist in this database
     begin  // create table , and then re-read it!
      S:='';
      if (Grid.DBPrimaryField<>'') then
       S:=S+Grid.DBPrimaryField+' '+DBStrFormat (cfString,16)+',';
      for I:=0 to Grid.ColCount-1 do
       if (GetField (Grid.Columns[I]) <> '') then
        S:=S+GetField (Grid.Columns[I])+' '+DBStrFormat (Grid.Columns[I].Format,Grid.Columns[I].MaxLength)+',';
      if S<>'' then
       begin
        S:='create table '+Grid.DBTableName+' ('+Copy (S,1,Length(S)-1)+')';
        if _libmysq.mysql_query (@MySQLRec,PChar(S))=0 then
        presults:=mysql_list_fields(@MySQLRec,PChar(Grid.DBTableName),#00);
       end;
     end;
    if presults<>nil then // if table exist, fetch rows, and updates them as required!
     begin
        for I:=0 to presults^.field_count-1 do
         begin
          pfield := mysql_fetch_field (presults);
          field := pfield^;
          fields.Add (UpperCase(StrPas (field.name))) ;
          // is this column exist in the grid?
          // if yes, check if type not the same, and possible to update type, if yes, update it.
          // if no, check if need to alter grid, if yes, alter table.
          bool:=false;
          for I1:=0 to Grid.ColCount-1 do
           if UpperCase (StrPas (field.name))=UpperCase(GetField(Grid.Columns[I1])) then
            begin
             bool:=true;
             if (Options and lgGridTypeSync=lgGridTypeSync) then
              UpdateSQLType (field._type,field.length,Grid.Columns[I]);
            end;
          if not bool and (Options and lgGridtoSQLSync=lgGridtoSQLSync) then
           begin end; // here, to synchronize the grid, by new columns!
         end;
     end;
   finally
      mysql_free_result(presults);
   end;
   // fetched all rows. Now we check if grid is the same!
  if (Options and (lgSQLtoGridSync+lgSQLTypeSync))>0 then
    begin
     S:=''; // synchronize primary field
     if (Grid.DBPrimaryField<>'') and (Fields.IndexOf (UpperCase(Grid.DBPrimaryField))=-1) then
      S:=S+' add '+Grid.DBPrimaryField+' '+DBStrFormat (cfString,16)+',';
     for I:=0 to Grid.ColCount-1 do
      if (GetField(Grid.Columns[I])<>'') and (Fields.IndexOf (UpperCase(GetField(Grid.Columns[I])))=-1) then
       S:=S+' add '+GetField(Grid.Columns[I])+' '+DBStrFormat(Grid.Columns[I].Format,Grid.Columns[I].MaxLength)+','
      else begin end; // check here if types are the same, and if needed to be synchronized
     if S<>'' then
      begin
       S:='alter table '+Grid.DBTableName+' '+Copy (S,1,Length(S)-1);
       mysql_query (@MySQLRec,PChar(S)); // send alter table if needed!
      end;
    end;
   Fields.Free;
 end;}
end;

function GetTable (Component : TObject) : string;

var
 I : integer;

 begin
  if Component is TDataTable then
   result:=(Component as TDataTable).DBTableName else
  if Component is TDataGrid then
   result:=(Component as TDataGrid).DBTableName else
  if Component is TForm then
   begin
     for I:=1 to (Component as TForm).ComponentCount do
      if (Component as TForm).Components[I] is TDataTable then
       result:=((Component as TForm).Components[I] as TDataTable).DBTableName;
   end
  else
   if Component is TDataVariable then
    result:=GetTable ((Component as TDataVariable).Owner) else
   if Component is TColumn then
    result:=GetTable ((Component as TColumn).Grid) else
   result:='';
 end;

function GetPrimaryField (Component : TObject) : string;

var
 I : integer;

 begin
  if Component is TDataGrid then
   result:=(Component as TDataGrid).DBPrimaryField else
  if Component is TForm then
   begin
     for I:=1 to (Component as TForm).ComponentCount do
      if (Component as TForm).Components[I] is TDataTable then
       result:=((Component as TForm).Components[I] as TDataTable).DBPrimaryField;
   end
  else
   if Component is TDataVariable then
    result:=GetPrimaryField ((Component as TDataVariable).Owner) else
   if Component is TColumn then
    result:=GetPrimaryField ((Component as TColumn).Grid) else
   result:='';
 end;

function GetLinkedData (Component : TObject) : string;

var
 I : integer;

 begin
  if Component is TDataGrid then
   result:=(Component as TDataGrid).DBLinkedData else
  if Component is TForm then
   begin
     for I:=1 to (Component as TForm).ComponentCount do
      if (Component as TForm).Components[I] is TDataTable then
       result:=((Component as TForm).Components[I] as TDataTable).DBLinkedData;
   end
  else
   if Component is TDataVariable then
    result:=GetLinkedData ((Component as TDataVariable).Owner) else
   if Component is TColumn then
    result:=GetLinkedData ((Component as TColumn).Grid) else
   result:='';
 end;

function ComponentCount (Component : TObject) : integer;

 begin
  if (Component is TForm) then
   result:=(Component as TForm).ComponentCount else
  if (Component is TDataGrid) then
   result:=(Component as TDataGrid).ColCount
  else
   result:=0;
 end;

function GetColumn (Component : TObject ; Index : integer) : TObject;

 begin
  if (Component is TDataTable) then
   result:=GetColumn ((Component as TDataTable).Owner,Index);
  if (Component is TForm) then
   result:=(Component as TForm).Components[Index] as TObject else
  if (Component is TDataGrid) then
   result:=(Component as TDataGrid).Columns[Index-1] as TObject
  else
   result:=nil;
 end;


procedure SynchronizeTables (MySQLRec : MySQL ; Table : TObject ; Options : Integer);

var
 presults : pmysql_res;
 pfield : pmysql_field;
 field : mysql_field;
 I : integer;
 S : string;
 TableName : string;
 PrimaryField : string;

begin
 if GetTable (Table)<>'' then
  begin
    presults:=nil;
    presults:=mysql_list_fields(@MySQLRec,PChar(TableName),#00);
    if (presults=nil) and (options and msSyncTables=msSyncTables) then {Table does not exist in this database}
     begin  // create table , and then re-read it!
      PrimaryField:=GetPrimaryField (Table);
      if (PrimaryField<>'') then
       S:=S+PrimaryField+' '+DBStrFormat (cfString,16)+',';
       for I:=1 to ComponentCount(Table) do
        if GetColumn(Table,I)<>nil then // its object for us!
         begin
          if (GetColumn(Table,I) is TForm) or (GetColumn (Table,I) is TDataGrid) then
           begin
            SynchronizeTables (MySQLRec,GetColumn(Table,I),Options);
            S:=S+GetPrimaryField (GetColumn(Table,I))+' '+DBStrFormat (cfString,16)+',';
           end
          else
           if GetField(GetColumn(Table,I))<>'' then
            S:=S+GetField (GetColumn(Table,I))+' '+GetSQLField (GetColumn(Table,I));
           // synchronized tables!
         end;
      if S<>'' then
       begin
        S:='create table '+GetTable(Table)+' ('+Copy (S,1,Length(S)-1)+')';
        mysql_query (@MySQLRec,PChar(S));
        {To Put error of writing table}
       end;
     end;
  end;
end;

//         presults:=mysql_list_fields(@MySQLRec,PChar(TableName),#00);

procedure SynchronizeFields (MySQLRec : MySQL ; Table : TObject ; Options : Integer);

var
 presults : pmysql_res;
 pfield : pmysql_field;
 field : mysql_field;
 I,I1 : integer;
 S : string;
 bool : boolean;
 TableName : string;
 PrimaryField : string;
 MaxLength : word;

begin
 if ((Options and msSyncFields)=msSyncFields) and (GetTable (Table)<>'') then
  begin
   try
   presults:=nil;
   presults:=mysql_list_fields(@MySQLRec,PChar(TableName),#00);
   if (presults<>nil) then {Table does not exist in this database}
     begin  // if table exist, now we can move into synchronizing fields!
      {synchronizing grid, and grid types by SQL}
      for I:=0 to presults^.field_count-1 do
        begin
         pfield := mysql_fetch_field (presults);
         field := pfield^;
          // is this column exist in the grid?
          // if yes, check if type not the same, and possible to update type, if yes, update it.
          // if no, check if need to alter grid, if yes, alter table.
          bool:=false;
          for I1:=1 to ComponentCount(Table) do
           if UpperCase (StrPas (field.name))=UpperCase(GetField(GetColumn(Table,I1))) then
            begin
             bool:=true;
             if (Options and msSyncFormats=msSyncFormats) then
              UpdateSQLType (field._type,field.length,GetColumn(Table,I));
            end;
          if not bool and (Options and msSyncColumns=msSyncColumns) then
           begin
           // here, to synchronize the grid, by new columns!
           end;
        end;
     end;
    S:='';
    {Synchronize SQL fields , and SQL types}
    for I:=1 to ComponentCount (Table) do
     begin
      presults^.current_field:=0;
      pfield := mysql_fetch_field (presults);
      field := pfield^;
      bool:=false;
      for I1:=0 to presults^.field_count do
       begin
        if (IsTable (GetColumn(Table,I1))) and (GetTable(GetColumn(Table,I1))<>GetTable(Table)) then   {if this column is table than redo}
         SynchronizeFields (MySQLRec,GetColumn (Table,I1),Options);
        if UpperCase (StrPas (field.name))=UpperCase (GetField(GetColumn(Table,I))) then
         begin         // if field exist, check if need to update SQL
          bool:=true; MaxLength:=field.length;
          if (Options and msSyncFormats=msSyncFormats) then
           if SQLTypetoFormat(field._type,MaxLength)<>GetFormat(GetColumn(Table,I1)) then
            begin
             S:=S+' change '+field.name+' '+DBStrFormat (GetFormat(GetColumn(Table,I1)),GetLength(GetColumn(Table,I)))+',';
            end;
         end;
        if (not bool) and ((Options and msSyncColumns)=msSyncColumns) then {record was not found}
          S:=S+' add '+field.name+' '+DBStrFormat (GetFormat(GetColumn(Table,I1)),GetLength(GetColumn(Table,I)))+',';
       end;
     end;
    if S<>'' then
     begin
      S:='alter table '+GetTable(Table)+' '+Copy (S,1,Length(S)-1);
      mysql_query (@MySQLRec,PChar(S)); // send alter table if needed!
     end;
   finally
    mysql_free_result (presults);
   end;
 end;
end;

procedure InLoad (MySQLRec : MySQL ; Component : TObject ; Options : Integer);

var
 I,I1 : integer;
 Fetchedrows : integer;
 presults : pmysql_res;
 prow: pmysql_row;     //row structure *pointer
 row: mysql_row;       //Couldnt figure out pointer arithmetic so....you'll see
 S : string;

begin  // which records should be selected?
 if GetTable (Component) <> '' then
  begin
   S:='';
   if (GetPrimaryField (Component) <> '') then
    S:=S+GetPrimaryField (Component)+',';
   for I:=1 to ComponentCount (Component) do
    begin
      if GetField (GetColumn(Component,I))<>'' then
       S:=S+GetField (GetColumn(Component,I))+','; {Select SQL Query}
    end;
   if S<>'' then
    begin
     S:='select '+copy (S,1,Length(S)-1)+' from '+GetTable (Component);
     if (GetPrimaryField (Component) <> '') and
        (GetLinkedData (Component) <> '') then
      S:='where '+GetPrimaryField (Component)+' = '+SQLChar+GetLinkedData(Component)+SQLChar;
     if mysql_query (@MySQLRec,PChar(S))=0 then
      begin
        presults:=nil;
        try
         presults:= mysql_store_result(@mysqlrec); //Store results locally
         {now we got the record we need, if its array type, we need to loop until
          we can fetch all the results, if not array type, then get only the first match}
         if (presults^.row_count>0) and (not IsArray(Component)) then Fetchedrows:=1 else
          begin
           FetchedRows:=presults^.row_count;
           // if we need to insert, or append or clear, there is the place to initialize it.
          end;
         for I1:=1 to FetchedRows do
          begin
           prow:= mysql_fetch_row(presults);
           row:= prow^;
           if GetPrimaryField (Component)<>'' then
            SetLinkedData (Component,StrPas(row[I1]));
           For I:=1 to ComponentCount (Component) do
            if GetField (GetColumn(Component,I))<>'' then
             begin
              SetFieldData (GetColumn (Component,I),StrPas(Row[I]));
            {if its array field then we need to get cursor next}
              if IsArray (Component) then
               begin
                // set to next grid, if needed.
                // if we need to load also inherited columns, call InLoad again.
               end;
            end;
          end;
        finally
        end;
      end;
    end;
  end;
end;

procedure Load (MySQLRec : MySQL ; Component : TObject ; Options : Integer);

var
 I : Integer;
 S : string;

begin
 {first need to get the table of the object}
 SynchronizeTables(MySQLRec,Component,Options);
 SynchronizeFields(MySQLRec,Component,Options);

end;

procedure LoadGrid (MySQLRec : MySQL ; Grid : TDataGrid ; Options : Integer);
 {- Load Grid cells according to primary key and query and row counter}

 {    - lgSQLSync       - Synchronize Grid with Table (adding GridColumns to SQLColumns)
      - lgGridSynC      - Synchronize Table with Grid (adding SQLColumns to GridColumns
      - lgAppend        - Append Queries to Table
      - lgInsert        - Insert Queries to Table from Current Grid position
      - lgPrimaryAsLike -
 }

var
  SQL : TStringList;
  I,I1 : integer;
  presults: pmysql_res; //results structure *pointer
  prow: pmysql_row;     //row structure *pointer
  row: mysql_row;       //Couldnt figure out pointer arithmetic so....you'll see
  S : string;

begin
{ S:='';
 if Options and (lgSQLtoGridSync+lgGridtoSQLSync)>0 then
  SynchronizeGrid (MySQLRec,Grid,Options);
 SQL:=TStringList.Create;
 for I:=0 to Grid.ColCount-1 do
  if Grid.Columns[I].RecordName <> '' then
   S:=S+Grid.Columns[I].RecordName + ',';
 if S='' then S:='*' else S:=Copy (S,1,Length (S)-1);
 SQL.Clear;
 SQL.Add ('select '+S+' from '+Grid.DBTableName);
 if Grid.DBPrimaryField <> '' then
   SQL.Add ('where '+Grid.DBPrimaryField+' = '+Grid.DBLinkedData);
 presults:= nil;
 if SendSQLQuery (MySQLRec,SQL)=0 then
  begin
   try
    presults:= mysql_store_result(@mysqlrec); //Store results locally
    for I:= 1 to presults^.row_count do
     begin
      prow:= mysql_fetch_row(presults);
      row:= prow^;
      for I1:= 0 to presults^.field_count -1 do
       begin
        Grid.Cells[I1,I]:= StrPas(row[I1]);
       end;
     end; // i
    finally
        mysql_free_result(presults);
     end;
  end;}
end;
 {
         lgSync      - Synchronize Grid first
         lgSyncGrid  - Synchronize Grid, but grid is primary in changes
         Table 1.   T1Column1  T1Column2  T1Column3  T1Column4
         Table 2.   T2Column1  T2Column2  T2Column2  T2Column4
         Grid, Primary Key: T2Column1 = T1Column4   - Linked!
  }
procedure SaveGrid (MySQLRec : MySQL ; Grid : TDataGrid ; Options : Integer);
 {- Update Grid cells according to Primary key and row counter}

//var
//  SQL : TStringList;
//  I{,I1 }: integer;
//  PrimaryData : string;

begin
{ SQL := TStringList.Create;
 PrimaryData:='';
 if Options and (lgSQLtoGridSync+lgGridtoSQLSync)>0 then
  SynchronizeGrid (MySQLRec,Grid,Options);
  if Grid.DBPrimaryField<>'' then
   if Grid.DBLinkedData<>'' then
    PrimaryData:=Grid.DBLinkedData;
  For I:=1 to Grid.RowCount-1 do
   begin
    SQL.Clear;
    SQLInsertStart (SQL,Grid.DBTableName);
    if PrimaryData<>'' then SQLInsert (SQL,Grid.DBPrimaryField,PrimaryData);
    for I1:=0 to Grid.ColCount-1 do
     begin
       if Grid.Columns[I1].RecordName <> '' then
         if Grid.Columns[I1].Format = cfString then SQLStrInsert (SQL,Grid.Columns[I1].RecordName,Grid.Cells[I1,I]) else
          if Grid.Columns[I1].Format = cfNumber then
          SQLInsert (SQL,
          Grid.Columns[I1].RecordName,Grid.Cells[I1,I]);
     end;
    SQLInsertFinish (SQL);
    SendSQLQuery (MySQLRec,SQL);
   end;
  SQL.Free;}
end;

procedure AddHebRelativeString (F : TField; First : String ; Middle : TField ; Last : String);
 {- Changes the S to First+Middle+Last string as long as Middle is different from nothing}

begin
 if Middle.AsString<>'' then F.AsString:=F.AsString+First+Middle.AsString+Last;
end;

procedure SQLSelectAll (SQL : TStrings ; TableName : String);

 begin
   with SQL do
    begin
     Add('SELECT *');
     Add ('FROM '+TableName);
    end;
 end;

function FixSQLstring (S : string) : string;

var
 I : integer;

begin
 result:=S;
 I:=pos(SQLChar,S);
 if I=0 then exit;
 repeat
  if S[I]=SQLChar then
   begin
    Insert (SQLChar,S,I);
    inc (I,2);
   end
  else Inc (I);
 until I>length(S);
 Result:=S;
end;

procedure SQLCount (SQL : TStrings ; TableName , ResultsField : String);

 begin
   with SQL do
    begin
     Add('SELECT COUNT (REID)'+ResultsField);
     Add ('FROM '+TableName);
    end;
 end;

function SQLAlike (FieldName,SQLRel, SQLAlike : string) : string;

 begin
  result:='';
  SQLAlike:=FixSQLString (SQLAlike);
  if SQLAlike<>'' then
   result:=SQLRel+' ('+FieldName+' LIKE '+SQLCHAR+'%'+SQLAlike+'%'+SQLCHAR+'")';
 end;

function SQLAddRel (String1 , SQLRel, String2 : String) : string;

begin
 Result:='';
 String1:=FixSQLString (String1);
 String2:=FixSQLString (String2);
 if (String1='') and (String2='') then exit;
 Result:='( '+String1;
 if String2<>'' then Result:=Result+' '+SQLRel+' '+String2;
 Result:=Result+' )';
end;

procedure SQLInsertStart (SQL : TStrings ; TableName : String);

begin
 if SQL=nil then Exit;
 with SQL do
  begin
   Clear;
   Add ('INSERT INTO '+TableName);
   Add ('(');
   Add ('VALUES (');
  end;
end;

procedure SQLReplaceStart (SQL : TStrings ; TableName : String);

begin
 with SQL do
  begin
   Clear;
   Add ('REPLACE INTO '+TableName);
   Add ('(');
   Add ('VALUES (');
  end;
end;

procedure SQLUpdateStart (SQL : TStrings ; TableName : String);

begin
 with SQL do
  begin
   Clear;
   Add ('update '+TableName);
   Add ('set ');
   Add ('');
  end;
end;

procedure SQLStrInsert (SQL : TStrings ; RecordName,RecordData : String);

 begin
   RecordData:=FixSQLString(RecordData);
   SQL.Strings[1]:=SQL.Strings[1]+RecordName+',';
   SQL.Strings[2]:=SQL.Strings[2]+SQLCHAR+RecordData+SQLCHAR+',';
 end;

procedure SQLInsert (SQL : TStrings ; RecordName,RecordData : String);

 begin
   RecordData:=FixSQLString(RecordData);
   SQL.Strings[1]:=SQL.Strings[1]+RecordName+',';
   SQL.Strings[2]:=SQL.Strings[2]+RecordData+',';
 end;

 procedure SQLStrUpdate (SQL : TStrings ; RecordName,RecordData : String);

  begin
   RecordData:=FixSQLString(RecordData);
   SQL.Strings[1]:=SQL.Strings[1]+RecordName+' = '+SQLCHAR+RecordData+SQLCHAR+',';
//   SQL.Strings[2]:=SQL.Strings[2]++',';
  end;

 procedure SQLIntUpdate (SQL : TStrings ; RecordName : string ; RecordData : Integer);

 begin
   SQL.Strings[1]:=SQL.Strings[1]+RecordName+' = '+SQLCHAR+inttostr(RecordData)+SQLCHAR+',';
 end;

 procedure SQLIntInsert (SQL : TStrings ; RecordName : string ; RecordData : Integer);

 begin
   SQL.Strings[1]:=SQL.Strings[1]+RecordName+',';
   SQL.Strings[2]:=SQL.Strings[2]+inttostr(RecordData)+',';
 end;

procedure SQLYNInsert (SQL : TStrings ; RecordName : string ; RecordData : TCheckBoxState);

 begin
   SQL.Strings[1]:=SQL.Strings[1]+(RecordName)+',';
   if RecordData=cbChecked then SQL.Strings[2]:=SQL.Strings[2]+SQLChar+'Y'+SQLChar+','
   else if RecordData=cbUnChecked then SQL.Strings[2]:=SQL.Strings[2]+SQLChar+'N'+SQLChar+','
   else SQL.Strings[2]:=SQL.Strings[2]+SQLChar+'y'+SQLChar+',';
 end;

 procedure SQLInsertFinish (SQL : TStrings);

 begin
  if Copy(SQL.Strings[1],Length(SQL.Strings[1]),1)=',' then
   SQL.Strings[1]:=Copy (SQL.Strings[1],1,Length(SQL.Strings[1])-1)+')';
  if Copy(SQL.Strings[2],Length(SQL.Strings[2]),1)=',' then
   SQL.Strings[2]:=Copy (SQL.Strings[2],1,Length(SQL.Strings[2])-1)+')';
  SQL.Strings[2]:=SQL.Strings[2]+SQLFinishChar;
 end;

 procedure SQLUpdateFinish (SQL : TStrings ; Key : String ; KeyData : String);

 begin
  if Copy(SQL.Strings[1],Length(SQL.Strings[1]),1)=',' then
   SQL.Strings[1]:=Copy (SQL.Strings[1],1,Length(SQL.Strings[1])-1);
  if Copy(SQL.Strings[2],Length(SQL.Strings[2]),1)=',' then
   SQL.Strings[2]:=Copy (SQL.Strings[2],1,Length(SQL.Strings[2])-1);
  if (Key<>'') then
   begin
    FixSQLString (KeyData);
    SQL.Add('where '+Key+' = '+SQLChar+KeyData+SQLChar);
   end;
  SQL.Strings[2]:=SQL.Strings[2]+SQLFinishChar;
 end;

function CreateDate : string;
 {- Returns today date in DD/MM/YYYY format}

var
 y,m,d : word;

begin
  DecodeDate(now,y,m,d);
  Result:=inttostr(d)+'/'+inttostr(m)+'/'+inttostr(y);
end;

function SQLYNEqual (FieldName, SQLRel : string ; SQLEqual : TCheckBoxState) : string;

begin
    Result:='';
     if SQLEqual=cbChecked then
       Result:=SQLREL + ' ('+fieldname+' = "Y") '
     else if SQLEqual=cbUnchecked then
       Result:=SQLREL + ' ('+fieldname+' = "N") ';
end;

function SQLStrEqual (FieldName, SQLRel,SQLEqual : string) : string;

begin
 Result:='';
 if SQLEqual<>'' then Result:=SQLRel+' ('+FieldName+' = "'+SQLEqual+'") ';
end;

function SQLEqual (FieldName, SQLRel,SQLEqual : string) : string;

begin
 Result:='';
 SQLEqual:=FixSQLString (SQLEqual);
 if SQLEqual<>'' then
   begin
     Result:=SQLRel+' ('+FieldName+' = '+SQLEqual+') ';
   end;
end;

function SQLBetween (FieldName , SQLRel, SQLFrom , SQLTo : string) : string;

begin
 result:='';
 SQLFrom:=FixSQLString (SQLFrom);
 SQLTo:=FixSQLString (SQLTo);
 if (SQLFrom<>'') or (SQLTo<>'') then                 // if one is not empty string
     begin
         if (SQLFrom<>'') and (SQLTo<>'') then        // if both are not empty string
          begin
            if Strtoint(SQLFrom)>strtoint(SQLTo) then
             begin
                 Result:=SQLFrom;
                 SQLTO:=SQLFrom;
                 SQLFrom:=Result;
             end;
            Result:=SQLRel+' ('+FieldName+' BETWEEN '+SQLFrom+' AND '+SQLTO+') ';
          end
         else
         if (SQLTo<>'') then
          Result:=SQLRel+' ('+FieldName+' BETWEEN 0 AND '+SQLTO+') ' else
         if (SQLFrom<>'') then
          Result:=SQLRel+ ' ('+FieldName+' >= '+SQLFrom+') ';
     end;
//
end;

procedure SetFieldModeWithLabel (Sender : TObject; Mode : Boolean);

begin
 SetFieldMode (Sender,Mode);
 SetFieldMode (((Sender as TComponent).Owner as TForm).FindComponent ('L'+(Sender as TComponent).Name),Mode);
end;

procedure SetFieldMode (Sender : TObject; Mode : Boolean);

begin
 if (Sender is TControl) then
   if (Sender as TControl).Enabled=not Mode then
    begin
     (Sender as TControl).Enabled:=Mode;
     if (Sender is TEdit) then
      if Mode then (Sender as TEdit).Color:=clWindow else (Sender as TEdit).Color:=clInactiveCaptionText else
     if (Sender is TMaskEdit) then
      if Mode then (Sender as TMaskEdit).Color:=clWindow else (Sender as TMaskEdit).Color:=clInactiveCaptionText else
     if (Sender is TLUCombo) then
      if Mode then (Sender as TLUCombo).Color:=clWindow else (Sender as TLUCombo).Color:=clInactiveCaptionText else
     if (Sender is TComboBox) then
      if Mode then (Sender as TComboBox).Color:=clWindow else (Sender as TComboBox).Color:=clInactiveCaptionText;
    end;
end;

function  strnum2str(s : string) : string;
 {- Takes string checks it and reformat it and return string}

 begin
 if s='' then Strnum2str:='-1' else Strnum2str:=S;
end;

function CheckedToYN (Sender : TCheckBox) : Char;

 begin
  CheckedToYN:='n';
   with Sender do
    if State=cbGrayed then CheckedToYN:='y' else
     if State=cbChecked then CheckedToYN:='Y' else
      if State=cbUnChecked then CheckedToYN:='N';
 end;

procedure YNToChecked (Sender : TCheckBox; S : String);

begin
   with Sender do
    if S='y' then State:=cbGrayed else
     if S='Y' then State:=cbChecked else
      if S='N' then State:=cbUnChecked else
       State:=cbUnChecked;
end;

End.
