;**************************************************************************
;*                     This file is part of the                           *
;*                      Mpxplay - audio player.                           *
;*                  The source code of Mpxplay is                         *
;*        (C) copyright 1998-2006 by PDSoft (Attila Padar)                *
;*                    http://mpxplay.cjb.net                              *
;*                  email: mpxplay@freemail.hu                            *
;**************************************************************************
;*  This program is distributed in the hope that it will be useful,       *
;*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
;*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
;*  Please contact with the author (with me) if you want to use           *
;*  or modify this source.                                                *
;**************************************************************************
;function: Audio MPEG Layer III sub-routines (antialias,mdct12/36)
;based on the MPG123 MPEG decoder source

.387
.386p
.model flat
		PUBLIC	mpxdec_l3mdct_init_
		PUBLIC	mpxdec_l3mdct_hybrid_

                PUBLIC	mpxdec_l3mdct_init
		PUBLIC	mpxdec_l3mdct_hybrid

DGROUP		GROUP	CONST,CONST2,_DATA,_BSS
_TEXT		SEGMENT	BYTE PUBLIC USE32 'CODE'
		ASSUME CS:_TEXT, DS:DGROUP, SS:DGROUP

;-------------------------------------------------------------------------
mpxdec_l3mdct_init:
mpxdec_l3mdct_init_:
push  eax
push  ebx
push  ecx
push  edx
push  edi
push  ebp
mov   ebp,esp
sub   esp,4

mov   ebx,10                        ;
mov   ecx,8                         ;
mov   edx,offset FLAT:L$24
mov   edi,offset FLAT:_aa_cs
fld1                                ;
L$1:                                ; for(i=0;i<9;i++){
 fld   qword ptr [edx]               ; Ci[i]->st0
 fld   st                            ;
 fmul  st,st(1)                      ;
 add   edx,8                         ;
 fadd  st,st(2)                      ;
 fsqrt                               ; sq=sqrt(1.0+Ci[i]*Ci[i]);
 fdivr st,st(2)                      ;
 fld   st                            ;
 fstp  tbyte ptr [edi]               ; aa_cs[i] = 1.0/sq;
 fmul                                ;
 fstp  tbyte ptr 80[edi]             ; aa_ca[i] = Ci[i]/sq;
 add   edi,ebx                       ;
 dec   ecx                           ;
jnz   L$1                           ; }
fstp  st                            ;

fld1
mov   dword ptr -4[ebp],2           ;
fidiv dword ptr -4[ebp]             ; 0.5=1/2
fldpi                               ;
mov   dword ptr -4[ebp],72          ;
fidiv dword ptr -4[ebp]             ; PIp12=PI/72
mov   edi,offset FLAT:_win          ; winp=&win[0][0][0]
mov   edx,1                         ;
mov   ecx,18                        ;
L$2:                                ; for(i=1;i<37;i+=2){
 mov   eax,edx                       ;
 add   eax,ecx                       ;
 mov   dword ptr -4H[ebp],eax        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(1)                      ;
 fcos                                ; a=cos((double)(i+18)*PIp72)
 mov   dword ptr -4H[ebp],edx        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(2)                      ;
 fsin                                ; b=sin((double)(i)*PIp72)
 fdivrp st(1),st                     ; a=a/b
 fmul  st,st(2)                      ; a*=0.5
 fld   st
 fstp  tbyte ptr [edi]               ; winp[0] =a
 fstp  tbyte ptr 360[edi]            ; winp[36]=a
 add   edi,ebx                       ; winp++
 add   edx,2                         ;
 cmp   edx,37                        ;
jb    L$2                           ; }

L$3:                                ; for(;i<73;i+=2){
 mov   eax,edx                       ;
 add   eax,ecx                       ;
 mov   dword ptr -4H[ebp],eax        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(1)                      ;
 fcos                                ; a=cos((double)(i+18)*PIp72)
 fld   st                            ;
 fdivr st,st(3)                      ;
 fstp  tbyte ptr 360[edi]            ; winp[36]=0.5/a
 mov   dword ptr -4H[ebp],edx        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(2)                      ;
 fsin                                ; b=sin(double)(i)*PIp72)
 fdivrp st(1),st                     ; a=a/b
 fmul  st,st(2)                      ; a*=0.5
 fld   st
 fstp  tbyte ptr [edi]               ; winp[0]   =a
 fstp  tbyte ptr 1080[edi]           ; winp[3*36]=a
 add   edi,ebx                       ; winp++
 add   edx,2                         ;
 cmp   edx,73                        ;
jb    L$3                           ; }

fldpi                               ;
mov   dword ptr -4[ebp],24          ;
fidiv dword ptr -4[ebp]             ; PIp12=PI/24
mov   edx,1                         ;
L$4:                                ; for(i=1;i<13;i+=2){
 mov   eax,edx                       ;
 add   eax,42                        ;
 mov   dword ptr -4H[ebp],eax        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(2)                      ;
 fcos                                ; a=cos((double)(i+42)*PIp72)
 fdivr st,st(3)                      ;
 fstp  tbyte ptr 840[edi]            ; winp[2*36+12]=0.5/a
 mov   eax,edx                       ;
 add   eax,66                        ;
 mov   dword ptr -4H[ebp],eax        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(2)                      ;
 fcos                                ; a=cos((double)(i+66)*PIp72
 mov   eax,edx                       ;
 add   eax,12                        ;
 mov   dword ptr -4H[ebp],eax        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(2)                      ;
 fsin                                ; b=sin((double)(i+12)*PIp24
 fdivrp st(1),st                     ; a=a/b
 fmul  st,st(3)                      ; a*=0.5
 fstp  tbyte ptr 240[edi]            ; winp[24]=a
 mov   eax,edx                       ;
 add   eax,30                        ;
 mov   dword ptr -4H[ebp],eax        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(2)                      ;
 fcos                                ; a=cos((double)(i+30)*PIp72
 mov   dword ptr -4H[ebp],edx        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(2)                      ;
 fsin                                ; b=sin((double)(i)*PIp24)
 fdivrp st(1),st                     ; a=a/b
 fmul  st,st(3)                      ; a*=0.5
 fstp  tbyte ptr 780[edi]            ; winp[2*36+6]=a
 fldz                                ;
 fstp  tbyte ptr 300[edi]            ; winp[  30]=0
 fldz                                ;
 fstp  tbyte ptr 720[edi]            ; winp[2*36]=0
 add   edi,ebx                       ; winp++
 add   edx,2                         ;
 cmp   edx,13                        ;
jb    L$4                           ; }

fxch  st(1)                         ;
fstp  st                            ; push PIp72

mov   edi,offset FLAT:_win          ; winp=&win[0][2][0]
add   edi,720                       ;
mov   edx,1                         ;
mov   ecx,6                         ;
L$5:                                ; for(i=1;i<25;i+=2){
 mov   eax,edx                       ;
 add   eax,ecx                       ;
 mov   dword ptr -4H[ebp],eax        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(1)                      ;
 fcos                                ; a=cos((double)(i+6)*PIp24)
 mov   dword ptr -4H[ebp],edx        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(2)                      ;
 fsin                                ; a=sin((double)(i)*PIp24)
 fdivrp st(1),st                     ; a=a/b
 fmul  st,st(2)                      ; a*=0.5
 fstp  tbyte ptr [edi]               ; winp[0]=a
 add   edi,ebx                       ; winp++
 add   edx,2                         ;
 cmp   edx,25                        ;
jb    L$5                           ; }
fstp  st                            ; push PIp24

mov   edi,offset FLAT:_win          ; winp=&win[0][0][0]
mov   edx,72                        ;
L$6:                                ; for(i=72;i;i--){
 fld   tbyte ptr [edi]               ;
 fstp  tbyte ptr 1440[edi]           ; winp[144]= winp[0]
 add   edi,ebx                       ; winp++
 fld   tbyte ptr [edi]               ;
 fchs                                ;
 fstp  tbyte ptr 1440[edi]           ; winp[144]=-winp[0]
 add   edi,ebx                       ; winp++
 dec   edx                           ;
jne   L$6                           ; }

fldpi                               ;
mov   dword ptr -4[ebp],18          ;
fidiv dword ptr -4[ebp]             ; PIp12=PI/18
xor   edx,edx                       ;
mov   edi,offset FLAT:_COS9         ; cosp=&COS9[0]
L$7:                                ; for(i=0;i<9;i++){
 mov   dword ptr -4H[ebp],edx        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(1)                      ;
 fcos                                ;
 fstp  tbyte ptr [edi]               ; cosp[0]=cos((double)(i)*PIp18)
 add   edi,ebx                       ; cosp++
 inc   edx                           ;
 cmp   edx,9                         ;
jb    L$7                           ; }

fstp  st                            ; push PIp18
fldpi                               ;
mov   dword ptr -4[ebp],36          ;
fidiv dword ptr -4[ebp]             ; PIp12=PI/36
mov   edx,1                         ;
L$8:                                ; for(i=1;i<19;i+=2){
 mov   dword ptr -4H[ebp],edx        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(1)                      ;
 fcos                                ;
 fdivr st,st(2)                      ;
 fstp  tbyte ptr [edi]               ; cosp[0]=0.5/cos((double)(i)*PIp36)
 add   edi,ebx                       ; cosp++
 add   edx,2                         ;
 cmp   edx,19                        ;
jb    L$8                           ; }

fstp  st                            ; push PIp36
fldpi                               ;
mov   dword ptr -4[ebp],12          ;
fidiv dword ptr -4[ebp]             ; PIp12=PI/12
mov   edi,offset FLAT:_tfcos12      ; cosp=&tfcos[0]
mov   edx,1                         ;
L$9:                                ; for(i=1;i<7;i+=2){
 mov   dword ptr -4H[ebp],edx        ;
 fild  dword ptr -4H[ebp]            ;
 fmul  st,st(1)                      ;
 fcos                                ;
 fdivr st,st(2)                      ; cosp[0]=0.5/cos((double)(i)*PIp12)
 fstp  tbyte ptr [edi]               ; cosp++
 add   edi,ebx                       ;
 add   edx,2                         ;
 cmp   edx,7                         ;
jb    L$9                           ; }

fstp  st                            ; push PIp12
fstp  st                            ; push 0.5

fldpi                               ;
mov   dword ptr -4[ebp],6           ;
fidiv dword ptr -4[ebp]             ;
fcos                                ;
fstp  tbyte ptr [edi]               ; cosp[0]=cos(PI/6)
add   edi,ebx                       ; cosp++
fldpi                               ;
mov   dword ptr -4[ebp],3           ;
fidiv dword ptr -4[ebp]             ;
fcos                                ;
fstp  tbyte ptr [edi]               ; cosp[0]=cos(PI/3)

mov  esp,ebp
pop  ebp
pop  edi
pop  edx
pop  ecx
pop  ebx
pop  eax
ret

;--------------------------------------------------------------------------
III_antialias_32bit_:
push  eax
push  edx
push  ebx
push  edi

fld    tbyte ptr   70[eax]    ; in7=in[ 7]
fld   st
fstp   tbyte ptr  -26[ebp]           ; in7_old=in7
fld    tbyte ptr   60[eax]   ;
fadd                           ; in76_old=in7+in[ 6]
fld   st			    ; in76=in76_old

fld    tbyte ptr   50[eax]    ; <- in[ 5]
fld   st                            ;
fld    tbyte ptr   60[eax]   ;
fadd                           ;
fstp   tbyte ptr   60[eax]    ; in[ 6]+=in[ 5]

fld    tbyte ptr   40[eax]   ;
fadd                           ; in54=in[ 5]+in[ 4]
fadd  st(1),st                      ; in76+=in54

fld    tbyte ptr   30[eax]    ;
fld   st                            ;
fld    tbyte ptr   40[eax]   ;
fadd                           ;
fstp   tbyte ptr   40[eax]    ; in[ 4]+=in[ 3]

fld    tbyte ptr   20[eax]   ;
fadd                           ; in32=in[ 3]+in[ 2]
fadd  st(1),st                      ; in54+=in32

fld    tbyte ptr   10[eax]    ;
fld   st                            ;
fld    tbyte ptr   20[eax]   ;
fadd                           ;
mov   edx,esi                       ; sb=esi
fstp   tbyte ptr   20[eax]    ; in[ 2]+=in[ 1]

fld    tbyte ptr    0[eax]   ;
fadd                           ;
mov   edi,10                         ;
fld st                         ;
fstp   tbyte ptr   10[eax]   ; in[ 1]+=in[ 0]

fadd                                ; in32+=in[ 1]
fstp   tbyte ptr   30[eax]    ; in[ 3]=in32
fstp   tbyte ptr   50[eax]    ; in[ 5]=in54
fstp   tbyte ptr   70[eax]    ; in[ 7]=in76
				    ;
dec edx                             ; sb_a--
jz noanti                           ; if(!sb_a) goto noanti
add  eax,180                         ;
antisb:                             ;
 mov   esi,eax                      ;
 mov   ebx,offset FLAT:_aa_cs       ;
				    ;
fld    tbyte ptr    0[eax]    ;
 fld   st                           ;
fld    tbyte ptr    0[ebx]   ;
fmul                           ;
 sub   esi,edi                      ;
fld    tbyte ptr    0[esi]    ;
fld    tbyte ptr   80[ebx]   ;
fmul                           ;
 fadd                               ;
fld st                         ;
fstp   tbyte ptr    0[eax]   ; in7=in[ 0]=(in[0]*aa_cs[0])+(in[17]*aa_cs[8])
				    ;
 fxch st(1)                         ;
fld    tbyte ptr   80[ebx]   ;
fmul                           ;
 add   eax,edi                      ;
fld    tbyte ptr    0[esi]    ;
fld    tbyte ptr    0[ebx]   ;
fmul                           ;
 add   ebx,edi                      ;
 fsubr                              ; in10=in[17]=(in[17]*aa_cs[0])+(in[0]*aa_cs[8])

 sub   esi,edi                      ;
fld    tbyte ptr    0[esi]    ;
fld    tbyte ptr    0[ebx]   ;
fmul                           ;
fld    tbyte ptr    0[eax]    ;
fld    tbyte ptr   80[ebx]   ;
fmul                           ;
 fsub                               ; in[16]
 fxch  st(1)                        ;
 fadd  st,st(1)                     ; in1110=(in[17]+=in[16])
				    ;
fld    tbyte ptr    0[eax]    ;
fld    tbyte ptr    0[ebx]   ;
fmul                           ;
fld    tbyte ptr    0[esi]    ;
fld    tbyte ptr   80[ebx]   ;
fmul                           ;
 add   ebx,edi                      ;
 fadd                               ; in[ 1]
 fxch  st(3)                        ;
 fadd  st,st(3)                     ;
fld st                         ;
fstp   tbyte ptr    0[eax]   ; in76=(in[ 1]+=in[0])
 add   eax,edi                      ;
 fxch  st(2)                        ; in76<->in10
				    ;
 mov   dh,3                         ;
 antiss:                            ;
  sub   esi,edi                     ;
fld    tbyte ptr    0[esi]    ;
fld    tbyte ptr   80[ebx]   ;
fmul                           ;
fld    tbyte ptr    0[eax]    ;
fld    tbyte ptr    0[ebx]    ;
  fmul  st,st(1)                    ;
  faddp st(2),st                    ; in[2],in[4],in[6]
  fxch  st(1)                       ;
  fxch  st(5)                       ;
  fadd  st,st(5)                    ;
fstp   tbyte ptr    0[eax]    ; in[2]+=in[1],in[4]+=in[3],in[6]+=in[5]

fld    tbyte ptr   80[ebx]   ;
fmul                           ;
  add   eax,edi                     ;
fld    tbyte ptr    0[esi]    ;
fld    tbyte ptr    0[ebx]   ;
fmul                           ;
  add   ebx,edi                     ;
  fsubr                             ; in[15],in[13],in[11]
  fxch  st(1)                       ;
  fadd  st,st(1)                    ;
fstp   tbyte ptr   10[esi]    ; in[16]+=in[15],in[14],in[12]

  sub   esi,edi                     ;
fld    tbyte ptr    0[esi]    ;
fld    tbyte ptr   80[ebx]   ;
fmul                           ;
fld    tbyte ptr    0[eax]    ;
fld    tbyte ptr    0[ebx]    ;
  fmul  st,st(1)                    ;
  faddp st(2),st                    ; in[3],in[5],in[7]
  fxch  st(1)                       ;
  fxch  st(5)                       ;
  fadd  st,st(5)                    ; in[3]+=in[2],in[5]+=in[4],in[7]+=in[6]
  fxch  st(4)                       ;
  fadd  st,st(4)                    ; in[3]+=in[1],in[5]+=in[3],in[7]+=in[5]
fstp   tbyte ptr    0[eax]    ;

fld    tbyte ptr   80[ebx]   ;
fmul                           ;
  add   eax,edi                     ;
fld    tbyte ptr    0[esi]    ;
fld    tbyte ptr    0[ebx]   ;
fmul                           ;
  add   ebx,edi                     ;
  fsubr                             ; in[14],in[12],in[10]
  fxch  st(1)                       ;
  fadd  st,st(1)                    ;
  dec   dh                          ;
fld st                         ;
fstp   tbyte ptr   10[esi]   ; in[15]+=in[14],in[13]+=in[12],in[11]+=in[10]
  fxch  st(2)                       ; in[15] <-> in[17]
  fadd  st,st(2)                    ;
fstp   tbyte ptr   30[esi]    ; in[17]+=in[15],in[15]+=in[13],in[13]+=in[11]
 jnz antiss                         ;

;st0=in10
;st1=in1110
;st2=in76
;st3=in7
;st4=in76_old

fld    tbyte ptr  -10[esi]   ;
fadd                           ; in10+=in[9]
fstp   tbyte ptr    0[esi]    ; in[10]=in10

fld    tbyte ptr  -10[esi]    ; in[9]
fld    tbyte ptr  -20[esi]   ;
fadd                           ; in98=in[9]+in[8]
 add  eax,100
 fadd  st(1),st                     ; in1110+=in98

;st0=in98
;st1=in1110
;st2=in76
;st3=in7
;st4=in76_old

 faddp st(4),st                     ; in76_old+=in98
fstp   tbyte ptr   10[esi]    ; in[11]=in1110
 fxch  st(2)                        ; in76<->in76_old
fstp   tbyte ptr -10[esi]    ; in[9]=in76_old

fld    tbyte ptr -20[esi]    ;
 fld  tbyte ptr -26[ebp]          ;
 fadd                        ;
 dec  dl
fstp   tbyte ptr -20[esi]    ; in[8]+=in7_old
 fstp  tbyte ptr -26[ebp]          ; in7_old=in7
				    ;
jnz antisb                          ;

sub  eax,180                         ;

noanti:
fld    tbyte ptr  160[eax]    ;
fld   st                            ;
fld    tbyte ptr  150[eax]   ;
fadd                           ;
fstp   tbyte ptr  160[eax]    ; in[16]+=in[15]
fld    tbyte ptr  170[eax]   ;
fadd                           ; in1716=in[17]+in[16]

fld    tbyte ptr  150[eax]    ;
fld    tbyte ptr  140[eax]   ;
fadd                           ; in1514=in[15]+in[14]
fadd  st(1),st                      ; in1716+=in1514

fld    tbyte ptr  130[eax]    ;
fld   st                            ;
fld    tbyte ptr  140[eax]   ;
fadd                           ;
fstp   tbyte ptr  140[eax]    ; in[14]+=in[13]
fld    tbyte ptr  120[eax]   ;
fadd                           ; in1312=in[13]+in[12]
fadd  st(1),st                      ; in1514+=in1312

fld    tbyte ptr  110[eax]    ;
fld   st                            ;
fld    tbyte ptr  120[eax]   ;
fadd                           ;
fstp   tbyte ptr  120[eax]    ; in[12]+=in[11]
fld    tbyte ptr  100[eax]   ;
fadd                           ; in1110=in[11]+in[10]
fadd  st(1),st                      ; in1312+=in1110

fld    tbyte ptr   90[eax]    ;
fld   st                            ;
fld    tbyte ptr  100[eax]   ;
fadd                           ;
fstp   tbyte ptr  100[eax]    ; in[10]+=in[ 9]
fld    tbyte ptr   80[eax]   ;
fadd                           ; in98=in[ 9]+in[ 8]
fadd  st(1),st                      ; in1110+=in98

faddp st(5),st                      ; in76_old+=in98

fstp   tbyte ptr  110[eax]    ; in[11]=in1110
fstp   tbyte ptr  130[eax]    ; in[13]=in1312
fstp   tbyte ptr  150[eax]    ; in[15]=in1514
fstp   tbyte ptr  170[eax]    ; in[17]=in1716

fstp   tbyte ptr   90[eax]    ; in[ 9]=in76_old

fld    tbyte ptr   80[eax]    ;
fld    tbyte ptr  -26[ebp]           ;
fadd                          ;
fstp   tbyte ptr   80[eax]    ; in[ 8]+=in7_old

pop  edi
pop  ebx
pop  edx
pop  eax
ret

;---------------------------------------------------------------------------
;struct gr_info_s {
; int scfsi;                         // 0x00
; unsigned int part2_3_length;       // 0x04
; unsigned int scalefac_compress;    // 0x08
; unsigned int block_type;           // 0x0c
; unsigned int mixed_block_flag;     // 0x10
; unsigned int table_select[3];      // 0x14
; unsigned int subblock_gain[3];     // 0x20
; unsigned int maxband[3];           // 0x2c
; unsigned int maxbandl;             // 0x38
; unsigned int maxb;                 // 0x3c
; unsigned int regions[4];           // 0x40
; unsigned int preflag;              // 0x50
; unsigned int scalefac_scale;       // 0x54
; unsigned int count1table_select;   // 0x58
; unsigned int full_gain[3];         // 0x5c
; FLOAT  *pow2gain;                  // 0x68
; FLOAT  *ispow32_base;              // 0x6c
; int *mapp;                         // 0x70
;};
;---------------------------------------------------------------------------
mpxdec_l3mdct_hybrid_:
; in:  eax = fsinp (deqp), edx = tspnt (hout), ebx = rawoutp (blockp), ecx = gr_info_s *gr_info

push  esi
push  edi
push  ebp
mov   ebp,esp
sub   esp,56

;  eax : fsinp
;  edx : tspnt
;  ebx : rawout1
;  ecx : rawout2
;  edi : winp
;  esi : cosp= COS9 or tfcos12

;  -4H[ebp] : sb
;  -8H[ebp] : empty
; -0cH[ebp] : mixed_block_flag
; -10H[ebp] : in7_old in antialias
; -26[ebp]  : ta33 in dct36()
; -36[ebp]  : ta66
; -46[ebp]  : tb33
; -56[ebp]  : tb66

mov   esi,dword ptr 3cH[ecx]   ;
mov   dword ptr -4H[ebp],esi   ; sb=gr_info->maxb
mov   edi,32                   ;
sub   edi,esi                  ;
mov   dword ptr -8H[ebp],edi   ; empty=32-sb
mov   esi,dword ptr 10H[ecx]   ;
mov   dword ptr -0cH[ebp],esi  ; mixed_block_flag=gr_info->mixed_block_flag
mov   esi,dword ptr 0cH[ecx]   ; blocktype=gr_info->blocktype
			       ;
mov   ecx,ebx                  ; rawout1=rawout2=rawoutp
xor   byte ptr -10[ebx],1      ; blc=!blc   (blc stored in the rawoutp[-1])
jz   noblc                     ; if(blc){
 add   ebx,11540               ;  rawout1+=2*SBLIMIT*SSLIMIT+2
jmp endblc                     ;
noblc:                         ; }else{
 add   ecx,11540               ;  rawout2+=2*SBLIMIT*SSLIMIT+2
endblc:                        ; }
			       ;
cmp   byte ptr -4H[ebp],0      ; if(!sb)
jz    sbnull                   ;  goto sbnull
			       ;
mov   edi,esi                  ;
shl   esi,3                    ;
add   edi,esi                  ;
shl   edi,3
mov   esi,edi
shl   edi,2                    ;
add   edi,esi
add   edi,offset _win          ; winp=&win[0][blocktype][0]
			       ;
cmp   esi,144                  ;
jne   nobt2                    ; if(blocktype==2){
 cmp   byte ptr -0cH[ebp],0    ;
 je    nombf                   ;  if(mixed_block_flag){
  mov   esi,2                  ;   sb_a=2
  call  III_antialias_32bit_   ;   III_antialias(fsinp,sb_a)
  mov   esi,offset _COS9       ;   cosp=COS9
  call  dct36_                 ;   dct36()
  add   edi,1440                ;   winp+=144
  dec   byte ptr -4H[ebp]      ;   sb--
  jz    sbnull                 ;   if(!sb) goto sbnull
  call  dct36_                 ;   dct36()
  sub   edi,1440                ;   winp-=144
  dec   byte ptr -4H[ebp]      ;   sb--
  jz    sbnull                 ;   if(!sb) goto sbnull
 nombf:                        ;  }
 mov   esi,offset _tfcos12     ;  cosp=tfcos12
 backbt2:                      ;  do{
  call  dct12_                 ;   dct12()
  add   edi,1440                ;   winp+=144
  dec   byte ptr -4H[ebp]      ;   sb--
  jz    sbnull                 ;   if(!sb) goto sbnull
  call  dct12_                 ;   dct12()
  sub   edi,1440                ;   winp-=144
  dec   byte ptr -4H[ebp]      ;   sb--
 jnz   backbt2                 ;  }while(sb)
 jmp   sbnull                  ;
nobt2:                         ; }else{
 mov   esi,dword ptr -4H[ebp]  ;  sb_a=sb
 call  III_antialias_32bit_    ;  III_antialias_32bit(fsinp,sb_a)
 mov   esi,offset _COS9        ;  cosp=COS9
 backnobt2:                    ;  do{
  call  dct36_                 ;   dct36()
  add   edi,1440                ;   winp+=144
  dec   byte ptr -4H[ebp]      ;   sb--
  jz    sbnull                 ;   if(!sb) goto sbnull
  call  dct36_                 ;   dct36()
  sub   edi,1440                ;   winp-=144
  dec   byte ptr -4H[ebp]      ;   sb--
 jnz   backnobt2               ;  }while(sb)
sbnull:                        ; }
mov   edi,dword ptr -8H[ebp]   ;
test  edi,edi                  ;
jz    endhybrid                ; if(!empty) goto endhybrid
mov   esi,10                   ;
backemptysb:                   ; do{
 mov   eax,18                  ;  ss=18
 backemptyss:                  ;  do{
  fld   tbyte ptr [ebx]        ;   *tspnt=*rawout1
  add   ebx,esi                ;   rawout1++
  fstp  tbyte ptr [edx]        ;
  add   edx,320                ;   tspnt+=32
  fldz                         ;
  fstp  tbyte ptr [ecx]        ;   *rawout2=0
  add   ecx,esi                ;   rawout2++
  dec   eax                    ;   ss--
 jnz   backemptyss             ;  }while(ss)
 sub   edx,5750                ;  tspnt-=575
 dec   edi                     ;  empty--
jnz   backemptysb              ; }while(empty)
			       ;
endhybrid:                     ;
mov   esp,ebp                  ;
pop   ebp                      ;
pop   edi                      ;
pop   esi                      ;
ret                            ;

mpxdec_l3mdct_hybrid:
push eax
push edx
push ebx
push ecx
mov eax,dword ptr [esp+ 4+16];
mov edx,dword ptr [esp+ 8+16];
mov ebx,dword ptr [esp+12+16];
mov ecx,dword ptr [esp+16+16];
call mpxdec_l3mdct_hybrid_
pop ecx
pop ebx
pop edx
pop eax
ret

;--------------------------------------------------------------------------
dct36_:                     ; c=COS9
fld    tbyte ptr   20[eax]    ;
fld    tbyte ptr   10[esi]   ;
fmul                           ;
fld    tbyte ptr   60[eax]    ;
fld    tbyte ptr   30[esi]   ;
fmul                           ;
fld    st                   ;
fstp   tbyte ptr -26[ebp]   ; ta33=in[6]*c[3]
fadd                        ;
fld    tbyte ptr  100[eax]    ;
fld    tbyte ptr   50[esi]   ;
fmul                           ;
fadd                        ;
fld    tbyte ptr  140[eax]    ;
fld    tbyte ptr   70[esi]   ;
fmul                           ;
fadd                        ; tmp1a=in[2]*c[1]+ta33+in[10]*c[5]+in[14]*c[7]
fld    tbyte ptr   40[eax]    ;
fld    tbyte ptr   20[esi]   ;
fmul                           ;
fld    tbyte ptr    0[eax]   ;
fadd                           ;
fld    tbyte ptr   80[eax]    ;
fld    tbyte ptr   40[esi]   ;
fmul                           ;
fadd                        ;
fld    tbyte ptr  120[eax]    ;
fld    tbyte ptr   60[esi]   ;
fmul                           ;
fld    st                   ;
fstp   tbyte ptr -36[ebp]   ; ta66=in[12]*c[6]
fadd                        ;
fld    tbyte ptr  160[eax]    ;
fld    tbyte ptr   80[esi]   ;
fmul                           ;
fadd                        ; tmp2a=in[4]*c[2]+in[0]+in[8]*in[4]+ta66+in[16]*c[8]
fld    tbyte ptr   30[eax]    ;
fld    tbyte ptr   10[esi]   ;
fmul                           ;
fld    tbyte ptr   70[eax]    ;
fld    tbyte ptr   30[esi]   ;
fmul                           ;
fld    st                   ;
fstp   tbyte ptr -46[ebp]   ; tb33=in[7]*c[3]
fadd                        ;
fld    tbyte ptr  110[eax]    ;
fld    tbyte ptr   50[esi]   ;
fmul                           ;
fadd                        ;
fld    tbyte ptr  150[eax]    ;
fld    tbyte ptr   70[esi]   ;
fmul                           ;
fadd                        ; tmp1b=in[3]*c[1]+tb33+in[11]*c[5]+in[15]*c[7]
fld    tbyte ptr   50[eax]    ;
fld    tbyte ptr   20[esi]   ;
fmul                           ;
fld    tbyte ptr   10[eax]   ;
fadd                           ;
fld    tbyte ptr   90[eax]    ;
fld    tbyte ptr   40[esi]   ;
fmul                           ;
fadd                        ;
fld    tbyte ptr  130[eax]    ;
fld    tbyte ptr   60[esi]   ;
fmul                           ;
fld    st                   ;
fstp   tbyte ptr -56[ebp]   ; tb66=in[13]*c[6]
fadd                        ;
fld    tbyte ptr  170[eax]    ;
fld    tbyte ptr   80[esi]   ;
fmul                           ;
fadd                        ; tmp2b=in[5]*c[2]+in[1]+in[9]*c[4]+tb66+in[17]*c[8]

fld    st(3)                ;
fadd   st,st(3)             ; sum0=tmp1a+tmp2a
fld    st(2)                ;
fadd   st,st(2)             ;
fld    tbyte ptr   90[esi]   ;
fmul                           ; sum1=(tmp1b+tmp2b)*COS9[9]
fld    st(1)                ;
fadd   st,st(1)             ; tmp=sum0+sum1
fld    tbyte ptr  270[edi]    ;
fmul   st,st(1)             ;
fstp   tbyte ptr   90[ecx]    ; out2[9]=tmp*winp[27]
fld    tbyte ptr  260[edi]   ;
fmul                           ;
fstp   tbyte ptr   80[ecx]    ; out2[8]=tmp*winp[26]
fsub                        ; sum0-=sum1
fld    tbyte ptr   80[edi]    ;
fmul   st,st(1)             ;
fld    tbyte ptr   80[ebx]   ;
fadd                           ;
fstp   tbyte ptr 2560[edx]    ; ts[256]=sum0*winp[8]+out1[8]
fld    tbyte ptr   90[edi]   ;
fmul                           ;
fld    tbyte ptr   90[ebx]   ;
fadd                           ;
fstp   tbyte ptr 2880[edx]    ; ts[288]=sum0*winp[9]+out1[9]

fsubr                       ;
fld    tbyte ptr  170[esi]   ;
fmul                           ; sum1=(tmp2b-tmp1b)*COS9[17]
fxch   st(2)                ;
fsub                        ; sum0=tmp2a-tmp1a
fld    st(1)                ;
fadd   st,st(1)             ; tmp=sum0+sum1
fld    tbyte ptr  180[edi]    ;
fmul   st,st(1)             ;
fstp   tbyte ptr    0[ecx]    ; out2[0]=tmp*winp[18]
fld    tbyte ptr  350[edi]   ;
fmul                           ;
fstp   tbyte ptr  170[ecx]    ; out2[17]=tmp*winp[35]
fsubr                       ; sum0-=sum1
fld    tbyte ptr    0[edi]    ;
fmul   st,st(1)             ;
fld    tbyte ptr    0[ebx]   ;
fadd                           ;
fstp   tbyte ptr    0[edx]    ; ts[0]=sum0*winp[0]+out1[0]
fld    tbyte ptr  170[edi]   ;
fmul                           ;
fld    tbyte ptr  170[ebx]   ;
fadd                           ;
fstp   tbyte ptr 5440[edx]    ; ts[544]=sum0*winp[17]+out1[17]

fld    tbyte ptr   20[eax]    ;
fld    tbyte ptr  100[eax]   ;
fsub                           ;
fld    tbyte ptr  140[eax]   ;
fsub                           ;
fld    tbyte ptr   30[esi]   ;
fmul                           ;
fld    tbyte ptr   40[eax]    ;
fld    tbyte ptr   80[eax]   ;
fsub                           ;
fld    tbyte ptr  160[eax]   ;
fsub                           ;
fld    tbyte ptr   60[esi]   ;
fmul                           ;
fld    tbyte ptr  120[eax]   ;
fsub                           ;
fld    tbyte ptr    0[eax]   ;
fadd                           ;
fld    tbyte ptr   30[eax]    ;
fld    tbyte ptr  110[eax]   ;
fsub                           ;
fld    tbyte ptr  150[eax]   ;
fsub                           ;
fld    tbyte ptr   30[esi]   ;
fmul                           ;
fld    tbyte ptr   50[eax]    ;
fld    tbyte ptr   90[eax]   ;
fsub                           ;
fld    tbyte ptr  170[eax]   ;
fsub                           ;
fld    tbyte ptr   60[esi]   ;
fmul                           ;
fld    tbyte ptr  130[eax]   ;
fsub                           ;
fld    tbyte ptr   10[eax]   ;
fadd                           ;

fld    st(3)                ;
fadd   st,st(3)             ;
fld    st(2)                ;
fadd   st,st(2)             ;
fld    tbyte ptr  100[esi]   ;
fmul                           ;
fld    st(1)                ;
fadd   st,st(1)             ;
fld    tbyte ptr  280[edi]    ;
fmul   st,st(1)             ;
fstp   tbyte ptr  100[ecx]    ;
fld    tbyte ptr  250[edi]   ;
fmul                           ;
fstp   tbyte ptr   70[ecx]    ;
fsub                        ;
fld    tbyte ptr   70[edi]    ;
fmul   st,st(1)             ;
fld    tbyte ptr   70[ebx]   ;
fadd                           ;
fstp   tbyte ptr 2240[edx]    ;
fld    tbyte ptr  100[edi]   ;
fmul                           ;
fld    tbyte ptr  100[ebx]   ;
fadd                           ;
fstp   tbyte ptr 3200[edx]    ;

fsubr                       ;
fld    tbyte ptr  160[esi]   ;
fmul                           ;
fxch   st(2)                ;
fsub                        ;
fld    st(1)                ;
fadd   st,st(1)             ;
fld    tbyte ptr  190[edi]    ;
fmul   st,st(1)             ;
fstp   tbyte ptr   10[ecx]    ;
fld    tbyte ptr  340[edi]   ;
fmul                           ;
fstp   tbyte ptr  160[ecx]    ;
fsubr                       ;
fld    tbyte ptr   10[edi]    ;
fmul   st,st(1)             ;
fld    tbyte ptr   10[ebx]   ;
fadd                           ;
fstp   tbyte ptr  320[edx]    ;
fld    tbyte ptr  160[edi]   ;
fmul                           ;
fld    tbyte ptr  160[ebx]   ;
fadd                           ;
fstp   tbyte ptr 5120[edx]    ;

fld    tbyte ptr   20[eax]    ;
fld    tbyte ptr   50[esi]   ;
fmul                           ;
fld    tbyte ptr -26[ebp]   ;
fsub                        ;
fld    tbyte ptr  100[eax]    ;
fld    tbyte ptr   70[esi]   ;
fmul                           ;
fsub                        ;
fld    tbyte ptr  140[eax]    ;
fld    tbyte ptr   10[esi]   ;
fmul                           ;
fadd                        ;
fld    tbyte ptr   40[eax]    ;
fld    tbyte ptr   80[esi]   ;
fmul                           ;
fld    tbyte ptr    0[eax]   ;
fsubr                          ;
fld    tbyte ptr   80[eax]    ;
fld    tbyte ptr   20[esi]   ;
fmul                           ;
fsub                        ;
fld    tbyte ptr -36[ebp]   ;
fadd                        ;
fld    tbyte ptr  160[eax]    ;
fld    tbyte ptr   40[esi]   ;
fmul                           ;
fadd                        ;
fld    tbyte ptr   30[eax]    ;
fld    tbyte ptr   50[esi]   ;
fmul                           ;
fld    tbyte ptr -46[ebp]   ;
fsub                        ;
fld    tbyte ptr  110[eax]    ;
fld    tbyte ptr   70[esi]   ;
fmul                           ;
fsub                        ;
fld    tbyte ptr  150[eax]    ;
fld    tbyte ptr   10[esi]   ;
fmul                           ;
fadd                        ;
fld    tbyte ptr   50[eax]    ;
fld    tbyte ptr   80[esi]   ;
fmul                           ;
fld    tbyte ptr   10[eax]   ;
fsubr                          ;
fld    tbyte ptr   90[eax]    ;
fld    tbyte ptr   20[esi]   ;
fmul                           ;
fsub                        ;
fld    tbyte ptr -56[ebp]   ;
fadd                        ;
fld    tbyte ptr  170[eax]    ;
fld    tbyte ptr   40[esi]   ;
fmul                           ;
fadd                        ;

fld    st(3)                ;
fadd   st,st(3)             ;
fld    st(2)                ;
fadd   st,st(2)             ;
fld    tbyte ptr  110[esi]   ;
fmul                           ;
fld    st(1)                ;
fadd   st,st(1)             ;
fld    tbyte ptr  290[edi]    ;
fmul   st,st(1)             ;
fstp   tbyte ptr  110[ecx]    ;
fld    tbyte ptr  240[edi]   ;
fmul                           ;
fstp   tbyte ptr   60[ecx]    ;
fsub                        ;
fld    tbyte ptr   60[edi]    ;
fmul   st,st(1)             ;
fld    tbyte ptr   60[ebx]   ;
fadd                           ;
fstp   tbyte ptr 1920[edx]    ;
fld    tbyte ptr  110[edi]   ;
fmul                           ;
fld    tbyte ptr  110[ebx]   ;
fadd                           ;
fstp   tbyte ptr 3520[edx]    ;

fsubr                       ;
fld    tbyte ptr  150[esi]   ;
fmul                           ;
fxch   st(2)                ;
fsub                        ;
fld    st(1)                ;
fadd   st,st(1)             ;
fld    tbyte ptr  200[edi]    ;
fmul   st,st(1)             ;
fstp   tbyte ptr   20[ecx]    ;
fld    tbyte ptr  330[edi]   ;
fmul                           ;
fstp   tbyte ptr  150[ecx]    ;
fsubr                       ;
fld    tbyte ptr   20[edi]    ;
fmul   st,st(1)             ;
fld    tbyte ptr   20[ebx]   ;
fadd                           ;
fstp   tbyte ptr  640[edx]    ;
fld    tbyte ptr  150[edi]   ;
fmul                           ;
fld    tbyte ptr  150[ebx]   ;
fadd                           ;
fstp   tbyte ptr 4800[edx]    ;

fld    tbyte ptr   20[eax]    ;
fld    tbyte ptr   70[esi]   ;
fmul                           ;
fld    tbyte ptr -26[ebp]   ;
fsub                        ;
fld    tbyte ptr  100[eax]    ;
fld    tbyte ptr   10[esi]   ;
fmul                           ;
fadd                        ;
fld    tbyte ptr  140[eax]    ;
fld    tbyte ptr   50[esi]   ;
fmul                           ;
fsub                        ;
fld    tbyte ptr   40[eax]    ;
fld    tbyte ptr   40[esi]   ;
fmul                           ;
fld    tbyte ptr    0[eax]   ;
fsubr                          ;
fld    tbyte ptr   80[eax]    ;
fld    tbyte ptr   80[esi]   ;
fmul                           ;
fadd                        ;
fld    tbyte ptr -36[ebp]   ;
fadd                        ;
fld    tbyte ptr  160[eax]    ;
fld    tbyte ptr   20[esi]   ;
fmul                           ;
fsub                        ;
fld    tbyte ptr   30[eax]    ;
fld    tbyte ptr   70[esi]   ;
fmul                           ;
fld    tbyte ptr -46[ebp]   ;
fsub                        ;
fld    tbyte ptr  110[eax]    ;
fld    tbyte ptr   10[esi]   ;
fmul                           ;
fadd                        ;
fld    tbyte ptr  150[eax]    ;
fld    tbyte ptr   50[esi]   ;
fmul                           ;
fsub                        ;
fld    tbyte ptr   50[eax]    ;
fld    tbyte ptr   40[esi]   ;
fmul                           ;
fld    tbyte ptr   10[eax]   ;
fsubr                          ;
fld    tbyte ptr   90[eax]    ;
fld    tbyte ptr   80[esi]   ;
fmul                           ;
fadd                        ;
fld    tbyte ptr -56[ebp]   ;
fadd                        ;
fld    tbyte ptr  170[eax]    ;
fld    tbyte ptr   20[esi]   ;
fmul                           ;
fsub                        ;

fld    st(3)                ;
fadd   st,st(3)             ;
fld    st(2)                ;
fadd   st,st(2)             ;
fld    tbyte ptr  120[esi]   ;
fmul                           ;
fld    st(1)                ;
fadd   st,st(1)             ;
fld    tbyte ptr  300[edi]    ;
fmul   st,st(1)             ;
fstp   tbyte ptr  120[ecx]    ;
fld    tbyte ptr  230[edi]   ;
fmul                           ;
fstp   tbyte ptr   50[ecx]    ;
fsub                        ;
fld    tbyte ptr   50[edi]    ;
fmul   st,st(1)             ;
fld    tbyte ptr   50[ebx]   ;
fadd                           ;
fstp   tbyte ptr 1600[edx]    ;
fld    tbyte ptr  120[edi]   ;
fmul                           ;
fld    tbyte ptr  120[ebx]   ;
fadd                           ;
fstp   tbyte ptr 3840[edx]    ;

fsubr                       ;
fld    tbyte ptr  140[esi]   ;
fmul                           ;
fxch   st(2)                ;
fsub                        ;
fld    st(1)                ;
fadd   st,st(1)             ;
fld    tbyte ptr  210[edi]    ;
fmul   st,st(1)             ;
fstp   tbyte ptr   30[ecx]    ;
fld    tbyte ptr  320[edi]   ;
fmul                           ;
fstp   tbyte ptr  140[ecx]    ;
fsubr                       ;
fld    tbyte ptr   30[edi]    ;
fmul   st,st(1)             ;
fld    tbyte ptr   30[ebx]   ;
fadd                           ;
fstp   tbyte ptr  960[edx]    ;
fld    tbyte ptr  140[edi]   ;
fmul                           ;
fld    tbyte ptr  140[ebx]   ;
fadd                           ;
fstp   tbyte ptr 4480[edx]    ;

fld    tbyte ptr    0[eax]    ;
fld    tbyte ptr   40[eax]   ;
fsub                           ;
fld    tbyte ptr   80[eax]   ;
fadd                           ;
fld    tbyte ptr  120[eax]   ;
fsub                           ;
fld    tbyte ptr  160[eax]   ;
fadd                           ;
fld    tbyte ptr   10[eax]    ;
fld    tbyte ptr   50[eax]   ;
fsub                           ;
fld    tbyte ptr   90[eax]   ;
fadd                           ;
fld    tbyte ptr  130[eax]   ;
fsub                           ;
fld    tbyte ptr  170[eax]   ;
fadd                           ;
fld    tbyte ptr  130[esi]   ;
fmul                           ;

fld    st(1)                ;
fadd   st,st(1)             ;
fld    tbyte ptr  310[edi]    ;
fmul   st,st(1)             ;
fstp   tbyte ptr  130[ecx]    ;
fld    tbyte ptr  220[edi]   ;
fmul                           ;
fstp   tbyte ptr   40[ecx]    ;
fsub                        ;
fld    tbyte ptr   40[edi]    ;
fmul   st,st(1)             ;
add  eax,180                 ;
fld    tbyte ptr   40[ebx]   ;
fadd                           ;
add  ecx,180                 ;
fstp   tbyte ptr 1280[edx]    ;
fld    tbyte ptr  130[edi]   ;
fmul                           ;
add  edx,10                  ;
fld    tbyte ptr  130[ebx]   ;
fadd                           ;
add  ebx,180                 ;
fstp   tbyte ptr 4150[edx]    ;

ret
;---------------------------------------------------------------------------
dct12_:
fld    tbyte ptr    0[ebx]    ;
fld    tbyte ptr   10[ebx]    ;
fld    tbyte ptr   20[ebx]    ;
fld    tbyte ptr   30[ebx]    ;
fld    tbyte ptr   40[ebx]    ;
fld    tbyte ptr   50[ebx]    ;
fstp   tbyte ptr 1600[edx]    ;
fstp   tbyte ptr 1280[edx]    ;
fstp   tbyte ptr  960[edx]    ;
fstp   tbyte ptr  640[edx]    ;
fstp   tbyte ptr  320[edx]    ;
fstp   tbyte ptr    0[edx]    ;
fldz                           ;
fld st                         ;
fstp   tbyte ptr  120[ecx]   ;
fld st                         ;
fstp   tbyte ptr  130[ecx]   ;
fld st                         ;
fstp   tbyte ptr  140[ecx]   ;
fld st                         ;
fstp   tbyte ptr  150[ecx]   ;
fld st                         ;
fstp   tbyte ptr  160[ecx]   ;
fstp   tbyte ptr  170[ecx]    ;
fld    tbyte ptr  120[eax]    ;
fld    tbyte ptr   90[eax]   ;
fadd                           ;
fstp   tbyte ptr -26[ebp]      ;
fld    tbyte ptr   90[eax]    ;
fld    tbyte ptr   60[eax]   ;
fadd                           ;
fld    tbyte ptr   30[eax]    ;
fld    tbyte ptr    0[eax]   ;
fadd                           ;
fld    tbyte ptr  150[eax]    ;
fld    tbyte ptr  120[eax]   ;
fadd                           ;
fadd   st,st(2)                ;
fld    tbyte ptr    0[eax]    ;
;fsub   st,st(4)                ;
fld    tbyte ptr -26[ebp]      ;
fsub
fld    st(2)                   ;
fsub   st,st(2)                ;
fld    tbyte ptr   10[esi]   ;
fmul                           ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fld    tbyte ptr  100[edi]    ;
fmul   st,st(1)                ;
fld    tbyte ptr  160[ebx]   ;
fadd                           ;
fstp   tbyte ptr 5120[edx]    ;
fld    tbyte ptr   70[edi]   ;
fmul                           ;
fld    tbyte ptr  130[ebx]   ;
fadd                           ;
fstp   tbyte ptr 4160[edx]    ;
fsub                           ;
fld    tbyte ptr   10[edi]    ;
fmul   st,st(1)                ;
fld    tbyte ptr   70[ebx]   ;
fadd                           ;
fstp   tbyte ptr 2240[edx]    ;
fld    tbyte ptr   40[edi]   ;
fmul                           ;
fld    tbyte ptr  100[ebx]   ;
fadd                           ;
fstp   tbyte ptr 3200[edx]    ;
fld    tbyte ptr   40[esi]   ;
fmul                           ;
fadd   st,st(1)                ;
fxch   st(2)                   ;
fadd                           ;
fld    tbyte ptr   30[esi]   ;
fmul                           ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fld    tbyte ptr    0[esi]   ;
fmul                           ;
fxch   st(2)                   ;
fsubr                          ;
fld    tbyte ptr   20[esi]   ;
fmul                           ;
fxch   st(1)                   ;
fld    tbyte ptr -26[ebp]      ;
fld    tbyte ptr   40[esi]   ;
fmul                           ;
fld    tbyte ptr    0[eax]   ;
fadd                           ;
fld    tbyte ptr   60[eax]    ;
fld    tbyte ptr   30[eax]   ;
fadd                           ;
fld    tbyte ptr   30[esi]   ;
fmul                           ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fxch   st(2)                   ;
fsubr                          ;
fxch   st(2)                   ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fld    tbyte ptr   80[edi]    ;
fmul   st,st(1)                ;
fld    tbyte ptr  140[ebx]   ;
fadd                           ;
fstp   tbyte ptr 4480[edx]    ;
fld    tbyte ptr   90[edi]   ;
fmul                           ;
fld    tbyte ptr  150[ebx]   ;
fadd                           ;
fstp   tbyte ptr 4800[edx]    ;
fsub                           ;
fld    tbyte ptr   20[edi]    ;
fmul   st,st(1)                ;
fld    tbyte ptr   80[ebx]   ;
fadd                           ;
fstp   tbyte ptr 2560[edx]    ;
fld    tbyte ptr   30[edi]   ;
fmul                           ;
fld    tbyte ptr   90[ebx]   ;
fadd                           ;
fstp   tbyte ptr 2880[edx]    ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fld    tbyte ptr  110[edi]    ;
fmul   st,st(1)                ;
fld    tbyte ptr  170[ebx]   ;
fadd                           ;
fstp   tbyte ptr 5440[edx]    ;
fld    tbyte ptr   60[edi]   ;
fmul                           ;
fld    tbyte ptr  120[ebx]   ;
fadd                           ;
fstp   tbyte ptr 3840[edx]    ;
fsubr                          ;
fld    tbyte ptr    0[edi]    ;
fmul   st,st(1)                ;
fld    tbyte ptr   60[ebx]   ;
fadd                           ;
fstp   tbyte ptr 1920[edx]    ;
fld    tbyte ptr   50[edi]   ;
fmul                           ;
fld    tbyte ptr  110[ebx]   ;
fadd                           ;
fstp   tbyte ptr 3520[edx]    ;
fld    tbyte ptr  130[eax]    ;
fld    tbyte ptr  100[eax]   ;
fadd                           ;
fld    tbyte ptr  100[eax]    ;
fld    tbyte ptr   70[eax]   ;
fadd                           ;
fld    tbyte ptr   40[eax]    ;
fld    tbyte ptr   10[eax]   ;
fadd                           ;
fld    tbyte ptr  160[eax]    ;
fld    tbyte ptr  130[eax]   ;
fadd                           ;
fadd   st,st(2)                ;
fld    tbyte ptr   10[eax]    ;
fsub   st,st(4)                ;
fld    st(2)                   ;
fsub   st,st(2)                ;
fld    tbyte ptr   10[esi]   ;
fmul                           ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fld    tbyte ptr  100[edi]    ;
fmul   st,st(1)                ;
fstp   tbyte ptr   40[ecx]    ;
fld    tbyte ptr   70[edi]   ;
fmul                           ;
fstp   tbyte ptr   10[ecx]    ;
fsub                           ;
fld    tbyte ptr   10[edi]    ;
fmul   st,st(1)                ;
fld    tbyte ptr 4160[edx]   ;
fadd                           ;
fstp   tbyte ptr 4160[edx]    ;
fld    tbyte ptr   40[edi]   ;
fmul                           ;
fld    tbyte ptr 5120[edx]   ;
fadd                           ;
fstp   tbyte ptr 5120[edx]    ;
fld    tbyte ptr   40[esi]   ;
fmul                           ;
fadd   st,st(1)                ;
fxch   st(2)                   ;
fadd                           ;
fld    tbyte ptr   30[esi]   ;
fmul                           ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fld    tbyte ptr    0[esi]   ;
fmul                           ;
fxch   st(2)                   ;
fsubr                          ;
fld    tbyte ptr   20[esi]   ;
fmul                           ;
fxch   st(2)                   ;
fld    tbyte ptr   40[esi]   ;
fmul                           ;
fld    tbyte ptr   10[eax]   ;
fadd                           ;
fld    tbyte ptr   70[eax]    ;
fld    tbyte ptr   40[eax]   ;
fadd                           ;
fld    tbyte ptr   30[esi]   ;
fmul                           ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fxch   st(2)                   ;
fsubr                          ;
fxch   st(2)                   ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fld    tbyte ptr   80[edi]    ;
fmul   st,st(1)                ;
fstp   tbyte ptr   20[ecx]    ;
fld    tbyte ptr   90[edi]   ;
fmul                           ;
fstp   tbyte ptr   30[ecx]    ;
fsub                           ;
fld    tbyte ptr   20[edi]    ;
fmul   st,st(1)                ;
fld    tbyte ptr 4480[edx]   ;
fadd                           ;
fstp   tbyte ptr 4480[edx]    ;
fld    tbyte ptr   30[edi]   ;
fmul                           ;
fld    tbyte ptr 4800[edx]   ;
fadd                           ;
fstp   tbyte ptr 4800[edx]    ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fld    tbyte ptr  110[edi]    ;
fmul   st,st(1)                ;
fstp   tbyte ptr   50[ecx]    ;
fld    tbyte ptr   60[edi]   ;
fmul                           ;
fstp   tbyte ptr    0[ecx]    ;
fsubr                          ;
fld    tbyte ptr    0[edi]    ;
fmul   st,st(1)                ;
fld    tbyte ptr 3840[edx]   ;
fadd                           ;
fstp   tbyte ptr 3840[edx]    ;
fld    tbyte ptr   50[edi]   ;
fmul                           ;
fld    tbyte ptr 5440[edx]   ;
fadd                           ;
fstp   tbyte ptr 5440[edx]    ;
fld    tbyte ptr  140[eax]    ;
fld    tbyte ptr  110[eax]   ;
fadd                           ;
fld    tbyte ptr  110[eax]    ;
fld    tbyte ptr   80[eax]   ;
fadd                           ;
fld    tbyte ptr   50[eax]    ;
fld    tbyte ptr   20[eax]   ;
fadd                           ;
fld    tbyte ptr  170[eax]    ;
fld    tbyte ptr  140[eax]   ;
fadd                           ;
fadd   st,st(2)                ;
fld    tbyte ptr   20[eax]    ;
fsub   st,st(4)                ;
fld    st(2)                   ;
fsub   st,st(2)                ;
fld    tbyte ptr   10[esi]   ;
fmul                           ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fld    tbyte ptr  100[edi]    ;
fmul   st,st(1)                ;
fstp   tbyte ptr  100[ecx]    ;
fld    tbyte ptr   70[edi]   ;
fmul                           ;
fstp   tbyte ptr   70[ecx]    ;
fsub                           ;
fld    tbyte ptr   10[edi]    ;
fmul   st,st(1)                ;
fld    tbyte ptr   10[ecx]   ;
fadd                           ;
fstp   tbyte ptr   10[ecx]    ;
fld    tbyte ptr   40[edi]   ;
fmul                           ;
fld    tbyte ptr   40[ecx]   ;
fadd                           ;
fstp   tbyte ptr   40[ecx]    ;
fld    tbyte ptr   40[esi]   ;
fmul                           ;
fadd   st,st(1)                ;
fxch   st(2)                   ;
fadd                           ;
fld    tbyte ptr   30[esi]   ;
fmul                           ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fld    tbyte ptr    0[esi]   ;
fmul                           ;
fxch   st(2)                   ;
fsubr                          ;
fld    tbyte ptr   20[esi]   ;
fmul                           ;
fxch   st(2)                   ;
fld    tbyte ptr   40[esi]   ;
fmul                           ;
fld    tbyte ptr   20[eax]   ;
fadd                           ;
fld    tbyte ptr   80[eax]    ;
fld    tbyte ptr   50[eax]   ;
fadd                           ;
fld    tbyte ptr   30[esi]   ;
fmul                           ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fxch   st(2)                   ;
fsubr                          ;
fxch   st(2)                   ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fld    tbyte ptr   80[edi]    ;
fmul   st,st(1)                ;
fstp   tbyte ptr   80[ecx]    ;
fld    tbyte ptr   90[edi]   ;
fmul                           ;
fstp   tbyte ptr   90[ecx]    ;
fsub                           ;
fld    tbyte ptr   20[edi]    ;
fmul   st,st(1)                ;
fld    tbyte ptr   20[ecx]   ;
fadd                           ;
fstp   tbyte ptr   20[ecx]    ;
fld    tbyte ptr   30[edi]   ;
fmul                           ;
fld    tbyte ptr   30[ecx]   ;
fadd                           ;
fstp   tbyte ptr   30[ecx]    ;
fld    st(1)                   ;
fadd   st,st(1)                ;
fld    tbyte ptr  110[edi]    ;
fmul   st,st(1)                ;
fstp   tbyte ptr  110[ecx]    ;
fld    tbyte ptr   60[edi]   ;
fmul                           ;
fstp   tbyte ptr   60[ecx]    ;
fsubr                          ;
fld    tbyte ptr    0[edi]    ;
fmul   st,st(1)                ;
fld    tbyte ptr    0[ecx]   ;
fadd                           ;
add   eax,180                   ;
fstp   tbyte ptr    0[ecx]    ;
fld    tbyte ptr   50[edi]   ;
fmul                           ;
add   edx,10                    ;
fld    tbyte ptr   50[ecx]   ;
fadd                           ;
add   ebx,180                   ;
fstp   tbyte ptr   50[ecx]    ;
add   ecx,180                   ;
ret                            ;

;-------------------------------------------------------------------------

_TEXT		ENDS
CONST		SEGMENT	DWORD PUBLIC USE32 'DATA'
CONST		ENDS
CONST2		SEGMENT	DWORD PUBLIC USE32 'DATA'
CONST2		ENDS
_DATA		SEGMENT	DWORD PUBLIC USE32 'DATA'
L$24:
    DB	33H, 33H, 33H, 33H, 33H, 33H, 0e3H, 0bfH
    DB	1fH, 85H, 0ebH, 51H, 0b8H, 1eH, 0e1H, 0bfH
    DB	1fH, 85H, 0ebH, 51H, 0b8H, 1eH, 0d5H, 0bfH
    DB	0aeH, 47H, 0e1H, 7aH, 14H, 0aeH, 0c7H, 0bfH
    DB	52H, 0b8H, 1eH, 85H, 0ebH, 51H, 0b8H, 0bfH
    DB	0cbH, 0a1H, 45H, 0b6H, 0f3H, 0fdH, 0a4H, 0bfH
    DB	86H, 5aH, 0d3H, 0bcH, 0e3H, 14H, 8dH, 0bfH
    DB	0acH, 0adH, 0d8H, 5fH, 76H, 4fH, 6eH, 0bfH

_DATA		ENDS
_BSS		SEGMENT	DWORD PUBLIC USE32 'BSS'

    ORG 0
_aa_cs   LABEL	BYTE ; 32*10=320
    ORG 320
_win     LABEL	BYTE ; 2*4*36*10=2880
    ORG 3200
_COS9    LABEL	BYTE ; 18*10=180
    ORG 3380
_tfcos12 LABEL	BYTE ; 5*10=50
    ORG 3430

_BSS		ENDS

		END
