/************************************************************************

    INSTALL 2.0.1 - GEM installer

    Copyright (C) 1985,2000  Caldera Inc. / John Elliott 
                             <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/


#include <ppdgem.h>

#define EXT
#define EQ(x) = x
#include "install.h"

MLOCAL WORD copy_ret;	/* Pointless */
MLOCAL WORD flags[10];
EFCB volfind_efcb = {0xFF, {0}, 8, 0, "????????", "???", {0}};

BYTE *script_words[] = {"DOS",    /* OK */
                      "ALERT", 	  /* OK */
                      "SRCMSG",   /* OK */
                      "PATBAT",   /* OK */
                      "COPY",
                      "MD",		  /* OK */
                      "IF1BUTN",  /* OK */
                      "IF2BUTN",  /* OK */
                      "IF3BUTN",  /* OK */
                      "IFHD",	  /* OK */
                      "IFFD",	  /* OK */
                      "GOTO",	  /* OK */
                      ":",		  /* OK */
                      "RUN",	  /* OK */
                      "CHECKVER", /* OK */
                      "SETFLAG",  /* OK */
                      "CLRFLAG",  /* OK */
                      "IFFLAG",	  /* OK */
                      "REN",	  /* OK */
                      "DEL",	  /* OK */
                      "CHKVOL",	  /* OK? Always returns TRUE on NT */
                      "DSTMSG",	  /* OK */
                      "CREATEMSG",/* OK */
                      "IFERR",    /* OK */
                      "SETVOL",   /* OK? RENAME doesn't work on NT */
                      "CURVER",   /* OK */
                      "IFNOSPC"   /* OK */
};
                     


/*		{
		union REGS ri, ro;
		char b2[200];
		
		ri.x.ax = 0x5900;
		ri.x.bx = 0;
		intdos(&ri, &ro);
		
		sprintf(b2, "[1][%04x|%02x %02x|%x %x %x %x %x %x %x|%x:%-11.11s|%x:%-11.11s][ OK ]", 
					ro.x.ax, ro.h.bh, ro.h.bl,
					setvol_dta[0], setvol_dta[1], setvol_dta[2],
					setvol_dta[3], setvol_dta[4], setvol_dta[5],
					setvol_dta[6], setvol_dta[7], setvol_dta + 8, 
					setvol_dta[23], setvol_dta + 24);

		form_alert(1, b2);
		}
*/					












/****** MAIN SCRIPT COMMANDS ******/

BYTE *cmd_alert(VOID)
{
	WORD chosen, defbut;
	BYTE *str;
	

	str = parse_alert(line_pointer, alert_buffer, 1, &defbut);
	chosen = form_alert(defbut, ADDR(alert_buffer));

	flg_1butn = flg_2butn = flg_3butn = 0;
	switch(chosen)
	{
		case 1: flg_1butn = 1; break;
		case 2: flg_1butn = 2; break;
		case 3: flg_1butn = 3; break;
	}
	return str;
}

BYTE *cmd_srcmsg(VOID)
{
	return parse_alert(line_pointer, srcmsg_buffer, 1, &srcmsg_defbut);
}


BYTE cmd_patbat(VOID)
{
	BYTE drvno;
	BYTE *findptr, *compptr, *matchptr;
	BYTE matchbuf[20];
	
	drvno = choose_drive();	/* Get target drive */
	get_word(findptr = compptr = script_pointer, matchbuf);
	matchptr = matchbuf;

	/* Search the script for the string after PATBAT (eg: "C:") and
	 * replace its first letter with the drive letter */
	 
	while (*compptr != 0x1A && *compptr != 0)	/* EOF? */
	{
		/* First letter matches */
		
		if (*matchptr == *compptr)
		{
			while (*matchptr == *compptr && *matchptr != 0)
			{
				++matchptr;	/* Does the word match? */
				++compptr;
			}
			if (*matchptr == 0)	/* Yes. Write in the drive letter */
			{
				matchptr = matchbuf;
				*findptr = drvno;
			}
			else findptr = compptr;	/* No. Go to end of matching section */
		}
		/* First letter doesn't match */
		
		else
		{
			matchptr = matchbuf;	/* Rewind comparison */
			++compptr;				/* Move to next char */
			findptr = compptr;
		}
	}
	return drvno;
}



WORD cmd_copy(VOID)
{
	BYTE srcname[80];
	BYTE srcraw[80];
	BYTE dstdir[80];
	BYTE dstraw[80];
	BYTE *linepos, *srcfn, *dstfn;
	BYTE srcroot[80];
	LONG bufmax, buflen, rdlen, wrlen;
	LPVOID xferbuf;
	LPBYTE rdptr;
	
	GRECT rcDialog;
	LONG wrmax;
	
	WORD hsrc;
	WORD hdest;
	WORD finished;
	WORD fatal = 1;
	WORD pointless;		/* Looks like it's here either:
						 * as debugging code DRI left in; or:
						 * to force evaluation of rdptr between calls 
						 *   to inc_pointer() */ 
	
	MLOCAL LPBYTE ad_rdwr;
	
	graf_mouse(HOURGLASS, NULL);
	linepos = get_word(line_pointer, srcraw);	/* Source filename, maybe
												 * ambiguous */
	get_file_dir(srcraw, srcname);				/* Source directory */

	srcfn = srcname + strlen(srcname);			/* Where to put filename */
												/* after wildcard expansion */
												
	rsrc_gaddr(R_TREE, COPYING, (LPVOID *)&gl_tree);
	rsrc_gaddr(R_FRSTR, FSWRITE, (LPVOID *)&gl_writing);
	rsrc_gaddr(R_FRSTR, FSREAD,  (LPVOID *)&gl_reading);

	/* Search for files in the root of the source drive... strange little
	 * excursion since we then ignore the results! */
	srcroot[0] = srcraw[0];
	srcroot[1] = srcraw[1];
	srcroot[2] = 0;
	strcat(srcroot, "\*.*");
	dos_sfirst(ADDR(srcroot),7);

	/* ... and go straight on to this... */

	dos_sfirst(ADDR("A:\\AUTO\\ATARIGDO.PRG"), 7);
	if (DOS_ERR)
	{
		strcpy(srcfn, ffblk.ff_name);
		DOS_ERR = 0;
		DOS_ERR = 0; 	/* Yes, twice */
		hsrc = dos_open(ADDR(srcname), 0);
		if (!DOS_ERR) dos_close(hsrc);
	}

	/* ... which we then ignore as well! */
	
	if (!strlen(srcraw))	/* No source filename! */
	{
		graf_mouse(ARROW, NULL);
		return fatal;
	}

	get_word(linepos, dstdir);	/* Get destination directory */
	strcpy(dstraw, dstdir);
	dstfn = dstdir + strlen(dstdir);
	*(dstfn++) = '\\';

	/* Reset the displays */
	
	gl_tree[CPYMSG  ].ob_spec = ADDR("");
	gl_tree[CPYCAP3 ].ob_spec = ADDR("");
	gl_tree[CPYDNAME].ob_spec = ADDR("");
	gl_tree[CPYSNAME].ob_spec = ADDR("");
	gl_tree[CPYDNAME].ob_spec = ADDR(dstraw);	/* Yes, really */
	ob_xywh(gl_tree, 0, &rcDialog);
	rcDialog.g_x -= 3;
	rcDialog.g_y -= 3;
	rcDialog.g_w += 6;
	rcDialog.g_h += 6;
	fatal = 0;
	finished = 0;

	/* Show the displays */
	
	form_dial(0, 0,0,0,0, rcDialog.g_x, rcDialog.g_y, 
	                      rcDialog.g_w, rcDialog.g_h);
	objc_draw(gl_tree, ROOT, MAX_DEPTH, rcDialog.g_x, rcDialog.g_y, 
										rcDialog.g_w, rcDialog.g_h);

	/* Buffer size */
	bufmax = dos_avail();
	if (bufmax > 0x10000L) bufmax = 0x10000L;
	buflen = bufmax;
	
	/* Allocate the buffer */

	xferbuf = rdptr = dos_alloc(buflen);
	DOS_ERR = 1; 

	/* Try to find the first source file */
	
	while (DOS_ERR)
	{
		DOS_ERR = 0;
		dos_sfirst(srcraw, 7);
		if (!DOS_ERR) continue;

		graf_mouse(ARROW, NULL);
		if (form_alert(srcmsg_defbut, srcmsg_buffer) > 1)
		{
			finished = 1;
			fatal    = 1;
			return fatal;
		}
		graf_mouse(HOURGLASS, NULL);
		DOS_ERR = 1;
	}
	/* Got it. */
	
	hsrc = 0;
	hdest = 0;
	wrlen = 0L;
	rdlen = 0L;
	while (!finished) /* Major file-copying loop */
	{
		gl_tree[CPYMSG].ob_spec = ADDR(srcname);
		gl_tree[CPYCAP3].ob_spec = ad_rdwr = *gl_reading;
		repaint_ctrl(gl_tree, CPYCAP3);

		/* Fill the source buffer */
		while (buflen > 20 && !finished)
		{
			if (!hsrc)	/* Open source file */
			{
				strcpy(srcfn, ffblk.ff_name);
				/* Stick source filename in buffer */
				LBCOPY(rdptr, ADDR(srcfn), 1 + LSTRLEN(ADDR(srcfn)));

				/* and increase buffer */
				inc_pointer(&rdptr, &buflen, 1 + strlen(srcfn));
				pointless = (FP_OFF(rdptr) & 1);
				/* Normalise the pointer */
				inc_pointer(&rdptr, &buflen, 0);
				repaint_ctrl(gl_tree, CPYMSG);

				while (!hsrc)	/* Try to open source file */
				{
					DOS_ERR = 0;
					hsrc = dos_open(ADDR(srcname), 0);
					if (!DOS_ERR) continue;

					if (form_alert(srcmsg_defbut, srcmsg_buffer) > 1)
					{
						finished = 1;
						fatal = 1;
						return fatal;
					}
					graf_mouse(HOURGLASS, NULL);
					hsrc = 0;
				}
			}

			/* Load as much file as will fit */
			if (ffblk.ff_size < buflen - 5) rdlen = ffblk.ff_size;
			else						    rdlen = buflen - 5;

			ffblk.ff_size -= rdlen;
			(*(LPLONG)rdptr) = rdlen;		/* Stick size read in the buffer */
			inc_pointer(&rdptr, &buflen, 4);
			dos_read(hsrc, rdlen, rdptr);
			inc_pointer(&rdptr, &buflen, rdlen);
			if (!ffblk.ff_size)
			{
				dos_close(hsrc);	/* End of source file */
				rdlen = 0;
				hsrc  = 0;			/* Close it */
				DOS_ERR = 0;
				dos_snext();
				finished = DOS_ERR;	/* Is there another one? */
			}
			(*(LPBYTE)rdptr) = 0;	/* End of buffer marker */
		} /* End while */
		
		if (fatal) break;			/* OK so far */
		wrmax  = buflen;			/* Size of buffer unused */
		rdptr  = xferbuf;
		buflen = bufmax;			/* Size of buffer used+unused */

		/* Signal: writing */
		gl_tree[CPYMSG].ob_spec = ADDR(dstdir);
		gl_tree[CPYCAP3].ob_spec = ad_rdwr = *gl_writing;
		repaint_ctrl(gl_tree, CPYCAP3);

		while (buflen != wrmax)		/* Still some "used" buffer left */
		{
			if (!hdest)	/* Open destination file */
			{
				LBCOPY(ADDR(dstfn), rdptr, LSTRLEN(rdptr) + 1);
				inc_pointer(&rdptr, &buflen, 1 + strlen(dstfn));
				pointless = FP_OFF(rdptr) & 1;
				inc_pointer(&rdptr, &buflen, 0);
				repaint_ctrl(gl_tree, CPYMSG);
			
				DOS_ERR = 1;
				while(DOS_ERR)
				{
					hdest = dos_create(ADDR(dstdir), 0);
					if (!DOS_ERR) continue;
					graf_mouse(ARROW, NULL);

					/* BUG? The DRI original uses dstmsg_defbut here */
					
					if (form_alert(cremsg_defbut, cremsg_buffer) > 1)
					{
						finished = 1;
						fatal = 1;
						return fatal;
					}
					graf_mouse(HOURGLASS, NULL);
					DOS_ERR = 1;
				}
				
			}
			/* Destination file open */
			/* Write buffered length */
			wrlen = *((LPLONG)rdptr);
			inc_pointer(&rdptr, &buflen, 4);
			if (dos_write(hdest, wrlen, rdptr) != wrlen)
			{
				dos_close(hdest);
				if (write_ok_flag)
				{
					graf_mouse(ARROW, NULL);
					form_alert(1, dstmsg_buffer);
					graf_mouse(HOURGLASS, NULL);
				}
				write_ok_flag = 0;
				dos_delete(ADDR(dstdir));
				finished = 1;
				fatal = 1;
				break;
			}
			else
			{
				inc_pointer(&rdptr, &buflen, wrlen);
				if (buflen != wrmax || !hsrc)
				{
					dos_close(hdest);
					hdest = 0;
					
				}
			}
		} /* end while, write buffer empty */
		if (fatal) break;

		/* Reset read pointers */
		rdptr = xferbuf;
		buflen = bufmax;
		*((LPBYTE)rdptr) = 0;
	} /* end monster while */
	form_dial(3, 0,0,0,0, rcDialog.g_x, rcDialog.g_y, 
						  rcDialog.g_w, rcDialog.g_h);
	dos_free(xferbuf);
	graf_mouse(ARROW, NULL);
	return fatal;
}

VOID cmd_md(VOID)
{
	LPBYTE ad_mdir;
	BYTE   buf[80];

	get_word(line_pointer, buf);
	ad_mdir = ADDR(buf);

	dos_mkdir(ad_mdir);
	fix_error();
}

VOID cmd_if1butn(VOID)
{
	if (flg_1butn) script_goto();
}

VOID cmd_if2butn(VOID)
{
	if (flg_2butn) script_goto();
}

VOID cmd_if3butn(VOID)
{
	if (flg_3butn) script_goto();
}

VOID cmd_ifhd(VOID)
{
	if (have_fixed_drive) script_goto();
}

VOID cmd_iffd(VOID)
{
	if (!have_fixed_drive) script_goto();
}

VOID cmd_goto(VOID)
{
	script_goto();
}

VOID cmd_colon(VOID) {}

VOID cmd_run(VOID)
{
	WORD doex, iscr, isgr;

	sh_parse(&doex, &iscr, &isgr, sh_cmdbuf, sh_tailbuf);
	shel_write(doex, iscr, isgr, ADDR(sh_cmdbuf), ADDR(sh_tailbuf));
}

VOID cmd_checkver(VOID)
{
	WORD ckver;

	ckver = xtoi(skip_spaces(line_pointer));

	flg_1butn = flg_2butn = flg_3butn = 0;

	if      (gl_gemver <  ckver) flg_1butn = 1;
	else if (gl_gemver == ckver) flg_2butn = 1;
	else if (gl_gemver >  ckver) flg_3butn = 1;
}


VOID cmd_setflag(VOID)
{
	WORD flagno;
	
	line_pointer = skip_spaces(line_pointer);

	flagno = line_pointer[0] - '0';
	/* XXX some range checking here, hmmm??? */
	flags[flagno] = 1;
}

VOID cmd_clrflag(VOID)
{
	WORD flagno;
	
	line_pointer = skip_spaces(line_pointer);

	flagno = line_pointer[0] - '0';
	/* XXX some range checking here, hmmm??? */
	flags[flagno] = 0;
}

VOID cmd_ifflag(VOID)
{
	WORD flagno;
	
	line_pointer = skip_spaces(line_pointer);

	flagno = line_pointer[0] - '0';
	/* XXX some range checking here, hmmm??? */
	if (flags[flagno]) script_goto();
}



VOID cmd_ren(VOID)
{
	LPBYTE ad_old, ad_new;
	BYTE   old[80], new[80];


	get_word(get_word(line_pointer, old), new);
	
	ad_old = ADDR(old);
	ad_new = ADDR(new);

	dos_rename(ad_old, ad_new);
	fix_error();
}



VOID cmd_del(VOID)
{
	LPBYTE ad_del;
	BYTE   buf[80];

	get_word(line_pointer, buf);
	ad_del = ADDR(buf);

	dos_delete(ad_del);
	fix_error();
}



VOID cmd_chkvol(VOID)
{
	WORD n, mask;
	BYTE buf[20];
	BYTE *lblname;

	mask = 0xFF;
	flg_3butn = flg_2butn = flg_1butn = 0;
	get_word(line_pointer, buf);
	lblname = buf;

	if (buf[1] == ':') 
	{
		volfind_efcb.drive = buf[0] - ('A' - 1);
		lblname += 2;
	}
	else volfind_efcb.drive = 0;

	strcpy(volfind_efcb.name, lblname);
	for (n = strlen(volfind_efcb.name); n < 11; n++)
	{
		volfind_efcb.name[n] = ' ';
	}
	DOS_AX = 0x1100;
	DOS_DX = FP_OFF(&volfind_efcb);
	DOS_DS = FP_SEG(&volfind_efcb);
	__DOS();

	if (DOS_AX & mask) flg_2butn = 1;	/* Not found */
	else			   flg_1butn = 1;	/* Found */
}



BYTE *cmd_cremsg(VOID)
{
	return parse_alert(line_pointer, cremsg_buffer, 1, &cremsg_defbut);
}


BYTE *cmd_dstmsg(VOID)
{
	return parse_alert(line_pointer, dstmsg_buffer, 1, &dstmsg_defbut);
}


VOID cmd_curver(VOID)
{
	rsrc_gaddr(R_TREE, ABOUTBOX, (LPVOID *)&gl_tree);	
	hndl_dialog(gl_tree);
}



VOID cmd_ifnospc(VOID)
{
	WORD free_k, drive;
	BYTE buf[80];
	LONG avail, required;
	
	line_pointer = get_word(line_pointer, buf);
	drive = buf[0];
	line_pointer = get_word(line_pointer, buf);
	free_k = atow(buf);

	avail = free_space(drive - ('A'-1));
	required = free_k;

	if (required > (avail / 1024L)) script_goto();
}



VOID cmd_iferr(VOID)
{
	BYTE buf[80];
	MLOCAL WORD ckerr;
	
	line_pointer = get_word(line_pointer, buf);
	ckerr = atow(buf);

	if ((ckerr == -1 && script_error) || (ckerr == script_error))
		script_goto();
}



VOID cmd_setvol(VOID)
{
	WORD n, mask;
	BYTE buf[20];
	BYTE *lblname;

	dos_sdta(ADDR(setvol_dta));
	mask = 0xFF;
	flg_3butn = flg_2butn = flg_1butn = 0;
	get_word(line_pointer, buf);
	lblname = buf;

	if (buf[1] == ':') 
	{
		volfind_efcb.drive = buf[0] - ('A' - 1);
		lblname += 2;
	}
	else volfind_efcb.drive = 0;

	for (n = 0; n < 11; n++)
	{
		volfind_efcb.name[n] = '?';
	}
	DOS_AX = 0x1100;
	DOS_DX = FP_OFF(&volfind_efcb);
	DOS_DS = FP_SEG(&volfind_efcb);
	__DOS();

	if (DOS_AX & mask)	/* Not found */
	{
		strcpy(volfind_efcb.name, lblname);
		for (n = strlen(volfind_efcb.name); n < 11; n++)
		{
			volfind_efcb.name[n] = ' ';
		}
		DOS_AX = 0x1600;
		DOS_DX = FP_OFF(&volfind_efcb);
		DOS_DS = FP_SEG(&volfind_efcb);
	}
	else
	{
		strcpy(setvol_dta + 0x18, lblname);

		for (n = strlen(setvol_dta + 0x18); n < 11; n++)
			setvol_dta[0x18+n] = ' ';
		setvol_dta[0x17] = setvol_dta[7];
		DOS_AX = 0x1700;
		DOS_DX = FP_OFF(setvol_dta);
		DOS_DS = FP_SEG(setvol_dta);
	}
	__DOS();
	
	if (DOS_AX & mask) flg_2butn = 1;
	else			   flg_1butn = 1;
}

/******* MAIN ********/


WORD GEMAIN(WORD ARGC, BYTE *ARGV[])
{
	WORD bp2, bp4, bp6;

	bp4 = appl_init(NULL);

	gl_gemver        = global[0];
	script_error 	 = 0;
	have_fixed_drive = 0;
	check_fixed();

	ad_rmsg      = ADDR(gl_rmsg);
	ad_something = ADDR(gl_something);
	graf_mouse(ARROW, NULL);

	/* not used word_282_A00 = 0; */
	dos_sdta(ADDR(&ffblk));
	
	if (!load_script()) return 1;

	flg_3butn = flg_2butn = flg_1butn = 0;

	write_ok_flag = 1;
	bp6 = 0;
	bp2 = 1;
	if (!load_resources()) return 1;

	while (bp2)
	{
		dos_sdta(ADDR(&ffblk)); 
		bp2 = script_match();
		
		line_pointer = script_pointer;
		switch(bp2)
		{
			case CMD_RUN:	  cmd_run();		/* FALL THROUGH */
			case CMD_DOS: 	  bp2 = bp6 = 0; 						 break;
			case CMD_ALERT:   script_pointer = cmd_alert(); bp6 = 0; break;
			case CMD_SRCMSG:  script_pointer = cmd_srcmsg();bp6 = 0; break;
			case CMD_PATBAT:  bp2 = cmd_patbat(); bp6 = 1;           break;
			case CMD_COPY:	  copy_ret = cmd_copy(); 
							  if (copy_ret) { bp2 = bp6 = 0; }
							  else			 bp6 = 1;				
							  break;	 
			case CMD_MD:	  cmd_md();	     bp6 = 1;				 break;
			case CMD_IF1BUTN: cmd_if1butn(); bp6 = 1;				 break;
			case CMD_IF2BUTN: cmd_if2butn(); bp6 = 1;				 break;
			case CMD_IF3BUTN: cmd_if3butn(); bp6 = 1;				 break;
			case CMD_IFHD:    cmd_ifhd();	 bp6 = 1;				 break;
			case CMD_IFFD:	  cmd_iffd();	 bp6 = 1;				 break;
			case CMD_GOTO:	  cmd_goto();	 bp6 = 1;				 break;
			case CMD_COLON:   cmd_colon();	 bp6 = 1;				 break;
			case CMD_CHECKVER:cmd_checkver();bp6 = 1; 			     break;
			case CMD_SETFLAG: cmd_setflag(); bp6 = 1;                break;
			case CMD_CLRFLAG: cmd_clrflag(); bp6 = 1;			     break;
			case CMD_IFFLAG:  cmd_ifflag();  bp6 = 1;                break;
			case CMD_REN:	  cmd_ren();	 bp6 = 1;				 break;
			case CMD_DEL:	  cmd_del();	 bp6 = 1;				 break;
			case CMD_CHKVOL:  cmd_chkvol();  bp6 = 1;				 break;
			case CMD_DSTMSG:  script_pointer = cmd_dstmsg();bp6 = 0; break;
			case CMD_CREMSG:  script_pointer = cmd_cremsg();bp6 = 0; break;
			case CMD_IFERR:   cmd_iferr();   bp6 = 1;				 break;
			case CMD_SETVOL:  cmd_setvol();  bp6 = 1; 				 break;
			case CMD_CURVER:  cmd_curver();  bp6 = 1; 				 break;
			case CMD_IFNOSPC: cmd_ifnospc(); bp6 = 1; 				 break;
			default:
				 form_alert(0, ADDR("[3][Bad command in INSTALL.TXT.|Cannot proceed.][ Cancel] "));
				 bp2 = 0;
				 break;
		}
		if (bp6) bp2 = next_line();
		
	}

	return 0;
}
