unit INIFilag;

interface

type
   PEntry   = ^TEntry;
   TEntry   = record
      Line  : string;
      Next  : PEntry;   
   end;

   PSection = ^TSection;
   TSection = record
      Name  : string;
      First : PEntry;
      Next  : PSection;
   end;

   TIniFile = record
      First : PSection;
   end;

   function SectionCount(o : TINIFile) : integer;

   function SectionIndex(o : TINIFile; s : string) : integer;

   function GetSection(o : TINIFile; index : integer) : PSection;

   function AddSection(var o : TINIFile; name : string) : PSection;

   function EntryCount(s : PSection) : integer;

   procedure ParseINILine(s : string; var name, value : string);

   function GetNameIndex(s : PSection; name : string) : integer;
   function GetLine(s : PSection; index : integer) : string;
   procedure SetLine(s : PSection; index : integer; line : string);
   function GetValue(s : PSection; name : string) : string;
   procedure SetValue(s : PSection; name, value : string);
   procedure AddLine(s : PSection; line : string);

   procedure LoadINIFile(var o : TINIFile; path : string);
   procedure SaveINIFile(var o : TINIFile; path : string);
   procedure FreeINIFile(var o : TINIFile);
   procedure FreeSection(var s : PSection);
   procedure FreeEntry(var e : PEntry);

implementation

   function UpperCase(stuff : string) : string;
   var
      i : integer;
      b : string;
   begin
      b := '';
      for i := 1 to length(stuff) do
         b := b + UpCase(stuff[i]);
      UpperCase := b;
   end;

   function SectionCount(o : TINIFile) : integer;
   var
      i : integer;
      c : PSection;
   begin
      i := 0;
      c := o.First;
      while c <> nil do
      begin
         inc(i);
         c := c^.Next;
      end;
      SectionCount := i;
   end;

   function SectionIndex(o : TINIFile; s : string) : integer;
   var
      i : integer;
      j : integer;
      u : string;
      c : PSection;
   begin
      i := -1;
      j := -1;
      u := UPPERCASE(s);
      c := o.First;
      while c <> nil do
      begin
         inc(i);
         if UPPERCASE(c^.Name) = u then
            j := i;
         c := c^.Next;
      end;
      SectionIndex := j;
   end;

   function GetSection(o : TINIFile; index : integer) : PSection;
   var
      i : integer;
      c : PSection;
   begin
      if index=0 then
         GetSection := o.First
      else if index < SectionCount(o) then
      begin
         c := o.First;
         for i := 1 to index do
         begin
            c := c^.Next;
            if c = nil then
            begin
               GetSection := nil;
               exit;
            end;
         end;
         GetSection := c;
      end
      else GetSection := nil;
   end;

   function AddSection(var o : TINIFile; name : string) : PSection;
   var
      c : PSection;
   begin
      c := o.First;
      if c = nil then
      begin
         new(o.First);
         o.First^.Name := name;
         o.First^.First := nil;
         o.First^.Next := nil;
         AddSection := o.First;
      end
      else
      begin
         while c^.Next <> nil do
            c := c^.Next;
         new(c^.Next);
         c^.Next^.Name := name;
         c^.Next^.Next := nil;
         c^.Next^.First := nil;
         AddSection := c^.Next;
      end;
   end;

   function EntryCount(s : PSection) : integer;
   var
      i : Integer;
      c : PEntry;
   begin
      if s = nil then begin EntryCount := -1; exit; end;
      i := 0;
      c := s^.First;
      while c <> nil do
      begin
         inc(i);
         c := c^.Next;
      end;
      EntryCount := i;
   end;

   procedure ParseINILine(s : string; var name, value : string);
   var
      p : integer;
   begin
      p := pos('=', s);
      value := copy(s,p+1,length(s));
      name := copy(s,1,length(s)-(p+1));
   end;

   function GetNameIndex(s : PSection; name : string) : integer;
   var
      i : integer;
      u : string;
      c : PEntry;
   begin
      i := -1;
      c := s^.First;
      GetNameIndex := -1;
      if c <> nil then
      begin
         u := UPPERCASE(name);
         while c <> nil do
         begin
            inc(i);
            if UPPERCASE(copy(c^.Line,1,length(name))) = u then
            begin
               GetNameIndex := i;
               exit;
            end;
            c := c^.Next;
         end;
      end;
   end;

   function GetLine(s : PSection; index : integer) : string;
   var
      i : integer;
      c : PEntry;
   begin
      if index <= EntryCount(s) then
      begin
         c := s^.First;
         if index = 0 then
            GetLine := c^.Line
         else if index > 0 then
         begin
            for i := 1 to index do
               c := c^.Next;
            GetLine := c^.Line;
         end
         else GetLine := '';
      end
      else GetLine := '';
   end;

   procedure SetLine(s : PSection; index : integer; line : string);
   var
      c : PEntry;
      i : integer;
   begin
      if index <= EntryCount(s) then
      begin
         c := s^.First;
         if index = 0 then
            c^.Line := line
         else
         begin
            for i := 1 to index do
               c := c^.Next;
            c^.Line := line;
         end;
      end;
   end;

   function GetValue(s : PSection; name : string) : string;
   var
      l : string; 
      newName, newValue : string;
   begin
      l := GetLine(s,GetNameIndex(s, name));
      ParseINILine(l,newName, newValue);
      GetValue := newValue;
   end;

   procedure SetValue(s : PSection; name, value : string);
   var
      l, i : integer;
   begin
      l := GetNameIndex(s,name);
      if l <> -1 then
         Setline(s,l,name+'='+value)
      else
         Addline(s,name+'='+value);
   end;

   procedure AddLine(s : PSection; line : string);
   var
      c : PEntry;
   begin
      if s <> nil then
      begin
         c := s^.First;
         if c = nil then
         begin
            new(s^.First);
            s^.First^.Line := line;
            s^.First^.Next := nil;
         end
         else
         begin
            while c^.Next <> nil do
               c := c^.Next;
            new(c^.Next);
            c^.Next^.Line := line;
            c^.Next^.Next := nil;
         end;
      end;
   end;

   procedure LoadINIFile(var o : TINIFile; path : string);
   var
      cs : PSection;
      f  : text;
      l  : string;
   begin
      FreeINIFile(o);
      cs := AddSection(o,'');
      Assign(f,path);
      Reset(f);
      repeat
         readln(f,l);
         if l[1] = '[' then
            cs := AddSection(o, copy(l,2,length(l)-2))
         else
            Addline(cs,l);
      until eof(f);
      Close(f);
   end;

   procedure SIEntriesHelper(var f : text; s : PEntry);
   var
      c : PEntry;
   begin
      c := s;
      while c <> nil do
      begin
         writeln(f,c^.Line);
         c := c^.Next;
      end;
   end;

   procedure SISectionsHelper(var f : text; s : PSection);
   var
      c : PSection;
   begin
      c := s;
      while c <> nil do
      begin
         if c^.Name <> '' then writeln(f,'['+c^.Name+']');
         SIEntriesHelper(f, c^.First);
         c := c^.Next;
      end;
   end;

   procedure SaveINIFile(var o : TINIFile; path : string);
   var
      f : text;
   begin
      Assign(f,path);
      Rewrite(f);
      SISectionsHelper(f,o.First);
      Close(f);
   end;

   procedure FreeINIFile(var o : TINIFile);
   begin
      FreeSection(o.First);
   end;

   procedure FreeSection(var s : PSection);
   begin
      if s <> nil then
      begin
         if s^.First <> nil then FreeEntry(s^.First);
         if s^.Next <> nil then FreeSection(s^.Next);
         Dispose(s);
      end;
   end;

   procedure FreeEntry(var e : PEntry);
   begin
      If e <> nil then
      begin
         if e^.Next <> nil then
            FreeEntry(e^.Next);
         Dispose(e);
      end;
   end;

end.
