/*
 * LZHUF.C English version 1.0
 * Based on Japanese version 29-NOV-1988
 * LZSS coded by Haruhiko OKUMURA
 * Adaptive Huffman Coding coded by Haruyasu YOSHIZAKI
 * Edited and translated to English by Kenji RIKITAKE
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include "defines.h"
#include "maus.h"

FILE *infile, *outfile;
unsigned long int textsize, printcount;

/* LZSS Parameters */

#define N		4096	/* Size of string buffer */
#define F		60	/* Size of look-ahead buffer */
#define THRESHOLD	2

unsigned char  text_buf[N + F - 1];

/* Huffman coding parameters */

#define N_CHAR  	(256 - THRESHOLD + F)
				/* character code (= 0..N_CHAR-1) */
#define T 		(N_CHAR * 2 - 1)	/* Size of table */
#define R 		(T - 1)			/* root position */
#define MAX_FREQ	0x8000
					/* update when cumulative frequency */
					/* reaches to this value */

typedef unsigned char uchar;

/*
 * Tables for encoding/decoding upper 6 bits of
 * sliding dictionary pointer
 */

/* decoder table */
uchar d_code[256] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
	0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
	0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
	0x0C, 0x0C, 0x0C, 0x0C, 0x0D, 0x0D, 0x0D, 0x0D,
	0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x0F, 0x0F, 0x0F,
	0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x11,
	0x12, 0x12, 0x12, 0x12, 0x13, 0x13, 0x13, 0x13,
	0x14, 0x14, 0x14, 0x14, 0x15, 0x15, 0x15, 0x15,
	0x16, 0x16, 0x16, 0x16, 0x17, 0x17, 0x17, 0x17,
	0x18, 0x18, 0x19, 0x19, 0x1A, 0x1A, 0x1B, 0x1B,
	0x1C, 0x1C, 0x1D, 0x1D, 0x1E, 0x1E, 0x1F, 0x1F,
	0x20, 0x20, 0x21, 0x21, 0x22, 0x22, 0x23, 0x23,
	0x24, 0x24, 0x25, 0x25, 0x26, 0x26, 0x27, 0x27,
	0x28, 0x28, 0x29, 0x29, 0x2A, 0x2A, 0x2B, 0x2B,
	0x2C, 0x2C, 0x2D, 0x2D, 0x2E, 0x2E, 0x2F, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
};

uchar d_len[256] = {
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
};

unsigned freq[T + 1];	/* cumulative freq table */

/*
 * pointing parent nodes.
 * area [T..(T + N_CHAR - 1)] are pointers for leaves
 */
int prnt[T + N_CHAR];

/* pointing children nodes (son[], son[] + 1)*/
int son[T];

unsigned getbuf;
uchar getlen;

int GetBit( void)	/* get one bit */
{
   int i;

   while( getlen<= 8)
   {
      if(( i= getc( infile))< 0)
	 i= 0;
      getbuf|= i<< ( 8- getlen);
      getlen+= 8;
   }
   i= getbuf;
   getbuf<<= 1;
   getlen--;
   return( i< 0);
}

int GetByte( void)	/* get a byte */
{
   unsigned i;

   while( getlen<= 8)
   {
      if( ( int)( i= getc( infile))< 0)
	 i= 0;
      getbuf|= i<< ( 8- getlen);
      getlen+= 8;
   }
   i= getbuf;
   getbuf<<= 8;
   getlen-= 8;
   return( i>> 8);
}

/* initialize freq tree */

void StartHuff( void)
{
   int i, j;

   for( i= 0; i< N_CHAR; i++)
   {
      freq[ i]= 1;
      son[ i]= i+ T;
      prnt[ i+ T]= i;
   }
   i= 0;
   j= N_CHAR;
   while( j<= R)
   {
      freq[ j]= freq[ i]+ freq[ i+ 1];
      son[ j]= i;
      prnt[ i]= prnt[ i+ 1]= j;
      i+= 2;
      j++;
   }
   freq[ T]= 0xFFFF;
   prnt[ R]= 0;
}


/* reconstruct freq tree */

void reconst( void)
{
   int i, j, k;
   unsigned f, l;

   /* halven cumulative freq for leaf nodes */
   j= 0;
   for( i= 0; i< T; i++)
   {
      if( son[ i]>= T)
      {
	 freq[ j]= ( freq[ i]+ 1)/ 2;
	 son[ j]= son[ i];
	 j++;
      }
   }
   /* make a tree : first, connect children nodes */
   for( i= 0, j= N_CHAR; j< T; i+= 2, j++)
   {
      k= i+ 1;
      f= freq[ j]= freq[ i]+ freq[ k];
      for( k= j- 1; f< freq[ k]; k--)
	 ;
      k++;
      l= ( j- k)* 2;

      /* movmem() is Turbo-C dependent
	 rewritten to memmove() by Kenji */

      /* movmem( &freq[ k], &freq[ k+ 1], l); */
      ( void)memmove( &freq[ k+ 1], &freq[ k], l);
      freq[ k]= f;
      /* movmem( &son[ k], &son[ k+ 1], l); */
      ( void)memmove( &son[ k+ 1], &son[ k], l);
      son[ k]= i;
   }
   /* connect parent nodes */
   for( i= 0; i< T; i++)
   {
      if(( k= son[ i])>= T)
	 prnt[ k]= i;
      else
	 prnt[ k]= prnt[ k+ 1]= i;
   }
}


/* update freq tree */

void update( int c)
{
   int i, j, k, l;

   if( freq[ R]== MAX_FREQ)
      reconst();
   c= prnt[ c+ T];
   do
   {
      k= ++freq[ c];

      /* swap nodes to keep the tree freq-ordered */
      if( k> freq[ l= c+ 1])
      {
	 while( k> freq[ ++l])
	    ;
	 l--;
	 freq[ c]= freq[ l];
	 freq[ l]= k;

	 i= son[ c];
	 prnt[ i]= l;
	 if( i< T)
	    prnt[ i+ 1]= l;

	 j= son[ l];
	 son[ l]= i;

	 prnt[ j]= c;
	 if( j< T)
	    prnt[ j+ 1]= c;
	 son[ c]= j;

	 c= l;
      }
   }while(( c= prnt[ c])!= 0);	   /* do it until reaching the root */
}

int DecodeChar( void)
{
   unsigned c;

   c= son[ R];

   /*
    * start searching tree from the root to leaves.
    * choose node #(son[]) if input bit == 0
    * else choose #(son[]+1) (input bit == 1)
    */
   while( c< T)
   {
      c+= GetBit();
      c= son[ c];
   }
   c-= T;
   update( c);
   return( c);
}

int DecodePosition( void)
{
   unsigned i, j, c;

   /* decode upper 6 bits from given table */
   i= GetByte();
   c= ( unsigned)d_code[ i]<< 6;
   j= d_len[ i];

   /* input lower 6 bits directly */
   j-= 2;
   while( j--)
      i= ( i<< 1)+ GetBit();
   return( c| i& 0x3F);
}

int Decode( int X, int Y, int Laenge, int Hoehe)           /* Uncompressing */
{
   int ret_val= 0, x_sp= 0, i, j, k, r, c;
   unsigned long count;

   printcount= 0;
   getbuf= 0;
   getlen= 0;
   if( fread( &textsize, sizeof( textsize), 1, infile)== 1)
   {
      if( textsize!= 0)
      {
	 StartHuff();
	 memset( text_buf, ' ', N- F);
	 r= N- F;
	 for( count= 0; count< textsize;)
	 {
	    c= DecodeChar();
	    if( c< 256)
	    {
	       putc( c, outfile);
	       text_buf[ r++]= c;
	       r&= ( N- 1);
	       count++;
	    }
	    else
	    {
	       i= ( r- DecodePosition()- 1)& ( N- 1);
	       j= c- 255+ THRESHOLD;
	       for( k= 0; k< j; k++)
	       {
		  c= text_buf[ ( i+ k)& ( N- 1)];
		  putc( c, outfile);
		  text_buf[ r++]= c;
		  r&= ( N- 1);
		  count++;
	       }
	    }
	    if( count> printcount)
	    {
	       ShowMouse( AUS);
	       Balken( X, Y, Laenge, Hoehe, count, textsize, &x_sp);
	       ShowMouse( AN);
	       printcount+= 1024;
	    }
	 }
	 ShowMouse( AUS);
	 Balken( X, Y, Laenge, Hoehe, count, textsize, &x_sp);
	 ShowMouse( AN);
      }
   }
   else
      ret_val= -2;
   return( ret_val);
}

int Decomp( int X, int Y, int Laenge, int Hoehe, char *Quelle, char *Ziel)
{
   int ret_val= 0;

   if((( infile= fopen( Quelle, "rb"))!= NULL)&& (( outfile= fopen( Ziel, "wb"))!= NULL))
   {
      ret_val= Decode( X, Y, Laenge, Hoehe);
      fclose( outfile);
   }
   else
      ret_val= -1;
   if( infile!= NULL)
      fclose( infile);
   return( ret_val);
}
