VIO_SEG         = 0A000H;* Segmentadresse des Video-RAM
                        ;* im Grafik-Modus
VIO_LEN         = 80    ;* in den neuen EGA-/VGA-Grafikmodi
                        ;* belegt jede Grafikzeile 80 Byte
BITMASK_REG     = 8     ;* Bitmask-Register
MODE_REG        = 5     ;* Mode-Register
FUNCSEL_REG     = 3     ;* Function-Select-Register
MAPSEL_REG      = 4     ;* Map-Select-Register
ENABLE_REG      = 1     ;* Enable Set-/Reset-Register
SETRES_REG      = 0     ;* Set-/Reset-Register
GRAPH_CONT      = 3CEH  ;* Portadresse des Grafik-Controller

GR_640_350      = 10H   ;* BIOS-Code fr den 640*350 Punkte-
                        ;* Grafikmodus bei 16 Farben
TX_80_25        = 03H   ;* BIOS-Code fr den 80*25-Zeichen-
                        ;* Textmodus

                        ;* Verknpfungsmodus:
OPE_MODE        = 0     ;*   00h = Ersetzen
OPU_MODE        = 8     ;*   08h = UND-Verknpfung
OPO_MODE        = 10H   ;*   10h = ODER-Verknpfung
OPX_MODE        = 18H   ;*   18h = EXKLUSIV-ODER-Verknpfung

Bitm        = 0         ;* normale Bitmap  (BM)
Cursor      = 2         ;* Maus-Cursor     (00 00 02 00)
Icone       = 1         ;* Icon            (00 00 01 00)
IcBytes     = 512       ;* Anzahl der Bytes einer Icon-
                        ;*  Farbbitmap. Die bekannten Icon-
                        ;*  Editoren erzeugen Bitmaps
                        ;*  mit den Maen 32*32 = 1024.
                        ;*  16-farbige Bildschirmmodi be-
                        ;*  ntigen zur Darstellung eines
                        ;*  Pixels 4 Bits (= 1 Bit pro Plane)
                        ;*  (1024 Pixel / 8 Bit * 4 Bit pro 
                        ;*  Pixel = 512 Bytes)

BS_xLen         = 640   ;* Bildschirmlnge in x-Richtung
BS_yLen         = 480   ;* Bildschirmlnge in y-Richtung
Sp_pro_Ebene    = 1     ;* Spalten (EMS-Page-Blcke in x-
                        ;* Richtung) pro Farbebene
Z_pro_Ebene     = 10    ;* Zeilen (EMS-Page-Blcke in y-
                        ;* Richtung) pro Farbebene
xPix_pro_Ebene  = 1280  ;* Pixel bzw. Bits der gesamten 
                        ;* Farbebene in x-Richtung
yPix_pro_Ebene  = 960   ;* Pixel bzw. Bits der gesamten 
                        ;* Farbebene in y-Richtung
PageBreite      = xPix_pro_Ebene/Sp_pro_Ebene
PageHoehe       = yPix_pro_Ebene/Z_pro_Ebene
Page_Len        = PageBreite/8
Bytes_pro_Page  = 4000H ;* Anzahl der Bytes pro Page (16K)
