/*  PAL_OP.C  Palette operations
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dos.h>
#include <graphics.h>
#include "pal_op.h"
#include "defines.h"

void SetPal( void)
{
   struct palettetype pal;
   struct REGPACK RP;

   pal.size= 16;
   pal.colors[  0]= PAL_BLACK;
   pal.colors[  1]= PAL_RED;
   pal.colors[  2]= PAL_GREEN;
   pal.colors[  3]= PAL_OLIVGREEN;
   pal.colors[  4]= PAL_BLUE;
   pal.colors[  5]= PAL_MAGENTA;
   pal.colors[  6]= PAL_CYAN;
   pal.colors[  7]= PAL_DARKGRAY;
   pal.colors[  8]= PAL_LIGHTGRAY;
   pal.colors[  9]= PAL_FIRERED;
   pal.colors[ 10]= PAL_LIGHTGREEN;    
   pal.colors[ 11]= PAL_YELLOW;  
   pal.colors[ 12]= PAL_LIGHTBLUE;
   pal.colors[ 13]= PAL_LIGHTMAGENTA;    
   pal.colors[ 14]= PAL_LIGHTCYAN;   
   pal.colors[ 15]= PAL_WHITE;    
   setallpalette( &pal);
   RP.r_ax= 0x1010;
   RP.r_bx= PAL_DARKGRAY;
   RP.r_cx= 0x2525;
   RP.r_dx= 0x2500;
   intr( VIDEO_INT, &RP);
   RP.r_ax= 0x1010;
   RP.r_bx= PAL_LIGHTGRAY;
   RP.r_cx= 0x3030;
   RP.r_dx= 0x3000;
   intr( VIDEO_INT, &RP);
}