;  ICOPCX.ASM  Routines to display ICO and PCX files
;  Copyright (C) 1991-1998  Felix Ritter
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
;
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

.MODEL huge, C
.286


;----------------------------------------------------------------------------
; Definition von Konstanten und Strukturen


; Konstanten des Bildschirms

VIDEO_GRAPHICMODE_SEGMENT      EQU  0A000h

VIDEO_MODE_640x480x16          EQU  012h   ;Nummer des Videomodes
VIDEO_LINE_LEN_640x480x16      EQU  80     ;jede Grafikzeile belegt 100 Byte
VIDEO_NUMBER_LINES_640x480x16  EQU  480    ;480 Grafikzeilen sind vorhanden

VIDEO_MODE_800x600x16          EQU  0102h  ;Nummer des Videomodes
VIDEO_LINE_LEN_800x600x16      EQU  100    ;jede Grafikzeile belegt 100 Byte
VIDEO_NUMBER_LINES_800x600x16  EQU  600    ;600 Grafikzeilen sind vorhanden


; Konstanten des Grafikkontrollers

GRAPH_CONT_ADR      	  EQU  3CEh     ;Portadresse des Grafik-Controller
CONT_BITMASK_REG          EQU  8        ;Bitmask-Register
CONT_MODE_REG        	  EQU  5        ;Mode-Register
CONT_FUNCSEL_REG     	  EQU  3        ;Function-Select-Register
CONT_MAPSEL_REG      	  EQU  4        ;Map-Select-Register
CONT_ENABLE_REG      	  EQU  1        ;Enable Set-/Reset-Register
CONT_SETRES_REG      	  EQU  0        ;Set-/Reset-Register

; Verknpfungsmodis:

CONT_OPE_MODE        	  EQU  0        ;Ersetzen
CONT_OPU_MODE        	  EQU  8        ;UND-Verknpfung
CONT_OPO_MODE        	  EQU  10h      ;ODER-Verknpfung
CONT_OPX_MODE        	  EQU  18h      ;EXKLUSIV-ODER-Verknpfung


; Konstanten des betriebssystemunabhngigen Teils

ICON_DIMENSION            EQU  032      ;Icon ist 32x32 Pixel gro


;----------------------------------------------------------------------------
; Beginn des Codesegments

.CODE

   L_Rand           DB 0                   ;linker Rand
   R_Rand           DB 0                   ;rechter Rand
   LVersatz         DB 0                   ;Versatz der Bitmap (des Icons)
   RVersatz         DB 0                   ;innerhalb einer Textspalte
   StartMask        DB 0                   ;Maske des linken Randes


;----------------------------------------------------------------------------
; VideoReset

; der Grafikkontroller wird auf die ursprnglichen (Default-) Werte gesetzt

;  IN:  -
; OUT:  -
; AX, DX werden verndert

PUBLIC VideoReset

VideoReset PROC FAR

   cli

   mov  dx, GRAPH_CONT_ADR                 ;Portadresse Grafik-Contr. laden

   mov  ax, CONT_BITMASK_REG+ (0FFH SHL 8) ;alte Bitmask
   out  dx, ax                             ;in das Register schreiben

   mov  ax, CONT_MODE_REG+ 0               ;alten Wert des ModeRegisters
   out  dx, ax                             ;in das Register schreiben

   mov  ax, CONT_FUNCSEL_REG+ 0	           ;alten Wert des FunctionsSelect-
   out  dx, ax                             ;Registers ins Register schreiben

   mov  ax, CONT_SETRES_REG+ 0             ;alten Wert des SetReset-
   out  dx, ax                             ;Registers ins Register schreiben

   mov  ax, CONT_ENABLE_REG+ 0             ;alten Wert des EnableSetReset-
   out  dx, ax                             ;Registers ins Register schreiben

   sti

   ret

VideoReset ENDP


;----------------------------------------------------------------------------
; DrawIcon

; Darstellung eines Icons im Video-Modus 12 an jeder beliebigen Position
; des Bildschirms
; die Routine manipuliert die einzelnen Bitplanes byteweise um eine sehr
; hohe Ausgabegeschwindigkeit zu erreichen
; bercksichtigt die XOR-Bitmap des Icons um duchsichtige bzw. Invertierte
; Stellen darzustellen
; liee sich ohne groen Aufwand in eine schnelle Routine zum Anzeigen von
; Bitmaps umwandeln (Windows-BMP)

;  IN:  Zeiger auf XOR-Bitmap
;       X-Koordinate  (mu NICHT! durch 8 teilbar sein)
;       Y-Koordinate
; OUT:  -
; kein Register wird verndert

PUBLIC DrawIcon

PROC DrawIcon, X:WORD, Y:WORD, DataAdr:DWORD

   pusha
   push ds

   lds  si, DataAdr

   mov  ax, Y                              ;Y-Koordinate

   mov  bx, X                              ;X-Koordinate
   push bx

   and  bx, 7                              ;LVersatz= Spalte MOD 8
   mov  cs:LVersatz, bl                    ;nur die untersten 3 Bit
					   ;interessieren

   mov  dx, ICON_DIMENSION		   ;Breite der Bitmap in Pixeln
   add  bx, dx                             ;dazuaddieren

   and  bx, 7                              ;RVersatz= Spalte MOD 8
   mov  cs:RVersatz, bl                    ;nur die untersten 3 Bit
					   ;interessieren
   pop  bx

   add  ax, ICON_DIMENSION		   ;AX= Bildschirmposition der
   dec  ax                                 ;untersten Bitmap-Zeile (+Hhe-1)

   mov  cl, bl                             ;LO-Byte der Grafikspalte merken

   mov  dx, VIDEO_LINE_LEN_640x480x16	   ;Anzahl der Bytes je Zeile nach DX
   mul  dx                                 ;AX= Grafikzeile* VideoLineLen

   shr  bx, 1                              ;Grafikspalte durch 8 teilen
   shr  bx, 1
   shr  bx, 1

   add  bx, ax                             ;Zeilenoffset addieren

   and  cl, 7                              ;Bits 4-7 der
					   ;Grafikspalte ausblenden
   xor  cl, 7                              ;Trick: entspricht 7- CL

   mov  ah, 1                              ;Bit-Maske zum Ausblenden
   shl  ah, cl                             ;aller anderen
   mov  cs:StartMask, ah                   ;Bit-Maske sichern

   mov  dx, VIDEO_GRAPHICMODE_SEGMENT
   mov  es, dx                             ;ES aufs Videosegment setzen

   mov  di, bx                             ;Pointer auf das Byte
					   ;im Video-RAM mit dem Pixel

   cli                                     ;Interrupts sperren

;IconBegin

   mov  dx, GRAPH_CONT_ADR                 ;DX= Portadresse des Grafikkontr.

   mov  ax, CONT_ENABLE_REG+ 0             ;Werte fr Planes aus
   out  dx, ax                             ;CPU-Byte nehmen

   xor  ch, ch                             ;Randmasken ermitteln
   mov  cl, cs:LVersatz                    ;Anzahl der Rechtsverschiebungen

   xor  al, al                             ;AL= 0 falls kein linker Rand

   or   cl, cl                             ;wird eine Randmaske bentigt?
   jz   NoLRand                            ;kein Rand ntig

L_Fill:

   stc                                     ;Carry-Flag setzen
   rcr  al, 1                              ;durch und mit dem Carry-Flag rot.
   loop L_Fill                             ;Maske fr linken Rand erzeugen

NoLRand:

   mov  cs:L_Rand, al                      ;Maske sichern

   not  al                                 ;Maske invertieren
   mov  cs:R_Rand, al                      ;Maske ist fr den rechten Rand

   mov  bp, si                             ;Zeiger auf 'XOR'-Bitmap
   add  bp, 512                            ;Zeiger auf 'AND'-Bitmap
   mov  cx, 32                             ;Zeilenanzahl

IcNewLin:

   mov  ax, CONT_MODE_REG+ 0               ;Read-/Write-Modus= 0
   out  dx, ax

   mov  ax, CONT_BITMASK_REG+ (0FFH SHL 8) ;alle 8 Bits durch das Bit-Mask-
   out  dx, ax                             ;Register ansprechen

   push cx                                 ;Zeilenanzahl retten
   push di                                 ;Video-Pointer retten

   mov  cx, 4                              ;4 Bytes (=32 Bit) ausgeben

   mov  ax, CONT_FUNCSEL_REG+ (CONT_OPU_MODE SHL 8)  ;UND-Verknpfung
   out  dx, ax

   mov  al, cs:L_Rand

AndByte:

   push cx                                 ;Anzahl der noch auszugebenden
					   ;Bytes pro Zeile

   mov  cl, cs:LVersatz                    ;Anzahl der Pixelverschiebungen

   xor  bl, bl
   mov  bh, ds:[bp]                        ;BX mit AND-Bitmap laden

   shr  bx, cl                             ;nach Rechts verschieben
   or   bh, al                             ;Rest aus AL in BH einblenden

   xchg ax, bx                             ;Ergebnis im Akku bereitstellen:
					   ;   AH= Ausgabe-Byte
					   ;   AL= neuer Rest

   mov  cl, ah                             ;XCHG, da erst die Latches geladen
					   ;und dann im aktuellen Verknpf-
					   ;ungsmodus beschrieben werden

   xchg cl, es:[di]                        ;eigentl. Ausgabe: Latches laden

   pop  cx                                 ;CX restaurieren

   inc  di
   inc  bp                                 ;Bitmap-Pointer erhhen
   loop AndByte

   cmp  cs:RVersatz, 0                     ;Ist die Bitmap verschoben ?
   jz   NoHGRest                           ;keine Ausgabe des Restbetrages

   mov  cl, al
   or   cl, cs:R_Rand                      ;rechten Rand ausgeben

   xchg cl, es:[di]                        ;Ausgabe wie oben

NoHGRest:

   pop  di                                 ;Video-Pointer holen
   push di                                 ;Video-Pointer retten

   mov  ax, CONT_MODE_REG+ (2 SHL 8)       ;Read-/Write-Modus=0
   out  dx, ax

   mov  ax, CONT_FUNCSEL_REG+ (CONT_OPX_MODE SHL 8)  ;XOR-Verknpfung
   out  dx, ax

   mov  ah, cs:StartMask                   ;Startmaske laden
   mov  cx, 8                              ;8 Worte bearbeiten
					   ;entsp. 32 Pixel  16 Farben

   push bp                                 ;Beginn der Farbausgabe

NewClrWord:

   push cx                                 ;Anzahl der noch
					   ;zu verarbeitenden Worte

   mov  bx, WORD PTR ds:[si]               ;Datenword holen
   xchg bl, bh                             ;Bytes tauschen
   inc  si                                 ;SI+= 2
   inc  si

   mov  cx, 0404h                          ;CL= 4 -> Shift fr ein
					   ;         Farbhalbbyte (4-Bit)
					   ;CH= 4 -> Bytezhler
ClrStep:

   mov  al, CONT_BITMASK_REG               ;Startmaske ist in AH
   out  dx, ax                             ;Bit-Mask-Register ansprechen

   rol  bx, cl                             ;Farbwert (4-Bit) klarmachen
   mov  al, bl
   and  al, 0Fh                            ;untersten 4-Bit interessieren
   xchg al, es:[di]                        ;Ausgabe auf Bildschirm (wie oben)
   ror  ah, 1                              ;Startmaske nach rechts versch.
   cmp  ah, 10000000B                      ;Bytegrenze erreicht?
   jnz  OldDI                              ;nein -> weiter mit gleichem Byte
   inc  di                                 ;ja -> Videopointer erhhen

OldDI:

   dec  ch                                 ;Bytezhler verringern

   or   ch, ch
   jnz  ClrStep                            ;wenn nicht Null dann weiter

   pop  cx                                 ;alten Wortzhler wiederherstellen
   loop NewClrWord                         ;auf ein Neues

   pop  bp                                 ;Ende der Farbausgabe

   pop  di                                 ;Video-Pointer holen
   pop  cx                                 ;Zeilenzhler wiederherstellen

   sub  di, VIDEO_LINE_LEN_640x480x16	   ;eine Zeile hher weitermachen

   ;loop IcNewLin

   dec  cx
   jz   Exit
   jmp  IcNewLin                           ;auf zur neuen Zeile

Exit:

   call VideoReset                         ;Register des Videokontrollers
					   ;zurcksetzen

   sti                                     ;Interrupt-Sperre aufheben
   pop  ds
   popa

   ret

DrawIcon ENDP


PUBLIC ShowPCX

PROC ShowPCX, W_Bitplane:BYTE, R_Bitplane:BYTE, Z_end_ptr:DWORD, END_ptr:DWORD, SCR_ptr:DWORD, file_ptr:DWORD, W_Maske:WORD

			   pusha
			   push ds
			   CLI
			   mov al, W_Bitplane
			   mov ah, R_Bitplane
			   les cx, Z_end_ptr
			   les dx, END_ptr
			   les bx, SCR_ptr
			   lds si, file_ptr
			   mov bp, W_Maske
			   cld
		     M0:   push dx
			   cmp al, 08h
			   jnz M1
			   mov ax, 050h
			   add bx, ax
			   add cx, ax
			   mov ax, 080h
		     M1:   rol al, 1
			   mov dx, 03C5h
			   out dx, al
			   mov dl, 0CEh
			   push ax
			   mov al, 04h
			   out dx, ax
			   pop ax
			   inc ah
			   mov di, bx
		     M2:   mov dl, ds:[si]
			   cmp dl, 0C0h
			   jb M5
			   and dl, 03Fh
			   inc si
			   push ax
			   xor dh, dh
			   mov ax, dx
			   add dx, di
			   cmp dx, cx
			   mov dx, ax
			   lahf
			   jna M3
			   dec dl
		     M3:   push cx
			   mov al, ds:[si]
			   mov cx, dx
			   rep stosb
			   pop cx
			   sahf
			   jna M4
			   mov ah, es:[di]
			   and ax, bp
			   or al, ah
			   mov es:[di], al
			   inc si
			   pop ax
			   jmp M7
		     M4:   pop ax
			   inc si
			   jmp M2
		     M5:   cmp di, cx
			   jnb M6
			   movsb
			   jmp M2
		     M6:   mov dx, ax
			   mov ah, es:[di]
			   mov al, ds:[si]
			   and ax, bp
			   or al, ah
			   mov es:[di], al
			   inc si
			   mov ax, dx
		     M7:   pop dx
			   cmp si, dx
			   jb M0
			   CALL VideoReset
			   STI
			   pop ds
			   popa
			   RET
ShowPCX ENDP


END