/*  EDITVIEW.C  Editor and Viewer
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <graphics.h>
#include <io.h>
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <alloc.h>
#include <time.h>
#include <fcntl.h>
#include <bios.h>
#include <ctype.h>
#include <setjmp.h>
#include <sys\stat.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

extern char *Tausender_Gruppen( char *ret_Zahl, unsigned long Zahl);
extern void SCR_move( WORD Xq, WORD Yq, WORD Spalten, WORD Lines, WORD Xz, WORD Yz);
extern char *MakeShowPath( char *, char *, int);
extern BOOL MouseMove( void);
extern void Dummy_Balken( void);
extern char *Path_to_Dir( char *dir, char *path);
extern char *Get_Filter( char *filter_sp, char *path);
extern char *Paste_Filter_to_Dir( char *dir, char *filter);
extern void *last_maus_cursor;

extern char     *textClipboard;                /* global clipboard for text */
extern unsigned  textClipboardLen;          /* number of chars in clipboard */
extern BOOL      validTextAtClipBoard;        /* is text at clipboard valid */

#define ED_MAXZEILEN                    3000
#define ED_MAXBLOECKE                   200
#define ED_MAXFILELENGTH                32768                   /* 32 KByte */
#define ED_MAXEDIT                      ED_MAXFILELENGTH
#define MAX_SICHT_ZEILEN                35
#define MAX_SICHT_SPALTEN               74
#define X_BEGINN                        16
#define Y_BEGINN                        56
#define X_ENDE                          608
#define Y_ENDE                          406
#define ZEILENABSTAND                   10
#define MAX_PUFFER                      19988
#define ED_MAXVIEW                      49152
#define TAB_SIZE                        8
#define RBALKEN_MINUS_MIN_MAUS          9
#define RBALKEN_PLUS_MIN_MAUS           10
#define ED_UP                           0
#define ED_DOWN                         1
#define ED_LEFT                         2
#define ED_RIGHT                        3
#define ED_PG_UP                        4
#define ED_PG_DN                        5
#define ED_POS1                         6
#define ED_ENDE                         7
#define ED_DOC_ANF                      8
#define ED_DOC_END                      9
#define ED_SHOW                         0
#define ED_MEMORY                       1
#define ED_NEW                          0
#define ED_OLD                          1
#define MARK_COLOR                      EGA_LIGHTGRAY
#define VOM_ANFANG                      0
#define VON_AKTPOS                      1
#define ED_ESC                          0
#define ED_HEX                          1
#define ED_ASCII                        2
#define MAX_SUCHTEXT                    50

typedef struct
	{
	   long Zeilen_offset,
		seek_pos,
		X_off,          /* Abstand zum vorhergehenden Zeilenumbruch */
		X_rest;               /* Abstand zum nchsten Zeilenumbruch */
	}BlockInfo_struct;

typedef struct ftime ftime;

typedef struct
	{
	   int      handle;
	   FILE    *stream;
	   ftime    ft;
	   long     X_cur,
		    Y_cur,
		    X_mark,
		    Y_mark,
		    file_len,
		    puffer_len,
		    last_X,
		    anz_Z_puffer;
	   unsigned akt_block;
	   char   **Zeilen,
		   *file,
		    old_mark,
		    search[ MAX_SUCHTEXT];
	   BlockInfo_struct *BI;
	   BOOL     text_mark,
		    text_geaendert,
		    Text_folgt,
		    Text_davor,
		    ignore_case,
		    TMP_file,
		    xEdit;
	   BYTE     edit_view,
		    hex_ascii;
	   RBalken *v_RB,                          /* v_RB->max= ANZ_ZEILEN */
		   *h_RB;                     /* h_RB->max= MAX_ZEILENLNGE */
	   MAUSStruct *MS;
	   DATWINStruct *DW;
	}Edit_struct;

typedef struct
	{
	   long X_cur,
		Y_cur,
		h_proz,
		v_proz;
	}Cursor_struct;

typedef struct
	{
	   long X1_mark,
		Y1_mark,
		X2_mark,
		Y2_mark;
	}Mark_struct;

BOOL Mark_to_Markstruct( Mark_struct *MA, Edit_struct *ED, char show_copy);
BOOL Is_Pos_Mark( unsigned X, unsigned Y, Edit_struct *ED, Mark_struct *MA);
BOOL Zeile_Mark_from_to( unsigned zeile, unsigned anf_pos, Edit_struct *ED, Mark_struct *MA, unsigned *from, unsigned *to);
void MarkZeile( Edit_struct *ED, Mark_struct *MA, unsigned zeile, unsigned anf_pos);
void ClearMark( Edit_struct *ED);
void TeilMark( Edit_struct *ED, Mark_struct *old_MA, Mark_struct *new_MA);
void _Speichern_unter( Edit_struct *ED);


static jmp_buf ERROR_jmp;

BOOL Hex_File( Edit_struct *ED)
{
   void *old_maus_cursor= last_maus_cursor;
   BOOL _new_file= 0;
   int ret, block= 1;
   unsigned char read_buf[ 16], text_buf[ 17], write_buf[ 80], *tmp_ptr;
   unsigned long offset= 0L, c_wert= 4208;

   PrintStatus( "Creating formatted temporary file,       0 lines ... ");
   MouseArt( maus_sanduhr);
   ED->v_RB->max= 1;
   if(( ED->stream= tmpfile())!= NULL)
   {
      while(( ret= _read( ED->handle, read_buf, 16))> 0)
      {
	 if( Break( 200, 200, "Really end the\ncurrent process?"))
	    break;
	 *(( tmp_ptr= memcpy( text_buf, read_buf, 16))+ 16)= '\0';
	 while( tmp_ptr< ( text_buf+ 16))
	 {
	    if(( *tmp_ptr== '\0')|| !isascii( *tmp_ptr)|| !isprint( *tmp_ptr))
	       *tmp_ptr= SPACE;
	    tmp_ptr++;
	 }
	 sprintf( write_buf, "%.7lX: %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X  %16s\r\n", offset, read_buf[ 0], read_buf[ 1], read_buf[ 2], read_buf[ 3], read_buf[ 4], read_buf[ 5], read_buf[ 6], read_buf[ 7], read_buf[ 8], read_buf[ 9], read_buf[ 10], read_buf[ 11], read_buf[ 12], read_buf[ 13], read_buf[ 14], read_buf[ 15], text_buf);
	 if( ret< 16)
	 {
	    memset( write_buf+ 9+ ( ret* 3), SPACE, 48- ( ret* 3));
	    memset( write_buf+ 58+ ret, SPACE, 16- ret);
	 }
	 if( fwrite( write_buf, 76, 1, ED->stream)!= 1)
	 {
	    ErrorMsg( WRITE_ERROR"TMP");
	    ret= -1;
	    break;
	 }
	 offset+= 16L;
	 if( offset== c_wert)
	 {
	    sprintf( write_buf, "%7ld", ED->BI[ block].Zeilen_offset= offset>> 4);
	    PrintStatus_at( 35, write_buf);
	    ED->BI[ block].seek_pos= ( long)MAX_PUFFER* block;
	    ED->BI[ block].X_off= 0;
	    ED->BI[ block++].X_rest= 74;
	    c_wert+= 4208;
	 }
      }
      if( ret== -1)
      {
	 lseek( ED->handle, 0L, SEEK_SET);
	 fclose( ED->stream);
	 ErrorMsg( READ_ERROR);
      }
      else
      {
	 if( offset> 16)
	    ED->BI[ 0].X_rest= 74;
	 ED->BI[ block- 1].X_rest= 0;
	 ED->v_RB->max= ED->BI[ block].Zeilen_offset= offset>> 4;
	 _close( ED->handle);
	 rewind( ED->stream);
	 ED->handle= fileno( ED->stream);
	 ED->BI[ block].seek_pos= ED->file_len= filelength( ED->handle);
	 _new_file= 1;
      }
   }
   ClearStatus();
   MouseArt( old_maus_cursor);
   return( _new_file);
}

long _z_len_rel( Edit_struct *ED, unsigned Zeile)
{
   char *tmp_ptr;

   if( Zeile< ( ED->anz_Z_puffer- 1))
   {
      if( *(( tmp_ptr= ED->Zeilen[ Zeile+ 1])- 2)!= '\r')
	 tmp_ptr++;
      return(( ( ptrdiff_t)tmp_ptr- ( ptrdiff_t)ED->Zeilen[ Zeile])- 2);
   }
   else
      return( ED->puffer_len- ( ( ptrdiff_t)ED->Zeilen[ Zeile]- ( ptrdiff_t)ED->Zeilen[ 0]));
}

long Z_len_Puffer( Edit_struct *ED, long Zeile)
{
   if( ED->edit_view== VIEW)
      Zeile-= ED->BI[ ED->akt_block].Zeilen_offset;
   return( _z_len_rel( ED, Zeile));
}

void check_Line_akt_Block( Edit_struct *ED, long z)
{
   if(( z< ED->BI[ ED->akt_block].Zeilen_offset)|| ( z>= ( ED->BI[ ED->akt_block].Zeilen_offset+ ED->anz_Z_puffer)))
   {
      ED->akt_block= 0;
      while( z> ED->BI[ ED->akt_block++].Zeilen_offset)
	 ;
      if( z< ED->BI[ --ED->akt_block].Zeilen_offset)
	 ED->akt_block--;
      _Read_Array( ED);
   }
}

long Zeile_len( Edit_struct *ED, long Zeile)
{
   long Z_len= 0;

   if( ED->edit_view== VIEW)
   {
      check_Line_akt_Block( ED, Zeile);
      if( Zeile== ED->BI[ ED->akt_block].Zeilen_offset)  /* erste Zeile des Puffers ? */
	 Z_len+= ED->BI[ ED->akt_block].X_off;
      if( Zeile== ( ED->BI[ ED->akt_block].Zeilen_offset+ ED->anz_Z_puffer- 1)) /* letzte Zeile des Puffers ? */
	 Z_len+= ED->BI[ ED->akt_block].X_rest;
      Zeile-= ED->BI[ ED->akt_block].Zeilen_offset;
   }
   return( Z_len+= _z_len_rel( ED, Zeile));
}

int _Build_Array( Edit_struct *ED)
{
   int ret_val= 0;
   unsigned max_z_len, relTabSize;
   long new_puffer_len, i, l;
   char *tmp_ptr, *old_ptr;

   PrintStatus( "Preparing the file ...   ");
   for( i= 0; ( i< ED->anz_Z_puffer)&& !ret_val; i++)
   {
      tmp_ptr= ED->Zeilen[ i];
      while(( tmp_ptr= memchr( tmp_ptr, '\t', _z_len_rel( ED, i)- ( ( ptrdiff_t)tmp_ptr- ( ptrdiff_t)ED->Zeilen[ i])))!= NULL)
      {
	 relTabSize= TAB_SIZE- ( ( ( ptrdiff_t)tmp_ptr- ( ptrdiff_t)ED->Zeilen[ i])% TAB_SIZE);
	 if(( ED->puffer_len+ relTabSize- 1)<= ( ( ED->edit_view== EDIT) ? ( ED_MAXEDIT) : ( ED_MAXVIEW)))
	 {
	    old_ptr= ED->Zeilen[ 0];
	    if(( ED->Zeilen[ 0]= farrealloc( ED->Zeilen[ 0], new_puffer_len= ED->puffer_len+ relTabSize- 1))!= NULL)
	    {
	       ( ptrdiff_t)tmp_ptr+= ( ptrdiff_t)ED->Zeilen[ 0]- ( ptrdiff_t)old_ptr;
	       memmove( tmp_ptr+ relTabSize, tmp_ptr+ 1, ED->puffer_len- ( ( ptrdiff_t)tmp_ptr+ 1- ( ptrdiff_t)ED->Zeilen[ 0]));
	       ED->puffer_len= new_puffer_len;
	       memset( tmp_ptr, SPACE, relTabSize);
	       ( ptrdiff_t)tmp_ptr+= relTabSize;
	       for( l= 1; l< ED->anz_Z_puffer; l++)
	       {
		  if( old_ptr!= ED->Zeilen[ 0])
		     ( ptrdiff_t)ED->Zeilen[ l]+= ( ptrdiff_t)ED->Zeilen[ 0]- ( ptrdiff_t)old_ptr;
		  if( l> i)
		     ( ptrdiff_t)ED->Zeilen[ l]+= relTabSize- 1;
	       }
	    }
	    else
	    {
	       ErrorMsg( KEIN_SPEICHER" #1");
	       ret_val= -1;
	       break;
	    }
	 }
	 else
	 {
	    ErrorMsg( "Maximum buffer size reached");
	    ret_val= -1;
	    break;
	 }
      }
      if(( max_z_len= _z_len_rel( ED, i))>= ED->h_RB->max)
	 ED->h_RB->max= max_z_len+ 1;
   }
   ED->h_RB->max++;
   ED->last_X= _z_len_rel( ED, ED->anz_Z_puffer- 1);
   ClearStatus();
   return( ret_val);
}

void Free_ED_VI_Array( Edit_struct *ED)
{
   if( ED->Zeilen[ 0]!= NULL)
      farfree( ED->Zeilen[ 0]);
   if( ED->Zeilen!= NULL)
      farfree( ED->Zeilen);
   if(( ED->edit_view== VIEW)&& ( ED->BI!= NULL))
      farfree( ED->BI);
   if( ED->stream!= NULL)
      fclose( ED->stream);
   else
      _close( ED->handle);
   if( ED->TMP_file)
      unlink( ED->file);
}

extern char *_searchNL( char *s, size_t n, int *anzNL);

void _FileLength( Edit_struct *ED)
{
   char tmp_array[ 15], Tausender[ 15];

   sprintf( tmp_array, "%9s", Tausender_Gruppen( Tausender, ED->file_len));
   MOverTextxy( 401, 442, tmp_array, 9);
}

int _Read_Array( Edit_struct *ED)
{
   int ret_val= 0, anzNL;

   if(( ED->Zeilen= ( char **)farrealloc( ED->Zeilen, ED_MAXZEILEN* sizeof( char *)))!= NULL)
   {
      if( ED->edit_view== EDIT)
	 ED->puffer_len= ED->file_len;
      else
	 ED->puffer_len= ED->BI[ ED->akt_block+ 1].seek_pos- ED->BI[ ED->akt_block].seek_pos;
      if( ED->file_len> 0)
      {
	 if(( ED->Zeilen[ 0]= ( char *)farrealloc( ED->Zeilen[ 0], ED->puffer_len))!= NULL)
	 {
	    if( ED->edit_view== VIEW)
	       lseek( ED->handle, ED->BI[ ED->akt_block].seek_pos, SEEK_SET);
	    if( _read( ED->handle, ED->Zeilen[ 0], ED->puffer_len)!= -1)
	    {
	       for( ED->anz_Z_puffer= 1; ED->anz_Z_puffer< ED_MAXZEILEN; ED->anz_Z_puffer++)
	       {
		  if(( ED->Zeilen[ ED->anz_Z_puffer]= _searchNL( ED->Zeilen[ ( ED->anz_Z_puffer)- 1], ED->puffer_len- ( ( ptrdiff_t)ED->Zeilen[ ( ED->anz_Z_puffer)- 1]- ( ptrdiff_t)ED->Zeilen[ 0]), &anzNL))!= NULL)
		  {
		     ED->Zeilen[ ED->anz_Z_puffer]+= anzNL;
		     if( ( ptrdiff_t)ED->Zeilen[ ED->anz_Z_puffer]> ( ( ptrdiff_t)ED->Zeilen[ 0]+ ED->puffer_len))
			break;
		  }
		  else
		     break;
	       }
	       if(( ED->anz_Z_puffer== 1)&& ( ED->edit_view== EDIT)) /* nur eine Zeile vorhanden ? */
		  ED->h_RB->max= ED->puffer_len;
	    }
	    else
	    {
	       ErrorMsg( READ_ERROR);
	       ret_val= -1;
	    }
	 }
	 else
	 {
	    ErrorMsg( KEIN_SPEICHER" #3");
	    ret_val= -1;
	 }
      }
      else
      {
	 ED->anz_Z_puffer= 1;
	 ED->h_RB->max= 0;
	 ED->Zeilen[ 0]= ( char *)farrealloc( ED->Zeilen[ 0], 1);
      }
      if( !ret_val)
      {
	 if( ED->edit_view== VIEW)
	 {
	    (( ED->BI[ ED->akt_block].seek_pos+ ED->puffer_len)< ED->file_len) ? ( ED->Text_folgt= 1) : ( ED->Text_folgt= 0);
	    ( ED->BI[ ED->akt_block].seek_pos> 0) ? ( ED->Text_davor= 1) : ( ED->Text_davor= 0);
	 }
	 ED->Zeilen= ( char **)farrealloc( ED->Zeilen, ED->anz_Z_puffer* sizeof( char *));
	 ret_val|= _Build_Array( ED);
	 if( ED->edit_view== EDIT)
	    ED->v_RB->max= ED->anz_Z_puffer;
      }
   }
   else
   {
      ErrorMsg( KEIN_SPEICHER" #4");
      ret_val= -1;
   }
   if( ret_val!= 0)
   {
      MouseStat();
      InitMouse();        /* wahrscheinlich ist der Mauscursor ausgeblendet */
      SetMouse( MStat.x, MStat.y);
      ShowMouse( AN);
      longjmp( ERROR_jmp, -1);
   }
   return( ret_val);
}

int Get_ZeilenInfo( Edit_struct *ED)
{
   BOOL _NL;
   char *mem_ptr, *s_ptr, *l_NL_ptr, *f_NL_ptr, _byte;
   int ret_val= 0, ret, block= 0, ende_block= 0, i, anzNL;
   long reads= 0, offset= 0, X_off= 0;

   if(( mem_ptr= farmalloc( MAX_PUFFER+ 1))!= NULL)   /* +1 falls letztes Zeichen \r */
   {
      PrintStatus( "Read in file...   ");
      ED->v_RB->max= 1;
      do
      {
	 if( reads> 0)
	 {
	    if(( *( ( char huge *)mem_ptr+ reads- 1)== '\r')&& (( offset+ reads)< ED->file_len))
	    {
	       if( ( long)( ret= _read( ED->handle, &_byte, 1))!= -1)
	       {
		  if( _byte== '\n')
		  {
		     *( ( char huge *)mem_ptr+ reads)= _byte;
		     reads++;
		  }
	       }
	       else
		  break;
	    }
	    _NL= 0;
	    l_NL_ptr= s_ptr= mem_ptr;
	    while(( s_ptr= _searchNL( s_ptr, reads- ( ( ptrdiff_t)s_ptr- ( ptrdiff_t)mem_ptr), &anzNL))!= NULL)
	    {
	       if( !_NL)
	       {
		  f_NL_ptr= s_ptr;
		  _NL= 1;
	       }
	       l_NL_ptr= s_ptr+= anzNL;
	       if( ( ptrdiff_t)s_ptr> ( ( ptrdiff_t)mem_ptr+ reads))
		  break;
	       ED->v_RB->max++;
	    }
	    if( _NL)
	       X_off= 0;
	    X_off+= reads- ( ( ptrdiff_t)l_NL_ptr- ( ptrdiff_t)mem_ptr);
	    for( i= ende_block; i< block; i++)
	    {
	       if(( i+ 1)!= block)
	       {
		  if( _NL)
		  {
		     ED->BI[ i].X_rest+= ( ptrdiff_t)f_NL_ptr- ( ptrdiff_t)mem_ptr;
		     ende_block++;
		  }
		  else
		     ED->BI[ i].X_rest+= reads;
	       }
	    }
	 }
	 ED->BI[ block].X_off= X_off;
	 ED->BI[ block].seek_pos= offset+= reads;
	 ED->BI[ block++].Zeilen_offset= ED->v_RB->max- 1;
	 (( ED->file_len- offset)> MAX_PUFFER) ? ( reads= MAX_PUFFER) : ( reads= ED->file_len- offset);
      }while(( reads> 0)&& ( ( long)( ret= _read( ED->handle, mem_ptr, reads))> 0));
      ClearStatus();
      if( ret!= -1)
	 lseek( ED->handle, 0L, SEEK_SET);
      else
      {
	 ErrorMsg( READ_ERROR);
	 ret_val= -1;
      }
      farfree( mem_ptr);
   }
   else
   {
      ErrorMsg( KEIN_SPEICHER" #5");
      ret_val= -1;
   }
   return( ret_val);
}

int _Beginn( Edit_struct *ED)
{
   int ret_val= 0;

   if(( ED->edit_view== EDIT)&& ( *ED->file== '\0'))  /* Neue Datei erzeugen ? */
   {
      strcpy( strcpy( ED->file, prgexe_path)+ ( ptrdiff_t)prgexe_ptr- ( ptrdiff_t)prgexe_path, "NONAMEXXXXXX");
      ED->handle= _creat( mktemp( ED->file), 0);
      ED->TMP_file= 1;
   }
   else
      ED->handle= _open( ED->file, ( ED->edit_view== EDIT) ? ( O_RDWR) : ( O_RDONLY));
   if( ED->handle!= -1)
   {
      ED->file_len= filelength( ED->handle);
      getftime( ED->handle, &ED->ft);
      _FileLength( ED);
      if( ED->edit_view== VIEW)
      {
	 if(( ED->BI= farcalloc( ED_MAXBLOECKE, sizeof( BlockInfo_struct)))!= NULL)
	 {
	    if(( ED->hex_ascii== ED_ASCII)|| !Hex_File( ED))
	       ret_val= Get_ZeilenInfo( ED);
	 }
	 else
	 {
	    ErrorMsg( KEIN_SPEICHER" #6");
	    ret_val= -1;
	 }
      }
      if( ret_val== 0)
      {
	 if(( ED->file_len> ED_MAXFILELENGTH)&& ( ED->edit_view== EDIT))
	 {
	    Info_Frage( 200, 150, "The file is too\nlarge to edit.", INFO);
	    ret_val= 1;
	 }
	 else
	 {
	    ED->Zeilen= ( char **)farmalloc( sizeof( char *));
	    ED->Zeilen[ 0]= ( char *)farmalloc( 1);
	 }
      }
      if( ret_val!= 0)
      {
	 if( ED->stream!= NULL)
	    fclose( ED->stream);
	 else
	    _close( ED->handle);
	 if( ED->TMP_file)
	    unlink( ED->file);
      }
   }
   else
   {
      ErrorMsg( OPEN_ERROR);
      ret_val= -1;
   }
   return( ret_val);
}

BOOL Draw_Cursor( Edit_struct *ED, int X, int Y, long h_proz, long v_proz, char an_aus)
{
   Mark_struct MA;
   struct fillsettingstype fi;
   char buffer[ 2]= "X", color;

   if(( X>= h_proz)&& ( X< ( h_proz+ ED->h_RB->maxstep))&& ( Y>= v_proz)&& ( Y< ( v_proz+ ED->v_RB->maxstep)))
   {
      if( ED->edit_view== EDIT)
      {
	 color= getcolor();
	 getfillsettings( &fi);
	 ShowMouse( AUS);
	 if( an_aus== AN)
	 {
	    if( X<= Zeile_len( ED, Y))
	    {
	       setcolor( 0x0F);
	       setwritemode( XOR_PUT);
	       line( X_BEGINN+ ( ( X- h_proz)<< 3), Y_BEGINN+ ( ( Y- v_proz)* ZEILENABSTAND)- 1, X_BEGINN+ ( ( X- h_proz)<< 3), Y_BEGINN+ ( ( Y- v_proz)* ZEILENABSTAND)+ 7);
	       line( X_BEGINN+ ( ( X- h_proz)<< 3)+ 1, Y_BEGINN+ ( ( Y- v_proz)* ZEILENABSTAND)- 1, X_BEGINN+ ( ( X- h_proz)<< 3)+ 1, Y_BEGINN+ ( ( Y- v_proz)* ZEILENABSTAND)+ 7);
	       setwritemode( COPY_PUT);
	    }
	 }
	 else
	 {
	    Mark_to_Markstruct( &MA, ED, ED_SHOW);
	    setcolor( EGA_BLACK);
	    setfillstyle( SOLID_FILL, ( Is_Pos_Mark( X, Y, ED, &MA)) ? ( MARK_COLOR) : ( EGA_WHITE));
	    bar( X_BEGINN+ ( ( X- h_proz)<< 3), Y_BEGINN+ ( ( Y- v_proz)* ZEILENABSTAND)- 1, X_BEGINN+ ( ( X- h_proz)<< 3)+ 7, Y_BEGINN+ ( ( Y- v_proz)* ZEILENABSTAND)+ 8);
	    if( X< Zeile_len( ED, Y))
	    {
	       *buffer= *( ED->Zeilen[ Y]+ X);
	       outtextxy( X_BEGINN+ ( ( X- h_proz)<< 3), Y_BEGINN+ ( ( Y- v_proz)* ZEILENABSTAND), buffer);
	    }
	 }
	 ShowMouse( AN);
	 setfillstyle( fi.pattern, fi.color);
	 setcolor( color);
      }
      return( 1);
   }
   else
      return( 0);
}

char *no_Null( char *text, unsigned len)
{
   char *tmp_ptr= text;

   while(( tmp_ptr= ( char *)memchr( tmp_ptr, '\0', len- ( tmp_ptr- text)))!= NULL)
      *( tmp_ptr++)= SPACE;
   return( text);
}

char *line_cpy( char *buffer, Edit_struct *ED, long z, long off, unsigned s_len) /* 'buffer' mu MAX_SICHT_SPALTEN+ 1 gro sein */
{
   BYTE _do_it= 1;
   char *tmp_ptr;
   long len= 0, n_len= 0, _last_X;

   if( ED->edit_view== VIEW)
      z-= ED->BI[ ED->akt_block].Zeilen_offset;
   if( ED->Text_davor&& ( z== 0))
   {
      if( ED->BI[ ED->akt_block].X_off< ( off+ ED->h_RB->maxstep))
      {
	 len= _z_len_rel( ED, z);
	 if( ED->BI[ ED->akt_block].X_off<= off)
	 {
	    if( len> ( off- ED->BI[ ED->akt_block].X_off))
	    {
	       if(( len-= ( off- ED->BI[ ED->akt_block].X_off))> ED->h_RB->maxstep)
		  len= ED->h_RB->maxstep;
	       *( no_Null( memcpy( buffer, ED->Zeilen[ z]+ ( off- ED->BI[ ED->akt_block].X_off), len), len)+ len)= '\0';
	    }
	    _do_it= 0;
	 }
	 else
	 {
	    n_len= ED->BI[ ED->akt_block].X_off- off;
	    if( len> ( ED->h_RB->maxstep- n_len))
	       len= ED->h_RB->maxstep- n_len;
	    *( no_Null( memcpy( buffer+ n_len, ED->Zeilen[ z], len), len)+ len)= '\0';
	    _do_it= 2;
	 }
      }
      if( _do_it)
      {
	 ED->akt_block--;
	 _Read_Array( ED);
	 len= _z_len_rel( ED, ED->anz_Z_puffer- 1);
	 if( _do_it== 2)
	 {
	    if(( len-= off)> ( ED->h_RB->maxstep- n_len))
	       len= ED->h_RB->maxstep- n_len;
	    no_Null( memcpy( buffer, ED->Zeilen[ ED->anz_Z_puffer- 1]+ off, len), len);
	 }
	 else                                                 /* _do_it== 1 */
	 {
	    if(( len= _z_len_rel( ED, z)- off)> ED->h_RB->maxstep)
	       len= ED->h_RB->maxstep;
	    if( len> 0)
	       *( no_Null( memcpy( buffer, ED->Zeilen[ ED->anz_Z_puffer- 1]+ off, len), len)+ len)= '\0';
	 }
      }
   }
   else
   {
      if(( len= _z_len_rel( ED, z)- off)> ED->h_RB->maxstep)
	 len= ED->h_RB->maxstep;
      if( len> 0)
	 *( no_Null( memcpy( buffer, ED->Zeilen[ z]+ off, len), len)+ len)= '\0';
      else
	 *buffer= '\0';
      if( ED->Text_folgt&& ( z== ( ED->anz_Z_puffer- 1)))
      {
	 if( ED->last_X< ( off+ ED->h_RB->maxstep))
	 {
	    _last_X= ED->last_X;
	    ED->akt_block++;
	    _Read_Array( ED);
	    n_len= _z_len_rel( ED, 0);
	    if( _last_X>= off)
	    {
	       if( n_len> ( ED->h_RB->maxstep- len))
		  n_len= ED->h_RB->maxstep- len;
	       *( no_Null( memcpy( buffer+ len, ED->Zeilen[ 0], n_len), n_len)+ n_len)= '\0';
	    }
	    else
	    {
	       if(( n_len-= off- _last_X)> 0)
	       {
		  if( n_len> ED->h_RB->maxstep)
		     n_len= ED->h_RB->maxstep;
		  *( no_Null( memcpy( buffer, ED->Zeilen[ 0]+ ( off- _last_X), n_len), n_len)+ n_len)= '\0';
	       }
	    }
	 }
      }
   }
   *( buffer+ s_len)= '\0';
   return( buffer);
}

void Zeilen_cpy( int X, int Y, Edit_struct *ED, long z, long off)
{
   char buffer[ MAX_SICHT_SPALTEN+ 1];

   outtextxy( X, Y, line_cpy( buffer, ED, z, off, MAX_SICHT_SPALTEN));
}

void Prozent_View( Edit_struct *ED)
{
   struct textsettingstype ti;
   char buffer[ 5];

   if( ED->edit_view== VIEW)
   {
      gettextsettings( &ti);
      settextjustify( CENTER_TEXT, ti.vert);
      setcolor( EGA_BLACK);
      ShowMouse( AUS);
      sprintf( buffer, "%ld%%", (( ED->v_RB->proz+ ED->v_RB->maxstep)> ED->v_RB->max) ? ( 100): (( ED->v_RB->proz+ ED->v_RB->maxstep)* 100/ ED->v_RB->max));
      ClearTextN( 562, 442, 4);
      outtextxy( 578, 442, buffer);
      ShowMouse( AN);
      settextjustify( ti.horiz, ti.vert);
   }
}

void View_Page( Edit_struct *ED)
{
   Mark_struct MA;
   long z;
   int y;
   char buffer[ MAX_SICHT_SPALTEN+ 1];

   Mark_to_Markstruct( &MA, ED, ED_SHOW);
   setfillstyle( SOLID_FILL, EGA_WHITE);
   setcolor( EGA_BLACK);
   ShowMouse( AUS);
   bar( 10, 50, 613, 411);
   setfillstyle( SOLID_FILL, MARK_COLOR);
   for( z= ED->v_RB->proz, y= Y_BEGINN; ( z< ( ED->v_RB->proz+ ED->v_RB->maxstep))&& ( z< ED->v_RB->max); z++, y+= ZEILENABSTAND)
   {
      if( ED->h_RB->proz< Zeile_len( ED, z))
      {
	 MarkZeile( ED, &MA, z, ED->h_RB->proz);
	 Zeilen_cpy( X_BEGINN, y, ED, z, ED->h_RB->proz);
      }
   }
   ShowMouse( AN);
   Draw_Cursor( ED, ED->X_cur, ED->Y_cur, ED->h_RB->proz, ED->v_RB->proz, AN);
   Prozent_View( ED);
}

void Page_Up_Down_Left_Right( Edit_struct *ED, char up_down)
{
   Mark_struct MA;
   int i, y;
   long X_merk;
   char buffer[ 2]= "X";

   setfillstyle( SOLID_FILL, EGA_WHITE);
   setcolor( EGA_BLACK);
   Mark_to_Markstruct( &MA, ED, ED_SHOW);
   ShowMouse( AUS);
   switch( up_down)
   {
      case ED_UP:
	 SCR_move( X_BEGINN, Y_BEGINN+ ZEILENABSTAND- 1, X_ENDE- X_BEGINN- 7, Y_ENDE- ( Y_BEGINN+ ZEILENABSTAND)+ 3, X_BEGINN, Y_BEGINN- 1);
	 bar( X_BEGINN, Y_ENDE- ZEILENABSTAND, X_ENDE, Y_ENDE+ 1);
	 setfillstyle( SOLID_FILL, MARK_COLOR);
	 if( ED->h_RB->proz< Zeile_len( ED, ED->v_RB->proz+ ED->v_RB->maxstep- 1))
	 {
	    MarkZeile( ED, &MA, ED->v_RB->proz+ ED->v_RB->maxstep- 1, ED->h_RB->proz);
	    Zeilen_cpy( X_BEGINN, Y_ENDE- ZEILENABSTAND, ED, ED->v_RB->proz+ ED->v_RB->maxstep- 1, ED->h_RB->proz);
	 }
	 break;
      case ED_DOWN:
	 SCR_move( X_BEGINN, Y_BEGINN- 1, X_ENDE- X_BEGINN+ 1, Y_ENDE- ( Y_BEGINN+ ZEILENABSTAND), X_BEGINN, Y_BEGINN+ ZEILENABSTAND- 1);
	 bar( X_BEGINN, Y_BEGINN- 1, X_ENDE, Y_BEGINN+ 8);
	 setfillstyle( SOLID_FILL, MARK_COLOR);
	 if( ED->h_RB->proz< Zeile_len( ED, ED->v_RB->proz))
	 {
	    MarkZeile( ED, &MA, ED->v_RB->proz, ED->h_RB->proz);
	    Zeilen_cpy( X_BEGINN, Y_BEGINN, ED, ED->v_RB->proz, ED->h_RB->proz);
	 }
	 break;
      case ED_LEFT:
	 SCR_move( X_BEGINN+ 8, Y_BEGINN- 1, X_ENDE- X_BEGINN- 16, Y_ENDE- Y_BEGINN+ 2, X_BEGINN, Y_BEGINN- 1);
	 bar( X_ENDE- 8, Y_BEGINN- 1, X_ENDE, Y_ENDE);
	 setfillstyle( SOLID_FILL, MARK_COLOR);
	 for( i= 0, y= Y_BEGINN; ( i< ED->v_RB->maxstep)&& (( ED->v_RB->proz+ i)< ED->v_RB->max); i++, y+= ZEILENABSTAND)
	 {
	    if(( ED->h_RB->proz+ ED->h_RB->maxstep)<= Zeile_len( ED, ED->v_RB->proz+ i))
	    {
	       if( Is_Pos_Mark( ED->h_RB->proz+ ED->h_RB->maxstep- 1, ED->v_RB->proz+ i, ED, &MA))
		  bar( X_ENDE- 8, y- 1, X_ENDE, y+ 8);
	       if( ED->edit_view== EDIT)
		  *buffer= *( ED->Zeilen[ ED->v_RB->proz+ i]+ ED->h_RB->proz+ ED->h_RB->maxstep- 1);
	       else
	       {
		  if((( ED->v_RB->proz+ i)== ( ED->BI[ ED->akt_block].Zeilen_offset+ ED->anz_Z_puffer- 1))&& ( ED->last_X< ( ED->h_RB->proz+ ED->h_RB->maxstep)))
		  {
		     X_merk= ED->last_X;
		     ED->akt_block++;
		     _Read_Array( ED);
		     *buffer= *( ED->Zeilen[ ED->v_RB->proz+ i- ED->BI[ ED->akt_block].Zeilen_offset]+ ( ED->h_RB->proz+ ED->h_RB->maxstep- 1- X_merk));
		  }
		  else
		  {
		     if(( ED->v_RB->proz+ i)== ED->BI[ ED->akt_block].Zeilen_offset)
		     {
			if( ED->BI[ ED->akt_block].X_off>= ( ED->h_RB->proz+ ED->h_RB->maxstep))
			{
			   ED->akt_block--;
			   _Read_Array( ED);
			   *buffer= *( ED->Zeilen[ ED->v_RB->proz+ i- ED->BI[ ED->akt_block].Zeilen_offset]+ ED->h_RB->proz+ ED->h_RB->maxstep- 1);
			}
			else
			   *buffer= *( ED->Zeilen[ ED->v_RB->proz+ i- ED->BI[ ED->akt_block].Zeilen_offset]+ ( ED->h_RB->proz+ ED->h_RB->maxstep- 1)- ED->BI[ ED->akt_block].X_off);
		     }
		     else
			*buffer= *( ED->Zeilen[ ED->v_RB->proz+ i- ED->BI[ ED->akt_block].Zeilen_offset]+ ED->h_RB->proz+ ED->h_RB->maxstep- 1);
		  }
	       }
	       outtextxy( X_ENDE- 8, y, buffer);
	    }
	 }
	 break;
      case ED_RIGHT:
	 SCR_move( X_BEGINN, Y_BEGINN- 1, X_ENDE- X_BEGINN- 16, Y_ENDE- Y_BEGINN+ 2, X_BEGINN+ 8, Y_BEGINN- 1);
	 bar( X_BEGINN, Y_BEGINN- 1, X_BEGINN+ 7, Y_ENDE);
	 setfillstyle( SOLID_FILL, MARK_COLOR);
	 for( i= 0, y= Y_BEGINN; ( i< ED->v_RB->maxstep)&& (( ED->v_RB->proz+ i)< ED->v_RB->max); i++, y+= ZEILENABSTAND)
	 {
	    if( ED->h_RB->proz< Zeile_len( ED, ED->v_RB->proz+ i))
	    {
	       if( Is_Pos_Mark( ED->h_RB->proz, ED->v_RB->proz+ i, ED, &MA))
		  bar( X_BEGINN, y- 1, X_BEGINN+ 7, y+ 8);
	       if( ED->edit_view== EDIT)
		  *buffer= *( ED->Zeilen[ ED->v_RB->proz+ i]+ ED->h_RB->proz);
	       else
	       {
		  if((( ED->v_RB->proz+ i)== ( ED->BI[ ED->akt_block].Zeilen_offset+ ED->anz_Z_puffer- 1))&& ( ED->last_X<= ED->h_RB->proz))
		  {
		     X_merk= ED->last_X;
		     ED->akt_block++;
		     _Read_Array( ED);
		     *buffer= *( ED->Zeilen[ ED->v_RB->proz+ i- ED->BI[ ED->akt_block].Zeilen_offset]+ ( ED->h_RB->proz- X_merk));
		  }
		  else
		  {
		     if(( ED->v_RB->proz+ i)== ED->BI[ ED->akt_block].Zeilen_offset)
		     {
			if( ED->BI[ ED->akt_block].X_off> ED->h_RB->proz)
			{
			   ED->akt_block--;
			   _Read_Array( ED);
			   *buffer= *( ED->Zeilen[ ED->v_RB->proz+ i- ED->BI[ ED->akt_block].Zeilen_offset]+ ED->h_RB->proz);
			}
			else
			   *buffer= *( ED->Zeilen[ ED->v_RB->proz+ i- ED->BI[ ED->akt_block].Zeilen_offset]+ ( ED->h_RB->proz- ED->BI[ ED->akt_block].X_off));
		     }
		     else
			*buffer= *( ED->Zeilen[ ED->v_RB->proz+ i- ED->BI[ ED->akt_block].Zeilen_offset]+ ED->h_RB->proz);
		  }
	       }
	       outtextxy( X_BEGINN, y, buffer);
	    }
	 }
	 break;
   }
   Draw_Cursor( ED, ED->X_cur, ED->Y_cur, ED->h_RB->proz, ED->v_RB->proz, AN);
   Prozent_View( ED);
   ShowMouse( AN);
}

void Cursor_pos( Edit_struct *ED)
{
   char buffer[ 12];

   ShowMouse( AUS);
   sprintf( buffer, "%5ld:%ld", ED->X_cur+ 1, ED->Y_cur+ 1);
   MOverTextxy( 534, 442, buffer, 11);
   ShowMouse( AN);
}

void Cursor_Blinken( Edit_struct *ED)
{
   BOOL an_aus= 0;
   int t;

   for( ;;)
   {
      for( t= 0; t< 50; t++)
      {
	 Clock();
	 delay( 3);
	 if( MouseMove()|| _bios_keybrd( _NKEYBRD_READY)|| ( MouseStat()!= NOTHING))
	    return;
      }
      Draw_Cursor( ED, ED->X_cur, ED->Y_cur, ED->h_RB->proz, ED->v_RB->proz, ( an_aus) ? ( an_aus= AUS) : ( an_aus= AN));
   }
}

BOOL ShowText_by_Cursor( Edit_struct *ED)
{
   BOOL show= 0;

   if(( ED->X_cur< ED->h_RB->proz)|| ( ED->X_cur>= ( ED->h_RB->proz+ ED->h_RB->maxstep)))
   {
      if(( ED->h_RB->proz= ED->X_cur- ( ED->h_RB->maxstep>> 1))< 0)
	 ED->h_RB->proz= 0;
      else
      {
	 if(( ED->h_RB->proz+ ED->h_RB->maxstep)> ED->h_RB->max)
	    if(( ED->h_RB->proz= ED->h_RB->max- ED->h_RB->maxstep)< 0)
	       ED->h_RB->proz= 0;
      }
      show= 1;
   }
   else
   {
      if(( ED->h_RB->proz+ ED->h_RB->maxstep)> ED->h_RB->max)
      {
	 if( ED->h_RB->proz!= 0)
	 {
	    if(( ED->h_RB->proz= ED->h_RB->max- ED->h_RB->maxstep)< 0)
	       ED->h_RB->proz= 0;
	    show= 1;
	 }
      }
   }
   if(( ED->Y_cur< ED->v_RB->proz)|| ( ED->Y_cur>= ( ED->v_RB->proz+ ED->v_RB->maxstep)))
   {
      if(( ED->v_RB->proz= ED->Y_cur- ( ED->v_RB->maxstep>> 1))< 0)
	 ED->v_RB->proz= 0;
      else
      {
	 if(( ED->v_RB->proz+ ED->v_RB->maxstep)> ED->v_RB->max)
	    if(( ED->v_RB->proz= ED->v_RB->max- ED->v_RB->maxstep)< 0)
	       ED->v_RB->proz= 0;
      }
      show= 1;
   }
   else
   {
      if(( ED->v_RB->proz+ ED->v_RB->maxstep)> ED->v_RB->max)
      {
	 if( ED->v_RB->proz!= 0)
	 {
	    if(( ED->v_RB->proz= ED->v_RB->max- ED->v_RB->maxstep)< 0)
	       ED->v_RB->proz= 0;
	    show= 1;
	 }
      }
   }
   return( show);
}

void Cursor_UP_DOWN_LEFT_RIGHT( Edit_struct *ED, char richtung, BOOL shift)
{
   Mark_struct old_MA, new_MA;
   int st_len;
   BOOL cursor_sichtbar, show= 0;
   char dir= HORIZ_DIR;

   if( !shift)
      ClearMark( ED);
   else
   {
      if( !ED->text_mark)
      {
	 ED->X_mark= ED->X_cur;
	 ED->Y_mark= ED->Y_cur;
	 ED->text_mark= 1;
      }
      Mark_to_Markstruct( &old_MA, ED, ED_SHOW);
   }
   cursor_sichtbar= Draw_Cursor( ED, ED->X_cur, ED->Y_cur, ED->h_RB->proz, ED->v_RB->proz, AUS);
   switch( richtung)
   {
      case ED_DOC_ANF:
	 ED->Y_cur= 0;
      case ED_POS1:
	 ED->X_cur= 0;
	 break;
      case ED_DOC_END:
	 ED->Y_cur= ED->v_RB->max- 1;
      case ED_ENDE:
	 ED->X_cur= Zeile_len( ED, ED->Y_cur);
	 break;
      case ED_PG_UP:
	 if(( ED->Y_cur-= ED->v_RB->maxstep)< 0)
	    ED->Y_cur= 0;
	 break;
      case ED_PG_DN:
	 if(( ED->Y_cur+= ED->v_RB->maxstep)>= ED->v_RB->max)
	    ED->Y_cur= ED->v_RB->max- 1;
	 break;
      case ED_LEFT:
	 if( ED->X_cur> 0)
	 {
	    ED->X_cur--;
	    if( ED->X_cur< ED->h_RB->proz)
	    {
	       if( KlickRollBalken( ED->MS, ED->h_RB, Dummy_Balken, RBALKEN_MINUS_MIN_MAUS)== ONE_ELEMENT_LEFT)
		  if( cursor_sichtbar)
		     Page_Up_Down_Left_Right( ED, ED_RIGHT);
	    }
	    break;
	 }
	 else
	 {
	    if( ED->Y_cur> 0)
	       ED->X_cur= Zeile_len( ED, ED->Y_cur- 1);
	    else
	       break;
	 }
      case ED_UP:
	 if( ED->Y_cur> 0)
	 {
	    ED->Y_cur--;
	    if( ED->Y_cur< ED->v_RB->proz)
	    {
	       if( KlickRollBalken( ED->MS, ED->v_RB, Dummy_Balken, RBALKEN_MINUS_MIN_MAUS)== ONE_ELEMENT_UP)
		  if( cursor_sichtbar)
		     Page_Up_Down_Left_Right( ED, ED_DOWN);
	    }
	    dir= VERT_DIR;
	 }
	 break;
      case ED_RIGHT:
	 if( ED->X_cur< Zeile_len( ED, ED->Y_cur))
	 {
	    ED->X_cur++;
	    if( ED->X_cur>= ( ED->h_RB->proz+ ED->h_RB->maxstep))
	    {
	       if( KlickRollBalken( ED->MS, ED->h_RB, Dummy_Balken, RBALKEN_PLUS_MIN_MAUS)== ONE_ELEMENT_RIGHT)
		  if( cursor_sichtbar)
		     Page_Up_Down_Left_Right( ED, ED_LEFT);
	    }
	    break;
	 }
	 else
	 {
	    if( ED->Y_cur< ( ED->v_RB->max- 1))
	       ED->X_cur= 0;
	    else
	       break;
	 }
      case ED_DOWN:
	 if( ED->Y_cur< ( ED->v_RB->max- 1))
	 {
	    ED->Y_cur++;
	    if( ED->Y_cur>= ( ED->v_RB->proz+ ED->v_RB->maxstep))
	    {
	       if( KlickRollBalken( ED->MS, ED->v_RB, Dummy_Balken, RBALKEN_PLUS_MIN_MAUS)== ONE_ELEMENT_DOWN)
		  if( cursor_sichtbar)
		     Page_Up_Down_Left_Right( ED, ED_UP);
	    }
	    dir= VERT_DIR;
	 }
	 break;
   }
   if( dir== VERT_DIR)
   {
      if( ED->X_cur> ( st_len= Zeile_len( ED, ED->Y_cur)))
      {
	 if(( ED->X_cur= st_len)< ED->h_RB->proz)
	 {
	    if(( ED->h_RB->proz= st_len- ED->h_RB->maxstep)< 0)
	       ED->h_RB->proz= 0;
	    show= 1;
	 }
      }
   }
   if( show|= ShowText_by_Cursor( ED))
   {
      View_Page( ED);
      _ViewAnfasser( ED->MS, ED->h_RB);
      _ViewAnfasser( ED->MS, ED->v_RB);
      shift= 0;
   }
   else
      Draw_Cursor( ED, ED->X_cur, ED->Y_cur, ED->h_RB->proz, ED->v_RB->proz, AN);
   if( shift)
   {
      Mark_to_Markstruct( &new_MA, ED, ED_SHOW);
      TeilMark( ED, &old_MA, &new_MA);
   }
   Cursor_pos( ED);
}

BOOL Mouse_to_Cursorpos( Cursor_struct *CM, Edit_struct *ED)
{
   int X_cur, Y_cur, st_len;

   CM->h_proz= ED->h_RB->proz;
   CM->v_proz= ED->v_RB->proz;
   if((( Y_cur= ( MStat.y- Y_BEGINN)/ ZEILENABSTAND)>= 0)&& ( Y_cur< ED->v_RB->maxstep)&& ( Y_cur< ED->v_RB->max))
   {
      if(( X_cur= ( MStat.x- X_BEGINN)>> 3)>= 0)
      {
	 if(( X_cur+ CM->h_proz)> ( st_len= Zeile_len( ED, CM->v_proz+ Y_cur)))
	 {
	    if(( X_cur= st_len- CM->h_proz)< 0)
	    {
	       if(( CM->h_proz= st_len- ( ED->h_RB->maxstep- 1))< 0)
	       {
		  X_cur= st_len;
		  CM->h_proz= 0;
	       }
	       else
		  X_cur= ED->h_RB->maxstep- 1;
	    }
	 }
	 CM->X_cur= CM->h_proz+ X_cur;
	 CM->Y_cur= CM->v_proz+ Y_cur;
	 return( 1);
      }
   }
   return( 0);
}

void MoveCursor( Cursor_struct *CM, Edit_struct *ED)
{
   Draw_Cursor( ED, ED->X_cur, ED->Y_cur, ED->h_RB->proz, ED->v_RB->proz, AUS);
   ED->X_cur= CM->X_cur;
   ED->Y_cur= CM->Y_cur;
   Draw_Cursor( ED, ED->X_cur, ED->Y_cur, ED->h_RB->proz, ED->v_RB->proz, AN);
   Cursor_pos( ED);
}

void Cursor_Set( Edit_struct *ED)
{
   Cursor_struct CM;

   if( Mouse_to_Cursorpos( &CM, ED))
   {
      if(( ED->h_RB->proz!= CM.h_proz)|| ( ED->v_RB->proz!= CM.v_proz))
      {
	 ED->h_RB->proz= CM.h_proz;
	 ED->v_RB->proz= CM.v_proz;
	 View_Page( ED);
	 _ViewAnfasser( ED->MS, ED->h_RB);
      }
      MoveCursor( &CM, ED);
   }
}

BOOL Mark_to_Markstruct( Mark_struct *MA, Edit_struct *ED, char show_copy)
{
   if( ED->text_mark)
   {
      if( ED->Y_cur> ED->Y_mark)
      {
	 MA->X1_mark= ED->X_mark;
	 MA->Y1_mark= ED->Y_mark;
	 if(( show_copy== ED_SHOW)&& ( ED->X_cur== 0))
	 {
	    MA->X2_mark= Zeile_len( ED, MA->Y2_mark= ED->Y_cur- 1);
	 }
	 else
	 {
	    MA->X2_mark= ED->X_cur;
	    MA->Y2_mark= ED->Y_cur;
	 }
      }
      else
      {
	 if( ED->Y_cur< ED->Y_mark)
	 {
	    MA->X1_mark= ED->X_cur;
	    MA->Y1_mark= ED->Y_cur;
	    if(( show_copy== ED_SHOW)&& ( ED->X_mark== 0))
	    {
	       MA->X2_mark= Zeile_len( ED, MA->Y2_mark= ED->Y_mark- 1);
	    }
	    else
	    {
	       MA->X2_mark= ED->X_mark;
	       MA->Y2_mark= ED->Y_mark;
	    }
	 }
	 else
	 {
	    MA->Y1_mark= MA->Y2_mark= ED->Y_mark;
	    if( ED->X_cur> ED->X_mark)
	    {
	       MA->X1_mark= ED->X_mark;
	       MA->X2_mark= ED->X_cur;
	    }
	    else
	    {
	       MA->X1_mark= ED->X_cur;
	       MA->X2_mark= ED->X_mark;
	    }
	 }
      }
      return( 1);
   }
   return( 0);
}

BOOL Is_Pos_Mark( unsigned X, unsigned Y, Edit_struct *ED, Mark_struct *MA)
{
   if( ED->text_mark)
   {
      if(( Y>= MA->Y1_mark)&& ( Y<= MA->Y2_mark))
      {
	 if( Y== MA->Y1_mark)
	 {
	    if( X>= MA->X1_mark)
	    {
	       if( Y== MA->Y2_mark)
	       {
		  if( X< MA->X2_mark)
		     return( 1);
	       }
	       else
	       {
		  if( X< Zeile_len( ED, Y))
		     return( 1);
	       }
	    }
	 }
	 else
	 {
	    if( Y== MA->Y2_mark)
	    {
	       if( X< MA->X2_mark)
		  return( 1);
	    }
	    else
	    {
	       if( X< Zeile_len( ED, Y))
		  return( 1);
	    }
	 }
      }
   }
   return( 0);
}

BOOL Zeile_Mark_from_to( unsigned zeile, unsigned anf_pos, Edit_struct *ED, Mark_struct *MA, unsigned *from, unsigned *to)
{
   if( !ED->text_mark|| ( zeile< MA->Y1_mark)|| ( zeile> MA->Y2_mark))
      return( 0);
   if( zeile== MA->Y1_mark)
   {
      if( anf_pos< MA->X1_mark)
      {
	 if(( *from= MA->X1_mark- anf_pos)>= ED->h_RB->maxstep)
	    return( 0);
      }
      else
      {
	 if( zeile== MA->Y2_mark)
	 {
	    if( anf_pos< MA->X2_mark)
	       *from= 0;
	    else
	       return( 0);
	 }
	 else
	 {
	    if( anf_pos< Zeile_len( ED, zeile))
	       *from= 0;
	    else
	       return( 0);
	 }
      }
   }
   else
   {
      if( zeile== MA->Y2_mark)
      {
	 if( anf_pos< MA->X2_mark)
	    *from= 0;
	 else
	    return( 0);
      }
      else
      {
	 if( anf_pos< Zeile_len( ED, zeile))
	    *from= 0;
	 else
	    return( 0);
      }
   }
   if( zeile== MA->Y2_mark)
   {
      if(( *to= MA->X2_mark- anf_pos)> ED->h_RB->maxstep)
	 *to= ED->h_RB->maxstep;
   }
   else
   {
      if(( *to= Zeile_len( ED, zeile)- anf_pos)> ED->h_RB->maxstep)
	 *to= ED->h_RB->maxstep;
   }
   if( *from!= *to)
      return( 1);
   else
      return( 0);
}

void MarkZeile( Edit_struct *ED, Mark_struct *MA, unsigned zeile, unsigned anf_pos)
{
   unsigned from, to;

   if( Zeile_Mark_from_to( zeile, anf_pos, ED, MA, &from, &to))
      bar( X_BEGINN+ ( from<< 3), Y_BEGINN+ ( zeile- ED->v_RB->proz)* ZEILENABSTAND- 1, X_BEGINN+ ( to<< 3)- 1, Y_BEGINN+ ( zeile- ED->v_RB->proz)* ZEILENABSTAND+ 8);
}

void Mark_Text( Edit_struct *ED, Mark_struct *MA, char an_aus)
{
   unsigned i, from, to;
   char buffer[ MAX_SICHT_SPALTEN+ 1];

   setfillstyle( SOLID_FILL, ( an_aus== AN) ? ( MARK_COLOR) : ( EGA_WHITE));
   setcolor( EGA_BLACK);
   ShowMouse( AUS);
   for( i= ( ( MA->Y1_mark< ED->v_RB->proz) ? ( ED->v_RB->proz) : ( MA->Y1_mark)); ( i<= MA->Y2_mark)&& ( i< ( ED->v_RB->proz+ ED->v_RB->maxstep)); i++)
   {
      if( Zeile_Mark_from_to( i, ED->h_RB->proz, ED, MA, &from, &to))
      {
	 if( ED->edit_view== VIEW)
	    check_Line_akt_Block( ED, i);
	 bar( X_BEGINN+ ( from<< 3), Y_BEGINN+ ( i- ED->v_RB->proz)* ZEILENABSTAND- 1, X_BEGINN+ ( to<< 3)- 1, Y_BEGINN+ ( i- ED->v_RB->proz)* ZEILENABSTAND+ 8);
	 outtextxy( X_BEGINN+ ( from<< 3), Y_BEGINN+ ( i- ED->v_RB->proz)* ZEILENABSTAND, line_cpy( buffer, ED, i, ED->h_RB->proz+ from, to- from));
      }
   }
   ShowMouse( AN);
}

int MouseScroll( void)
{
   if( MStat.x> X_ENDE)
      return( ED_LEFT);
   if( MStat.x< X_BEGINN)
      return( ED_RIGHT);
   if( MStat.y> Y_ENDE)
      return( ED_UP);
   if( MStat.y< Y_BEGINN)
      return( ED_DOWN);
   return( -1);
}

void ClearMark( Edit_struct *ED)
{
   Mark_struct MA;

   if( ED->text_mark)                  /* alte Markierung rckgngig machen */
   {
      Mark_to_Markstruct( &MA, ED, ED_SHOW);
      Mark_Text( ED, &MA, AUS);
      ED->text_mark= 0;
   }
}

void TeilMark( Edit_struct *ED, Mark_struct *old_MA, Mark_struct *new_MA)
{
   Mark_struct MA;

   if( ED->text_mark)
   {
      if(( ED->Y_cur> ED->Y_mark)|| (( ED->Y_cur== ED->Y_mark)&& ( ED->X_cur> ED->X_mark)))
      {
	 if( ED->old_mark== UP)
	 {
	    MA.X1_mark= old_MA->X1_mark;
	    MA.Y1_mark= old_MA->Y1_mark;
	    MA.X2_mark= ED->X_mark;
	    MA.Y2_mark= ED->Y_mark;
	    Mark_Text( ED, &MA, AUS);
	 }
	 if(( new_MA->Y2_mark> old_MA->Y2_mark)|| (( new_MA->Y2_mark== old_MA->Y2_mark)&& ( new_MA->X2_mark> old_MA->X2_mark)))
	 {
	    MA.X1_mark= old_MA->X2_mark;
	    MA.Y1_mark= old_MA->Y2_mark;
	    MA.X2_mark= new_MA->X2_mark;
	    MA.Y2_mark= new_MA->Y2_mark;
	    Mark_Text( ED, &MA, AN);
	    ED->old_mark= DOWN;
	 }
	 else
	 {
	    MA.X1_mark= new_MA->X2_mark;
	    MA.Y1_mark= new_MA->Y2_mark;
	    MA.X2_mark= old_MA->X2_mark;
	    MA.Y2_mark= old_MA->Y2_mark;
	    Mark_Text( ED, &MA, AUS);
	 }
      }
      else
      {
	 if( ED->old_mark== DOWN)
	 {
	    MA.X1_mark= ED->X_mark;
	    MA.Y1_mark= ED->Y_mark;
	    MA.X2_mark= old_MA->X2_mark;
	    MA.Y2_mark= old_MA->Y2_mark;
	    Mark_Text( ED, &MA, AUS);
	 }
	 if(( new_MA->Y1_mark< old_MA->Y1_mark)|| (( new_MA->Y1_mark== old_MA->Y1_mark)&& ( new_MA->X1_mark< old_MA->X1_mark)))
	 {
	    MA.X1_mark= new_MA->X1_mark;
	    MA.Y1_mark= new_MA->Y1_mark;
	    MA.X2_mark= old_MA->X1_mark;
	    MA.Y2_mark= old_MA->Y1_mark;
	    Mark_Text( ED, &MA, AN);
	    ED->old_mark= UP;
	 }
	 else
	 {
	    MA.X1_mark= old_MA->X1_mark;
	    MA.Y1_mark= old_MA->Y1_mark;
	    MA.X2_mark= new_MA->X1_mark;
	    MA.Y2_mark= new_MA->Y1_mark;
	    Mark_Text( ED, &MA, AUS);
	 }
      }
   }
}

void Cursor_Mark( Edit_struct *ED)
{
   Cursor_struct CM;
   Mark_struct old_MA, new_MA;
   int status;
   unsigned X_cur, Y_cur;
   BOOL scroll;

   ClearMark( ED);
   Cursor_Set( ED);
   if( MStat.buttons!= RIGHT)
   {
      ED->X_mark= ED->X_cur;
      ED->Y_mark= ED->Y_cur;
      ED->text_mark= 1;
      Mark_to_Markstruct( &old_MA, ED, ED_SHOW);
      do
      {
	 if(( status= MouseScroll())!= -1)
	 {
	    switch( status)
	    {
	       case ED_LEFT:
		  scroll= ( KlickRollBalken( ED->MS, ED->h_RB, Dummy_Balken, RBALKEN_PLUS_MIN_MAUS)== ONE_ELEMENT_RIGHT);
		  MStat.x= X_ENDE- 1;
		  break;
	       case ED_RIGHT:
		  scroll= ( KlickRollBalken( ED->MS, ED->h_RB, Dummy_Balken, RBALKEN_MINUS_MIN_MAUS)== ONE_ELEMENT_LEFT);
		  MStat.x= X_BEGINN+ 1;
		  break;
	       case ED_UP:
		  scroll= ( KlickRollBalken( ED->MS, ED->v_RB, Dummy_Balken, RBALKEN_PLUS_MIN_MAUS)== ONE_ELEMENT_DOWN);
		  MStat.y= Y_ENDE- 1;
		  break;
	       case ED_DOWN:
		  scroll= ( KlickRollBalken( ED->MS, ED->v_RB, Dummy_Balken, RBALKEN_MINUS_MIN_MAUS)== ONE_ELEMENT_UP);
		  MStat.y= Y_BEGINN+ 1;
		  break;
	    }
	    if( scroll)
	       Page_Up_Down_Left_Right( ED, status);
	 }
	 if( Mouse_to_Cursorpos( &CM, ED))
	 {
	    if(( CM.X_cur!= ED->X_cur)|| ( CM.Y_cur!= ED->Y_cur))
	    {
	       X_cur= ED->X_cur;
	       Y_cur= ED->Y_cur;
	       ED->X_cur= CM.X_cur;
	       ED->Y_cur= CM.Y_cur;
	       Mark_to_Markstruct( &new_MA, ED, ED_SHOW);
	       TeilMark( ED, &old_MA, &new_MA);
	       Draw_Cursor( ED, X_cur, Y_cur, ED->h_RB->proz, ED->v_RB->proz, AUS);
	       Draw_Cursor( ED, ED->X_cur, ED->Y_cur, ED->h_RB->proz, ED->v_RB->proz, AN);
	       Cursor_pos( ED);
	       memcpy( &old_MA, &new_MA, sizeof( Mark_struct));
	    }
	 }
      }while( MouseStat()!= NOTHING);
      if(( ED->X_mark== ED->X_cur)&& ( ED->Y_mark== ED->Y_cur))
	 ED->text_mark= 0;
      else
      {
	 if( ED->xEdit)
	    _Copy( ED);
      }
   }
   else
   {
      if( ED->xEdit)
      {
	 _Paste( ED, textClipboard, textClipboardLen);
	 While_Klick();
      }
   }
}

void FreeSpace( Edit_struct *ED)
{
   char tmp_array[ 10], Tausender[ 10];

   sprintf( tmp_array, "%6s", Tausender_Gruppen( Tausender, ED_MAXEDIT- ED->puffer_len));
   MOverTextxy( 544, 33, tmp_array, 6);
}

int _Copy( Edit_struct *ED)
{
   Mark_struct MA;
   int ret_val= 0;

   if( Mark_to_Markstruct( &MA, ED, ED_MEMORY))
   {
      if( validTextAtClipBoard)
	 free( textClipboard);
      if(( textClipboard= malloc( textClipboardLen= ( ED->Zeilen[ MA.Y2_mark]+ MA.X2_mark)- ( ED->Zeilen[ MA.Y1_mark]+ MA.X1_mark)))!= NULL)
      {
	 memcpy( textClipboard, ED->Zeilen[ MA.Y1_mark]+ MA.X1_mark, textClipboardLen);
	 validTextAtClipBoard= TRUE;
      }
      else
      {
	 validTextAtClipBoard= FALSE;
	 ErrorMsg( KEIN_SPEICHER);
	 ret_val= -1;
      }
   }
   else
      Hinweis( "No text selected    ");
   return( ret_val);
}

void ScrollLine( unsigned X, unsigned Y, unsigned X_dist, unsigned Y_dist, Edit_struct *ED, char Dir)
{
   unsigned z_len, i, X_Ya;
   char buffer[ MAX_SICHT_SPALTEN+ 1];

   ShowMouse( AUS);
   setfillstyle( SOLID_FILL, EGA_WHITE);
   setcolor( EGA_BLACK);
   switch( Dir)
   {
      case ED_LEFT:
	 if(( X- ED->h_RB->proz)< ED->h_RB->maxstep)
	 {
	    SCR_move( X_BEGINN+ (( X- ED->h_RB->proz)<< 3), Y_BEGINN+ (( Y- ED->v_RB->proz)* ZEILENABSTAND)- 1, (( ED->h_RB->maxstep- ( X- ED->h_RB->proz)- 1)<< 3)- 1, 10, X_BEGINN+ (( X- X_dist- ED->h_RB->proz)<< 3), Y_BEGINN+ (( Y- ED->v_RB->proz)* ZEILENABSTAND)- 1);
	    X_Ya= ( ED->h_RB->maxstep- X_dist)+ ED->h_RB->proz;
	 }
	 else
	    X_Ya= X- X_dist;
	 bar( X_BEGINN+ (( X_Ya- ED->h_RB->proz)<< 3), Y_BEGINN+ (( Y- ED->v_RB->proz)* ZEILENABSTAND)- 1, X_ENDE, Y_BEGINN+ (( Y- ED->v_RB->proz)* ZEILENABSTAND)+ 8);
	 if( X_Ya< ( z_len= Zeile_len( ED, Y)))
	 {
	    if(( ED->h_RB->proz+ ED->h_RB->maxstep)>= z_len)
	       i= z_len- X_Ya;
	    else
	       i= ED->h_RB->proz+ ED->h_RB->maxstep- X_Ya;
	    *( no_Null( memcpy( buffer, ED->Zeilen[ Y]+ X_Ya, i), i)+ i)= '\0';
	    outtextxy( X_BEGINN+ (( X_Ya- ED->h_RB->proz)<< 3), Y_BEGINN+ (( Y- ED->v_RB->proz)* ZEILENABSTAND), buffer);
	 }
	 break;
      case ED_UP:
	 bar( X_BEGINN+ ((( X- X_dist)- ED->h_RB->proz)<< 3), Y_BEGINN+ ((( Y- Y_dist)- ED->v_RB->proz)* ZEILENABSTAND)- 1, X_ENDE, Y_BEGINN+ ((( Y- Y_dist)- ED->v_RB->proz)* ZEILENABSTAND)+ 8);
	 if(( X- X_dist)< ( z_len= Zeile_len( ED, Y- Y_dist)))
	 {
	    if(( i= z_len- ( X- X_dist))> ( ED->h_RB->maxstep- (( X- X_dist)- ED->h_RB->proz)))
	       i= ED->h_RB->maxstep- (( X- X_dist)- ED->h_RB->proz);
	    *( no_Null( memcpy( buffer, ED->Zeilen[ Y- Y_dist]+ X- X_dist, i), i)+ i)= '\0';
	    outtextxy( X_BEGINN+ ((( X- X_dist)- ED->h_RB->proz)<< 3), Y_BEGINN+ ((( Y- Y_dist)- ED->v_RB->proz)* ZEILENABSTAND), buffer);
	 }
	 if(( Y- ED->v_RB->proz)< ( ED->v_RB->maxstep- 1))
	 {
	    SCR_move( X_BEGINN, Y_BEGINN+ ((( Y- ED->v_RB->proz)+ 1)* ZEILENABSTAND)- 1, X_ENDE- X_BEGINN- 8, Y_ENDE- ( Y_BEGINN+ ((( Y- ED->v_RB->proz)+ 1)* ZEILENABSTAND))+ 1, X_BEGINN, Y_BEGINN+ ((( Y- ED->v_RB->proz)- Y_dist+ 1)* ZEILENABSTAND)- 1);
	    X_Ya= ( ED->v_RB->maxstep- Y_dist)+ ED->v_RB->proz;
	 }
	 else
	    X_Ya= Y- Y_dist+ 1;
	 bar( X_BEGINN, Y_BEGINN+ (( X_Ya- ED->v_RB->proz)* ZEILENABSTAND)- 1, X_ENDE, Y_ENDE);
	 for( i= X_Ya- ED->v_RB->proz; ( i< ED->v_RB->maxstep)&& (( ED->v_RB->proz+ i)< ED->v_RB->max); i++)
	    Zeilen_cpy( X_BEGINN, Y_BEGINN+ ( i* ZEILENABSTAND), ED, ED->v_RB->proz+ i, ED->h_RB->proz);
	 break;
      case ED_RIGHT:
	 if(( X- ED->h_RB->proz)< ED->h_RB->maxstep)
	 {
	    if(( ED->h_RB->maxstep- ( X- ED->h_RB->proz)- X_dist)> 0)
	       SCR_move( X_BEGINN+ (( X- ED->h_RB->proz)<< 3), Y_BEGINN+ (( Y- ED->v_RB->proz)* ZEILENABSTAND)- 1, ( ED->h_RB->maxstep- ( X- ED->h_RB->proz)- 1- X_dist)<< 3, 10, X_BEGINN+ (( X+ X_dist- ED->h_RB->proz)<< 3), Y_BEGINN+ (( Y- ED->v_RB->proz)* ZEILENABSTAND)- 1);
	    if(( z_len= X+ X_dist- ED->h_RB->proz)> ED->h_RB->maxstep)
	       z_len= ED->h_RB->maxstep;
	    bar( X_BEGINN+ (( X- ED->h_RB->proz)<< 3), Y_BEGINN+ (( Y- ED->v_RB->proz)* ZEILENABSTAND)- 1, X_BEGINN+ ( z_len<< 3)- 1, Y_BEGINN+ (( Y- ED->v_RB->proz)* ZEILENABSTAND)+ 8);
	    if(( i= Zeile_len( ED, Y)- X)> ( ED->h_RB->maxstep- ( X- ED->h_RB->proz)))
	       i= ED->h_RB->maxstep- ( X- ED->h_RB->proz);
	    *( no_Null( memcpy( buffer, ED->Zeilen[ Y]+ X, i), i)+ i)= '\0';
	    outtextxy( X_BEGINN+ (( X- ED->h_RB->proz)<< 3), Y_BEGINN+ (( Y- ED->v_RB->proz)* ZEILENABSTAND), buffer);
	 }
	 break;
      case ED_DOWN:
	 bar( X_BEGINN+ (( X- ED->h_RB->proz)<< 3), Y_BEGINN+ (( Y- ED->v_RB->proz)* ZEILENABSTAND)- 1, X_ENDE, Y_BEGINN+ (( Y- ED->v_RB->proz)* ZEILENABSTAND)+ 8);
	 if( X< ( z_len= Zeile_len( ED, Y)))
	 {
	    if(( z_len-= X)> ( ED->h_RB->maxstep- ( X- ED->h_RB->proz)))
	       z_len= ED->h_RB->maxstep- ( X- ED->h_RB->proz);
	    *( no_Null( memcpy( buffer, ED->Zeilen[ Y]+ X, z_len), z_len)+ z_len)= '\0';
	    outtextxy( X_BEGINN+ (( X- ED->h_RB->proz)<< 3), Y_BEGINN+ (( Y- ED->v_RB->proz)* ZEILENABSTAND), buffer);
	 }
	 if(( Y- ED->v_RB->proz)< ( ED->v_RB->maxstep- 1))
	 {
	    if((( Y- ED->v_RB->proz)+ Y_dist+ 1)< ED->v_RB->maxstep)
	       SCR_move( X_BEGINN, Y_BEGINN+ ((( Y- ED->v_RB->proz)+ 1)* ZEILENABSTAND)- 1, X_ENDE- X_BEGINN+ 1, Y_ENDE- ( Y_BEGINN+ ((( Y- ED->v_RB->proz)+ Y_dist+ 1)* ZEILENABSTAND))+ 1, X_BEGINN, Y_BEGINN+ ((( Y- ED->v_RB->proz)+ Y_dist+ 1)* ZEILENABSTAND)- 1);
	    if(( z_len= ( Y- ED->v_RB->proz)+ Y_dist)>= ED->v_RB->maxstep)
	       z_len= ED->v_RB->maxstep- 1;
	    bar( X_BEGINN, Y_BEGINN+ ((( Y- ED->v_RB->proz)+ 1)* ZEILENABSTAND)- 1, X_ENDE, Y_BEGINN+ ( z_len* ZEILENABSTAND)+ 8);
	    for( i= 1; ( i<= Y_dist)&& ((( Y- ED->v_RB->proz)+ i)< ED->v_RB->maxstep); i++)
	       Zeilen_cpy( X_BEGINN, Y_BEGINN+ ((( Y- ED->v_RB->proz)+ i)* ZEILENABSTAND), ED, Y+ i, ED->h_RB->proz);
	 }
	 break;
   }
   Draw_Cursor( ED, ED->X_cur, ED->Y_cur, ED->h_RB->proz, ED->v_RB->proz, AN);
   ShowMouse( AN);
}

void _Clear( Edit_struct *ED)
{
   Mark_struct MA;
   long _mem_len;
   unsigned i;
   char *old_ptr;

   if( Mark_to_Markstruct( &MA, ED, ED_MEMORY))
   {
      memmove( ED->Zeilen[ MA.Y1_mark]+ MA.X1_mark, ED->Zeilen[ MA.Y2_mark]+ MA.X2_mark, ED->puffer_len- (( ED->Zeilen[ MA.Y2_mark]+ MA.X2_mark)- ED->Zeilen[ 0]));
      old_ptr= ED->Zeilen[ 0];
      ED->Zeilen[ 0]= farrealloc( ED->Zeilen[ 0], ED->puffer_len-= ( _mem_len= ( ED->Zeilen[ MA.Y2_mark]+ MA.X2_mark)- ( ED->Zeilen[ MA.Y1_mark]+ MA.X1_mark)));
      if( old_ptr!= ED->Zeilen[ 0])
      {
	 for( i= 1; i< ED->v_RB->max; i++)
	    ( ptrdiff_t)( ( char *)ED->Zeilen[ i])+= ( ptrdiff_t)( ( char *)ED->Zeilen[ 0])- ( ptrdiff_t)( ( char *)old_ptr);
      }
      for( i= MA.Y1_mark+ 1; i< ED->v_RB->max; i++)
	 ED->Zeilen[ i]= ED->Zeilen[ i+ ( MA.Y2_mark- MA.Y1_mark)]- _mem_len;
      ED->anz_Z_puffer= ED->v_RB->max-= MA.Y2_mark- MA.Y1_mark;
      ED->Zeilen= ( char **)farrealloc( ED->Zeilen, ED->v_RB->max* sizeof( char *));
      ED->X_cur= MA.X1_mark;
      ED->Y_cur= MA.Y1_mark;
      ED->text_mark= 0;
      ED->text_geaendert= 1;
      if(( i= Zeile_len( ED, MA.Y1_mark))>= ED->h_RB->max)
	 ED->h_RB->max= i+ 1;
      if( ShowText_by_Cursor( ED))
	 View_Page( ED);
      else
      {
	 if(( MA.Y2_mark- MA.Y1_mark)== 0)
	    ScrollLine( MA.X2_mark, MA.Y2_mark, MA.X2_mark- MA.X1_mark, 0, ED, ED_LEFT);
	 else
	    ScrollLine( MA.X2_mark, MA.Y2_mark, MA.X2_mark- MA.X1_mark, MA.Y2_mark- MA.Y1_mark, ED, ED_UP);
      }
      _ViewAnfasser( ED->MS, ED->h_RB);
      _ViewAnfasser( ED->MS, ED->v_RB);
      FreeSpace( ED);
      Cursor_pos( ED);
   }
   else
      Hinweis( "No text selected    ");
}

int _Cut( Edit_struct *ED)
{
   int ret_val;

   if(( ret_val= _Copy( ED))== 0)
      _Clear( ED);
   return( ret_val);
}

int _Paste( Edit_struct *ED, char *Text, unsigned len)
{
   int ret_val= 0, anzNL;
   unsigned l, new_Zeilen= 0;
   char *zeile, *tmp_ptr, *old_ptr;

   if( len> 0)
   {
      if(( ED->puffer_len+ len)<= ED_MAXEDIT)
      {
	 if( ED->text_mark)
	    _Clear( ED);
	 zeile= Text;
	 while(( tmp_ptr= _searchNL( zeile, len- ( zeile- Text), &anzNL))!= NULL)
	 {
	    zeile= tmp_ptr+ anzNL;
	    new_Zeilen++;
	 }
	 old_ptr= ED->Zeilen[ 0];
	 if(( ED->Zeilen[ 0]= farrealloc( ED->Zeilen[ 0], ED->puffer_len+ len))!= NULL)
	 {
	    if(( ED->Zeilen= ( char **)farrealloc( ED->Zeilen, ( ED->v_RB->max+ new_Zeilen)* sizeof( char *)))!= NULL)
	    {
	       if( old_ptr!= ED->Zeilen[ 0])
	       {
		  for( l= 1; l< ED->v_RB->max; l++)
		     ( ptrdiff_t)( ( char *)ED->Zeilen[ l])+= ( ptrdiff_t)( ( char *)ED->Zeilen[ 0])- ( ptrdiff_t)( ( char *)old_ptr);
	       }
	       Draw_Cursor( ED, ED->X_cur, ED->Y_cur, ED->h_RB->proz, ED->v_RB->proz, AUS);
	       memmove( ( ED->Zeilen[ ED->Y_cur]+ ED->X_cur)+ len, ED->Zeilen[ ED->Y_cur]+ ED->X_cur, ED->puffer_len- (( ED->Zeilen[ ED->Y_cur]+ ED->X_cur)- ED->Zeilen[ 0]));
	       memcpy( ED->Zeilen[ ED->Y_cur]+ ED->X_cur, Text, len);
	       for( l= ED->v_RB->max- 1; l> ED->Y_cur; l--)
		  ED->Zeilen[ l+ new_Zeilen]= ED->Zeilen[ l]+ len;
	       ED->anz_Z_puffer= ED->v_RB->max+= new_Zeilen;
	       ED->puffer_len+= len;
	       tmp_ptr= (( ED->Y_cur+ new_Zeilen+ 1)< ED->v_RB->max) ? ( ED->Zeilen[ ED->Y_cur+ new_Zeilen+ 1]- 2) : ( ED->Zeilen[ 0]+ ED->puffer_len);
	       for( l= 1; l<= new_Zeilen; l++)
		  ED->Zeilen[ ED->Y_cur+ l]= ( char *)memchr( ED->Zeilen[ ED->Y_cur+ l- 1], '\n', tmp_ptr- ED->Zeilen[ ED->Y_cur+ l- 1])+ 1;
	       for( l= 0; l<= new_Zeilen; l++)
	       {
		  if( Zeile_len( ED, ED->Y_cur+ l)>= ED->h_RB->max)
		     ED->h_RB->max= Zeile_len( ED, ED->Y_cur+ l)+ 1;
	       }
	       ED->text_geaendert= 1;
	       if( ShowText_by_Cursor( ED))
		  View_Page( ED);
	       else
	       {
		  if( new_Zeilen== 0)
		     ScrollLine( ED->X_cur, ED->Y_cur, len, 0, ED, ED_RIGHT);
		  else
		     ScrollLine( ED->X_cur, ED->Y_cur, 0, new_Zeilen, ED, ED_DOWN);
	       }
	       _ViewAnfasser( ED->MS, ED->v_RB);
	       _ViewAnfasser( ED->MS, ED->h_RB);
	       FreeSpace( ED);
	    }
	    else
	    {
	       ED->Zeilen[ 0]= farrealloc( ED->Zeilen[ 0], ED->puffer_len); /* ursprngliche Speicherbelegung wiederherstellen */
	       ErrorMsg( KEIN_SPEICHER);
	       ret_val= -1;
	    }
	 }
	 else
	 {
	    ErrorMsg( KEIN_SPEICHER);
	    ED->Zeilen[ 0]= old_ptr;
	    ret_val= -1;
	 }
      }
      else
      {
	 Hinweis( "Maximum buffer size reached   ");
	 ret_val= -2;
      }
   }
   else
      Hinweis( "The clipboard is empty     ");
   return( ret_val);
}

static char *strn_str( char *s1, char *s2, size_t maxlen, BOOL ignore_case)
{
   int find= 1;
   unsigned len, i;

   len= strlen( s2);
   for( i= 0; ( *s1!= '\0')&& ( ( long)i<= ( ( long)maxlen- len)); i++)
      if(( find= ( ignore_case ? memicmp( s1++, s2, len) : memcmp( s1++, s2, len)))== 0)
	 break;
   return( ( find) ? ( NULL) : ( --s1));
}

BOOL _Search( Edit_struct *ED, char *text, BYTE from)
{
   Mark_struct old_MA, new_MA;
   unsigned text_len, search_rest_len= 0;
   long i, offset, z, search_rest_offset;
   BOOL rest_found= 0;
   char *tmp_ptr, search_rest[ 2* MAX_SUCHTEXT];

   if(( text!= NULL)&& ( *text!= '\0'))
   {
      if( ED->edit_view== EDIT)
      {
	 if( from== VOM_ANFANG)
	 {
	    i= 0;
	    offset= 0;
	 }
	 else
	 {
	    i= ED->Y_cur;
	    offset= ED->X_cur;
	 }
	 for( ; i< ED->v_RB->max; i++)
	 {
	    if(( tmp_ptr= strn_str( ED->Zeilen[ i]+ offset, text, Zeile_len( ED, i)- offset, ED->ignore_case))!= NULL)
	    {
	       Mark_to_Markstruct( &old_MA, ED, ED_SHOW);
	       ED->X_cur= ( ptrdiff_t)tmp_ptr- ( ptrdiff_t)ED->Zeilen[ i];
	       ED->Y_cur= i;
	       ED->X_mark= ED->X_cur+ strlen( text);
	       ED->Y_mark= i;
	       if( ED->text_mark)
	       {
		  Mark_to_Markstruct( &new_MA, ED, ED_SHOW);
		  if( memcmp( &old_MA, &new_MA, sizeof( Mark_struct))== 0)  /* ist diese Stelle schon markiert ? */
		  {
		     offset++;
		     i--;
		     continue;
		  }
	       }
	       Mark_Text( ED, &old_MA, AUS);
	       ED->text_mark= 1;
	       if( ShowText_by_Cursor( ED))
	       {
		  View_Page( ED);
		  _ViewAnfasser( ED->MS, ED->h_RB);
		  _ViewAnfasser( ED->MS, ED->v_RB);
	       }
	       else
	       {
		  Mark_to_Markstruct( &new_MA, ED, ED_SHOW);
		  Mark_Text( ED, &new_MA, AN);
	       }
	       Cursor_pos( ED);
	       return( 1);
	    }
	    offset= 0;
	 }
	 Hinweis( "The text could not be found          ");
      }
      else
      {
	 Mark_to_Markstruct( &old_MA, ED, ED_SHOW);
	 if( from== VOM_ANFANG)
	 {
	    if( ED->akt_block!= 0)
	    {
	       ED->akt_block= 0;
	       _Read_Array( ED);
	    }
	    ED->X_cur= 0;
	    ED->Y_cur= 0;
	 }
	 z= ED->Y_cur;
	 offset= ED->X_cur;
	 text_len= strlen( text);
	 check_Line_akt_Block( ED, z);
	 if(( z== ED->BI[ ED->akt_block].Zeilen_offset)&& ( offset< ED->BI[ ED->akt_block].X_off)&& ED->Text_davor)
	 {
	    ED->akt_block--;
	    _Read_Array( ED);
	 }
	 if(( z== ( ED->BI[ ED->akt_block].Zeilen_offset+ ED->anz_Z_puffer- 1))&& ( offset>= ED->last_X)&& ED->Text_folgt)
	 {
	    ED->akt_block++;
	    _Read_Array( ED);
	 }
	 while( z< ED->v_RB->max)
	 {
	    for( i= z- ED->BI[ ED->akt_block].Zeilen_offset; i< ED->anz_Z_puffer; i++, z++)
	    {
	       if( i== 0)
	       {
		  if( search_rest_len> 0)
		  {
		     memcpy( ( char huge *)search_rest+ search_rest_len, ED->Zeilen[ i], text_len- 1);
		     if(( tmp_ptr= strn_str( search_rest, text, search_rest_len+ text_len- 1, ED->ignore_case))!= NULL)
			rest_found= 1;
		     search_rest_len= 0;
		  }
		  if( offset>= ED->BI[ ED->akt_block].X_off)
		     offset-= ED->BI[ ED->akt_block].X_off;
	       }
	       if( rest_found|| (( tmp_ptr= strn_str( ED->Zeilen[ i]+ offset, text, _z_len_rel( ED, i)- offset, ED->ignore_case))!= NULL))
	       {
		  ED->Y_cur= z;
		  ED->Y_mark= z;
		  if( rest_found)
		     ED->X_cur= ( ( ptrdiff_t)tmp_ptr- ( ptrdiff_t)search_rest)+ search_rest_offset;
		  else
		     ED->X_cur= ( ptrdiff_t)tmp_ptr- ( ptrdiff_t)ED->Zeilen[ i];
		  ED->X_mark= ED->X_cur+ strlen( text);
		  if( rest_found)
		     rest_found= 0;
		  else
		  {
		     if( i== 0)
		     {
			ED->X_cur+= ED->BI[ ED->akt_block].X_off;
			ED->X_mark+= ED->BI[ ED->akt_block].X_off;
		     }
		  }
		  if( ED->text_mark)
		  {
		     Mark_to_Markstruct( &new_MA, ED, ED_SHOW);
		     if( memcmp( &old_MA, &new_MA, sizeof( Mark_struct))== 0)  /* ist diese Stelle schon markiert ? */
		     {
			offset++;
			i--;
			z--;
			continue;
		     }
		  }
		  Mark_Text( ED, &old_MA, AUS);
		  ED->text_mark= 1;
		  if( ShowText_by_Cursor( ED))
		  {
		     View_Page( ED);
		     _ViewAnfasser( ED->MS, ED->h_RB);
		     _ViewAnfasser( ED->MS, ED->v_RB);
		  }
		  else
		  {
		     Mark_to_Markstruct( &new_MA, ED, ED_SHOW);
		     Mark_Text( ED, &new_MA, AN);
		  }
		  Prozent_View( ED);
		  return( 1);
	       }
	       if( i== ( ED->anz_Z_puffer- 1))
	       {
		  search_rest_len= (( ED->last_X- offset)< MAX_SUCHTEXT- 2) ? ( ED->last_X- offset) : ( MAX_SUCHTEXT- 2);
		  search_rest_offset= ED->last_X- search_rest_len;
		  memcpy( search_rest, ED->Zeilen[ i]+ search_rest_offset, search_rest_len);
	       }
	       offset= 0;
	    }
	    if( ED->Text_folgt)
	    {
	       ED->akt_block++;
	       _Read_Array( ED);
	       z--;
	    }
	 }
	 if( z>= ED->v_RB->max)
	    Hinweis( "The text could not be found       ");
      }
   }
   else
      Hinweis( "A search phrase must be entered first              ");
   return( 0);
}

void _Texteingabe( Edit_struct *ED, not_use_key_struct *NUK)
{
   int ret_val, nrSpaces= 0, lineLen;
   BOOL added= FALSE;
   unsigned char Zeichen[ 2]= "X";
   char *searchPtr, spaceArray[]= "                                                  ";

   if(( NUK->Sondertaste& STRG_PRESS)== 0)
   {
      if( ED->text_mark)
	 _Clear( ED);
      if( NUK->Taste== '\r')
      {
	 if( Edit_PRG_Mode)
	 {
	    lineLen= ED->X_cur;
	    searchPtr= ED->Zeilen[ ED->Y_cur];
	    while(( lineLen--> 0)&& ( *searchPtr++== SPACE))
	       nrSpaces++;
	    if(( ret_val= _Paste( ED, "\r\n", 2))== 0)
	       Cursor_UP_DOWN_LEFT_RIGHT( ED, ED_RIGHT, 0);
	    while(( ret_val== 0)&& ( nrSpaces> 0))
	    {
	       if(( ret_val= _Paste( ED, spaceArray, min( sizeof( spaceArray)- 1, nrSpaces)))== 0)
	       {
		  Draw_Cursor( ED, ED->X_cur, ED->Y_cur, ED->h_RB->proz, ED->v_RB->proz, AUS);
		  ED->X_cur+= min( sizeof( spaceArray)- 1, nrSpaces);
		  added= TRUE;
	       }
	       nrSpaces-= sizeof( spaceArray)- 1;
	    }

	    if( ret_val== 0)
	       ED->X_cur--;
	    else
	    {
	       if( added)
		  Cursor_UP_DOWN_LEFT_RIGHT( ED, ED_RIGHT, 0);
	    }
	 }
	 else
	    ret_val= _Paste( ED, "\r\n", 2);
      }
      else
      {
	 *Zeichen= NUK->Taste;
	 ret_val= _Paste( ED, Zeichen, 1);
      }
      if( ret_val== 0)
	 Cursor_UP_DOWN_LEFT_RIGHT( ED, ED_RIGHT, 0);
   }
}

void _Delete( Edit_struct *ED)
{
   if( ED->text_mark)
      _Clear( ED);
   else
   {
      if( ED->X_cur< Zeile_len( ED, ED->Y_cur))
      {
	 ED->X_mark= ED->X_cur+ 1;
	 ED->Y_mark= ED->Y_cur;
      }
      else
      {
	 if( ED->Y_cur< ( ED->v_RB->max- 1))
	 {
	    ED->X_mark= 0;
	    ED->Y_mark= ED->Y_cur+ 1;
	 }
	 else
	    return;
      }
      ED->text_mark= 1;
      _Clear( ED);
   }
}

void _Backspace( Edit_struct *ED)
{
   if( ED->text_mark)
      _Clear( ED);
   else
   {
      if(( ED->X_cur> 0)|| ( ED->Y_cur> 0))
      {
	 Cursor_UP_DOWN_LEFT_RIGHT( ED, ED_LEFT, 0);
	 _Delete( ED);
      }
   }
}

void _Save( Edit_struct *ED)
{
   if( ED->TMP_file)
      _Speichern_unter( ED);
   else
   {
      lseek( ED->handle, 0L, SEEK_SET);
      if( _write( ED->handle, ED->Zeilen[ 0], ED->puffer_len)== -1)
	 ErrorMsg( WRITE_ERROR);
      chsize( ED->handle, ED->file_len= ED->puffer_len);
      ED->text_geaendert= 0;
      _FileLength( ED);
   }
}

char *get_TD( char *ret_array, char date_time)
{
   struct tm *time_now;
   time_t secs_now;
   char *dt_format[]= { "%d.%m.%Y",
			"%H:%M" };

   tzset();
   time( &secs_now);
   strftime( ret_array, MAXPATH, dt_format[ date_time], localtime( &secs_now));
   return( ret_array);
}

char *Get_Time( char *ret_array)
{
   return( get_TD( ret_array, 1));
}

char *Get_Date( char *ret_array)
{
   return( get_TD( ret_array, 0));
}

void Klick( void)
{
   int Taste;

   while(( MouseStat()== NOTHING)&& (( Taste= kbhit())== 0))
      Clock();
   if( Taste)
      if( !getch())
	 getch();
   screensp= 0;
}

void _Drucken( Edit_struct *ED)
{
   struct ftime ft;
   void *old_maus_cursor= last_maus_cursor;
   saveall sa;
   int X= 170, Y= 197, xsp= 0;
   unsigned prints;
   long offset= 0;
   char *mem_ptr;

   if(( ED->edit_view== EDIT)|| (( mem_ptr= malloc( 1024))!= NULL))
   {
      PCX_Window( &X, &Y, PCX_PRINT, &sa, SHADOW);
      MouseArt( maus_sanduhr);
      if( fprintf( stdprn, "%s\r\n    created on %d.%d.%d at %d:%02d\r\n\r\n", ED->file, ED->ft.ft_day, ED->ft.ft_month, ED->ft.ft_year+ 80, ED->ft.ft_hour, ED->ft.ft_min)!= EOF)
      {
	 if( ED->edit_view== EDIT)
	 {
	    do
	    {
	       if( Break( 250, 260, "Really end the\ncurrent process?"))
		  break;
	       (( ED->puffer_len- offset)> 1024) ? ( prints= 1024) : ( prints= ED->puffer_len- offset);
	       if( fwrite( ( char huge *)ED->Zeilen[ 0]+ offset, prints, 1, stdprn)!= 1)
	       {
		  ErrorMsg( "Could not print the text");
		  break;
	       }
	       offset+= prints;
	       ShowMouse( AUS);
	       Balken( X+ 15, Y+ 45, 269, 10, offset, ED->puffer_len, &xsp);
	       ShowMouse( AN);
	    }while( offset< ED->puffer_len);
	 }
	 else
	 {
	    if( lseek( ED->handle, 0L, SEEK_SET)!= -1)
	    {
	       do
	       {
		  if( Break( 250, 260, "Really end the\ncurrent process?"))
		     break;
		  (( ED->file_len- offset)> 1024) ? ( prints= 1024) : ( prints= ED->file_len- offset);
		  if(( _read( ED->handle, mem_ptr, prints)== -1)|| ( fwrite( mem_ptr, prints, 1, stdprn)!= 1))
		  {
		     ErrorMsg( "Could not print the text");
		     break;
		  }
		  offset+= prints;
		  ShowMouse( AUS);
		  Balken( X+ 15, Y+ 45, 269, 10, offset, ED->file_len, &xsp);
		  ShowMouse( AN);
	       }while( offset< ED->file_len);
	    }
	    else
	       ErrorMsg( READ_ERROR);
	    free( mem_ptr);
	 }
      }
      else
	 ErrorMsg( "Could not print the text");
      MouseArt( old_maus_cursor);
      ShowMouse( AUS);
      BigScreenRestore( &sa, X, Y);
      ShowMouse( AN);
   }
   else
      ErrorMsg( KEIN_SPEICHER);
}

int _Editmenu( void)
{
   int status, X= 8, Y= 45;
   char *msg[]= { "Search the file for text",
		  "Search the file again with the previous text",
		  "Put the cursor at the start of a specified line         ",
		  "Insert current time at the cursor position     ",
		  "Insert current date at the cursor position   ",
		  "Insert a directory name at the cursor position  ",
		  "Insert a complete filename at the cursor position         ",
		  "Save file      ",
		  "Save file under another name             ",
		  "Print out file  "};
   WORD mauspos[]= { BUTTON3|    FRAME| KEY|            MSG,   5, 144,   5,  26, 's',
		     BUTTON3|    FRAME| KEY|            MSG,   5, 144,  27,  48, 'w',
		     BUTTON3|    FRAME| KEY|            MSG,   5, 144,  49,  70, 'g',
		     BUTTON3|    FRAME| KEY|            MSG,   5, 144,  81, 102, 'z',
		     BUTTON3|    FRAME| KEY|            MSG,   5, 144, 103, 124, 't',
		     BUTTON3|    FRAME| KEY|            MSG,   5, 144, 125, 146, 'v',
		     BUTTON3|    FRAME| KEY|            MSG,   5, 144, 147, 168, 'f',
		     BUTTON3|    FRAME| KEY|            MSG,   5, 144, 179, 200, 'e',
		     BUTTON3|    FRAME| KEY|            MSG,   5, 144, 201, 222, 'u',
		     BUTTON3|    FRAME| KEY|            MSG,   5, 144, 233, 254, 'd',
		     BUTTON3|    FRAME| KEY| DEFBUTTON,        5, 144, 265, 286, 'a',
		     TASTE, ESC };
   MAUSStruct MS= { DEFAULT, DEFAULT, 150, 292, 12, INIT, NULL, AN};

   MS.x= &X;
   MS.y= &Y;
   MS.msg= msg;
   MS.mauspos= mauspos;
   PCX_Window( MS.x, MS.y, PCX_EDIT_MENU, &MS.sa, SHADOW);
   while(( status= __CheckMousepos( &MS))== -1)
   {
      if( MStat.buttons!= NOTHING) /* wenn geklickt wurde und status== -1 ist, dann wurde auerhalb der Elemente geklickt */
      {
	 status= 12;
	 break;
      }
   }
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   if(( status== 11)|| ( status== 12)) /* ESC, auerhalb des Mens geklickt */
      status= -1;
   return( status);
}

extern BOOL isTxtFile( char *filename);

int _Hex_Ascii( char *filename)
{
   int status, X= 240, Y= 200;
   char *msg[]= { "Show the selected file as hexadecimal (byte dump)              ",
		  "Show the selected file as normal ASCII text             "};
   WORD mauspos[]= { BUTTON| FRAME| KEY,                   5,  27,   5,  21, ESC,
		     BUTTON| FRAME| KEY|            MSG,  11,  80,  29,  82, 'h',
		     BUTTON| FRAME| KEY|            MSG,  85, 154,  29,  82, 'a',
		     MOVEWINDOW
		     };
   MAUSStruct MS= { DEFAULT, DEFAULT, 166, 95, 4, INIT, NULL, AN};

   mauspos[ ( isTxtFile( filename)) ? 12 : 6]|= DEFBUTTON;
   MS.x= &X;
   MS.y= &Y;
   MS.msg= msg;
   MS.mauspos= mauspos;
   PCX_Window( MS.x, MS.y, PCX_VIEWER_HEX_ASCII, &MS.sa, SHADOW);
   while(( status= __CheckMousepos( &MS))== -1)
      ;
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   return( status);
}

void _Speichern_unter( Edit_struct *ED)
{
   int ret= 0, ret_val= 0, handle, X= 165, Y= 150, X_tree= 300;
   char file[ MAXPATH], z_path[ MAXPATH+ MAXPATH];
   void *arg_ptr[ 3];
   char *msg[]= { "Enter filename or complete path with filename             "};
   WORD mauspos[]= { BUTTON|   FRAME| KEY,              5,  27,   5,  21, ESC,
		     FILEINPUTNOBOX| IGN_CASE| FRAME| KEY| DEFBUTTON| MSG,  18,  44, 149, MAXPATH- 1, 'd',
		     DIRINPUT| IGN_CASE| FRAME| KEY,             18,  79, 273, MAXDIR- 1, 245, 37, LWAUSWAHL, 'v',
		     BUTTON|   FRAME| KEY,             18, 150, 109, 134, RETURN,
		     BUTTON|   FRAME| KEY,            160, 291, 109, 134, 'a',
		     MOVEWINDOW
		     };
   MAUSStruct MS= { DEFAULT, DEFAULT, 310, 151, 6, INIT, NULL, AN};

   if( ED->TMP_file)
   {
      arg_ptr[ 0]= strcpy( file, "NONAME");
      arg_ptr[ 1]= Path_to_Dir( z_path, ( ED->DW->verzeichnis!= NULL) ? ED->DW->verzeichnis : ED->file);
   }
   else
   {
      arg_ptr[ 0]= Get_Filter( file, ED->file);
      arg_ptr[ 1]= Path_to_Dir( z_path, ED->file);
   }
   arg_ptr[ 2]= &X_tree;
   MS.x= &X;
   MS.y= &Y;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_EDITOR_SPEICHERN_UNTER, &MS.sa, SHADOW);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	  case 3:                                                     /* OK */
	     if( isalpha( file[ 0])&& ( strncmp( &file[ 1], ":\\", 2)== 0))
		strcpy( z_path, file);
	     else
		Paste_Filter_to_Dir( z_path, file);

	     if( stricmp( z_path, ED->file)== 0)
	     {
		ED->TMP_file= 0;
		_Save( ED);
	     }
	     else
	     {
		if( access( z_path, 0)== 0)
		{
		   if( Info_Frage( 250, 230, "The file already\nexists.\nSave anyway?", FRAGE)== 0) /* ja */
		      chmod( z_path, S_IWRITE);
		   else
		      ret_val= 1;
		}
		if( ret_val== 0)
		{
		   if(( handle= _creat( z_path, 0))!= -1)
		   {
		      if( _write( handle, ED->Zeilen[ 0], ED->puffer_len)!= -1)
		      {
			 _close( ED->handle);
			 if( ED->TMP_file)
			 {
			    unlink( ED->file);
			    ED->TMP_file= 0;
			 }
			 ED->text_geaendert= 0;
			 ED->handle= handle;
			 ED->file_len= ED->puffer_len;
			 _FileLength( ED);
			 strcpy( ED->file, z_path);
			 MOverTextxy( 78, 442, MakeShowPath( ED->file, z_path, 38), 38);
		      }
		      else
			 ErrorMsg( WRITE_ERROR);
		   }
		   else
		      ErrorMsg( CREAT_ERROR);
		}
	     }
	  case 0:                                                    /* ESC */
	  case 4:                                                /* Abbruch */
	     ret= 1;
	     break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
}

void _Suchen( Edit_struct *ED)
{
   int ret= 0, X= 191, Y= 200;
   void *arg_ptr[ 2];
   WORD mauspos[]= { BUTTON|   FRAME| KEY,              5,  27,   5,  21, ESC,
		     INPUT|    FRAME| KEY| DEFBUTTON,  19,  44, 219, MAX_SUCHTEXT- 1, 't',
		     CHECKBOX| FRAME| KEY,             19,  67, 'g',
		     BUTTON|   FRAME| KEY,             19, 125,  89, 114, RETURN,
		     BUTTON|   FRAME| KEY,            131, 238,  89, 114, 'a',
		     MOVEWINDOW
		     };
   MAUSStruct MS= { DEFAULT, DEFAULT, 258, 132, 6, INIT, NULL, AUS};

   arg_ptr[ 0]= ED->search;
   arg_ptr[ 1]= &ED->ignore_case;
   MS.x= &X;
   MS.y= &Y;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_TEXT_SUCHEN, &MS.sa, SHADOW);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 3:                                                      /* OK */
	    ret= 2;
	    break;
	 case 0:                                                     /* ESC */
	 case 4:                                                 /* Abbruch */
	    ret= 1;
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   if( ret== 2)
      _Search( ED, ED->search, VOM_ANFANG);
}

void _Go_to_line( Edit_struct *ED)
{
   Cursor_struct CM;
   Mark_struct MA;
   int X= 219, Y= 200;
   long zeilen_nr;
   char Zeile[ 10]= "";

   WORD mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
		     INPUT|       FRAME| KEY| DEFBUTTON,  18,  42, 165,  sizeof( Zeile)- 1, 'z',
		     BUTTON|      FRAME| KEY,             17,  97,  65,  90, RETURN,
		     BUTTON|      FRAME| KEY,            104, 184,  65,  90, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 202, 103, 5, INIT, NULL, AUS};

   MS.x= &X;
   MS.y= &Y;
   MS.mauspos= mauspos;
   if( INPUTWindow( Zeile, PCX_ZEIGE_ZEILE, &MS)== 0)         /* alles o.k. */
   {
      zeilen_nr= atol( Zeile);
      if(( zeilen_nr> 0)&& ( zeilen_nr<= ED->v_RB->max))
      {
	 ClearMark( ED);
	 if( ED->edit_view== EDIT)
	 {
	    CM.X_cur= 0;
	    CM.Y_cur= zeilen_nr- 1;
	    MoveCursor( &CM, ED);
	 }
	 else
	 {
	    ED->X_cur= 0;
	    ED->Y_cur= zeilen_nr- 1;
	    ED->X_mark= Zeile_len( ED, ED->Y_mark= ED->Y_cur);
	    ED->text_mark= 1;
	    Prozent_View( ED);
	 }
	 if( ShowText_by_Cursor( ED))
	 {
	    View_Page( ED);
	    _ViewAnfasser( ED->MS, ED->v_RB);
	    _ViewAnfasser( ED->MS, ED->h_RB);
	 }
	 else
	 {
	    if( ED->edit_view== VIEW)
	    {
	       Mark_to_Markstruct( &MA, ED, ED_SHOW);
	       Mark_Text( ED, &MA, AN);
	    }
	 }
      }
      else
	 ErrorMsg( "Line number is outside the range allowed          ");
   }
}

void _Editor_Viewer( char *file, BYTE _edit_view, DATWINStruct *DW)
{
   Edit_struct ED= { 0};
   RBalken v_RB= { 618,  49, 412, VERT_DIR,  1, MAX_SICHT_ZEILEN,  0L, 0L, 0L};
   RBalken h_RB= {   9, 416, 614, HORIZ_DIR, 1, MAX_SICHT_SPALTEN, 0L, 0L, 0L};
   int ret= 0, Dummy= 0, Y_Dummy= 47, X_tree= 100, X_lw= 100, Y_lw= 50;
   char tmp_array[ MAXPATH];
   not_use_key_struct NUK;
   BOOL shift;
   void *arg_ptr[ 7];
   char *view_msg[]= { "Search the file for text",
		       "Search the file again with the previous text",
		       "Display a specified line          ",
		       "Print out file    " };
   char *edit_msg[]= { "Search, save, print, ... call up",
		       "Cut selected text (copy into the clipboard)                  ",
		       "Erase selected text   ",
		       "Copy selected text into the clipboard      ",
		       "Paste contents of the clipboard at the cursor position  ",
		       "Quick copy and paste with left and right mouse buttons          ",
		       "Programming mode (automatic indentation of each line)        "};
   WORD view_mauspos[]= { BUTTON|     FRAME| KEY| DEFBUTTON,      3,  25,   3,  19, ESC,
			  ROLLBALKEN|        KEY,                 1, 1, PAGE_UP, PAGE_DOWN, HOME, END, 1,
			  ROLLBALKEN,
			  TASTE, CURSOR_UP,
			  TASTE, CURSOR_DOWN,
			  TASTE, CURSOR_LEFT,
			  TASTE, CURSOR_RIGHT,
			  BUTTON3|    FRAME| KEY|            MSG,   5, 130,  23,  44, ALT_S,
			  BUTTON3|    FRAME| KEY|            MSG, 131, 256,  23,  44, ALT_W,
			  BUTTON3|    FRAME| KEY|            MSG, 257, 382,  23,  44, ALT_Z,
			  BUTTON3|    FRAME| KEY|            MSG, 383, 508,  23,  44, ALT_D,
			  BUTTON3|    FRAME| KEY,                 509, 634,  23,  44, ALT_A,
			  };
   WORD edit_mauspos[]= { BUTTON|     FRAME| KEY| DEFBUTTON,      3,  25,   3,  19, ESC,
			  ROLLBALKEN|        KEY,                 1, 1, ALT_PAGE_UP, ALT_PAGE_DOWN, ALT_POS1, ALT_ENDE, 1,
			  ROLLBALKEN,
			  TASTE, CURSOR_UP,
			  TASTE, CURSOR_DOWN,
			  TASTE, CURSOR_LEFT,
			  TASTE, CURSOR_RIGHT,
			  PUSHAREA,                               X_BEGINN, X_ENDE, Y_BEGINN, Y_ENDE,
			  BUTTON3|    FRAME| KEY|            MSG,   5, 130,  23,  44, ALT_F,
			  BUTTON3|    FRAME| KEY|            MSG, 131, 158,  23,  44, SHIFT_DELETE,
			  BUTTON3|    FRAME| KEY|            MSG, 159, 186,  23,  44, STRG_DELETE,
			  BUTTON3|    FRAME| KEY|            MSG, 187, 214,  23,  44, STRG_INSERT,
			  BUTTON3|    FRAME| KEY|            MSG, 215, 242,  23,  44, SHIFT_INSERT,
			  CHECKBOX|   FRAME| KEY|            MSG, 249,  27, ALT_E,
			  CHECKBOX|   FRAME| KEY|            MSG, 306,  27, ALT_P,
			  HOTAREA,                                 10, 613,  50, 411,
			  HOTAREA,                                  0, 639,   0, 479,
			  TASTE, SHIFT_CURSOR_UP,
			  TASTE, SHIFT_CURSOR_DOWN,
			  TASTE, SHIFT_CURSOR_LEFT,
			  TASTE, SHIFT_CURSOR_RIGHT,
			  TASTE, SHIFT_PAGE_UP,
			  TASTE, SHIFT_PAGE_DOWN,
			  TASTE, SHIFT_POS1,
			  TASTE, SHIFT_ENDE,
			  TASTE, PAGE_UP,
			  TASTE, PAGE_DOWN,
			  TASTE, HOME,
			  TASTE, END,
			  TASTE, STRG_SHIFT_POS1,
			  TASTE, STRG_SHIFT_ENDE,
			  TASTE, STRG_POS1,
			  TASTE, STRG_ENDE,
			  TASTE, DELETE,
			  TASTE, BACKSPACE,
			  TASTE, ALT_W,
			  NOT_USE_KEY
			  };
   MAUSStruct MS= { DEFAULT, DEFAULT, 640, 480, DEFAULT, INIT, NULL, AN};

   ED.xEdit= Edit_X_Term;

   arg_ptr[ 0]= &v_RB;
   arg_ptr[ 1]= Dummy_Balken;
   arg_ptr[ 2]= &h_RB;
   arg_ptr[ 3]= Dummy_Balken;
   arg_ptr[ 4]= &ED.xEdit;
   arg_ptr[ 5]= &Edit_PRG_Mode;
   arg_ptr[ 6]= &NUK;
   MS.x= &Dummy;
   MS.y= &Dummy;
   if( _edit_view== EDIT)
   {
      MS.spotanz= 37;
      MS.msg= edit_msg;
      MS.mauspos= edit_mauspos;
   }
   else
   {
      MS.spotanz= 12;
      MS.msg= view_msg;
      MS.mauspos= view_mauspos;
   }
   MS.arg_ptr= arg_ptr;
   ShowMouse( AUS);
   SaveAll( &MS.sa);
   ShowMouse( AN);
   PCX_Window( MS.x, MS.y, ( _edit_view== EDIT) ? PCX_EDITOR_LEISTE : PCX_VIEWER_LEISTE, NULL, NO_SHADOW);
   PCX_Window( MS.x, &Y_Dummy, PCX_EDITOR_VIEWER, NULL, NO_SHADOW);
   uhrsp= -1;
   Clock();
   ED.ignore_case= TRUE;
   ED.MS= &MS;
   ED.DW= DW;
   ED.X_cur= 0;
   ED.Y_cur= 0;
   ED.file= file;
   ED.v_RB= &v_RB;
   ED.h_RB= &h_RB;
   switch( _edit_view)
   {
      case EDIT:
	 ED.hex_ascii= ED_ASCII;
	 ED.edit_view= EDIT;
	 break;
      case VIEW:
	 ED.hex_ascii= _Hex_Ascii( file);
	 ED.edit_view= VIEW;
	 break;
      case VIEW_HEX:
	 ED.hex_ascii= ED_HEX;
	 ED.edit_view= VIEW;
	 break;
      case VIEW_ASCII:
	 ED.hex_ascii= ED_ASCII;
	 ED.edit_view= VIEW;
	 break;
   }
   if(( ED.hex_ascii!= ED_ESC)&& (( ret= _Beginn( &ED))== 0))
   {
      if((( ret= setjmp( ERROR_jmp))== 0)&& (( ret= _Read_Array( &ED))== 0))
      {
	 MOverTextxy(  78, 442, MakeShowPath( ED.file, tmp_array, 38), 38);
	 if( ED.edit_view== EDIT)
	 {
	    FreeSpace( &ED);
	    Cursor_pos( &ED);
	 }
	 else
	    Prozent_View( &ED);
	 View_Page( &ED);
	 do
	 {
	    shift= 0;
	    switch( __CheckMousepos( &MS))
	    {
	       case 0:                                               /* ESC */
		  if( ED.edit_view== EDIT)
		     goto EDITOR_ENDE;
		  else
		     ret= 1;
		  break;
	       case 1:                                      /* v_Rollbalken */
		  V_RB:
		  ;
		  switch( v_RB.ret_val)
		  {
		     case ONE_ELEMENT_UP:
			Page_Up_Down_Left_Right( &ED, ED_DOWN);
			break;
		     case ONE_ELEMENT_DOWN:
			Page_Up_Down_Left_Right( &ED, ED_UP);
			break;
		     case ELEMENT_RANDOM:
			View_Page( &ED);
			break;
		  }
		  break;
	       case 2:                                      /* h_Rollbalken */
		  H_RB:
		  ;
		  switch( h_RB.ret_val)
		  {
		     case ONE_ELEMENT_LEFT:
			Page_Up_Down_Left_Right( &ED, ED_RIGHT);
			break;
		     case ONE_ELEMENT_RIGHT:
			Page_Up_Down_Left_Right( &ED, ED_LEFT);
			break;
		     case ELEMENT_RANDOM:
			View_Page( &ED);
			break;
		  }
		  break;
	       case 17:
		  shift= 1;
	       case 3:
		  if( ED.edit_view== EDIT)
		     Cursor_UP_DOWN_LEFT_RIGHT( &ED, ED_UP, shift);
		  else
		  {
		     if( KlickRollBalken( ED.MS, ED.v_RB, Dummy_Balken, RBALKEN_MINUS_MIN_MAUS)== ONE_ELEMENT_UP)
			Page_Up_Down_Left_Right( &ED, ED_DOWN);
		  }
		  break;
	       case 18:
		  shift= 1;
	       case 4:
		  if( ED.edit_view== EDIT)
		     Cursor_UP_DOWN_LEFT_RIGHT( &ED, ED_DOWN, shift);
		  else
		  {
		     if( KlickRollBalken( ED.MS, ED.v_RB, Dummy_Balken, RBALKEN_PLUS_MIN_MAUS)== ONE_ELEMENT_DOWN)
			Page_Up_Down_Left_Right( &ED, ED_UP);
		  }
		  break;
	       case 19:
		  shift= 1;
	       case 5:
		  if( ED.edit_view== EDIT)
		     Cursor_UP_DOWN_LEFT_RIGHT( &ED, ED_LEFT, shift);
		  else
		  {
		     if( KlickRollBalken( ED.MS, ED.h_RB, Dummy_Balken, RBALKEN_MINUS_MIN_MAUS)== ONE_ELEMENT_LEFT)
			Page_Up_Down_Left_Right( &ED, ED_RIGHT);
		  }
		  break;
	       case 20:
		  shift= 1;
	       case 6:
		  if( ED.edit_view== EDIT)
		     Cursor_UP_DOWN_LEFT_RIGHT( &ED, ED_RIGHT, shift);
		  else
		  {
		     if( KlickRollBalken( ED.MS, ED.h_RB, Dummy_Balken, RBALKEN_PLUS_MIN_MAUS)== ONE_ELEMENT_RIGHT)
			Page_Up_Down_Left_Right( &ED, ED_LEFT);
		  }
		  break;
	       case 7:                                   /* direkt geklickt */
		  if( ED.edit_view== EDIT)
		     Cursor_Mark( &ED);
		  else
		     _Suchen( &ED);
		  break;
	       case 8:
		  if( ED.edit_view== EDIT)
		  {
		     MouseArt( maus_pfeil);
		     switch( _Editmenu())
		     {
			case 0:                                   /* Suchen */
			   _Suchen( &ED);
			   break;
			case 1:                                  /* weiter~ */
			   _Search( &ED, ED.search, VON_AKTPOS);
			   break;
			case 2:                            /* Gehe zu Zeile */
			   _Go_to_line( &ED);
			   break;
			case 3:                             /* Uhrzeit einf */
			   Get_Time( tmp_array);
			   _Paste( &ED, tmp_array, strlen( tmp_array));
			   break;
			case 4:                               /* Datum einf */
			   Get_Date( tmp_array);
			   _Paste( &ED, tmp_array, strlen( tmp_array));
			   break;
			case 5:                         /* Verzeichnis einf */
			   if( !ShowTree( tmp_array, &X_tree, LWAUSWAHL))
			      _Paste( &ED, tmp_array, strlen( tmp_array));
			   break;
			case 6:                               /* Datei einf */
			   if( !LwBox( &X_lw, &Y_lw, DEFAULT, "*.*", tmp_array))
			      _Paste( &ED, tmp_array, strlen( tmp_array));
			   break;
			case 7:                                /* Speichern */
			   _Save( &ED);
			   break;
			case 8:                                   /* ~unter */
			   _Speichern_unter( &ED);
			   break;
			case 9:                                  /* Drucken */
			   _Drucken( &ED);
			   break;
			case 10:                                 /* Abbruch */
			   EDITOR_ENDE:
			   ;
			   MouseArt( maus_pfeil);
			   if( ED.text_geaendert)
			   {
			      switch( Info_Frage( 200, 150, "The file has been\nchanged!  Save\nchanged file?", FRAGE))
			      {
				 case 0:                              /* ja */
				    _Save( &ED);
				 case 1:                            /* nein */
				    ret= 1;
				 case 2:                    /* ESC, Abbruch */
				    break;
			      }
			   }
			   else
			      ret= 1;
			   break;
		     }
		  }
		  else
		     _Search( &ED, ED.search, VON_AKTPOS);
		  break;
	       case 9:
		  if( ED.edit_view== EDIT)
		     _Cut( &ED);
		  else
		     _Go_to_line( &ED);
		  break;
	       case 10:
		  if( ED.edit_view== EDIT)
		     _Clear( &ED);
		  else
		     _Drucken( &ED);
		  break;
	       case 11:
		  if( ED.edit_view== EDIT)
		     _Copy( &ED);
		  else
		     ret= 1;                                     /* Abbruch */
		  break;
	       case 12:
		  _Paste( &ED, textClipboard, textClipboardLen);
		  break;
	       case 14:                                         /* PRG_Mode */
		  veraendert= 1;
		  break;
	       case 15:
		  if( last_maus_cursor== maus_pfeil)
		     MouseArt( maus_text);
		  break;
	       case 16:
		  if( last_maus_cursor== maus_text)
		     MouseArt( maus_pfeil);
		  break;
	       case 21:
		  shift= 1;
	       case 25:
		  Cursor_UP_DOWN_LEFT_RIGHT( &ED, ED_PG_UP, shift);
		  break;
	       case 22:
		  shift= 1;
	       case 26:
		  Cursor_UP_DOWN_LEFT_RIGHT( &ED, ED_PG_DN, shift);
		  break;
	       case 23:
		  shift= 1;
	       case 27:
		  Cursor_UP_DOWN_LEFT_RIGHT( &ED, ED_POS1, shift);
		  break;
	       case 24:
		  shift= 1;
	       case 28:
		  Cursor_UP_DOWN_LEFT_RIGHT( &ED, ED_ENDE, shift);
		  break;
	       case 29:
		  shift= 1;
	       case 31:
		  Cursor_UP_DOWN_LEFT_RIGHT( &ED, ED_DOC_ANF, shift);
		  break;
	       case 30:
		  shift= 1;
	       case 32:
		  Cursor_UP_DOWN_LEFT_RIGHT( &ED, ED_DOC_END, shift);
		  break;
	       case 33:                                     /* Taste DELETE */
		  _Delete( &ED);
		  break;
	       case 34:                                  /* Taste BACKSPACE */
		  _Backspace( &ED);
		  break;
	       case 35:                                      /* Taste ALT_W */
		  _Search( &ED, ED.search, VON_AKTPOS);
		  break;
	       case 36:
		  _Texteingabe( &ED, &NUK);
		  break;
	       default:
		  Cursor_Blinken( &ED);
		  break;
	    }
	 }while( !ret);
      }
      Free_ED_VI_Array( &ED);
   }
   MouseArt( maus_pfeil);
   if( ret< 0)
      Klick();
   ShowMouse( AUS);
   RestoreAll( &MS.sa);
   ShowMouse( AN);
}
