/*  CDPLAYER.C  CDPlayer
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <graphics.h>
#include <dos.h>
#include <io.h>
#include <dir.h>
#include <string.h>
#include <conio.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"
#include "cd_op.h"

void CD_Player( void)
{
   QChannel_Info qinfo;
   CD_Addr SongLen;
   char Play_Intro= AUS, buffer[ 10];
   int intro_z, status, ret= 0, Anz_Songs, Akt_Song, Song, X;
   WORD Stat, Sekunden= 0, old_sec= 0;
   DWORD L_Stat;
   void *arg_ptr[ 2];
   char *msg[]= { "Go straight to track  ",
		  "Play previous track           ",
		  "Play audio CD     ",
		  "Play 15 seconds of each track       ",
		  "Play next track         ",
		  "Go back 15 seconds",
		  "Pause/unpause CD                                          ",
		  "Stop playing the CD      ",
		  "Change CD                               ",
		  "Forwards 15 seconds " };
   WORD mauspos[]= { BUTTON|     FRAME| KEY| DEFBUTTON,        7,  29,   7,  23, ESC,
		     LAUFLEISTE| FRAME| KEY|            MSG,  13,  38, 373,   1,  4560,  1, CURSOR_LEFT, CURSOR_RIGHT,
		     BUTTON2|    FRAME| KEY|            MSG,  13,  47,  71,  93, '1',
		     BUTTON2|    FRAME| KEY|            MSG,  49, 137,  71,  93, '1',
		     BUTTON2|    FRAME| KEY|            MSG, 139, 173,  71,  93, '1',
		     BUTTON2|    FRAME| KEY|            MSG, 175, 209,  71,  93, '1',
		     BUTTON2|    FRAME| KEY|            MSG,  13,  47,  95, 117, '1',
		     BUTTON2|    FRAME| KEY|            MSG,  49,  92,  95, 117, '1',
		     BUTTON2|    FRAME| KEY|            MSG,  94, 137,  95, 117, '1',
		     BUTTON2|    FRAME| KEY|            MSG, 139, 173,  95, 117, '1',
		     BUTTON2|    FRAME| KEY|            MSG, 175, 209,  95, 117, '1',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 400, 130, 12, INIT, NULL, AN};

   ( char *)arg_ptr[ 0]= "";
   arg_ptr[ 1]= &Sekunden;
   MS.x= &CD_player_X;
   MS.y= &CD_player_Y;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_CDPLAYER, &MS.sa, SHADOW);
   switch( Anz_Songs= init_CDAudio())
   {
      case NODRIVE:
      case NOAUDIO:
	 Info_Frage( 350, 300, "You do not have\na CD-ROM drive\nwhich can play\naudio CDs.", INFO);
	 break;
   }
   if(( Anz_Songs>= 0)|| ( Anz_Songs== NOTREADY))
   {
      do
      {
	 Sekunden= old_sec= ret= 0;
	 if( !(( L_Stat= get_Status( get_audio_drive()))& DOOR_OPEN)&& !( L_Stat& NO_CD_INSERT))
	 {
	    Anz_Songs= re_init_CDAudio();
	    mauspos[ 11]= CD_length_in_Sec();        /* Gesammtlnge in Sec */
	    ShowMouse( AUS);
	    setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
	    bar( *MS.x+ 48, *MS.y+ 27, *MS.x+ 348, *MS.y+ 35);
	    for( status= 1; status<= Anz_Songs; status++)
	    {
	       X= (( ( double)Song_Begin_in_Sec( status)/ ( double)CD_length_in_Sec())* ( double)301.0)+ *MS.x+ 49;
	       setcolor( EGA_DARKGRAY);
	       line( X, *MS.y+ 28, X, *MS.y+ 34);
	       setcolor( EGA_WHITE);
	       line( X+ 1, *MS.y+ 28, X+ 1, *MS.y+ 34);
	    }
	    ShowMouse( AN);
	 }
	 do
	 {
	    do
	    {
	       if( get_Media_Changed()!= NOT_CHANGED)
	       {
		  ret= NOCHMAL;
	       }
	       else
	       {
		  if( Anz_Songs!= NOTREADY)
		  {
		     qinfo= read_QChannel();
		     if(( Sekunden= qinfo.dmin* 60+ qinfo.dsec)!= old_sec)
		     {
			SongLen= get_len( Akt_Song= (( qinfo.tno>> 4)* 10+ ( qinfo.tno& 0x0F)));
			setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
			ShowMouse( AUS);
			bar( *MS.x+ 262, *MS.y+ 76, *MS.x+ 302, *MS.y+ 113);
			bar( *MS.x+ 333, *MS.y+ 76, *MS.x+ 373, *MS.y+ 113);
			setcolor( EGA_BLACK);
			sprintf( buffer, "%2d", Akt_Song);
			outtextxy( *MS.x+ 274, *MS.y+ 76, buffer);
			sprintf( buffer, "%2d", Anz_Songs);
			outtextxy( *MS.x+ 347, *MS.y+ 76, buffer);
			sprintf( buffer, "%2d:%.2d", qinfo.tmin, qinfo.tsec);
			outtextxy( *MS.x+ 262, *MS.y+ 91, buffer);
			sprintf( buffer, "%2d:%.2d", SongLen.TIME.minute, SongLen.TIME.second);
			outtextxy( *MS.x+ 333, *MS.y+ 91, buffer);
			SongLen= get_len( 0);
			sprintf( buffer, "%2d:%.2d", qinfo.dmin, qinfo.dsec);
			outtextxy( *MS.x+ 262, *MS.y+ 106, buffer);
			sprintf( buffer, "%2d:%.2d", SongLen.TIME.minute, SongLen.TIME.second);
			outtextxy( *MS.x+ 333, *MS.y+ 106, buffer);
			_LaufLeiste( *MS.x+ 13, *MS.y+ 38, 373, "", old_sec= Sekunden, 1, CD_length_in_Sec(), AN);
			ShowMouse( AN);
		     }
		  }
	       }
	    }while((( status= __CheckMousepos( &MS))== -1)&& ( Play_Intro== AUS)&& !ret);
	    if( Play_Intro== AN)
	    {
	       if( status== -1)
		  status= 4;
	       else
		  Play_Intro= AUS;
	    }
	    Akt_Song= get_actual_track();
	    switch( status)
	    {
	       case 0:                                               /* ESC */
		  ret= ABBRUCH;
		  break;
	       case 1:                                    /* direkt gesetzt */
		  qinfo= read_QChannel();
		  Skip_Audio(( ( long)Sekunden* 75L)- ( ( long)qinfo.dmin* 4500L+ ( long)qinfo.dsec* 75L+ ( long)qinfo.dframe));
		  break;
	       case 2:                                      /* Titel zurck */
		  if(( qinfo.dmin* 60+ qinfo.dsec+ qinfo.dframe/ 75)< ( Song_Begin_in_Sec( Akt_Song)+ 2))
		     ( Akt_Song== 1) ? ( Song= Anz_Songs) : ( Song= Akt_Song- 1);
		  else
		     Song= Akt_Song;
		  Stop_Audio();
		  Play_Tracks( Song, Anz_Songs);
		  break;
	       case 3:                                              /* Play */
		  if( !audio_busy())
		     Play_Tracks( 1, Anz_Songs);
		  break;
	       case 4:                              /* alle Titel anspielen */
		  if( Play_Intro== AUS)
		  {
		     Stop_Audio();
		     Play_Intro= AN;
		     intro_z= 1;
		  }
		  if( intro_z<= Anz_Songs)
		  {
		     if( !audio_busy())
			Play_Track_Intro( intro_z++);
		  }
		  else
		     Play_Intro= AUS;
		  break;
	       case 5:                                    /* nchster Titel */
		  ( Akt_Song== Anz_Songs) ? ( Song= 1) : ( Song= Akt_Song+ 1);
		  Stop_Audio();
		  Play_Tracks( Song, Anz_Songs);
		  break;
	       case 6:                                     /* 15 Sec zurck */
		  Skip_Audio( -15* 75);
		  break;
	       case 7:                                             /* Pause */
		  if( audio_busy())
		     Stop_Audio();                               /* PAUSE */
		  else
		     Resume_Audio();                            /* Weiter ! */
		  break;
	       case 8:                                              /* Stop */
		  if( audio_busy())
		     Stop_Audio();
		  break;
	       case 9:                                /* Auswurf/ Einziehen */
		  if( get_Status( get_audio_drive())& DOOR_OPEN)
		     Stat= insert_CD();
		  else
		     Stat= eject_CD();
		  if(( Stat& 0x8000)&& (( Stat& 0x00FF)== 3))
		     Info_Frage( 200, 230, "You do not have\nautomatic ejection\non your CD-ROM\ndrive.", INFO);
		  break;
	       case 10:                                  /* 15 Sec vorwrts */
		  Skip_Audio( 15* 75);
		  break;
	    }
	    if( status!= 0)                                     /* kein ESC */
	       delay( 500);       /* Verzgerung, damit Q-Kanal Info stimmt */
	 }while( !ret);
      }while( ret== NOCHMAL);
   }
   Free_CD_Res();
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
}
