!include "..\config.mak"

.AUTODEPEND

#               *Implicit Rules*
.c.obj:
  $(CC) +SYS.CFG -c {$< }

.cpp.obj:
  $(CC) +SYS.CFG -c {$< }

#		*List Macros*

LIBS =  ..\lib\device.lib

EXE_dependencies =  \
 sys.obj \
 $(LIBS)

#		*Explicit Rules*
production:     ..\bin\sys.com

..\bin\sys.com: sys.com
                copy sys.com ..\bin

#sys.com:        sys.exe
#                ..\utils\exe2bin sys.exe sys.com

b_fat12.h:      ..\boot\b_fat12.bin bin2c.com
                bin2c ..\boot\b_fat12.bin b_fat12.h b_fat12

b_fat16.h:      ..\boot\b_fat16.bin bin2c.com
                bin2c ..\boot\b_fat16.bin b_fat16.h b_fat16

#sys.exe:        sys.cfg $(EXE_dependencies)

sys.com:        sys.cfg $(EXE_dependencies)
                $(LINK) /t/x/c/L$(LIBPATH) @&&|
c0t.obj+
sys.obj
sys
		# no map file
$(LIBS)+
emu.lib+
maths.lib+
cs.lib
|


clobber:	clean
                ..\utils\rm -f sys.com sys.exe b_fat12.h b_fat16.h sys.cfg

clean:
        ..\utils\rm -f *.obj *.bak *.crf *.xrf *.map *.lst *.las status.me

#		*Individual File Dependencies*
sys.obj: sys.cfg sys.c b_fat12.h b_fat16.h

#		*Compiler Configuration File*
sys.cfg: sys.mak
  copy &&|
-v
-vi-
-k-
-I$(INCLUDEPATH);..\hdr
-L$(LIBPATH)
-DI86=1;PROTO=1
| sys.cfg
