/* Partial implementation of the DOS MODE command by Eric Auer 2003 ..., */
/* for inclusion in MODECON (by Aitor Merino), which does the codepages! */
/* This code is primarily for Aitor, but you may use it as is under the  */
/* terms of the GNU GPL (v2) license if you want to, see www.gnu.org ... */
/* If you have questions, mail me: eric%coli.uni-sb.de (replace % by @). */

/* This file: Option parsing helpers */

#include "mode.h"

static char * helptext[] = {
  "MODE LPTn[:] cols[,[lines][,retry]] (80/132 cols, 6/8 lpi)",
  "MODE LPTn[:] [COLS=...] [LINES=...] [RETRY=...]",
  "  (retry: b/e/r return busy/error/ready if busy, p/n infinite/no retry)",
  "MODE COMn[:] baud,parity,data,stop,retry (same optionality as LPT)",
  "MODE COMn[:] [BAUD=...] [PARITY=...] [DATA=...] [STOP=...] [RETRY=...]",
  "  (baud can be abbreviated to unique prefix, parity can be o/e/n/s/m,",
  "  the latter 2 meaning space/mark, data can be 5..8, stop 1..2)",
  "MODE [device] [/STA[TUS]] (show status of one or all devices)",
  "MODE LPTn[:]=COMn[:] (redirect printer data to serial port)",
  "MODE CON [CP|CODEPAGE] REFRESH",
  "MODE CON [CP|CODEPAGE] SELECT=number",
  "MODE CON [CP|CODEPAGE] PREPARE=((...) filename)",
  "  (... can be one or more comma separated numbers or empty strings)",
/* "  Currently only CON device supported for CODEPAGE operations!",          */
  "MODE [BW40|BW80|CO40|CO80|MONO][,rows] (rows can be 25, 28, 43 or 50)",
  "  Use 8, 14 or 16 as 'rows' value if you only want to change the font",
/* "  Support for 30 and 60 rows on request!",                                */
  "MODE CON[:] [COLS=...] [LINES=...] (cols can be 40 or 80)",
  "MODE CON[:] [RATE=...] [DELAY=...] (default rate 20, default delay 1)",
  "  (rate: 1..32 for 2..30 char/sec, delay: 1..4 for 1/4sec..4/4sec)",
  "MODE CON[:] [NUMLOCK|CAPSLOCK|SCROLLLOCK|SWITCHAR]=value",
  "  (value: + or - for the locks or a character for switchar)",
  "** printer redirection/retry and CGA horizontal shift not yet supported! **",
/* "** Retry-parameters and redirection need a TSR or separate .sys driver",  */
/* "** (I prefer the latter) which MODE would control. CGA horizontal shift", */
/* "** not planned, other special features not planned either...)",           */
  NULL
}; /* helptext */

/* TODO: improve help screen (e.g. look at the FreeDOS MODE(.asm) one). */

/* TODO: use KITTEN i18n library and tiny prf.c printf implementation! */

/* ------------------------------------------------ */

/* skip over whitespace, return NULL if hitting EOF */
char * skipspace(char * str)
{
  if (str == NULL)
    return str; /* the NULL string is empty, too */

  while (!isgraph(str[0])) { /* skip over leading whitespace */
    if ((str[0] == 13) || (str[0] == 0)) { /* nothing but whitespace? */
      return NULL;
    }
    str++;
  }
  return str;
} /* skipspace */

/* ------------------------------------------------ */

/* find a numerical or one-char value after the label string */
unsigned int grabarg(char * str, const char * label)
{
  str = strstr(str, label);
  if (str == NULL)
    return 0; /* failed */
  str = skipspace(str+strlen(label));
  if (isdigit(str[0])) {
    return (int)(0xffff & atol(str)); /* numerical argument */
  } else {
    return (int)str[0]; /* single char argument */
  }
} /* grabarg */

/* ------------------------------------------------ */

/* find a numerical or one-char value after the nth comma */
unsigned int posarg(char * str, int commas)
{
  char * termp;
  char term;
  unsigned int value;

  while (commas>0) {
    str = strchr(str, ',');
    if (str == NULL)
      return 0; /* failed */
    str++; /* advance past the comma */
    commas--;
  }
  str = skipspace(str);

  if (str==NULL) { /* string ended at the comma that would start the value */
    return 0;
  }
  
  termp = str;
  while ( (termp[0]!=0) && (termp[0]!=' ') && (termp[0]!=',') ) {
    termp++; /* find END of argument (next space or comma) */
  }
  term = termp[0]; /* save char */
  termp[0] = 0; /* temporarily terminate string here */

  if (isdigit(str[0])) {
    value = (int)(0xffff & atol(str)); /* numerical argument */
  } else {
    value = (int)str[0]; /* single char argument */
  }
  
  /* printf("[%s] -> %u\r\n", str, value); */
  termp[0] = term; /* restore string */
  return value;
} /* posarg */

/* ------------------------------------------------ */

/* translate char retry B/E/R/P/N into value 0..4 or -1 */
int xlatretry(char retry)
{
  static char * retryname[] = {
    "report B_USY", "report E_RROR", "report R_EADY",
    "INFINITE retry (P)", "N_O retry"
  }; /* retryname */
  int i = -1;

  switch (retry) {
    case 0: /* default: return BUSY when printer is BUSY */
      return 0;
    case 'B':
      i = 0;
      break;
    case 'E':
      i = 1;
      break;
    case 'R':
      i = 2;
      break;
    case 'P':
      i = 3;
      break;
    case 'N':
      i = 4;
      break;
  } /* switch */

#ifdef DMODE
  if (i>=0) printf("User selected reaction on busy port: %s\r\n",
    retryname[i]);
#endif

  return i;
} /* xlatretry */

/* ------------------------------------------------ */

/* show the help screen */
void help(void)
{
  int i;
  for (i=0; helptext[i]!=NULL; i++) {
    printf("%s\r\n", helptext[i]);
  }
  return;
} /* help */

