/* 
    JEMM386.H
*/

#define NULL 0
#define TRUE 1
#define FALSE 0

#define MK_FP(seg,ofs)        ((void far *)(((ulong)(seg)<<16)|(ushort)(ofs)))
#define FP_SEG(fp)            ((ushort)((ulong)(void far *)(fp)>>16))
#define FP_OFF(fp)            ((ushort)(fp))

typedef unsigned char uchar;
typedef unsigned int   uint;
typedef unsigned short ushort;
typedef unsigned long ulong;

extern int printf(char *,...);
extern void memset(char *s1, char c, int count);
/* extern void memcpy(char *s1, char *s2,int len); */
extern int  strlen(char *s);

/* extern int  toupper (unsigned c); */
extern char * pascal FindCommand(char *searchstring);
extern unsigned long pascal GetValue(char *commandline, int base, char usesuffix);
extern ushort IsProtectedMode(void);
extern int emmcall(uchar);
extern int XMSinit(void);
extern void TryUnload(void);
extern int IsEmmInstalled(void);
#if INTEGRATED==0
extern int xmscall(uchar);
extern int xmscall32(uchar);
#else
extern int pascal GetA20Method(char *);
extern int EnableA20(void);
extern int DisableA20(void);
extern ulong pascal I15GetMemoryStatus(ushort);
extern ulong pascal I15AllocMemory(int, ulong);
#endif
extern ulong InitJemm(void);
extern int IsDPMI(void);
extern int VMwareDetect(void);
extern int EmmStatus(void);
extern int EmmUpdate(void);
/* extern int AddIfContiguousWithDosMem(int,int); */
/* extern int InstallXMSHandler(int); */
extern int TestForSystemRAM(void *, int, unsigned int *);


#define isWhite(c) ((c) == ' ' || (c) == '\t')

/* your code must provide this function */

#define EXECMODE_SYS 0
#define EXECMODE_EXE 1

/* globals, also defined in JEMM386.INC or JEMM32.ASM */

#ifndef INTEGRATED
#define INTEGRATED 0
#endif

#define MAX_EMS_PAGES_POSSIBLE 0x8000 /* 512 MB EMS is abs. max */
#define MAX_EMS_PAGES_ALLOWED  0x800  /* 32 MB EMS is std. max */
#define MINMEM16K_DEFAULT 0      /* MIN= default (in 16 kB units) */
#define MAXMEM16K_DEFAULT 0x1E00 /* MAX= default (in 16 kB units) */
#define DMABUFFDEFAULT    64 /* DMA buffer default size in kB */
#define UMB_MAX_BLOCKS    8 /* max UMB blocks */

/* compiler switches, requires switches in JEMM.INC to be set as well */

#define SBSUPP        1    /* support SB option */
#define VMESUPP       1    /* support VME/NOVME options */
#define LOADSUPP      1    /* support LOAD option */
#define A20SUPP       1    /* support A20/NOA20 options */
#define EMXSUPP       1    /* support EMX option */
#define PGESUPP       1    /* support PGE/NOPGE options */
#define UNLOADSUPP    1    /* support UNLOAD option */
#define FASTBOOT      1    /* support FASTBOOT option */
#define SPLIT         1    /* support SPLIT option */
#define V86EXC0D      1    /* support V86EXC0D option */

/* equates, must match the ones in JEMM32.ASM */

#if SBSUPP
#define V86F_SB       1    /* SB compat switch set */
#endif
#define V86F_NOCHECK  2    /* NOCHECK switch set */
#if EMXSUPP
#define V86F_EMX      4    /* EMX compat switch set */
#endif
#if FASTBOOT
#define V86F_FASTBOOT 8    /* FASTBOOT switch set */
#endif
#if V86EXC0D
#define V86F_V86EXC0D 16   /* V86EXC0D switch set */
#endif

#define CHECK00FFONLY 0    /* I=TEST checks pages for 0x00 and 0xFF values only */

/* structures */

/* structure for calling XMS V2 and EMS functions */

typedef struct
{
    ushort ax;
    ushort bx;
    ushort cx;
    ushort dx;
} REG16;

/* structure for calling XMS V3 functions */

typedef struct
{
    ulong eax;
    ulong ebx;
    ulong ecx;
    ulong edx;
} REG32;

/* UMB block 'array' ; this structure is also defined in JEMM386.INC */

typedef struct tagUMBBLK {
    ushort segment;
    ushort size;
} UMBBLK;

/* structure for v86 monitor initialization */
/* this structure is also defined in JEMM.INC */

typedef struct tagJEMMINIT {
    ulong MonitorStart;     /* XMS/I15 block physical start */
    ulong MonitorEnd;       /* XMS/I15 block physical end */
    ulong TotalMemory;      /* XMS/I15 highest physical address */
    ulong MaxMem16k;        /* MAX=xxxx (default 120M), in 16kB units */
    ulong MinMem16k;        /* MIN=xxxx (default 0), in 16kB units */
    ulong XMSHandleTable;   /* far16 address XMS handle table */
    uchar far * pPageMap;   /* far16 address 1. MB page map */
    ushort MaxEMSPages;     /* Min(32M, MaxMem16k), in 16 kB units */
    ushort XMSControlHandle;/* XMS handle for memory block or 0000 */
    ushort DMABufferSize;   /* DMA buffer size in kB */
    ushort Frame;           /* segment address EMS page frame */
    ushort Border;          /* segment address start EMS mappable pages */
    ushort FirstUMB;        /* segment address first UMB */
#if INTEGRATED
    ushort HmaMin;
    ushort X2Max;
#endif
    uchar NoEMS;
    uchar NoFrame;
    uchar NoPool;
    uchar AltBoot;
    uchar NoVME;
    uchar NoVDS;
    uchar NoPGE;
    uchar NoA20;
    uchar NoVCPI;
    uchar NoInvlPg;
    uchar V86Flags;
    uchar NoRAM;
    uchar NoHigh;
    uchar NumUMBs;
#if INTEGRATED
    uchar A20Method;
#endif
} JEMMINIT;

