/*
// Program:  Free FDISK
// Module:  FDISK.H
// Module Description:  Free FDISK Header File
// Written By:  Brian E. Reifsnyder
// Version:  0.98 Pre 1
// Copyright:  1998-2000 under the terms of the GNU GPL
*/


/* Phil Brutsche - November 20, 1998

   * Created some preprocessor directives to simplify the help screens.

*/

/*
/////////////////////////////////////////////////////////////////////////////
//  DEFINES FOR MAINTENANCE PURPOSES
/////////////////////////////////////////////////////////////////////////////
*/

#define PRINAME "Free FDISK"
#define ALTNAME "FreeDOS"
#define VERSION "0.98 Pre 1 DEV"
#define COPYLEFT "1998 - 2000"

#define DEFAULT_VERSION 6
			 /* ***** Set the above definition to the     */
			 /* ***** version to be emulated if the       */
			 /* ***** fdisk.ini file does not exist or if */
			 /* ***** the fdisk.ini file does not have a  */
			 /* ***** VERSION statement.                  */
#define FREEDOS_VERSION 6
			 /* ***** Set the above definition to the     */
			 /* ***** version to be emulated if the       */
			 /* ***** VERSION statement in the fdisk.ini  */
			 /* ***** file is set to "FD."  Note:  Do not */
			 /* ***** enter "100" in the above line.      */

			 /* ***** Version Codes:                      */
			 /* *****   Version 4:      4                 */
			 /* *****   Version 5:      5                 */
			 /* *****   Version 6:      6                 */
			 /* *****   Win 95/Win 95A: 7                 */
			 /* *****   Win 95B:        72                */
			 /* *****   Win 98          8                 */
			 /* *****   FreeDOS:        100               */

#define SIZE_OF_MBR 445
			 /* ***** This is the number of bytes for the */
			 /* ***** boot code in the partition table.   */
			 /* ***** If the boot code in the partition   */
			 /* ***** table changes, this WILL need       */
			 /* ***** changed.  (Start the count at 0.)   */
			 /* ***** The MBR code is in the file         */
			 /* ***** bootcode.h                          */


#define EMULATED_CYLINDERS   784
#define EMULATED_HEADS       255
#define EMULATED_SECTORS      63
			 /* ***** The above 3 values are the physical */
			 /* ***** attributes of an emulated hard disk */
			 /* ***** See the fdisk.ini file for          */
			 /* ***** instructions on how to enable this  */
			 /* ***** feature.                            */

/*
/////////////////////////////////////////////////////////////////////////////
//  DEFINES
/////////////////////////////////////////////////////////////////////////////
*/

#ifdef MAIN
#define EXTERN /**/
#else
#define EXTERN extern
#endif

#define READ 2

#define TRUE 1
#define FALSE 0

#define UNCHANGED 20
#define UNUSED    99

#define FD         100
#define FOUR       4
#define FIVE       5
#define SIX        6
#define W95        7
#define W95B       72
#define W98        8

#define MEG 1048576

#define PRIMARY 1
#define EXTENDED 2
#define LOGICAL 3
#define SPECIAL 4

#define LAST 99

#define PERCENTAGE 1

#define STANDARD 0
#define TECHNICAL 1

#define BOLD 1

#define INTERNAL 0
#define EXTERNAL 1

#define NOEXTRAS 50

/* Definitions for the menus */
#define MM   0x00               /* Main Menu                     */

  #define CP   0x10             /* Create PDP or LDD             */

    #define CPDP 0x11           /* Create Primary DOS Partition  */
    #define CEDP 0x12           /* Create Extended DOS Partition */
    #define CLDD 0x13           /* Create Logical DOS Drive      */

  #define SAP  0x20             /* Set Active Partition          */

  #define DP   0x30             /* Delete partition or LDD       */

    #define DPDP 0x31           /* Delete Primary DOS Partition  */
    #define DEDP 0x32           /* Delete Extended DOS Partition */
    #define DLDD 0x33           /* Delete Logical DOS Drive      */
    #define DNDP 0x34           /* Delete Non-DOS Partition      */

  #define DPI  0x40             /* Display Partition Information */

  #define CD   0x50             /* Change Drive                  */

#define EXIT 0x0f               /* Code to Exit from Program     */

/* Definitions for the input routine */
#define YN     0
#define NUM    1
#define NUMP   2
#define ESC    3
#define ESCR   4
#define ESCE   5
#define ESCC   6
#define CHAR   7
#define NONE   8

/*
/////////////////////////////////////////////////////////////////////////////
//  GLOBAL VARIABLES
/////////////////////////////////////////////////////////////////////////////
*/

EXTERN char filename[256];
EXTERN char path[256];

EXTERN char partition_label[16];

/* Buffers */
EXTERN unsigned char sector_buffer[512];
EXTERN unsigned char partition_lookup_table_buffer_short[256] [9];
EXTERN unsigned char partition_lookup_table_buffer_long[256] [17];

/* Brief partition type table buffer for computing drive letters. */
EXTERN int brief_partition_table[8] [27];

/* Buffer containing drive letters. */
EXTERN char drive_lettering_buffer[8] [27];

/* Ending Mapping Variables */
EXTERN long computed_ending_cylinder;
EXTERN unsigned long computed_partition_size;

/* Integers converted from long numbers */
EXTERN int integer1;
EXTERN int integer2;

/* LBA Specific Global Variables */
EXTERN unsigned char disk_address_packet[16];
EXTERN unsigned char result_buffer[26];

/*
/////////////////////////////////////////////////////////////////////////////
// GLOBAL STRUCTURES
/////////////////////////////////////////////////////////////////////////////
/*

/* Debugging Structure...Created 5/27/1999 */
typedef struct debugging_table_structure {
  int all;
  int create_partition;
  int determine_free_space;
  int emulate_disk;
  int input_routine;
  int path;
  int read_sector;
  int write;
  } Debugging_Table;

/* Flags Structure...Created 5/27/1999 */
typedef struct flags_structure {

  int display_name_description_copyright;
  int do_not_pause_help_information;
  int drive_number;
  int esc;
  int flag_sector;
  int use_freedos_label;
  int use_extended_int_13;
  int extended_options_flag;
  int fat32;
  int label;
  int monochrome;
  int maximum_drive_number;
  int more_than_one_drive;
  int partitions_have_changed;
  int partition_type_lookup_table;
  int reboot;
  int version;
  int use_ambr;
  } Flags;

/* Partition Table Structure...Created 5/6/1999 */
typedef struct part_table_structure {

  /* Hard disk Geometry */
  unsigned long total_cyl;
  unsigned long total_head;
  unsigned long total_sect;

  int ext_int_13;
  int ext_int_13_version;
  int device_access_using_packet_structure;

  /* Pre-computed hard disk sizes */
  long double total_hard_disk_size_in_log_sectors;
  unsigned long total_hard_disk_size_in_MB;

  int part_values_changed;
  int pri_part_exists;

    /* Primary Partition Table */

      /* Specific information that is stored in the partition table. */
      int active_status[4];

      int pri_part_num_type[4];
      char pri_part_vol_label[4] [13];

      long pri_part_start_cyl[4];
      long pri_part_start_head[4];
      long pri_part_start_sect[4];

      long pri_part_end_cyl[4];
      long pri_part_end_head[4];
      long pri_part_end_sect[4];

      unsigned long pri_part_rel_sect[4];
      unsigned long pri_part_num_sect[4];

      long pri_part_size_in_MB[4];

      int pri_part_created[4];
      /* General pre-computed information. */
      unsigned long pri_part_largest_free_space;

      long pp_largest_free_space_start_cyl;
      long pp_largest_free_space_start_head;
      long pp_largest_free_space_start_sect;

      long pp_largest_free_space_end_cyl;

      int pri_part_physical_order[4];

  int ext_part_exists;
  int num_of_ext_part;

    /* Extended Partition Table */
    long ext_part_size_in_MB;
    unsigned long ext_part_num_sect;
    long double ext_part_largest_free_space;

    long log_drive_largest_free_space_location;
    long log_drive_free_space_start_cyl;
    long log_drive_free_space_end_cyl;

    int num_of_log_drives;
    int log_drive_num_type[23];
    char log_drive_vol_label[23] [13];

    long log_drive_start_cyl[23];
    long log_drive_start_head[23];
    long log_drive_start_sect[23];

    long log_drive_end_cyl[23];
    long log_drive_end_head[23];
    long log_drive_end_sect[23];

    unsigned long log_drive_rel_sect[23];
    unsigned long log_drive_num_sect[23];

    unsigned long log_drive_size_in_MB[23];

    int log_drive_created[23];

    int next_ext_exists[23];

    int next_ext_num_type[23];

    long next_ext_start_cyl[23];
    long next_ext_start_head[23];
    long next_ext_start_sect[23];

    long next_ext_end_cyl[23];
    long next_ext_end_head[23];
    long next_ext_end_sect[23];

    unsigned long next_ext_rel_sect[23];
    unsigned long next_ext_num_sect[23];

} Partition_Table;

EXTERN Debugging_Table debug;
EXTERN Flags flags;
EXTERN Partition_Table part_table[8];




