#
# To build JEMMEX.EXE, you will need:
#
# Tool        Default (recommended) Alternatives
#-----------------------------------------------------------------
# Assembler   Wasm 1.7j             Masm 6.14/6.15/7.00
# C Compiler  Open Watcom WCC       MS VC++ 1.5, Turbo C 2.01/4.0, DMC
# OMF Linker  Open Watcom Wlink     DM OptLink, MS Link, TLink 7.1.30
# COFF Linker Open Watcom Wlink     MS Link, PoLink
# Make        Open Watcom Wmake     MS NMAKE, Borland MAKE (v3.6+)
#
# not all combinations work, however, i.e. Wlink won't link modules
# compiled with MS VC.
#
# Since Jemm386 v5.4, the 32bit code uses the FLAT memory model and
# is linked separately. This complicates the build process slightly:
#
#  1. create Jemm32.bin. This is a Win32 PE binary.
#  2. use EXTRSECT to extract the section contents of this binary to file
#     $(OUTDIR)\_Jemm32.inc.
#  3. assemble Jemm16.asm (which includes $(OUTDIR)\_Jemm32.inc).
#  4. compile the C modules with 16-bit compiler.
#  5. link Jemm16.obj and C modules to JemmEx.exe.

!ifndef DEBUG
DEBUG=0
!endif

# select assembler, default WASM

!ifndef MASM
MASM=0
!endif

# select 16-bit C compiler, default WCC

!ifndef WCC
WCC=0
!endif
!ifndef MSC
MSC=0
!endif
!ifndef DMC
DMC=0
!endif
!ifndef TCC
TCC=0
!endif

!if $(WCC)+$(MSC)+$(DMC)+$(TCC)==0
WCC=1
!endif

COFFMODS=.\jemm32.obj .\ems.obj .\vcpi.obj .\dev.obj .\xms.obj .\dma.obj .\i15.obj .\emu.obj .\vds.obj .\pool.obj .\init.obj .\debug.obj
WLMODS=.\jemm32.obj,.\ems.obj,.\vcpi.obj,.\dev.obj,.\xms.obj,.\dma.obj,.\i15.obj,.\emu.obj,.\vds.obj,.\pool.obj,.\init.obj,.\debug.obj

# select Win32 COFF linker, default WLINK

# wlink has some problems (generates empty .idata and .reloc sections),
# but due to tool EXTRSECT this is a non-issue.
LINKCOFF=wlink system nt file $(WLMODS) name jemm32.bin option offs=0x100000, objalign=0x10000, start=_start, map, quiet, norelocs

# MS link works good, and it will automatically convert OMF to COFF format
#COFFOPT=/fixed /driver /subsystem:native /entry:start /base:0x100000 /align:0x10000 /MAP /OUT:jemm32.bin /nologo
#LINKCOFF=link.exe /FileAlign:0x200 $(COFFOPT) $(COFFMODS)

# PoLink accepts modules in COFF format only. So it can't be used with WASM.
#LINKCOFF=polink.exe $(COFFOPT) $(COFFMODS)


# select OMF linker, default WLINK

!ifndef WLINK
WLINK=0
!endif
!ifndef OPTLINK
OPTLINK=0
!endif
!ifndef MSLINK
MSLINK=0
!endif
!ifndef TLINK
TLINK=0
!endif
!ifndef VALX
VALX=0
!endif

!if $(TLINK)+$(WLINK)+$(VALX)+$(MSLINK)+$(OPTLINK)==0
WLINK=1
!endif

NAME=JEMMEX

!if $(DEBUG)
!if $(MASM)
AOPTD=-D_DEBUG
!else
AOPTD=-d_DEBUG
!endif
OUTDIR=DEBEX
!else
AOPTD=
OUTDIR=RELEX
!endif

!if $(MASM)
ML=ml.exe -c -nologo -Cp -D?INTEGRATED=1  
AS1=$(ML)       $(AOPTD) -Fl$(OUTDIR)\jemm16.LST -Fo$(OUTDIR)\jemm16.OBJ -D?WCC=$(WCC) -D?MSC=$(MSC) -D?DMC=$(DMC) -I$(OUTDIR) jemm16.asm
AS2=$(ML) -coff $(AOPTD) -Fl$*.LST -Fo$*.OBJ
AOPT2=
!else
WASM=wasm.exe -q -zcp -d?INTEGRATED=1
AS1=$(WASM) $(AOPTD) -I$(OUTDIR) -d?WCC=$(WCC) -d?MSC=$(MSC) -fo$(OUTDIR)\jemm16.obj jemm16.asm
AS2=$(WASM) $(AOPTD) -fo$@
AOPT2=
!endif

!if $(WCC)
CC=wcc.exe -3 -bt=dos -ecc -ms -os -q -s -fp3 -w=3 -DINTEGRATED=1
# the OW C++ compiler produces slightly better code
#CC=wpp.exe -3 -bt=dos -ecc -ms -os -q -s -fp3 -w=3
OUTO=-fo
!endif
!if $(DMC)
CC=\dm\bin\sc.exe -msd -c -3 -J -o -DINTEGRATED=1
OUTO=-o
!endif
!if $(TCC)
CC=tcc.exe -c -G- -w -r -N- -O -Z -k- -DINTEGRATED=1
OUTO=-o
!endif
!if $(MSC)
CC=cl.exe -c -nologo -O1 -G3 -Gs -Gx -J -Zl -Fl$*.lst -DINTEGRATED=1
OUTO=-Fo
!endif

!if $(WLINK)
LINK=wlink.exe system dos file jemm16.obj,jemm16c.obj name $(NAME).EXE option map=$(NAME).MAP, quiet
!endif
!if $(OPTLINK)
LINK=\dm\bin\link.exe /MAP:FULL /NOD /NOI jemm16.obj jemm16c.obj,$(NAME).EXE,$(NAME).MAP;
!endif
!if $(MSLINK)
LINK=link16.exe /NOLOGO/MAP:FULL/NOD /NOI jemm16.obj jemm16c.obj,$(NAME).EXE,$(NAME).MAP;
!endif
!if $(TLINK)
LINK=tlink.exe /3 /m /s /n jemm16.obj jemm16c.obj,$(NAME).EXE,$(NAME).MAP;
!endif
!if $(VALX)
LINK=valx.exe /MAP jemm16.obj jemm16c.obj,$(NAME).EXE,$(NAME).MAP;
!endif

ALL: $(OUTDIR) $(OUTDIR)\$(NAME).EXE

$(OUTDIR):
  if not exist $(OUTDIR)/nul mkdir $(OUTDIR)

$(OUTDIR)\$(NAME).EXE: $(OUTDIR)\jemm16.obj $(OUTDIR)\jemm16c.obj
    cd $(OUTDIR)
	$(LINK)
    cd ..

$(OUTDIR)\jemm16.obj: jemm16.asm jemm.inc debug.inc $(OUTDIR)\_jemm32.inc $(NAME).MAK
	@$(AS1)

$(OUTDIR)\jemm16c.obj: jemm16c.c jemm16c.h $(NAME).MAK
	@$(CC) $(OUTO)$(OUTDIR)\jemm16c.obj jemm16c.c
    
COFFDEPS=$(COFFMODS:.\=RELEX\)

$(OUTDIR)\_jemm32.inc: $(COFFDEPS)
	cd $(OUTDIR)
	$(LINKCOFF)
	..\extrsect.exe -i -q -x 0 jemm32.bin _jemm32.inc
    cd ..

32BITDEPS=jemm32.inc jemm.inc external.inc debug.inc $(NAME).MAK

$(OUTDIR)\jemm32.obj: jemm32.asm $(32BITDEPS)
	@$(AS2) jemm32.asm $(AOPT2)

$(OUTDIR)\ems.obj: ems.asm ems32.inc $(32BITDEPS)
	@$(AS2) ems.asm $(AOPT2)

$(OUTDIR)\vcpi.obj: vcpi.asm $(32BITDEPS)
	@$(AS2) vcpi.asm $(AOPT2)

$(OUTDIR)\dev.obj: dev.asm $(32BITDEPS)
	@$(AS2) dev.asm $(AOPT2)

$(OUTDIR)\xms.obj: xms.asm $(32BITDEPS)
	@$(AS2) xms.asm $(AOPT2)

$(OUTDIR)\vds.obj: vds.asm $(32BITDEPS)
	@$(AS2) vds.asm $(AOPT2)

$(OUTDIR)\pool.obj: pool.asm $(32BITDEPS)
	@$(AS2) pool.asm $(AOPT2)

$(OUTDIR)\init.obj: init.asm $(32BITDEPS)
	@$(AS2) init.asm $(AOPT2)

$(OUTDIR)\dma.obj: dma.asm $(32BITDEPS)
	@$(AS2) dma.asm $(AOPT2)

$(OUTDIR)\emu.obj: emu.asm $(32BITDEPS)
	@$(AS2) emu.asm $(AOPT2)

$(OUTDIR)\i15.obj: i15.asm $(32BITDEPS)
	@$(AS2) i15.asm $(AOPT2)

$(OUTDIR)\debug.obj: debug.asm $(32BITDEPS)
	@$(AS2) debug.asm $(AOPT2)
