/* choice.c */

/* Waits for the user to press a key, which must be in a list of
   choices */

/*
   Copyright (C) 1994--1998 Jim Hall, jhall1@isd.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>				/* for exit (Borland) */
#include <ctype.h>				/* for toupper */

#include <conio.h>				/* for getch (Borland) */

#include "getopt.h"				/* hack for GNU getopt */


#define beep() putch('\a')


void usage (void);


int
main (int argc, char **argv)
{
  int i;
  int key;
  int show_choices = 1;
  int case_sensitive = 0;

  char *yesno = "yn";
  char *choices = yesno;

  /* Scan command line */

  opterr = 0;					/* no error messages */

  while ((i = getopt (argc, argv, "c:C:nNsSt:T:")) != EOF)
    {
      switch (i)
	{
	case 'c':
	case 'C': /* allowable chars */
	  choices = optarg;			/* pointer assignment */
	  if (choices[0] == ':')
	    {
	      choices++;
	    }
	  break;

	case 'n':
	case 'N': /* do not display choices at end */
	  show_choices = 0;
	  break;

	case 's':
	case 'S': /* be case sensitive */
	  case_sensitive = 1;
	  break;

	case 't':
	case 'T': /* time to wait - ignored */
	  break;

	default:
	  /* show usage, and quit */

	  usage ();
	  exit (0);
	  break;
	} /* switch */
    } /* while */

  /* Display text */

  if (optind < argc)
    {
      for (i = optind; i < argc; i++)
	{
	  printf ("%s ", argv[i]);
	}
    }

  if (show_choices)
    {
      printf ("[%s]? ", choices);
    }

  /* Grab the key.  Don't exit until we found it. */

  while (1)
    {
      key = getch();

      for (i = 0; choices[i]; i++)
	{
	  if (key == choices[i])
	    {
	      printf ("\n");		/* force a new line */
	      exit (i+1);		/* exit starts counting at 1 */
	    }

	  if ((!case_sensitive) && (toupper(key) == toupper(choices[i])))
	    {
	      printf ("\n");		/* force a new line */
	      exit (i+1);		/* exit starts counting at 1 */
	    }
	} /* for */

      beep();
    } /* while */
}

void
usage (void)
{
  printf ("CHOICE - Waits for the user to press a key, from a list of choices\n");
  printf ("usage: CHOICE [/C[:]choices] [/N] [/S] [/T[:]c,nn] [text]\n");
  printf ("\t/C[:]choices Specifies allowable keys. Default is YN\n");
  printf ("\t/N           Do not display choices and ? at end of prompt.\n");
  printf ("\t/S           Treat choices as case sensitive.\n");
  printf ("\t/T[:]c,nn    (ignored, for compatibility)\n");
  printf ("\ttext         Prompt string to display\n");
}