Comment *
Ŀ
Title	 : moveattr							     
purpose : moves a set of attibutes to a screen buffer. 		     
									     
This routine does a block move  avoiding snow on the Ibm color card.	     
It does this by monitering the video status bit at port location 0x3da      
by Jack A. Zucker (jaz) 75766,1336 on jan 25,1986			     

 *

title	buffer moveattr
name	moveattr

	assume cs:_text
_text	segment public byte 'code'
	public _moveattr

public	_moveattr, next, status_low, status_high

_moveattr   proc near

	push bp
	mov bp,sp
	push si
	push di
	push es
	push ds

	mov ax,[bp + 4] 	; get screen segment
	mov ds,ax		; in ds
	mov si,[bp + 6] 	; get screen offset
	inc si			; point to attribute
	mov bx,si		; save screen offset in bx
	mov ax,[bp + 8] 	; get number of rows
	mov cl,[bp + 0Ah]	; get number of columns
	mov ch,[bp + 0Ch]	; get attribute in ch
	cmp [bp+4],0B000h	; mono ?
	jz mono

next:
	mov dx,3dah		; address of 6845 Status register
	push ax
status_low:
	in al,dx		; get vertical retrace status
	ror al,1		; faster than test
	jc status_low		; wait for partially done retrace
	cli			; don't allow any more interrupts
status_high:
	in al,dx		; wait for beginning of new retrace
	ror al,1
	jnc status_high 	; retrace not started

	mov byte ptr [si],ch	; paint attribute on screen
	sti			; interrupts allowed now
	inc si
	inc si
	pop ax
	dec cl
	or cl,cl
	jnz next
	add bx,160
	mov si,bx
	mov cl,[bp + 0Ah]
	dec ax
	or ax,ax
	jnz next
	jmp exit

mono:
	mov byte ptr [si],ch	; paint attribute on screen
	sti			; interrupts allowed now
	inc si
	inc si
	dec cl
	or cl,cl
	jnz mono
	add bx,160
	mov si,bx
	mov cl,[bp + 0Ah]
	dec ax
	or ax,ax
	jnz mono

exit:

	pop ds
	pop es
	pop di
	pop si
	mov sp,bp
	pop  bp
	ret
_moveattr  endp
_text	ends
	end
