/*
Ŀ
jzgetfat.c								     
Return a dynamically allocated fat table for the specifed disk. This can    
then be used for cluster searches ala chkdsk.				     
									     
Usage: 								     
  char *wfat;								     
									     
  jzgetfat(&wfat , 0); 						     
									     
 (C) JazSoft Software by Jack A. Zucker (301) 794-5950 		     

*/

jzgetfat( ffat , fdisk )
char **ffat;
int fdisk;	/* 0 = 'A' , 1 = 'B' etc */
{
  int woffset,w;   /* work integers */
  char wbuf[512];	/* disk buffer	 */
  int werr;
  TDISKBLK *wblock = (TDISKBLK *) wbuf;
  char *malloc();

  diskinfo(fdisk,wbuf); 	/* get disk parameters */

  /* bytes per sector * sectors per fat table */

  if ( ! (*ffat = malloc(wblock->bytes * wblock->sectfat))) {
    printf("\nInsufficient Memory. Aborting...");
    exit(-1);
  }

  woffset = (int) *ffat;

  for (w = 1 ; w <= wblock->sectfat ; w ++) {
    dosreads(fdisk , w , 1 ,woffset);  /* read fat sector */
    woffset += wblock->bytes;	       /* increment by sector size */
  }

}
