/*
Ŀ
jzappend.c								     
Append a window onto the existing window list. 			     
Usage: see screen.dmo for examples					     
									     
 (C) JazSoft Software by Jack A. Zucker (301) 794-5950 		     

*/
#include <jaz.h>
#include <jzscreen.h>
TWINDOW *jzappend(fheader,fattr,fy1,fx1,fy2,fx2,fwindnum)
THEADER *fheader;
unsigned char fattr;
int  fy1,fx1,fy2,fx2,fwindnum;
{
  TWINDOW *new,*initnew();

  if (new = initnew(fattr,fy1,fx1,fy2,fx2)) {
    if (fheader->first)        /* if the list is not empty */
       fheader->last->next = new; /*link in new node */
    else
      fheader->first = new;
    fheader->last = new;
    fheader->length ++;
    new->number = fwindnum;		/* set the window number */
    return(new);
  }
  else return(0);
}

TWINDOW *initnew(fattr,fy1,fx1,fy2,fx2)
unsigned char fattr;
int fy1,fx1,fy2,fx2;
{
  TWINDOW *new;
  int wrow,wcol,wstart,wstop;

  jzgetcur(&wrow,&wcol,&wstart,&wstop);  /* get current loc of cursor */

  if (new = (TWINDOW *) malloc(sizeof(TWINDOW))) {
    new->next = 0;		/* points to null */
    new->buf = (int *) malloc(((fx2 - fx1 + 1) * (fy2 - fy1 + 1)) << 1);
    new->row = wrow;
    new->col = wcol;
    new->attr = fattr;
    new->row1 = fy1;
    new->col1 = fx1;
    new->row2 = fy2;
    new->col2 = fx2;
    jzsavwnd(new); /* save contents of window */
  }

  return(new);
}
