/***
*disked.h - DISKED The DISK EDitor for MS(tm)-DOS
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Definitions and declarations.
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Versions

   1.1   13-Sep-1996    added sizes to some extern char arrays to
                        keep CL /W4 from complaining
*/

#ifndef FILENAME_MAX
#include <stdio.h>
#endif
#ifndef GENERAL_H
#include "general.h"
#endif
#ifndef KEYS_H
#include "keys.h"
#endif
#ifndef INIT_H
#include "init.h"
#endif

#define PAUSE   TRUE
#define NOPAUSE FALSE
#define XLATE   TRUE
#define NOXLATE FALSE
#define MAXSTR  63
#define SEARCH  63
#define MAX_DRIVE 26

struct Msg {                  /* generic number input messages */
    char *msg;                /* prompt */
    int len;                  /* length of input (e.g. 3 = 999 max) */
    int spec;                 /* sepcial argument handleing */
};

/* in SETUP.C */

extern const char * const Version;
#ifndef _MSC_VER
extern unsigned short _winmajor, _winminor;
#else
extern unsigned char __near __cdecl _winmajor;
extern unsigned char __near __cdecl _winminor;
#endif

/* in DATA.C */

extern char *command_text1[];
extern char *command_text2[];
extern char *signon_text[];
extern char *com_line_text[];
extern char *keywords_help[];
extern char *translate_help[];
extern char *io_help[];
extern char *dir_help[];

/* in DISKED.C */

extern char cur_dir[FILENAME_MAX];     /* current directory each drive */
extern char com_spec[FILENAME_MAX];    /* for shell command */
extern char ini_file[FILENAME_MAX];    /* initialization file name */
extern char prompt_var[FILENAME_MAX];  /* DOS prompt variable */
extern int files_indexed;              /* files-indexed flag */
extern int write_to;                   /* double protection on write */
extern unsigned long tagged[10];       /* "tagged" sectors */
extern unsigned int byte_cnt;          /* buffer byte count */
extern unsigned int max_bytes;         /* maximum buffer size */
extern unsigned char *data_buf;        /* pointer to area for data buffer */
extern unsigned char *save_sec;        /* duplicate sector buffer */
extern unsigned char *spare_sec;       /* spare sector buffer */
extern unsigned int dir_cluster;       /* startup directory cluster SETUP.C */
extern long set_sector;                /* startup sector number */
extern int big_screen;                 /* if 50 line display */

/* in SEARCH.C */

extern char tmpfstr[SEARCH+1];         /* find string, entry */
extern char findstr[SEARCH+1];         /* find string, actual */
extern unsigned int findlen;           /* find string, length */
typedef enum { F_BUFFER, F_DISK, F_CASE = 0, F_NOCASE, F_OFFSET } FIND_ARGUMENTS;

/* Function Prototypes */

extern int _access(const char *, int);
#define exist(f)  (_access(f,00)==0)

/* in DISKLIB.C */

extern void ext_commands(void);
extern void commands(void);
extern void signon_msg(void);
extern void header(void);
extern void dumpsector(void);
extern void dumpfilesec(void);
extern int get(struct Msg *str,int *one, int *two);
extern int getl(struct Msg *str,long *one, long *two);
extern int set(struct Msg *str,int *one,int *two,int *three);
extern int view(unsigned char *buffer,unsigned int bfptr,unsigned int bufend,int pause,int base);
extern int find(int val, int get,int kase);
extern void range(int val);
extern void dparams(char *drivedir);
extern void dumpboot(unsigned char *);
extern void help(void);
extern void set_physical(void);
extern int displaymask(int c);
extern char *buffermask(int c);
extern int prompt(int n, int base);

/* in FILEIO.C */

typedef enum { FILE_OVERWRITE = 1, FILE_APPEND } FILEMODE;
typedef enum { FILEBUF_X, FILEBUF, FILEBUF_H, SECBUF_H } PUTMODE;
extern void put_sectors(void);
extern void put_file(PUTMODE mode);
extern void get_file(int xlate);
extern void insert_file(int xlate);
extern void copy_file(void);
extern int append(int mask,unsigned char *buffer,unsigned int nbytes);
extern long filesize(const char *file);

/* in SETUP.C */

extern int setup(char **argv, int drives[], int *dsk);
extern int startup(unsigned int cdisk, unsigned int ddisk);
extern void drivestatus(int status);
extern void gettmpdir(char *tmpdir, char *dirspec);
extern void logerror(int i);
extern int newdisk(int tempd);

/* in DEBUG.C */

extern void debug(void);

/* in FILETRCK.C */

extern int ft_track;
extern int filetrack(const char *file, const int fnum);
extern void filetell(void);
extern int fileoffset(unsigned int cluster);
extern long filebytes(void);
extern int trackfile(KEY *c);
