/*
 *	dos\gcc\ioctl.c 	perform DOS IOCTL calls
 *
 *	Copyright (C) 1998, Gregg Jennings
 *
 *  1.1 23-Sep-1998 greggj  dosmem.h, ../debug.h
 */

#include "../dosio.h"
#include "../debug.h"
#include "dosmem.h"

/*
 * dos_ioctl		perform DOS IOCTL call (INT 21h/440Dh)
 *
 */

extern int dos_ioctl(DOS_SUBFUNCTION func, DOS_MINOR_CODE code, int dev,
					 void *data)
{
__dpmi_regs regs;
int seg,sel;
int size;

	regs.x.ax = 0x4400 + func;
	regs.x.bx = dev;
	if (code != DOS_MINOR_NONE)
		regs.x.cx = 0x0800 + code;

	if (data)
	{
		switch (code) {
			case DOS_MINOR_GET_DEVICE:
				size = sizeof(struct DEVICEPARAMS);
				break;
			case DOS_MINOR_GET_MEDIA:
				size = sizeof(struct MID);
				break;
			default:
				return 0;
				break;
		}
		if ((seg = _dosmalloc(size,&sel)) == -1)
			return 0;
		regs.x.ds = seg;
		regs.x.dx = 0;
	}

	__dpmi_int(0x21,&regs);

	if (regs.x.flags & 1) {
		DBG_err_dump("ioctl");
		return 0;
	}

	if (data) {
		_getdosmem(data,size,sel);
		_dosfree(sel);
	}

	/* handle special cases */

	if (func == DOS_DEV_REMOVE)
		return regs.x.ax;

	if (func == DOS_DRV_REMOTE)
		return regs.x.dx;

	return -1;
}
