/* Definition file for structures used to manage disks
   Last update 2000.12.23
   For a detailed description consult "Scheibenkleister" pages
   481-486 */


#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <bios.h>
#include <alloc.h>
#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>


#define MAX(a, b)			(((a) > (b)) ? (a) : (b))
#define MIN(a, b)			(((a) < (b)) ? (a) : (b))

#define SECT_SIZE 512

#define P_ID_EXT 0x5
#define MAX_DISKS 8
#define PHSDISK 0x80

typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long ulong;

typedef struct
	{
	word recsiz;  /* size of one record/sector */
	word clsiz;   /* size of one cluster */
	word clsizb;  /* size of one cluster in bytes */
	word rdlen;   /* root dir len */
	word fsiz;    /* size of fat in sectors */
	word fatrec;  /* sector where 1st fat starts */
   word nfat;    /* number of fats */
	word datrec;  /* 1st data record */
	word numcl;   /* number of cluster on this drive */
	word bflags;  /* flag if 12bit or 16bit FAT*/
	} BPB;

typedef struct
	{
	byte flags;
	byte bh;     /* start head */
	byte bs;     /* start sector */
	byte bc;     /* start cylinder */
   byte id;     /* partition id */
   byte eh;     /* end head */
	byte es;     /* end sector */
	byte ec;     /* end cylinder */
	ulong start_sec;
	ulong size;
	} PART_INFO;

typedef struct
	{
	byte hd_root_prg[0x1bE];
	PART_INFO part_0;
	PART_INFO part_1;
	PART_INFO part_2;
	PART_INFO part_3;
	word hd_chksum;
	} ROOT_SECTOR;

typedef struct
	{
	byte b_branch[2];
	byte b_loader[6];
	byte b_serial[3];
	word b_bps;        /* bytes per sector */
	byte b_spc;        /* sectors per cluster */
	word b_res;        /* number of reserved sectors */
	byte b_fats;       /* number of FATs */
	word b_dir;        /* number of root dir entries */
	word b_sec;        /* number of sectors on disk/partition */
	byte b_media;      /* media byte - F8 = harddisk */
	word b_spf;        /* number of sectors used for FAT */
	word b_spt;        /* sectors per track */
	word b_heads;      /* number of heads */
	word b_hidden;     /* number of hidden sectors */
	word b_execflag;
	word b_ldmode;
	word b_ssect;
	word b_sectcnt;
	ulong b_ldaddr;
	ulong b_fatbuf;
	char b_fname[12];
	byte b_bootprg[452];
	word b_chksum;
	} BOOT_SECTOR;

typedef struct
	{
	char d_fname[11];
	byte d_attr;
	byte d_res[10];
	word d_time;
	word d_date;
	word d_fclust;
	ulong d_size;
	} DIR_ENTRY;

typedef struct
	{
	word tsize;                  /* max number of possible entries in FAT */
	word csize;                  /* max number of clusters on disk tsize-2 */
	word fat_type;               /* 12-bit = 0, 16-bit = 1*/
	word huge *flat_fat;
	byte *check_fat;
	BPB  *bpb;
	ulong f_size;                /* sum of file size        */
	long f_index;                /* counter for files       */
	long d_index;                /* counter for directories */
	long h_index;                /* counter for hidden files*/
	long bad_cl;
	long used_cl;
	long unused_cl;
	} FAT_TABLE;

typedef struct        /* preset for floppy  @ - preset for hd = */
	{
	word  d_tracks;   /* @ */
	word  d_spt;      /* @ */
	word  d_heads;    /* @ */
	ulong d_sectors;  /* = */
	ulong d_clusters;
	word  d_clsiz;    /* = @ */        /* in sectors */
	word  d_bps;      /* = @ */
	word  d_numdir;   /* = @ */
	word  d_dirsec;
	int   d_numfats;  /* = @ */
	ulong d_fatsec;
	ulong d_datsec;                    /* first data sector */
	int   d_fattype;  /* = @ */        /* 0 - 12 bit, 1 - 16 bit */
	word  d_res_sec;  /* = @ */
	word  d_hid_sec;  /* = @ */
	int   d_drv;      /* = @ */
	byte  d_media;
	byte  *d_bad_clu;
	ulong d_bad_cl_c;
	} DRV_INFO;

typedef struct {                       /* struct that holds info about disk */
    word dev;                          /* geometry */
    word cyl;
    word heads;
    word sect;
    word valid;}
    INT13_TAB;

#define MD_READ    0
#define MD_WRITE   1
#define MD_IGNMEDC 2
#define MD_ABS     8

#define MD_SHOWDIR  0x01
#define MD_CHECKFAT 0x02
#define MD_CHECKDIR 0x04
#define MD_SHOWFAT  0x08
#define MD_WRITECHG 0x80
#define MD_VERIFY   0x100
#define FAT_OFFSET  2

#define EF_OUTSIDE -1
#define EF_INVALID -2
#define EF_BADBLCK -3
#define EF_CRSSLNK -4
#define EF_LOSTCST -5
#define EF_NOCLSTS -6
#define EF_WRGSIZG -7
#define EF_WRGSIZL -8
#define EF_USEDFRE -9

#define ED_NOCLSTS -16
#define ED_BADCHAR -17
#define ED_ILLFLAG -18
#define ED_BADRSVD -19

#define E_DISCREAD -24
#define E_DISCWRIT -25
#define E_DISCGENL -26    /* general disc error   */
#define E_DISCNOFS -27    /* error no file system */
#define E_DISCUNUS -28    /* disc unusable        */

#define EP_INVALID -64    /* invalid parameter */

