;    long integer/cardinal support for Modula-2

; (C) Copyright 1987 Fitted Software Tools. All rights reserved.

IFNDEF M2O
data            segment public 'data'
                public  DATA_M2LONGS
DATA_M2LONGS    equ     $
data            ends
ENDIF


code            segment 'code'
                assume  cs:code
IFNDEF M2O
                public  M2LONGS_INIT
                public  M2LONGS_LIMUL
                public  M2LONGS_LIDIV
                public  M2LONGS_LIMOD
                public  M2LONGS_LICMP
                public  M2LONGS_LCMUL
                public  M2LONGS_LCDIV
                public  M2LONGS_LCMOD
                public  M2LONGS_LCCMP
                public  M2LONGS_LCADR
                public  M2LONGS_ADRLC
ENDIF

IFDEF M2O
                dw      10                  ; number of procedures
                dw      offset M2LONGS_INIT     ; 0
                dw      offset M2LONGS_LIMUL    ; 1
                dw      offset M2LONGS_LIDIV    ; 2
                dw      offset M2LONGS_LIMOD    ; 3
                dw      offset M2LONGS_LICMP    ; 4
                dw      offset M2LONGS_LCMUL    ; 5
                dw      offset M2LONGS_LCDIV    ; 6
                dw      offset M2LONGS_LCMOD    ; 7
                dw      offset M2LONGS_LCCMP    ; 8
                dw      offset M2LONGS_LCADR    ; 9
                dw      offset M2LONGS_ADRLC    ; 10
ENDIF

rterror         equ     0C0h

op0             equ     word ptr [bp+6]          ;only op
op1             equ     word ptr [bp+10]         ;1st of 2 op
op2             equ     word ptr [bp+6]          ;2nd of 2 op

M2LONGS_LIMUL           proc    far
                push    bp
                mov     bp,sp

                mov     ax,op1
                mov     dx,op1+2
                mov     bx,op2
                mov     cx,op2+2
                call    mul32

                mov     sp,bp
                pop     bp
                ret     8
M2LONGS_LIMUL   endp

M2LONGS_LIDIV   proc    far
                push    bp
                mov     bp,sp

                mov     ax,op1
                mov     dx,op1+2
                mov     bx,op2
                mov     cx,op2+2
                call    div32

                mov     sp,bp
                pop     bp
                ret     8
M2LONGS_LIDIV   endp

M2LONGS_LIMOD   proc    far
                push    bp
                mov     bp,sp

                mov     ax,op1
                mov     dx,op1+2
                mov     bx,op2
                mov     cx,op2+2
                call    div32
                mov     ax,bx
                mov     dx,cx

                mov     sp,bp
                pop     bp
                ret     8
M2LONGS_LIMOD   endp


M2LONGS_LICMP   proc    far
                push    bp
                mov     bp,sp

                mov     ax,op1+2
                cmp     ax,op2+2
                jg      lic3
                jl      lic1
                mov     ax,op1
                cmp     ax,op2
                ja      lic3
                jb      lic1
lic2:           xor     ax,ax               ; =
                xor     dx,dx
                jmp     lic10
lic1:           xor     ax,ax               ; <
                mov     dx,1
                jmp     lic10
lic3:           mov     ax,1                ; >
                xor     dx,dx

lic10:          mov     sp,bp
                pop     bp
                ret     8
M2LONGS_LICMP   endp


M2LONGS_LCMUL   proc    far
                push    bp
                mov     bp,sp

                mov     ax,op1
                mov     dx,op1+2
                mov     bx,op2
                mov     cx,op2+2
                call    mul32u

                mov     sp,bp
                pop     bp
                ret     8
M2LONGS_LCMUL   endp

M2LONGS_LCDIV   proc    far
                push    bp
                mov     bp,sp

                mov     ax,op1
                mov     dx,op1+2
                mov     bx,op2
                mov     cx,op2+2
                call    div32u

                mov     sp,bp
                pop     bp
                ret     8
M2LONGS_LCDIV   endp

M2LONGS_LCMOD   proc    far
                push    bp
                mov     bp,sp

                mov     ax,op1
                mov     dx,op1+2
                mov     bx,op2
                mov     cx,op2+2
                call    div32u
                mov     ax,bx
                mov     dx,cx

                mov     sp,bp
                pop     bp
                ret      8
M2LONGS_LCMOD   endp

M2LONGS_LCCMP   proc     far
                push     bp
                mov      bp,sp

                mov      ax,op1+2
                cmp      ax,op2+2
                ja       lcc3
                jb       lcc1
                mov      ax,op1
                cmp      ax,op2
                ja       lcc3
                jb       lcc1
lcc2:           xor      ax,ax               ; =
                xor      dx,dx
                jmp      lcc10
lcc1:           xor      ax,ax               ; <
                mov      dx,1
                jmp      lcc10
lcc3:           mov      ax,1                ; >
                xor      dx,dx

lcc10:          mov      sp,bp
                pop      bp
                ret      8
M2LONGS_LCCMP   endp

M2LONGS_LCADR   proc     far
                push     bp
                mov      bp,sp

                mov      ax,op0
                mov      dx,op0+2
                mov      cx,12
lcadr1:         clc
                rcl       ax,1
                rcl      dx,1
                loop     lcadr1
                mov      cl,12
                shr      ax,cl

                mov      sp,bp
                pop      bp
                ret      4
M2LONGS_LCADR   endp


M2LONGS_ADRLC   proc     far
                push     bp
                mov      bp,sp

                mov      ax,op0
                mov      dx,op0+2
                xor      bx,bx
                mov      cx,12
adrlc1:         clc
                rcr      dx,1
                rcr      bx,1
                loop     adrlc1
                add      ax,bx
                adc      dx,0

                mov      sp,bp
                pop      bp
                ret      4
M2LONGS_ADRLC   endp



;    Generic LongInt routines.

;    MUL32, MUL32U: DX:AX := DX:AX * CX:BX
mul32           proc     near
                mov      si,0
                test     dx,8000h
                jz       mul1
                not      ax
                not      dx
                add      ax,1
                adc      dx,0
                inc      si
mul1:           test     cx,8000h
                jz       mul2
                not      bx
                not      cx
                add      bx,1
                adc      cx,0
                xor      si,1
mul2:           push     si
                call     mul32u
                pop      si
                test     si,si
                je       muldone
                not      ax
                not      dx
                add      ax,1
                adc      dx,0
muldone:        ret
mul32           endp


mul32u          proc     near
                mov      si,ax
                mov      di,dx
                xor      dx,dx
                mul      cx        ;low * high
                mov      cx,ax     ;cx = res hi
                mov      ax,si
                xor      dx,dx
                mul      bx        ;low * low
                mov      si,ax     ;si = res low
                add      cx,dx
                mov      ax,di
                xor      dx,dx
                mul      bx        ;high * low
                mov      dx,ax
                mov      ax,si
                add      dx,cx
                ret
mul32u          endp


;    DIV32: DX:AX := DX:AX / CX:BX; CX:BX := remainder.

div32           proc     near
negative        equ      byte ptr [bp-2]
                push     bp
                mov      bp,sp
                sub      sp,2
                mov      negative,0
                test     dx,8000h
                jz       aok
                inc      negative
                not      ax
                not      dx
                add      ax,1
                adc      dx,0
aok:            test     cx,8000h
                jz       bok
                or       negative,2
                not      bx
                not      cx
                add      bx,1
                adc      cx,0
bok:            call     div32u
                cmp      negative,3     ;both ops negative
                je       div2           ;sign(rem) = sign(dividend)
                test     negative,3     ;was one of them negative?
                jz       divdone
                not      ax
                not      dx
                add      ax,1
                adc      dx,0
                test     negative,1     ;how about the dividend?
                jz       divdone
div2:           not      bx
                not      cx
                add      bx,1
                adc      cx,0
divdone:        mov      sp,bp
                pop      bp
                ret
div32           endp

     ; DIVU: DX:AX := DX:AX / CX:BX unsigned (32 bits)
div32u          proc     near
shiftcnt        equ      byte ptr [bp-2]
                push     bp
                mov      bp, sp
                sub      sp, 2
                test     cx,cx          ;divisor < 1FFFF
                jnz      divu1
                call     divx           ;and done!
                jmp      divu10
divu1:          cmp      cx,dx
                ja       r0             ;result is 0.
                jb       divu2
                cmp      bx,ax
                jbe      r1             ;result is 1, calc remainder.
divu2:          ;  do division
                ;  shift divisor left till > dividend
                mov      shiftcnt, 1
divu3:          test     ch, 80h
                jnz      divu4     ; do not shift past sign bit
                shl      bx, 1
                rcl      cx, 1
                inc      shiftcnt
                cmp      dx, cx
                ja       divu3
                jb       divu4
                cmp      ax, bx
                ja       divu3
divu4:          xor      si, si    ; q in si:di
                mov      di, si
divu5:          ;  do division loop shiftcnt times
                shl      di, 1
                rcl      si, 1
                cmp      dx, cx
                ja       divusub
                jb       divunosub
                cmp      ax, bx
                jb       divunosub
divusub:        sub      ax, bx
                sbb      dx, cx
                inc      di
divunosub:      shr      cx, 1
                rcr      bx, 1
                dec      shiftcnt
                jnz      divu5

                mov      bx, ax         ; remainder
                mov      cx, dx
                mov      ax, di         ; q
                mov      dx, si
                jmp      divu10

r0:             ; result = 0, remainder = dividend
                mov      bx,ax
                mov      cx,dx
                mov      ax,0
                mov      dx,0
                jmp      divu10

r1:             ; result = 1, calculate remainder
                sub      ax,bx
                sbb      dx,cx
                mov      bx,ax
                mov      cx,dx
                mov      ax,1
                mov      dx,0
divu10:         mov      sp, bp
                pop      bp
                ret
div32u          endp

     ; DIVX: DX:AX := DX:AX / BX, BX := REMAINDER.
divx            proc     near
                push     cx             ;do not clobber cx
                push     ax             ;save low dividend
                mov      ax,dx
                xor      dx,dx
                div      bx             ;ax := dividend.high / BX
                mov      cx,ax          ;save high result
                pop      ax
                div      bx             ;ax := high remainder:dividend.low / BX
                mov      bx,dx          ;set remainder
                mov      dx,cx          ;result.high
                pop      cx
                ret
divx            endp

M2LONGS_INIT    proc    far
                ret
M2LONGS_INIT    endp

code            ends

                end
