// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
//                                                                    
//    This program draws the mandelbrot set in the complex numbers    
//    plane. The picture is a result of many iterated calculations.   
//                                                                    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

// Ŀ
//  Global variables.                                                 
// 
int max = 400;
byt pal[256][3];

float z[2][4] =
{
  -2.300, -1.250,  1.200,  1.250,
  -1.260,  0.378, -1.251,  0.385
};

// Ŀ
//  Global strings.                                                   
// 
char * info[3] =
{
  "THE MANDELBROT SET ",
  "A SPECIAL VIEW",
  "MODE %d: %dx%d"
};

// Ŀ
//  Palette: Set up our own palette colors.                           
// 
void palette(void)
{
  int x, y;

  for(x = 0; x < 256 ; x++)
  {
    y = x & 63;
    
    if (x & 64)
      y = 63 - y;
    
    pal[x][0] = y;
    pal[x][1] = y * y / 63;

    y = (x >> 1) & 63;
    
    if (x & 128)
      y = 63 - y;
    
    pal[x][2] = y;
  }
}

// Ŀ
//  SCREEN: Set up a screen with infos and a border.                  
// 
void screen(void)
{
  int k;

  k = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  setcol(1, 63, 63, 63);
  setcol(2, 0, 23, 35);
  
  rect ( 0, 0, hor - 1, ver - 1, 1);
  hline(20, 1, hor - 1, 1);
  frect( 1, 1, hor - 2, 19, 2);
  print( k, 7, 1, 3, info[2], mode, hor, ver);
}

// Ŀ
//  MANDEL: This draws the mandelbrot set at the rectangle specified. 
// 
int mandel(float x1, float y1, float x2, float y2, int n)
{
  float zr, zi, cr, ci, r2, i2, xscale, yscale;
  int   c, x, y;

  c = 13 + n * 130;

  frect( 1, 1, 220, 19, 2);
  print( 5, 7, 1, 3, info[n % 2]);

  xscale = (x2 - x1) / (hor - 4);
  yscale = (y2 - y1) / (ver - 22);

  for (y = 2; y < ver-22; y++)
    for (x = 2; x < hor-2; x++)
    {
      n = 0;
      zr = 0;
      zi = 0;
      cr = x1 + x * xscale;
      ci = y1 + y * yscale;
      r2 = zr * zr;
      i2 = zi * zi;

      while ((r2 + i2 <= 4) && (n < max))
      {
        zi = 2 * zr * zi + ci;
        zr = r2 - i2 + cr;
        r2 = zr * zr;
        i2 = zi * zi;
        n  = n + 1;
      }
      if ((r2 + i2 > 4) & (n < max))
        plot(x, y + 20, n % 253 + c);
      else
        plot(x, y + 20, 0);

      if (key())
        return(0);
    }
  waitkey();
  return(0);
}

// Ŀ
//  DEMO: Invokes the mandelbrot function with a view rectangle.      
// 
void demo(int m)
{
  int i;

  gmode(m);

  palette();
  setpal(*pal);
  screen();

  for (i = 0; i < 2; i++)
  {
    mandel(z[i][0], z[i][1], z[i][2], z[i][3], i);
    frect(2, 21, hor - 2, ver - 2, black);
  }
}

// Ŀ
//  MAIN: It runs the demo function at several resolutions.           
// 
void main(void)
{
  demo(257);
  demo(259);
  demo(261);

  tmode();
}

