// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

// Ŀ
//  Global variables.                                                 
// 
byt  pal[256][3];

// Ŀ
//  Global strings.                                                   
// 
char * info[2] =
{
  "LINE PATTERN",
  "MODE %d: %dx%d"
};

// Ŀ
//  Palette: Set up our own palette colors.                           
// 
void palette(void)
{
  long x, y;

  for(x = 0; x < 256 ; x++)
  {
    y = x & 63;
    
    if (x & 64)
      y = 63 - y;
    
    pal[x][0] = y;
    pal[x][1] = y * y / 63;
    y = (x >> 1) & 63;
    
    if (x & 128)
      y = 63 - y;
    
    pal[x][2] = y;
  }
}

// Ŀ
//  SCREEN: Set up a screen with infos and a border.                  
// 
void screen(void)
{
  int k;

  k = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  palette();
  setpal(*pal);
  setcol(blue, 0, 23, 35);
  setcol(lwhite, 63, 63, 63);
  setcol(black, 20, 20, 20);
  retrace();

  rect ( 0, 0, hor - 1, ver - 1, lwhite);
  hline(20, 1, hor - 1, lwhite);
  frect( 1, 1, hor - 2, 19, blue);
  print( 5, 7, lwhite , 16, info[0]);
  print( k, 7, lwhite , 16, info[1], mode, hor, ver);
}

// Ŀ
//  Demo: It shows a pattern made with colored lines.                 
// 
void demo(int m)
{
  int i, xleft, xrigt, xmid, ymid;

  gmode(m);
  screen();

  ymid = ver / 2 - 15;
  xmid  = hor / 2;
  xleft = xmid - ymid;
  xrigt = xmid + ymid;

  for (i = xleft ; i <= xmid ; i += 8)
    line(i, ymid +24, xmid, ymid-i+xleft + 24, (i>>3)%253+16);

  for (i = xleft ; i <= xmid ; i += 8)
    line(i, ymid + 24, xmid, ymid+i-xleft + 24, (i>>3)%253+16);

  for (i = xrigt ; i >= xmid ; i -= 8)
    line(i, ymid + 24, xmid, ymid+i-xrigt + 24, (i>>3)%253+16);

  for (i = xrigt ; i >= xmid ; i -= 8)
    line(i, ymid + 24, xmid, ymid-i+xrigt + 24, (i>>3)%253+16);

  waitkey();
}

// Ŀ
//  Main: It runs the demo function at several resolutions.           
// 
void main()
{
  demo(257);
  demo(259);
  demo(261);

  tmode();
}

