// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

#define abs(a)  ((a < 0) ? -a : a)

// Ŀ
//  Global variables.                                                 
// 
int  r, px, py, dx, dy, tx, ty, vx, vy;

// Ŀ
//  Global strings.                                                   
// 
char * info[3] =
{
  "BOUNCING OBJECTS",
  "MODE %d: %dx%d",
  "VESALIB 1.4"
};

// Ŀ
//  SCREEN: Set up a screen with infos and border.                    
// 
void screen(void)
{
  int k;

  k = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  setcol(black, 45, 45, 45);
  setcol(blue,   0, 23, 35);

  rect ( 0, 0, hor - 1, ver - 1, lwhite);
  hline(20, 1, hor - 1, lwhite);
  frect( 1, 1, hor - 2, 19, blue);
  print( 5, 7, lwhite, 16, info[0]);
  print( k, 7, lwhite, 16, info[1], mode, hor, ver);

  clip ( 2, 21, hor - 2, ver - 2);
}

// Ŀ
//  DRAW: This draws both objects or clears them, depending on the    
//        variable n.                                                 
// 
void draw(int n)
{
  if (n == 1)
  {
    fcircle(px  , py  , 15, 40);
    fcircle(px-5, py-5,  5, 12);
    fcircle(px-5, py-5,  4, 64);
    fcircle(px-5, py-5,  3, 86);
    fcircle(px-5, py-5,  1, 15);

    frect(tx - 50, ty - 6, tx + 48, ty + 12, blue);
    vline(tx + 49, ty - 6, ty + 12, 16);
    hline(ty + 12, tx - 49, tx + 49, 16);
    print(tx - 44, ty, lwhite, 0, info[2]);
  }
  else
  {
    fcircle(px,  py,  r, black);
    frect  (tx - 62, ty - 6, tx + 60, ty + 12, black);
  }
}

// Ŀ
//  MOVE: This calculates the new displacement, depending on the      
//        actual positions of the objects relative to the borders.    
// 
void move(void)
{
  if (px <= xmin + r + abs(dx) | px >= xmax - r - abs(dx))
    dx = -dx;
  px = px + dx;

  if (py <= ymin + r + abs(dy) | py >= ymax - r - abs(dy))
    dy = -dy;
  py = py + dy;

  if (tx <= xmin + 44 | tx >= xmax - 44)
    vx = -vx;
  tx = tx + vx;

  if (ty <= ymin + 9 | ty >= ymax - 9)
    vy = -vy;
  ty = ty + vy;
}

// Ŀ
//  DEMO: This function bounces a textframe and a circle around the   
//        screen. Look where the retrace function is placed.          
// 
void demo(int m)
{
  gmode(m);
  screen();

  px = hor/3; py = ver/3;
  dx = 6;     dy = 6;

  tx = px;    ty = py;
  vx = 4;     vy = 4;
  r  = 15;

  while (!key())
  {
    draw(1);
    retrace();
    draw(2);
    move();
  }
}

// Ŀ
//  MAIN: This runs the demo function at several resolutions.         
// 
void main(void)
{
  demo(257);
  demo(259);
  demo(261);

  tmode();
}

