#! /bin/sh
# This shell script is generated by the 'configure' script.  It is invoked in a
# subdirectory of the build tree.  It generates a sed-script in the parent
# directory that is used to adjust includes for header files that reside in a
# subdirectory of /usr/include, etc.
PRG=""
while test $# != 3
do
PRG="$PRG $1"; shift
done
DST=$1
REF=$2
SRC=$3
TMPSRC=${TMPDIR-/tmp}/`basename $SRC`$$
TMPSED=${TMPDIR-/tmp}/headers.sed$$
echo installing $SRC in $DST
case $DST in
/*/include/*)
	END=`basename $DST`
	for i in `cat $REF/../*/headers |fgrep -v "#"`
	do
		NAME=`basename $i`
		echo "s/<$NAME>/<$END\/$NAME>/" >> $TMPSED
	done
	;;
*)
	echo "" >> $TMPSED
	;;
esac
rm -f $TMPSRC
sed -f $TMPSED $SRC > $TMPSRC
NAME=`basename $SRC`
# Just in case someone gzip'd manpages, remove the conflicting copy.
test -f $DST/$NAME.gz && rm -f $DST/$NAME.gz

eval $PRG $TMPSRC $DST/$NAME
rm -f $TMPSRC $TMPSED
