#include <io.h>
#include <unistd.h>
#include <string.h>

void writeerr( const char *s )
{
    _write( 2, s, strlen( s ) );
}

void writeout( const char *s )
{
    _write( 1, s, strlen( s ) );
}

int main( int argc, char **argv )
{
    int c = 0, i = 1;
    char buf[ PATH_MAX ];

    if( argc < 1 || argv[ 1 ][ 0 ] == _getswitch() || argv[ 1 ][ 0 ] == '-' ) {
        writeerr( "FreeDOS READLINK 1.0 - Print resolution of a symlink\n" );
        writeerr( "Syntax: READLINK <file1> [<file2> ...]\n" );

        return( 1 );
    }

    while( i < argc ) {
        if( readlink( argv[ i ], buf, PATH_MAX ) == -1 ) {
            writeerr( "Failed to read symlink `" );
            writeerr( argv[ i ] );
            writeerr( "'.\n" );
            c++;
        } else {
            writeout( buf );
            writeout( "\n" );
        }
        i++;
    }

    return( c );
}

