#include <unistd.h>
#include <limits.h>
#include <string.h>
#include <stdlib.h>

#define OPT_USEPWD   0x01
#define OPT_RESOLV   0x02
#define OPT_PRHELP   0x04

void writeerr( const char *s )
{
    _write( 2, s, strlen( s ) );
}

void writeout( const char *s )
{
    _write( 1, s, strlen( s ) );
}

int main( int argc, char **argv )
{
    int c, flags = 0;
    char *pwd = NULL, nolinks[ PATH_MAX ];

    while( ( c = getopt( argc, argv, "LP" ) ) != -1 ) {
        switch( c ) {
            case 'P':
                flags |= OPT_RESOLV;
                break;
            case 'L':
                flags |= OPT_USEPWD;
                break;
            case '?':
                flags |= OPT_PRHELP;
                break;
        }
    }

    if( flags & OPT_PRHELP || argc < 1 ) {
        writeerr( "FreeDOS PWD 1.0 - Print the current working directory\n" );
        writeerr( "Syntax: PWD <pathname>\n" );
        writeerr( "Options:\n" );
        writeerr( "  -L  Use the PWD evironment variable\n" );
        writeerr( "  -P  Resolve symlinks in the current working directory\n" );
        return( 1 );
    }

    if( flags & OPT_USEPWD ) pwd = getenv( "PWD" );
    if( pwd == NULL ) pwd = getcwd( NULL, 0 );
    if( flags & OPT_RESOLV ) {
        if( readlink( pwd, nolinks, PATH_MAX ) != -1 ) pwd = nolinks;
    }

    if( pwd == NULL ) {
        writeout( "Couldn't get the current directory.\n" );
        return( 1 );
    }

    writeout( pwd );
    writeout( "\n" );

    return( 0 );
}

