#include <io.h>
#include <unistd.h>
#include <string.h>

void writeerr( const char *s )
{
    _write( 2, s, strlen( s ) );
}

int main( int argc, char **argv )
{
    int c = 0, i = 1;

    if( argc < 1 || argv[ 1 ][ 0 ] == _getswitch() || argv[ 1 ][ 0 ] == '-' ) {
        writeerr( "FreeDOS LINK 1.0 - Hard link two files (copy)\n" );
        writeerr( "Syntax: LINK <file1> <file2> [<file3> <file4> ...]\n" );

        return( 1 );
    }

    while( i < ( argc - 1 ) ) {
        if( link( argv[ i ], argv[ i + 1 ] ) == -1 ) {
            writeerr( "Failed to link `" );
            writeerr( argv[ i ] );
            writeerr( "' to `" );
            writeerr( argv[ i + 1 ] );
            writeerr( "'.\n" );
            c++;
        }
        i += 2;
    }

    return( c );
}

