#include <unistd.h>
#include <dos.h>
#include <signal.h>
#include <time.h>

static clock_t __targettime = 0, __intervaltime = 0;
extern void interrupt far ( *___prev28 )();
/* so that exit() can restore it */

static void interrupt __catchalarm( void )
{
    if( clock() >= __targettime ) {
        if( __intervaltime ) {
            __targettime += __intervaltime;
        } else {
            setvect( 0x28, ___prev28 );
            ___prev28 = NULL;
            __targettime = 0;
        }
        raise( SIGALRM );
    }

    if( ___prev28 != NULL ) ___prev28();
}

useconds_t ualarm( useconds_t seconds, useconds_t interval )
{
    if( __targettime ) return( ( ( __targettime - clock() ) / 18 ) * 54945 );
    if( interval ) {
        __intervaltime = interval * 18;
        if( __intervaltime % 54945 ) __intervaltime += 54945;
        __intervaltime /= 54945;
    }

    if( ___prev28 == NULL ) ___prev28 = getvect( 0x28 );
    /* Try not to use floating point :-) */
    __targettime = ( seconds * 18 );
    __targettime+= __targettime % 54945 ? 54945 : 0;
    __targettime/= 54945;
    /* The number by which we get clock ticks from one million */
    __targettime+= clock();
    setvect( 0x28, __catchalarm );

    return( 0 );
}

