#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include "symglobl.h"

static int loop = SYMLOOP_MAX;

ssize_t __readsinglelink( const char *path, char *buf, size_t bufl )
{
    char link[ 511 ], *p = link + 10, *b = buf;
    int handle, i = 0, j = bufl;

    if( ( handle = _open( path, O_RDONLY ) ) == -1 ) return( -1 );

    if( ( i = _read( handle, link, 510 ) ) != 510 ) {
        if( i != -1 ) errno = EINVAL; /* Not a symlink (510 bytes long) */

        _close( handle );

        return( -1 );
    }
    _close( handle );

    if( strncmp( link, __beginsymb, 10 ) != 0 ) {
        errno = EINVAL;

        return( -1 );
    }
    i = 0;

    while( j && *p != '\n' ) {
        *b = *p;
        j--, p++, b++, i++;
    }

    *b = '\0';
    p++;

    if( strncmp( p, __finishsym, 105 ) != 0 ) {
        errno = EINVAL;

        return( -1 );
    }

    return( 0 );
}

/* Read DJGPP-style symlinks */
ssize_t readlink( const char * restrict path, char * restrict buf, size_t bufl )
{
    char testpath[ PATH_MAX ], temppath[ PATH_MAX ], *t = testpath;
    int i = 0, j;

    loop--;

    strcpy( testpath, path );

    while( *t ) {
        if( *t == '/' ) *t = '\\';
        t++;
    }

    t = testpath;

    for( ;; ) {
        while( *t != '\\' && *t != '\0' ) t++;
        if( *t == '\0' ) break;

        *t = '\0';
        if( __readsinglelink( testpath, buf, bufl ) != -1 ) {
            i++;/* Expanded a symlink */
            if( buf[ 1 ] == ':' || buf[ 0 ] == '\\'  ) {
                /* Absolute path in the symlink */
                *t = '\\';
                strcpy( temppath, t );
                strncat( buf, temppath, bufl );
                strcpy( testpath, buf );
            } else { /* Relative path, replace the old path section */
                char *ptr = strrchr( testpath, '\\' );

                if( ptr == NULL ) ptr = testpath;
                else ptr++;

                *t = '\\';
                strcpy( temppath, t );
                strcpy( ptr, buf );
                strcat( testpath, temppath );
                strncpy( buf, testpath, bufl );
            }

            t = testpath;

            while( strcmp( t, temppath ) != 0 ) t++;
        }
        *t = '\\';
        t++;
    }

    if( __readsinglelink( testpath, buf, bufl ) != -1 ) {
        i++;
        if( buf[ 1 ] != ':' && buf[ 0 ] != '\\'  ) {
            char *ptr = strrchr( testpath, '\\' );

            if( ptr == NULL ) ptr = testpath;
            else ptr++;
            strcpy( ptr, buf );
            strncpy( buf, testpath, bufl );
        }
    }
    else if( i ) strncpy( buf, testpath, bufl );
    else {
        loop++;

        return( -1 );
    }

    strcpy( testpath, buf );
    i = strlen( testpath );

    if( loop == 0 ) {
        errno = ELOOP;
        loop++;

        return( -1 );
    }

    if( ( j = readlink( testpath, buf, bufl ) ) == -1 ) {
        loop++;

        return( errno == ELOOP ? -1 : i );
    }

    loop++;

    return( j );
}

