#include <unistd.h>
#include <signal.h>

static void ( *__savehandlers[ 7 ] )( int sig );

void __pausehandler( int sig )
{
    int i;

    if( sig != -1 ) goto __finishpause;

    for( i = 0; i < 7; i++ ) __savehandlers[ i ] = __handlers[ i ];
    for( i = 0; i < 7; i++ ) __handlers[ i ] = __pausehandler;
    for( ;; ); /* Loop until a signal is caught */

__finishpause:
    /* Call original handler */
    __savehandlers[ sig ]( sig );
    /* Restore signal handlers */
    for( i = 0; i < 7; i++ ) __handlers[ i ] = __savehandlers[ i ];
}

int pause( void )
{
    __pausehandler( -1 );

    return( 0 );
}

