#include <unistd.h>
#include <fcntl.h>

/* 
 * Simply copies a file.
 * Hard links are possible on FAT but disk tools don't like them.
 */
int link( const char *path, const char *path2 )
{
    int handle1 = creatnew( path2, _A_NORMAL ),
        handle2 = _open( path, O_RDONLY ),
        nread;
    char transbuf[ 1024 ];

    if( handle1 == -1 || handle2 == -1 ) {
        if( handle1 != -1 ) unlink( path2 );

        _close( handle1 );
        _close( handle2 );

        return( -1 );
    }

    setmode( handle1, O_BINARY );
    setmode( handle2, O_BINARY );

    while( ( nread = _read( handle2, transbuf, 1024 ) ) != -1 && nread != 0 ) {
        if( _write( handle1, transbuf, nread ) == -1 ) {
            _close( handle1 );
            _close( handle2 );

            return( -1 );
        }
    }

    _close( handle1 );
    _close( handle2 );

    return( 0 );
}

