#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

/* macros */
#define NO_ARG          0
#define REQUIRED_ARG    1
#define OPTIONAL_ARG    2

/* types */
typedef enum __getopt_ordering_t
{
    PERMUTE,
    RETURN_IN_ORDER,
    REQUIRE_ORDER
} __getopt_ordering_t;

/* functions */

/* __reverse_argv_elements:  reverses num elements starting at argv */
static void __reverse_argv_elements( char **argv, int num )
{
    int i;
    char *tmp;

    for( i = 0; i < ( num >> 1 ); i++ ) {
        tmp = argv[ i ];
        argv[ i ] = argv[ num - i - 1 ];
        argv[ num - i - 1 ] = tmp;
    }
}

/* __permute: swap two blocks of argv-elements given their lengths */
static void __permute( char **argv, int len1, int len2 )
{
    __reverse_argv_elements( argv, len1 );
    __reverse_argv_elements( argv, len1 + len2 );
    __reverse_argv_elements( argv, len2 );
}

/* __is_option: is this argv-element an option or the end of the option list? */
static int __is_option( char *argv_element, int only )
{
    return( ( argv_element == NULL )
            || ( argv_element[ 0 ] == '-' )
            || ( argv_element[ 0 ] == _getswitch() )
            || ( only && argv_element[ 0 ] == '+' ) );
}

/* __getopt_internal:  the function that does all the dirty work */
static int __getopt_internal( int argc, char **argv, char *shortopts,
                            struct option * longopts, int *longind, int only )
{
    __getopt_ordering_t ordering = PERMUTE;
    static size_t optwhere;
    size_t __permute_from, match_chars;
    int num_nonopts,
        optindex,
        longopt_match,
        has_arg,
        arg_next;
    char *possible_arg = NULL;
    char *cp;

    optwhere = __permute_from =
               match_chars =
               num_nonopts =
               optindex =
               arg_next = 0;
    longopt_match = has_arg = -1;

    /* first, deal with silly parameters and easy stuff */
    if( argc == 0 || argv == NULL || ( shortopts == NULL && longopts == NULL ) )
        return( ( optopt = '?' ) );
    if( optind >= argc || argv[ optind ] == NULL )
        return( EOF );
    if( strcmp( argv[ optind ], "--" ) == 0 ) {
        optind++;
        return( EOF );
    }
    /* if this is our first time through */
    if( optwhere == 0 ) optwhere = 1;

    /* define ordering */
    if( shortopts != NULL && ( *shortopts == '-' || *shortopts == '+' ) ) {
        ordering = (*shortopts == '-') ? RETURN_IN_ORDER : REQUIRE_ORDER;
        shortopts++;
    } else ordering = REQUIRE_ORDER;

    /*
     * based on ordering, find our next option, if we're at the beginning of
     * one
     */
    if( optwhere == 1 ) {
        switch( ordering ) {
            case PERMUTE:
                __permute_from = optind;
                num_nonopts = 0;
                while( !__is_option( argv[ optind ], only ) ) {
                    optind++;
                    num_nonopts++;
                }
                if( argv[ optind ] == NULL ) {
                    /* no more options */
                    optind = __permute_from;
                    return( EOF );
                } else if( strcmp( argv[ optind ], "--" ) == 0 ) {
                    /* no more options, but have to get `--' out of the way */
                    __permute( argv + __permute_from, num_nonopts, 1 );
                    optind = __permute_from + 1;
                    return( EOF );
                }
                break;
            case RETURN_IN_ORDER:
                if( !__is_option( argv[ optind ], only ) ) {
                    optarg = argv[ optind++ ];
                    return( ( optopt = 1 ) );
                }
                break;
            case REQUIRE_ORDER:
                if( !__is_option( argv[ optind ], only ) ) return( EOF );
                break;
        }
    }
    /* we've got an option, so parse it */

    /* first, is it a long option? */
    if( ( memcmp( argv[ optind ], "--", 2 ) == 0 ||
        ( only && argv[ optind ][ 0 ] == '+' ) ) &&
        optwhere == 1 ) {
        /* handle long options */
        if( memcmp( argv[ optind ], "--", 2 ) == 0 ) optwhere = 2;
        longopt_match = -1;
        possible_arg = strchr( argv[ optind ] + optwhere, '=' );
        if( possible_arg == NULL ) {
            /* no =, so next argv might be arg */
            match_chars = strlen( argv[ optind ] );
            possible_arg = argv[ optind ] + match_chars;
            match_chars = match_chars - optwhere;
        } else match_chars = ( possible_arg - argv[ optind ] ) - optwhere;

        for( optindex = 0; longopts[ optindex ].name != NULL; optindex++ ) {
            if( memcmp( argv[ optind ] + optwhere,
                        longopts[ optindex ].name, match_chars ) == 0 ) {
                /* do we have an exact match? */
                if( match_chars == ( strlen( longopts[ optindex ].name ) ) ) {
                    longopt_match = optindex;
                    break;
                } else {
                /* do any characters match? */
                    if( longopt_match < 0 ) longopt_match = optindex;
                    else {
                        /* we have ambiguous options */
                        if( opterr ) {
                            _write( 2, argv[ 0 ], strlen( argv[ 0 ] ) );
                            _write( 2, ": option `", 10 );
                            _write( 2, argv[ optind ],
                                       strlen( argv[ optind ] ) );
                            _write( 2, "' is ambiguous (could be `--", 28 );
                            _write( 2, longopts[ longopt_match ].name,
                                       strlen( longopts[ longopt_match ].name )
                                       );
                            _write( 2, "' or `--", 8 );
                            _write( 2, longopts[ optindex ].name,
                                       strlen( longopts[ optindex ].name ) );
                            _write( 2, "')\n", 3 );
                        }
/*                            fprintf( stderr,
                                              "%s: option `%s' is ambiguous "
                                              "(could be `--%s' or `--%s')\n",
                                              argv[ 0 ],
                                              argv[ optind ],
                                              longopts[ longopt_match ].name,
                                              longopts[ optindex ].name );*/
                        return( ( optopt = '?') );
                    }
                }
            }
        }
        if( longopt_match >= 0 ) has_arg = longopts[ longopt_match ].has_arg;
    }
    /* if we didn't find a long option, is it a short option? */
    if( longopt_match < 0 && shortopts != NULL ) {
/*        while( 1 ) {*/
            cp = strchr( shortopts, argv[ optind ][ optwhere ] );
            if( cp == NULL ) {
                /* couldn't find option in shortopts */
                if( opterr ) {
                    _write( 2, argv[ 0 ], strlen( argv[ 0 ] ) );
                    _write( 2, ": invalid option -- `-", 22 );
                    _write( 2, &argv[ optind ][ optwhere ], 1 );
                    _write( 2, "'\n", 2 );
/*                    break;*/
                }
                /*fprintf( stderr,
                                      "%s: invalid option -- `-%c'\n",
                                      argv[ 0 ], argv[ optind ][ optwhere ] );*/
                optwhere++;
                if( argv[ optind ][ optwhere ] == '\0' ) {
                    optind++;
                    optwhere = 1;
/*                    break;*/
                }
                return( ( optopt = '?') );
            }
            has_arg = ( ( cp[ 1 ] == ':' ) ?
                      ( ( cp[ 2 ] == ':' ) ? OPTIONAL_ARG : REQUIRED_ARG ) :
                      NO_ARG );
            possible_arg = argv[ optind ] + optwhere + 1;
            optopt = *cp;
        }
/*    }*/
    /* get argument and reset optwhere */
    arg_next = 0;
    switch( has_arg ) {
        case OPTIONAL_ARG:
            if( *possible_arg == '=' ) possible_arg++;
            if( *possible_arg != '\0' ) {
                optarg = possible_arg;
                optwhere = 1;
            } else optarg = NULL;
            break;
        case REQUIRED_ARG:
            if( *possible_arg == '=' ) possible_arg++;
            if( *possible_arg != '\0' ) {
                optarg = possible_arg;
                optwhere = 1;
            } else if( optind + 1 >= argc ) {
                if( opterr ) {
                    _write( 2, argv[ 0 ], strlen( argv[ 0 ] ) );
                    _write( 2, ": argument required for option `", 32 );
/*                    fprintf( stderr,
                             "%s: argument required for option `",
                             argv[ 0 ] );*/
                    if( longopt_match >= 0 ) {
                        _write( 2, "--", 2 );
                        _write( 2, longopts[ longopt_match ].name,
                                   strlen( longopts[ longopt_match ].name ) );
                        _write( 2, "'\n", 2 );
                    } else {
                        _write( 2, "-", 1 );
                        _write( 2, cp, 1 );
                        _write( 2, "'\n", 2 );
                    }
/*                        fprintf( stderr, "--%s'\n",
                                 longopts[ longopt_match ].name );
                    else fprintf( stderr, "-%c'\n", *cp );*/
                }
                optind++;
                return( ( optopt = ':' ) );
            } else {
                optarg = argv[ optind + 1 ];
                arg_next = 1;
                optwhere = 1;
            }
            break;
        case NO_ARG:
            if( longopt_match < 0 ) {
                optwhere++;
                if( argv[ optind ][ optwhere ] == '\0' ) optwhere = 1;
            } else optwhere = 1;
            optarg = NULL;
            break;
    }

    /* do we have to __permute or otherwise modify optind? */
    if( ordering == PERMUTE && optwhere == 1 && num_nonopts != 0 ) {
        __permute( argv + __permute_from, num_nonopts, 1 + arg_next );
        optind = __permute_from + 1 + arg_next;
    } else if( optwhere == 1 ) optind = optind + 1 + arg_next;

    /* finally return */
    if( longopt_match >= 0 ) {
        *longind = longopt_match;
        if( longopts[ longopt_match ].flag != NULL ) {
            *( longopts[ longopt_match ].flag ) = longopts[ longopt_match ].val;
            return( 0 );
        } else return( longopts[ longopt_match ].val );
    } else return( optopt );
}

int getopt_long( int argc, char **argv, char *shortopts,
                 struct option * longopts, int *longind )
{
  return( __getopt_internal( argc, argv, shortopts, longopts, longind, 0 ) );
}

int getopt_long_only( int argc, char **argv, char *shortopts,
                      struct option * longopts, int *longind )
{
  return( __getopt_internal( argc, argv, shortopts, longopts, longind, 1 ) );
}

