#include <time.h>
#include <stdarg.h>

static char *__aday[] = {
    "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};

static char *__day[] = {
    "Sunday", "Monday", "Tuesday", "Wednesday",
    "Thursday", "Friday", "Saturday"
};

static char *__amonth[] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};

static char *__month[] = {
    "January", "February", "March", "April", "May", "June",
    "July", "August", "September", "October", "November", "December"
};

static char __buf[ 26 ];
static int __pow[ 5 ] = { 1, 10, 100, 1000, 10000 };

static void __strfmt( char *str, const char *fmt, ... )
{
    int ival, ilen;
    char *sval;
    va_list vp;

    va_start( vp, fmt );
    while( *fmt ) {
        if( *fmt++ == '%' ) {
            ilen = *fmt++ - '0';
            if( ilen == 0 ) {              /* zero means string arg */
                sval = va_arg( vp, char * );
                while( *sval ) *str++ = *sval++;
            } else {                        /* always leading zeros */
                ival = va_arg( vp, int );
                while( ilen ) {
                    ival %= __pow[ ilen-- ];
                    *str++ = ( char )( '0' + ival / __pow[ ilen ]);
                }
            }
        }
        else *str++ = fmt[ -1 ];
    }
    *str = '\0';
    va_end( vp );
}

size_t strftime( char *s, size_t maxs, const char *f, const struct tm *t )
{
    int w;
    char *p, *q, *r;

    p = s;
    q = s + maxs - 1;
    while( ( *f != '\0' ) ) {
        if( *f++ == '%' ) {
            r = __buf;
            switch( *f++ ) {
                case '%' :
                    r = "%";
                    break;
                case 'a' :
                    r = __aday[ t->tm_wday ];
                    break;
                case 'A' :
                    r = __day[ t->tm_wday ];
                    break;
                case 'b' :
                    r = __amonth[ t->tm_mon ];
                    break;
                case 'B' :
                    r = __month[ t->tm_mon ];
                    break;
                case 'c' :
                    __strfmt( r, "%0 %0 %2 %2:%2:%2 %4",
                              __aday[ t->tm_wday ], __amonth[ t->tm_mon ],
                              t->tm_mday, t->tm_hour, t->tm_min,
                              t->tm_sec, t->tm_year + 1900);
                    break;
                case 'd' :
                    __strfmt( r, "%2", t->tm_mday );
                    break;
                case 'H' :
                    __strfmt( r, "%2", t->tm_hour );
                    break;
                case 'I' :
                    __strfmt( r, "%2", ( t->tm_hour % 12 ) ?
                                     t->tm_hour % 12 : 12 );
                    break;
                case 'j' :
                    __strfmt( r, "%3", t->tm_yday + 1 );
                    break;
                case 'm' :
                    __strfmt( r, "%2", t->tm_mon + 1 );
                    break;
                case 'M' :
                    __strfmt( r, "%2", t->tm_min );
                    break;
                case 'p' :
                    r = ( t->tm_hour > 11 ) ? "PM" : "AM";
                    break;
                case 'S' :
                    __strfmt( r, "%2", t->tm_sec );
                    break;
                case 'U' :
                    w = t->tm_yday / 7;
                    if( t->tm_yday % 7 > t->tm_wday ) w++;
                    __strfmt( r, "%2", w );
                    break;
                case 'W' :
                    w = t->tm_yday / 7;
                    if( t->tm_yday % 7 > ( t->tm_wday + 6 ) % 7 ) w++;
                    __strfmt( r, "%2", w );
                    break;
                case 'w' :
                    __strfmt( r, "%1", t->tm_wday );
                    break;
                case 'x' :
                    __strfmt( r, "%3s %3s %2 %4", __aday[ t->tm_wday ],
                            __amonth[ t->tm_mon ], t->tm_mday,
                            t->tm_year + 1900 );
                    break;
                case 'X' :
                    __strfmt( r, "%2:%2:%2", t->tm_hour, t->tm_min, t->tm_sec );
                    break;
                case 'y' :
                    __strfmt( r, "%2", t->tm_year % 100 );
                    break;
                case 'Y' :
                    __strfmt( r, "%4", t->tm_year + 1900 );
                    break;
                case 'Z' :
                    r = ( t->tm_isdst ) ? tzname[ 1 ] : tzname[ 0 ];
                    break;
                default:
                    __buf[ 0 ] = '%';     /* reconstruct the format */
                    __buf[ 1 ] = f[ -1 ];
                    __buf[ 2 ] = '\0';
                    if( __buf[ 1 ] == 0 ) f--; /* back up if at end of string */
            }
            while( *r ) {
                if( p == q ) {
                    *q = '\0';
                    return( 0 );
                }
                *p++ = *r++;
            }
        } else {
            if( p == q ) {
                *q = '\0';
                return( 0 );
            }
            *p++ = f[ -1 ];
        }
    }
    *p = '\0';
    
    return( ( size_t )( p - s ) );
}

