#include <time.h>
#include "internal.h"

/* dow - written by Paul Edwards, 1993-01-31 */
/* Released to the Public Domain */
/* 
 * This routine will work over the range 1-01-01 to 32767-12-31.
 * It assumes the current calendar system has always been in
 * place in that time.  If you pass 0 or negative years, then
 * it produces results on the assumption that there is a year
 * 0.  It should always produce a value in the range of 0..6
 * if a valid month and day have been passed, no matter what
 * the year is.  However, it has not been tested for negative
 * years, because the results are meaningless anyway.  It is
 * mainly to stop people playing silly buggers and causing
 * the macro to crash on negative years.
 */
 
#define dow( y, m, d )  ( ( ( ( ( ( m ) + 9 ) % 12 + 1 ) << 4 ) % 27 + ( d ) + \
                        1 + ( ( y ) % 400 + 400 ) + ( ( y ) % 400 + 400 ) / 4 \
                        - ( ( y ) % 400 + 400 ) / 100 + ( ( ( m ) <= 2 ) ? \
                        ( ( ( ( ( ( y ) % 4 ) == 0 ) && \
                        ( ( ( y ) % 100 ) != 0 ) ) || \
                        ( ( ( y ) % 400 ) == 0 ) ) ? 5 : 6 ) : 0 ) ) % 7 )

static struct tm __tms;

struct tm *localtime( const time_t *timer )
{
    unsigned yr, mo, da;
    unsigned long secs, days;

    days = *timer / ( 60L * 60 * 24 );
    secs = *timer % ( 60L * 60 * 24 );
    __scalar_to_ymd( days + __ymd_to_scalar( 1970, 1, 1 ), &yr, &mo, &da );
    __tms.tm_year = yr - 1900;
    __tms.tm_mon = mo - 1;
    __tms.tm_mday = da;
    __tms.tm_yday = ( int )( __ymd_to_scalar( __tms.tm_year + 1900, 1, 1 )
                    - __ymd_to_scalar( __tms.tm_year + 1900, mo, da ) );
    __tms.tm_wday = dow( __tms.tm_year + 1900, mo, da );
    __tms.tm_isdst = -1;
    __tms.tm_sec = ( int )( secs % 60 );
    secs /= 60;
    __tms.tm_min = ( int )( secs % 60 );
    secs /= 60;
    __tms.tm_hour = ( int )secs;
    
    return( &__tms );
}

