#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main( int argc, char **argv )
{
    struct stat statbuf;
    int failure = 0;

    if( stat( argc > 1 ? argv[ 1 ] : argv[ 0 ], &statbuf ) == -1 ) {
        printf( "stat() - Failure\n" );
        failure++;
    } else {
        printf( "stat() - Success\n" );
        printf( "%s:\n", argc > 1 ? argv[ 1 ] : argv[ 0 ] );
        printf( "statbuf.st_dev = %lu\n", ( unsigned long )statbuf.st_dev );
        printf( "statbuf.st_ino = %lu\n", ( unsigned long )statbuf.st_ino );
        printf( "statbuf.st_mode = %u\n", ( unsigned )statbuf.st_mode );
        printf( "statbuf.st_nlink = %u\n", ( unsigned )statbuf.st_nlink );
        printf( "statbuf.st_uid = %u\n", ( unsigned )statbuf.st_uid );
        printf( "statbuf.st_gid = %u\n", ( unsigned )statbuf.st_gid );
        printf( "statbuf.st_size = %lu\n", ( unsigned long )statbuf.st_size );
        printf( "statbuf.st_atime = %lu\n", ( unsigned long )statbuf.st_atime );
        printf( "statbuf.st_mtime = %lu\n", ( unsigned long )statbuf.st_mtime );
        printf( "statbuf.st_ctime = %lu\n", ( unsigned long )statbuf.st_ctime );
        printf( "statbuf.st_blksize = %u\n", ( unsigned )statbuf.st_blksize );
        printf( "statbuf.st_blocks = %u\n", ( unsigned )statbuf.st_blocks );
    }

    return( failure );
}

